/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SCallActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSubProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SBoundaryEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerDefinition;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventReadException;
import org.bonitasoft.engine.core.process.instance.model.SCallActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.core.process.instance.model.builder.SFlowNodeInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceUpdateBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SIntermediateCatchEventInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SIntermediateThrowEventInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingErrorEventBuilder;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SBPMEventType;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingErrorEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.TransactionContainedProcessInstanceInterruptor;
import org.bonitasoft.engine.execution.event.CoupleEventHandlerStrategy;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.event.OperationsWithContext;
import org.bonitasoft.engine.execution.event.SBPMEventHandlerException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;

public class ErrorEventHandlerStrategy
extends CoupleEventHandlerStrategy {
    private static final OperationsWithContext EMPTY = new OperationsWithContext(null, null);
    private final ProcessInstanceService processInstanceService;
    private final ContainerRegistry containerRegistry;
    private final ProcessDefinitionService processDefinitionService;
    private final EventsHandler eventsHandler;
    private final TechnicalLoggerService logger;

    public ErrorEventHandlerStrategy(BPMInstanceBuilders instanceBuilders, EventInstanceService eventInstanceService, ProcessInstanceService processInstanceService, ContainerRegistry containerRegistry, ProcessDefinitionService processDefinitionService, EventsHandler eventsHandler, TechnicalLoggerService logger) {
        super(instanceBuilders, eventInstanceService);
        this.processInstanceService = processInstanceService;
        this.containerRegistry = containerRegistry;
        this.processDefinitionService = processDefinitionService;
        this.eventsHandler = eventsHandler;
        this.logger = logger;
    }

    @Override
    public void handleThrowEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SThrowEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Error event is thrown, error code = " + ((SErrorEventTriggerDefinition)sEventTriggerDefinition).getErrorCode() + " process instance = " + eventInstance.getRootContainerId());
        }
        TransactionContainedProcessInstanceInterruptor processInstanceInterruptor = new TransactionContainedProcessInstanceInterruptor(this.getInstanceBuilders(), this.processInstanceService, this.getEventInstanceService(), this.containerRegistry, this.logger);
        this.updateInterruptorErrorEvent(eventInstance);
        processInstanceInterruptor.interruptChildrenOnly(eventInstance.getParentContainerId(), SStateCategory.ABORTING, -1L, eventInstance.getId());
    }

    private void updateInterruptorErrorEvent(SThrowEventInstance eventInstance) throws SProcessInstanceNotFoundException, SProcessInstanceReadException, SProcessInstanceModificationException {
        SIntermediateThrowEventInstanceBuilder throwEventKeyProvider = this.getInstanceBuilders().getSIntermediateThrowEventInstanceBuilder();
        SProcessInstanceUpdateBuilder updateBuilder = this.getInstanceBuilders().getProcessInstanceUpdateBuilder();
        long parentProcessInstanceId = eventInstance.getLogicalGroup(throwEventKeyProvider.getParentProcessInstanceIndex());
        updateBuilder.updateInterruptingEventId(eventInstance.getId());
        SProcessInstance processInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
        this.processInstanceService.updateProcess(processInstance, updateBuilder.done());
    }

    @Override
    public void handleThrowEvent(SEventTriggerDefinition sEventTriggerDefinition) {
    }

    @Override
    public boolean handlePostThrowEvent(SProcessDefinition processDefinition, SEndEventDefinition sEventDefinition, SThrowEventInstance sThrowEventInstance, SEventTriggerDefinition sEventTriggerDefinition, SFlowNodeInstance sFlowNodeInstance) throws SBonitaException {
        boolean hasActionToExecute = false;
        SIntermediateThrowEventInstanceBuilder flowNodeKeyProvider = this.getInstanceBuilders().getSIntermediateThrowEventInstanceBuilder();
        long parentProcessInstanceId = sThrowEventInstance.getLogicalGroup(flowNodeKeyProvider.getParentProcessInstanceIndex());
        SErrorEventTriggerDefinition errorTrigger = (SErrorEventTriggerDefinition)sEventTriggerDefinition;
        SWaitingErrorEvent waitingErrorEvent = this.getWaitingErrorEvent(processDefinition.getProcessContainer(), parentProcessInstanceId, errorTrigger, sThrowEventInstance, sFlowNodeInstance);
        if (waitingErrorEvent != null) {
            this.eventsHandler.triggerCatchEvent(waitingErrorEvent, sThrowEventInstance.getId());
            hasActionToExecute = true;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("No catch error event was defined to handle the error code '");
            stringBuilder.append(errorTrigger.getErrorCode());
            stringBuilder.append("' defined in the process [name: ");
            stringBuilder.append(processDefinition.getName());
            stringBuilder.append(", version: ");
            stringBuilder.append(processDefinition.getVersion());
            stringBuilder.append("]");
            if (sEventDefinition != null) {
                stringBuilder.append(", throw event: ");
                stringBuilder.append(sEventDefinition.getName());
            }
            stringBuilder.append(". This throw error event will act as a Terminate Event.");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, stringBuilder.toString());
            }
        }
        return hasActionToExecute;
    }

    private SWaitingErrorEvent getWaitingErrorEvent(SFlowElementContainerDefinition container, long parentProcessInstanceId, SErrorEventTriggerDefinition errorTrigger, SThrowEventInstance eventInstance, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        SProcessInstance processInstance = this.processInstanceService.getProcessInstance(parentProcessInstanceId);
        String errorCode = errorTrigger.getErrorCode();
        SIntermediateThrowEventInstanceBuilder flowNodeKeyProvider = this.getInstanceBuilders().getSIntermediateThrowEventInstanceBuilder();
        SWaitingErrorEvent waitingErrorEvent = this.getWaitingErrorEventFromBoundary(flowNodeKeyProvider, eventInstance, errorCode, flowNodeInstance);
        if (waitingErrorEvent == null) {
            waitingErrorEvent = this.getWaitingErrorEventSubProcess(container, parentProcessInstanceId, errorCode);
        }
        if (waitingErrorEvent == null && processInstance.getCallerId() != -1L && SFlowNodeType.CALL_ACTIVITY.equals((Object)processInstance.getCallerType())) {
            waitingErrorEvent = this.getWaitingErrorEventFromCallActivity(errorTrigger, flowNodeKeyProvider, processInstance, eventInstance, errorCode, flowNodeInstance);
        }
        return waitingErrorEvent;
    }

    private SWaitingErrorEvent getWaitingErrorEventFromBoundary(SFlowNodeInstanceBuilder flowNodeKeyProvider, SThrowEventInstance eventInstance, String errorCode, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        long logicalGroup = eventInstance.getLogicalGroup(flowNodeKeyProvider.getParentActivityInstanceIndex());
        if (logicalGroup <= 0L) {
            return null;
        }
        long processDefinitionId = flowNodeInstance.getLogicalGroup(flowNodeKeyProvider.getProcessDefinitionIndex());
        SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
        SActivityDefinition flowNode = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        List<SBoundaryEventDefinition> boundaryEventDefinitions = flowNode.getBoundaryEventDefinitions();
        return this.getWaitingErrorEventFromBoundary(errorCode, flowNodeInstance, boundaryEventDefinitions);
    }

    private SWaitingErrorEvent getWaitingErrorEventFromCallActivity(SErrorEventTriggerDefinition errorTrigger, SFlowNodeInstanceBuilder flowNodeKeyProvider, SProcessInstance processInstance, SThrowEventInstance eventInstance, String errorCode, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        long processDefinitionId;
        SProcessDefinition callActivityContainer;
        SCallActivityDefinition callActivityDef;
        List<SBoundaryEventDefinition> boundaryEventDefinitions;
        SCallActivityInstance callActivityInstance = (SCallActivityInstance)this.getEventInstanceService().getFlowNodeInstance(processInstance.getCallerId());
        SWaitingErrorEvent waitingErrorEvent = this.getWaitingErrorEventFromBoundary(errorCode, callActivityInstance, boundaryEventDefinitions = (callActivityDef = (SCallActivityDefinition)(callActivityContainer = this.processDefinitionService.getProcessDefinition(processDefinitionId = callActivityInstance.getLogicalGroup(flowNodeKeyProvider.getProcessDefinitionIndex()))).getProcessContainer().getFlowNode(callActivityInstance.getFlowNodeDefinitionId())).getBoundaryEventDefinitions());
        if (waitingErrorEvent == null) {
            long callActivityParentProcInstId = callActivityInstance.getLogicalGroup(flowNodeKeyProvider.getParentProcessInstanceIndex());
            waitingErrorEvent = this.getWaitingErrorEvent(callActivityContainer.getProcessContainer(), callActivityParentProcInstId, errorTrigger, eventInstance, flowNodeInstance);
        }
        return waitingErrorEvent;
    }

    private SWaitingErrorEvent getWaitingErrorEventFromBoundary(String errorCode, SFlowNodeInstance flowNodeInstance, List<SBoundaryEventDefinition> boundaryEventDefinitions) throws SWaitingEventReadException {
        String catchingErrorCode = errorCode;
        boolean canHandleError = this.containsHandler(boundaryEventDefinitions, catchingErrorCode);
        if (!canHandleError) {
            catchingErrorCode = null;
            canHandleError = this.containsHandler(boundaryEventDefinitions, catchingErrorCode);
        }
        if (canHandleError) {
            return this.getEventInstanceService().getBoundaryWaitingErrorEvent(flowNodeInstance.getId(), catchingErrorCode);
        }
        return null;
    }

    private SWaitingErrorEvent getWaitingErrorEventSubProcess(SFlowElementContainerDefinition container, long parentProcessInstanceId, String errorCode) throws SBonitaSearchException, SBPMEventHandlerException {
        String catchingErrorCode = errorCode;
        boolean canHandleError = this.hasEventSubProcessCatchingError(container, catchingErrorCode);
        if (!canHandleError) {
            catchingErrorCode = null;
            canHandleError = this.hasEventSubProcessCatchingError(container, catchingErrorCode);
        }
        SWaitingErrorEvent waitingErrorEvent = null;
        if (canHandleError) {
            SWaitingErrorEventBuilder waitingErrorEventKeyProvider = this.getInstanceBuilders().getSWaitingErrorEventBuilder();
            OrderByOption orderByOption = new OrderByOption(SWaitingEvent.class, waitingErrorEventKeyProvider.getFlowNodeNameKey(), OrderByType.ASC);
            ArrayList<FilterOption> filters = new ArrayList<FilterOption>(3);
            filters.add(new FilterOption(SWaitingErrorEvent.class, waitingErrorEventKeyProvider.getErrorCodeKey(), catchingErrorCode));
            filters.add(new FilterOption(SWaitingErrorEvent.class, waitingErrorEventKeyProvider.getEventTypeKey(), SBPMEventType.EVENT_SUB_PROCESS.name()));
            filters.add(new FilterOption(SWaitingErrorEvent.class, waitingErrorEventKeyProvider.getParentProcessInstanceIdKey(), parentProcessInstanceId));
            QueryOptions queryOptions = new QueryOptions(0, 2, Collections.singletonList(orderByOption), filters, null);
            List<SWaitingErrorEvent> waitingEvents = this.getEventInstanceService().searchWaitingEvents(SWaitingErrorEvent.class, queryOptions);
            if (waitingEvents.size() != 1) {
                StringBuilder stb = new StringBuilder();
                stb.append("One and only one error start event sub-process was expected for the process instance ");
                stb.append(parentProcessInstanceId);
                stb.append(" and error code ");
                stb.append(catchingErrorCode);
                stb.append(", but ");
                stb.append(waitingEvents.size());
                stb.append(" was found.");
                throw new SBPMEventHandlerException(stb.toString());
            }
            waitingErrorEvent = waitingEvents.get(0);
        }
        return waitingErrorEvent;
    }

    private boolean containsHandler(List<SBoundaryEventDefinition> boundaryEventDefinitions, String errorCode) {
        boolean found = false;
        Iterator<SBoundaryEventDefinition> iterator = boundaryEventDefinitions.iterator();
        while (iterator.hasNext() && !found) {
            SBoundaryEventDefinition boundaryEventDefinition = iterator.next();
            SCatchErrorEventTriggerDefinition currentErrorTrigger = boundaryEventDefinition.getErrorEventTriggerDefinition(errorCode);
            if (currentErrorTrigger == null) continue;
            found = true;
        }
        return found;
    }

    private boolean hasEventSubProcessCatchingError(SFlowElementContainerDefinition container, String errorCode) {
        boolean found = false;
        Iterator<SActivityDefinition> iterator = container.getActivities().iterator();
        while (iterator.hasNext() && !found) {
            SSubProcessDefinition eventSubProcess;
            SStartEventDefinition startEventDefinition;
            SActivityDefinition activity = iterator.next();
            if (!SFlowNodeType.SUB_PROCESS.equals((Object)activity.getType()) || !((SSubProcessDefinition)activity).isTriggeredByEvent() || (startEventDefinition = (eventSubProcess = (SSubProcessDefinition)activity).getSubProcessContainer().getStartEvents().get(0)).getErrorEventTriggerDefinition(errorCode) == null) continue;
            found = true;
        }
        return found;
    }

    @Override
    public void handleCatchEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SCatchEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        SWaitingErrorEventBuilder builder = this.getInstanceBuilders().getSWaitingErrorEventBuilder();
        SErrorEventTriggerDefinition errorEventTriggerDefinition = (SErrorEventTriggerDefinition)sEventTriggerDefinition;
        SIntermediateCatchEventInstanceBuilder eventInstanceKeyProvider = this.getInstanceBuilders().getSIntermediateCatchEventInstanceBuilder();
        switch (eventDefinition.getType()) {
            case BOUNDARY_EVENT: {
                SBoundaryEventInstance boundary = (SBoundaryEventInstance)eventInstance;
                long rootProcessInstanceId = eventInstance.getLogicalGroup(eventInstanceKeyProvider.getRootProcessInstanceIndex());
                long parentProcessInstanceId = eventInstance.getLogicalGroup(eventInstanceKeyProvider.getParentProcessInstanceIndex());
                builder.createNewWaitingErrorBoundaryEventInstance(processDefinition.getId(), rootProcessInstanceId, parentProcessInstanceId, eventInstance.getId(), errorEventTriggerDefinition.getErrorCode(), processDefinition.getName(), eventInstance.getFlowNodeDefinitionId(), eventInstance.getName(), boundary.getActivityInstanceId());
                SWaitingErrorEvent errorEvent = builder.done();
                this.getEventInstanceService().createWaitingEvent(errorEvent);
                break;
            }
            case INTERMEDIATE_CATCH_EVENT: 
            case START_EVENT: {
                throw new SWaitingEventCreationException("Catch error event cannot be put in " + (Object)((Object)eventDefinition.getType()) + ". They must be used as boundary events or start event subprocess.");
            }
            default: {
                throw new SWaitingEventCreationException((Object)((Object)eventDefinition.getType()) + " is not a catch event.");
            }
        }
    }

    @Override
    public OperationsWithContext getOperations(SWaitingEvent waitingEvent, Long triggeringElementID) {
        return EMPTY;
    }

    @Override
    public void handleEventSubProcess(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SEventTriggerDefinition sEventTriggerDefinition, long subProcessId, SProcessInstance parentProcessInstance) throws SBonitaException {
        SWaitingErrorEventBuilder builder = this.getInstanceBuilders().getSWaitingErrorEventBuilder();
        SErrorEventTriggerDefinition trigger = (SErrorEventTriggerDefinition)sEventTriggerDefinition;
        builder.createNewWaitingErrorEventSubProcInstance(processDefinition.getId(), parentProcessInstance.getId(), parentProcessInstance.getRootProcessInstanceId(), trigger.getErrorCode(), processDefinition.getName(), eventDefinition.getId(), eventDefinition.getName(), subProcessId);
        SWaitingErrorEvent event = builder.done();
        this.getEventInstanceService().createWaitingEvent(event);
    }
}

