/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SReceiveTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SCatchEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCorrelationDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SEventTriggerInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventCreationException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSendTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SCorrelationContainerBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SMessageInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingMessageEventBuilder;
import org.bonitasoft.engine.core.process.instance.model.event.SCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SBPMEventType;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingMessageEvent;
import org.bonitasoft.engine.core.process.instance.model.event.trigger.SThrowMessageEventTriggerInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilders;
import org.bonitasoft.engine.execution.event.CoupleEventHandlerStrategy;
import org.bonitasoft.engine.execution.event.OperationsWithContext;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class MessageEventHandlerStrategy
extends CoupleEventHandlerStrategy {
    private static final String CORRELATION_NO_VALUE = "NONE";
    private final ExpressionResolverService expressionResolverService;
    private final BPMInstancesCreator bpmInstancesCreator;
    private final DataInstanceService dataInstanceService;
    private final SDataInstanceBuilders sDataInstanceBuilders;
    private final ProcessDefinitionService processDefinitionService;

    public MessageEventHandlerStrategy(ExpressionResolverService expressionResolverService, BPMInstanceBuilders instanceBuilders, EventInstanceService eventInstanceService, BPMInstancesCreator bpmInstancesCreator, DataInstanceService dataInstanceService, SDataInstanceBuilders sDataInstanceBuilders, ProcessDefinitionService processDefinitionService) {
        super(instanceBuilders, eventInstanceService);
        this.expressionResolverService = expressionResolverService;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.dataInstanceService = dataInstanceService;
        this.sDataInstanceBuilders = sDataInstanceBuilders;
        this.processDefinitionService = processDefinitionService;
    }

    @Override
    public void handleCatchEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SCatchEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        SExpressionContext expressionContext;
        SWaitingMessageEventBuilder builder;
        SCatchMessageEventTriggerDefinition messageTrigger = (SCatchMessageEventTriggerDefinition)sEventTriggerDefinition;
        String messageName = messageTrigger.getMessageName();
        String processName = processDefinition.getName();
        switch (eventDefinition.getType()) {
            case BOUNDARY_EVENT: {
                builder = this.getInstanceBuilders().getSWaitingMessageEventBuilder().createNewWaitingMessageBoundaryEventInstance(processDefinition.getId(), eventInstance.getRootContainerId(), eventInstance.getParentProcessInstanceId(), eventInstance.getId(), messageName, processName, eventInstance.getFlowNodeDefinitionId(), eventInstance.getName());
                expressionContext = new SExpressionContext((Long)eventInstance.getParentContainerId(), this.getParentContainerType(eventInstance).name(), processDefinition.getId());
                break;
            }
            case INTERMEDIATE_CATCH_EVENT: {
                builder = this.getInstanceBuilders().getSWaitingMessageEventBuilder().createNewWaitingMessageIntermediateEventInstance(processDefinition.getId(), eventInstance.getRootContainerId(), eventInstance.getParentProcessInstanceId(), eventInstance.getId(), messageName, processName, eventInstance.getFlowNodeDefinitionId(), eventInstance.getName());
                expressionContext = new SExpressionContext((Long)eventInstance.getParentContainerId(), this.getParentContainerType(eventInstance).name(), processDefinition.getId());
                break;
            }
            case START_EVENT: {
                builder = this.getInstanceBuilders().getSWaitingMessageEventBuilder().createNewWaitingMessageStartEventInstance(processDefinition.getId(), messageTrigger.getMessageName(), processDefinition.getName(), eventDefinition.getId(), eventDefinition.getName());
                expressionContext = new SExpressionContext();
                expressionContext.setProcessDefinitionId(processDefinition.getId());
                break;
            }
            default: {
                throw new SWaitingEventCreationException((Object)((Object)eventDefinition.getType()) + " is not a catch event.");
            }
        }
        this.fillCorrelation(builder, messageTrigger.getCorrelations(), expressionContext);
        this.getEventInstanceService().createWaitingEvent(builder.done());
    }

    public void handleCatchEvent(SProcessDefinition processDefinition, SReceiveTaskInstance receiveTaskInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        SCatchMessageEventTriggerDefinition messageTrigger = (SCatchMessageEventTriggerDefinition)sEventTriggerDefinition;
        String messageName = messageTrigger.getMessageName();
        String processName = processDefinition.getName();
        SWaitingMessageEventBuilder builder = this.getInstanceBuilders().getSWaitingMessageEventBuilder().createNewWaitingMessageIntermediateEventInstance(processDefinition.getId(), receiveTaskInstance.getRootContainerId(), receiveTaskInstance.getParentProcessInstanceId(), receiveTaskInstance.getId(), messageName, processName, receiveTaskInstance.getFlowNodeDefinitionId(), receiveTaskInstance.getName());
        SExpressionContext expressionContext = new SExpressionContext((Long)receiveTaskInstance.getParentContainerId(), this.getParentContainerType(receiveTaskInstance).name(), processDefinition.getId());
        this.fillCorrelation(builder, messageTrigger.getCorrelations(), expressionContext);
        this.getEventInstanceService().createWaitingEvent(builder.done());
    }

    @Override
    public void handleThrowEvent(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SThrowEventInstance eventInstance, SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        long eventInstanceId = eventInstance.getId();
        String eventInstanceName = eventInstance.getName();
        long parentContainerId = eventInstance.getParentContainerId();
        Long processDefinitionId = processDefinition.getId();
        SExpressionContext expressionContext = new SExpressionContext((Long)parentContainerId, this.getParentContainerType(eventInstance).name(), processDefinitionId);
        this.handleThrowMessage(sEventTriggerDefinition, eventInstanceId, eventInstanceName, processDefinitionId, expressionContext);
    }

    public void handleThrowEvent(SProcessDefinition processDefinition, SSendTaskInstance sendTaskInstance, SThrowMessageEventTriggerDefinition messageTrigger) throws SEventTriggerInstanceCreationException, SMessageInstanceCreationException, SDataInstanceException, SExpressionException {
        long eventInstanceId = sendTaskInstance.getId();
        String eventInstanceName = sendTaskInstance.getName();
        long parentContainerId = sendTaskInstance.getParentContainerId();
        Long processDefinitionId = processDefinition.getId();
        SExpressionContext expressionContext = new SExpressionContext((Long)parentContainerId, this.getParentContainerType(sendTaskInstance).name(), processDefinitionId);
        this.handleThrowMessage(messageTrigger, eventInstanceId, eventInstanceName, processDefinitionId, expressionContext);
    }

    private void handleThrowMessage(SEventTriggerDefinition sEventTriggerDefinition, long eventInstanceId, String eventInstanceName, Long processDefinitionId, SExpressionContext expressionContext) throws SEventTriggerInstanceCreationException, SMessageInstanceCreationException, SDataInstanceException, SExpressionException {
        SThrowMessageEventTriggerDefinition messageTrigger = (SThrowMessageEventTriggerDefinition)sEventTriggerDefinition;
        String messageName = messageTrigger.getMessageName();
        SExpression targetProcess = messageTrigger.getTargetProcess();
        SExpression targetFlowNode = messageTrigger.getTargetFlowNode();
        String stringTargetProcess = (String)this.expressionResolverService.evaluate(targetProcess);
        String stringTargetFlowNode = null;
        if (targetFlowNode != null) {
            stringTargetFlowNode = (String)this.expressionResolverService.evaluate(targetFlowNode);
        }
        SThrowMessageEventTriggerInstance messageEventTriggerInstance = this.getInstanceBuilders().getSThrowMessageEventTriggerInstanceBuilder().createNewInstance(eventInstanceId, messageName, stringTargetProcess, stringTargetFlowNode).done();
        this.getEventInstanceService().createEventTriggerInstance(messageEventTriggerInstance);
        SMessageInstanceBuilder builder = this.getInstanceBuilders().getSMessageInstanceBuilder().createNewInstance(messageEventTriggerInstance, processDefinitionId, eventInstanceName);
        List<SCorrelationDefinition> correlations = messageTrigger.getCorrelations();
        this.fillCorrelation(builder, correlations, expressionContext);
        SMessageInstance messageInstance = builder.done();
        this.getEventInstanceService().createMessageInstance(messageInstance);
        if (!messageTrigger.getDataDefinitions().isEmpty()) {
            this.bpmInstancesCreator.createDataInstances(messageTrigger.getDataDefinitions(), messageInstance.getId(), DataInstanceContainer.MESSAGE_INSTANCE, expressionContext, this.expressionResolverService, this.dataInstanceService, this.sDataInstanceBuilders);
            this.dataInstanceService.createDataContainer(messageInstance.getId(), DataInstanceContainer.MESSAGE_INSTANCE.name());
            TechnicalLoggerService logger = this.bpmInstancesCreator.getLogger();
            if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                StringBuilder stb = new StringBuilder();
                stb.append("Initialized variables for message instance [name: <");
                stb.append(messageInstance.getMessageName());
                stb.append(">, id: <");
                stb.append(messageInstance.getId());
                stb.append(">, flow node: <");
                stb.append(messageInstance.getFlowNodeName());
                stb.append(">, target flow node: <");
                stb.append(messageInstance.getTargetFlowNode());
                stb.append(">, target process: <");
                stb.append(messageInstance.getTargetProcess());
                stb.append(">, process definition: <");
                stb.append(messageInstance.getProcessDefinitionId());
                stb.append(">]");
                logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, stb.toString());
            }
        }
    }

    private void fillCorrelation(SCorrelationContainerBuilder builder, List<SCorrelationDefinition> correlations, SExpressionContext expressionContext) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        int size = correlations.size();
        size = Math.min(5, size);
        ArrayList<SExpression> toEval = new ArrayList<SExpression>(size * 2);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                SCorrelationDefinition sCorrelationDefinition = correlations.get(i);
                toEval.add(sCorrelationDefinition.getKey());
                toEval.add(sCorrelationDefinition.getValue());
            }
            List<Object> res = this.expressionResolverService.evaluate(toEval, expressionContext);
            ArrayList<String> keys = new ArrayList<String>(size);
            ArrayList<String> values = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                keys.add(String.valueOf(res.get(i * 2)));
                values.add(String.valueOf(res.get(i * 2 + 1)));
            }
            ArrayList sortedKeys = new ArrayList(keys);
            Collections.sort(sortedKeys);
            for (int i = 0; i < size; ++i) {
                String key = (String)sortedKeys.get(i);
                builder.setCorrelation(i + 1, key + "-$-" + (String)values.get(keys.indexOf(key)));
            }
        }
        for (int i = size; i < 5; ++i) {
            builder.setCorrelation(i + 1, CORRELATION_NO_VALUE);
        }
    }

    @Override
    public OperationsWithContext getOperations(SWaitingEvent waitingEvent, Long triggeringElementID) throws SBonitaException {
        SMessageInstance messageInstance = this.getEventInstanceService().getMessageInstance(triggeringElementID);
        SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(waitingEvent.getProcessDefinitionId());
        SExpressionContext context = new SExpressionContext((Long)messageInstance.getId(), DataInstanceContainer.MESSAGE_INSTANCE.name(), processDefinition.getId());
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        SFlowNodeDefinition targetFlowNode = processContainer.getFlowNode(waitingEvent.getFlowNodeName());
        SCatchMessageEventTriggerDefinition messageEventTrigger = null;
        if (targetFlowNode instanceof SReceiveTaskDefinition) {
            messageEventTrigger = ((SReceiveTaskDefinition)targetFlowNode).getTrigger();
        } else {
            SCatchEventDefinition catchEvent = SBPMEventType.BOUNDARY_EVENT.equals((Object)waitingEvent.getEventType()) ? processContainer.getBoundaryEvent(messageInstance.getTargetFlowNode()) : (SCatchEventDefinition)targetFlowNode;
            messageEventTrigger = catchEvent.getMessageEventTriggerDefinition(messageInstance.getMessageName());
        }
        List<SOperation> operations = messageEventTrigger.getOperations();
        return new OperationsWithContext(context, operations);
    }

    @Override
    public void handleThrowEvent(SEventTriggerDefinition sEventTriggerDefinition) throws SBonitaException {
        this.handleThrowMessage(sEventTriggerDefinition, -1L, "", -1L, null);
    }

    @Override
    public void handleEventSubProcess(SProcessDefinition processDefinition, SEventDefinition eventDefinition, SEventTriggerDefinition sEventTriggerDefinition, long subProcessId, SProcessInstance parentProcessInstance) throws SBonitaException {
        SWaitingMessageEventBuilder builder = this.getInstanceBuilders().getSWaitingMessageEventBuilder();
        SMessageEventTriggerDefinition messageEventTriggerDefinition = (SMessageEventTriggerDefinition)sEventTriggerDefinition;
        builder.createNewWaitingMessageEventSubProcInstance(processDefinition.getId(), parentProcessInstance.getId(), parentProcessInstance.getRootProcessInstanceId(), messageEventTriggerDefinition.getMessageName(), processDefinition.getName(), eventDefinition.getId(), eventDefinition.getName(), subProcessId);
        SExpressionContext expressionContext = new SExpressionContext((Long)parentProcessInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.name(), processDefinition.getId());
        this.fillCorrelation(builder, messageEventTriggerDefinition.getCorrelations(), expressionContext);
        SWaitingMessageEvent event = builder.done();
        this.getEventInstanceService().createWaitingEvent(event);
    }

    @Override
    public boolean handlePostThrowEvent(SProcessDefinition processDefinition, SEndEventDefinition sEventDefinition, SThrowEventInstance sThrowEventInstance, SEventTriggerDefinition sEventTriggerDefinition, SFlowNodeInstance sFlowNodeInstance) {
        return false;
    }
}

