/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Map;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventReadException;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingMessageEvent;
import org.bonitasoft.engine.execution.work.TenantAwareBonitaWork;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class ExecuteMessageCoupleWork
extends TenantAwareBonitaWork {
    private static final long serialVersionUID = 2171765554098439091L;
    private final long messageInstanceId;
    private final long waitingMessageId;

    ExecuteMessageCoupleWork(long messageInstanceId, long waitingMessageId) {
        this.messageInstanceId = messageInstanceId;
        this.waitingMessageId = waitingMessageId;
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + ": messageInstanceId: " + this.messageInstanceId + ", waitingMessageId: " + this.waitingMessageId;
    }

    private void resetWaitingMessage(long waitingMessageId, EventInstanceService eventInstanceService, BPMInstanceBuilders instanceBuilders) throws SWaitingEventModificationException, SWaitingEventNotFoundException, SWaitingEventReadException {
        SWaitingMessageEvent waitingMsg = eventInstanceService.getWaitingMessage(waitingMessageId);
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(instanceBuilders.getSWaitingMessageEventBuilder().getProgressKey(), 0);
        eventInstanceService.updateWaitingMessage(waitingMsg, descriptor);
    }

    private void resetMessageInstance(long messageInstanceId, EventInstanceService eventInstanceService, BPMInstanceBuilders instanceBuilders) throws SMessageModificationException, SMessageInstanceNotFoundException, SMessageInstanceReadException {
        SMessageInstance messageInstance = eventInstanceService.getMessageInstance(messageInstanceId);
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(instanceBuilders.getSMessageInstanceBuilder().getHandledKey(), false);
        eventInstanceService.updateMessageInstance(messageInstance, descriptor);
    }

    @Override
    public String getRecoveryProcedure() {
        return "Change the 'progress' field of the waiting message having id " + this.waitingMessageId + " to " + 0 + " and " + "the 'handled' field of the message instance  having id " + this.messageInstanceId + " to false";
    }

    @Override
    public void work(Map<String, Object> context) throws Exception {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        EventInstanceService eventInstanceService = tenantAccessor.getEventInstanceService();
        SWaitingMessageEvent waitingMessage = eventInstanceService.getWaitingMessage(this.waitingMessageId);
        if (waitingMessage != null) {
            tenantAccessor.getEventsHandler().triggerCatchEvent(waitingMessage, this.messageInstanceId);
        }
    }

    @Override
    public void handleFailure(Throwable e, Map<String, Object> context) throws Exception {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        this.resetWaitingMessage(this.waitingMessageId, tenantAccessor.getEventInstanceService(), tenantAccessor.getBPMInstanceBuilders());
        this.resetMessageInstance(this.messageInstanceId, tenantAccessor.getEventInstanceService(), tenantAccessor.getBPMInstanceBuilders());
    }
}

