/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.api.impl.APIAccessorImpl;
import org.bonitasoft.engine.connector.ConnectorAPIAccessorImpl;
import org.bonitasoft.engine.connector.EngineExecutionContext;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.expression.ExpressionConstants;
import org.bonitasoft.engine.expression.ExpressionConstantsResolver;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;
import org.bonitasoft.engine.sessionaccessor.TenantIdNotSetException;

public class EngineConstantExpressionExecutorStrategy
implements ExpressionExecutorStrategy {
    private final ActivityInstanceService activityInstanceService;
    private final ProcessInstanceService processInstanceService;
    protected final ReadSessionAccessor sessionAccessor;
    protected final SessionService sessionService;

    public EngineConstantExpressionExecutorStrategy(ActivityInstanceService activityInstanceService, ProcessInstanceService processInstanceService, SessionService sessionService, ReadSessionAccessor sessionAccessor) {
        this.activityInstanceService = activityInstanceService;
        this.processInstanceService = processInstanceService;
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
    }

    @Override
    public Serializable evaluate(SExpression expression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException {
        ExpressionConstants expressionConstant = ExpressionConstantsResolver.getExpressionConstantsFromName((String)expression.getContent());
        if (expressionConstant == null) {
            expressionConstant = ExpressionConstants.API_ACCESSOR;
            expressionConstant = ExpressionConstantsResolver.getExpressionConstantsFromName((String)expression.getContent());
        }
        if (expressionConstant == null) {
            throw new SExpressionEvaluationException(expression.getContent() + " is not a valid Engine-provided variable");
        }
        switch (expressionConstant) {
            case API_ACCESSOR: {
                return this.getApiAccessor();
            }
            case CONNECTOR_API_ACCESSOR: {
                return this.getConnectorApiAccessor();
            }
            case ENGINE_EXECUTION_CONTEXT: {
                return this.getFromContextOrEngineExecutionContext(expressionConstant, dependencyValues);
            }
            case ACTIVITY_INSTANCE_ID: {
                return this.getFromContextOrEngineExecutionContext(expressionConstant, dependencyValues);
            }
            case PROCESS_INSTANCE_ID: {
                return this.getFromContextOrEngineExecutionContext(expressionConstant, dependencyValues);
            }
            case PROCESS_DEFINITION_ID: {
                return this.getFromContextOrEngineExecutionContext(expressionConstant, dependencyValues);
            }
            case ROOT_PROCESS_INSTANCE_ID: {
                return this.getFromContextOrEngineExecutionContext(expressionConstant, dependencyValues);
            }
            case TASK_ASSIGNEE_ID: {
                return this.getFromContextOrEngineExecutionContext(expressionConstant, dependencyValues);
            }
            case LOGGED_USER_ID: {
                return Long.valueOf(this.getLoggedUserFromSession());
            }
        }
        return this.inContext(expressionConstant, dependencyValues);
    }

    protected APIAccessorImpl getApiAccessor() {
        return new APIAccessorImpl();
    }

    protected APIAccessor getConnectorApiAccessor() throws SExpressionEvaluationException {
        long tenantId;
        try {
            tenantId = this.sessionAccessor.getTenantId();
        }
        catch (TenantIdNotSetException e) {
            throw new SExpressionEvaluationException(e);
        }
        return new ConnectorAPIAccessorImpl(tenantId);
    }

    private long getLoggedUserFromSession() throws SExpressionEvaluationException {
        try {
            return this.sessionService.getSession(this.sessionAccessor.getSessionId()).getUserId();
        }
        catch (SSessionNotFoundException e) {
            throw new SExpressionEvaluationException(e);
        }
        catch (SessionIdNotSetException e) {
            return -1L;
        }
    }

    private Serializable getFromContextOrEngineExecutionContext(ExpressionConstants expressionConstant, Map<String, Object> dependencyValues) throws SExpressionEvaluationException {
        Object object = dependencyValues.get(expressionConstant.getEngineConstantName());
        if (object == null) {
            EngineExecutionContext context = (EngineExecutionContext)dependencyValues.get(ExpressionConstants.ENGINE_EXECUTION_CONTEXT.getEngineConstantName());
            if (context != null) {
                return context.getExpressionConstant(expressionConstant);
            }
            return this.evaluate(expressionConstant, dependencyValues);
        }
        return (Serializable)object;
    }

    private Serializable evaluate(ExpressionConstants expressionConstant, Map<String, Object> dependencyValues) throws SExpressionEvaluationException {
        if (ExpressionConstants.ENGINE_EXECUTION_CONTEXT.equals((Object)expressionConstant)) {
            return this.createContext(dependencyValues);
        }
        if (dependencyValues.containsKey("containerType") && dependencyValues.containsKey("containerId")) {
            String containerType = (String)dependencyValues.get("containerType");
            long containerId = (Long)dependencyValues.get("containerId");
            if (ExpressionConstants.PROCESS_DEFINITION_ID.equals((Object)expressionConstant)) {
                return (Serializable)dependencyValues.get("processDefinitionId");
            }
            if (DataInstanceContainer.ACTIVITY_INSTANCE.toString().equals(containerType)) {
                return this.evaluteUsingActivityInstanceContainer(expressionConstant, dependencyValues, containerId);
            }
            return this.evaluateUsingProcessInstanceContainer(expressionConstant, dependencyValues, containerId);
        }
        return Integer.valueOf(-1);
    }

    private Serializable evaluateUsingProcessInstanceContainer(ExpressionConstants expressionConstant, Map<String, Object> dependencyValues, long containerId) throws SExpressionEvaluationException {
        if (ExpressionConstants.PROCESS_INSTANCE_ID.equals((Object)expressionConstant)) {
            return Long.valueOf(containerId);
        }
        if (ExpressionConstants.TASK_ASSIGNEE_ID.equals((Object)expressionConstant)) {
            return Integer.valueOf(-1);
        }
        this.fillDependenciesFromProcessInstance(dependencyValues, containerId);
        return this.getNonNullLong(expressionConstant, dependencyValues);
    }

    private Serializable evaluteUsingActivityInstanceContainer(ExpressionConstants expressionConstant, Map<String, Object> dependencyValues, long containerId) throws SExpressionEvaluationException {
        if (ExpressionConstants.ACTIVITY_INSTANCE_ID.equals((Object)expressionConstant)) {
            return Long.valueOf(containerId);
        }
        this.fillDependenciesFromFlowNodeInstance(dependencyValues, containerId);
        return this.getNonNullLong(expressionConstant, dependencyValues);
    }

    private Serializable getNonNullLong(ExpressionConstants expressionConstant, Map<String, Object> dependencyValues) {
        Serializable serializable = (Serializable)dependencyValues.get(expressionConstant.getEngineConstantName());
        return serializable == null ? Long.valueOf(-1L) : serializable;
    }

    private void fillDependenciesFromProcessInstance(Map<String, Object> dependencyValues, long processInstanceId) throws SExpressionEvaluationException {
        try {
            SProcessInstance processInstance = this.processInstanceService.getProcessInstance(processInstanceId);
            dependencyValues.put(ExpressionConstants.PROCESS_INSTANCE_ID.getEngineConstantName(), processInstance.getId());
            dependencyValues.put(ExpressionConstants.ROOT_PROCESS_INSTANCE_ID.getEngineConstantName(), processInstance.getRootProcessInstanceId());
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new SExpressionEvaluationException("Error retrieving process instance while building EngineExecutionContext as EngineConstantExpression", e);
        }
        catch (SProcessInstanceReadException e) {
            throw new SExpressionEvaluationException("Error retrieving process instance while building EngineExecutionContext as EngineConstantExpression", e);
        }
    }

    private void fillDependenciesFromFlowNodeInstance(Map<String, Object> dependencyValues, long flowNodeInstanceId) throws SExpressionEvaluationException {
        try {
            SFlowNodeInstance flowNodeInstance = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
            dependencyValues.put(ExpressionConstants.PROCESS_INSTANCE_ID.getEngineConstantName(), flowNodeInstance.getLogicalGroup(3));
            dependencyValues.put(ExpressionConstants.ROOT_PROCESS_INSTANCE_ID.getEngineConstantName(), flowNodeInstance.getLogicalGroup(1));
            if (this.isHumanTask(flowNodeInstance)) {
                SHumanTaskInstance taskInstance = (SHumanTaskInstance)flowNodeInstance;
                dependencyValues.put(ExpressionConstants.TASK_ASSIGNEE_ID.getEngineConstantName(), taskInstance.getAssigneeId());
            }
        }
        catch (SFlowNodeReadException e) {
            throw new SExpressionEvaluationException("Error retrieving flow node instance while building EngineExecutionContext as EngineConstantExpression", e);
        }
        catch (SFlowNodeNotFoundException e) {
            throw new SExpressionEvaluationException("Error retrieving flow node instance while building EngineExecutionContext as EngineConstantExpression", e);
        }
    }

    private boolean isHumanTask(SFlowNodeInstance flowNodeInstance) {
        return SFlowNodeType.USER_TASK.equals((Object)flowNodeInstance.getType()) || SFlowNodeType.MANUAL_TASK.equals((Object)flowNodeInstance.getType());
    }

    private Serializable inContext(ExpressionConstants expressionConstant, Map<String, Object> dependencyValues) throws SExpressionEvaluationException {
        Object object = dependencyValues.get(expressionConstant.getEngineConstantName());
        if (object == null) {
            throw new SExpressionEvaluationException("EngineConstantExpression not supported for: " + expressionConstant.getEngineConstantName());
        }
        return (Serializable)object;
    }

    private Serializable createContext(Map<String, Object> dependencyValues) throws SExpressionEvaluationException {
        EngineExecutionContext ctx = new EngineExecutionContext();
        if (dependencyValues.containsKey("containerType") && dependencyValues.containsKey("containerId")) {
            String containerType = (String)dependencyValues.get("containerType");
            long containerId = (Long)dependencyValues.get("containerId");
            if (DataInstanceContainer.ACTIVITY_INSTANCE.toString().equals(containerType)) {
                this.updateContextFromActivityInstance(ctx, containerId);
            } else if (DataInstanceContainer.PROCESS_INSTANCE.toString().equals(containerType)) {
                this.updateContextFromProcessInstance(ctx, containerId);
            }
        }
        if (dependencyValues.containsKey("processDefinitionId")) {
            ctx.setProcessDefinitionId(((Long)dependencyValues.get("processDefinitionId")).longValue());
        }
        return ctx;
    }

    private void updateContextFromProcessInstance(EngineExecutionContext ctx, long processInstanceId) throws SExpressionEvaluationException {
        try {
            SProcessInstance processInstance = this.processInstanceService.getProcessInstance(processInstanceId);
            ctx.setProcessInstanceId(processInstance.getId());
            ctx.setRootProcessInstanceId(processInstance.getRootProcessInstanceId());
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new SExpressionEvaluationException("Error retrieving process instance while building EngineExecutionContext as EngineConstantExpression", e);
        }
        catch (SProcessInstanceReadException e) {
            throw new SExpressionEvaluationException("Error retrieving process instance while building EngineExecutionContext as EngineConstantExpression", e);
        }
    }

    private void updateContextFromActivityInstance(EngineExecutionContext ctx, long activityInstanceId) throws SExpressionEvaluationException {
        ctx.setActivityInstanceId(activityInstanceId);
        try {
            SActivityInstance activityInstance = this.activityInstanceService.getActivityInstance(activityInstanceId);
            ctx.setProcessInstanceId(activityInstance.getParentProcessInstanceId());
            ctx.setRootProcessInstanceId(activityInstance.getRootProcessInstanceId());
            if (this.isHumanTask(activityInstance)) {
                ctx.setTaskAssigneeId(((SHumanTaskInstance)activityInstance).getAssigneeId());
            }
        }
        catch (SActivityReadException e) {
            throw new SExpressionEvaluationException("Error retrieving Activity instance while building EngineExecutionContext as EngineConstantExpression", e);
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new SExpressionEvaluationException("Error retrieving Activity instance while building EngineExecutionContext as EngineConstantExpression", e);
        }
    }

    @Override
    public void validate(SExpression expression) throws SInvalidExpressionException {
        if (ExpressionConstantsResolver.getExpressionConstantsFromName((String)expression.getContent()) == null) {
            throw new SInvalidExpressionException("Unable to get Engine Constant '" + expression.getContent() + "' in expression: " + expression);
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_ENGINE_CONSTANT;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException {
        ArrayList<Object> results = new ArrayList<Object>();
        for (SExpression sExpression : expressions) {
            results.add(this.evaluate(sExpression, (Map)dependencyValues, (Map)resolvedExpressions));
        }
        return results;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return true;
    }
}

