/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategyProvider;
import org.bonitasoft.engine.expression.ExpressionService;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class ExpressionServiceImpl
implements ExpressionService {
    private final Map<ExpressionKind, ExpressionExecutorStrategy> expressionExecutorsMap;
    private final TechnicalLoggerService logger;
    private boolean checkExpressionReturnType = false;

    public ExpressionServiceImpl(ExpressionExecutorStrategyProvider expressionExecutorStrategyProvider, TechnicalLoggerService logger, boolean checkExpressionReturnType) {
        List<ExpressionExecutorStrategy> expressionExecutors = expressionExecutorStrategyProvider.getExpressionExecutors();
        this.expressionExecutorsMap = new HashMap<ExpressionKind, ExpressionExecutorStrategy>(expressionExecutors.size());
        this.checkExpressionReturnType = checkExpressionReturnType;
        for (ExpressionExecutorStrategy expressionExecutorStrategy : expressionExecutors) {
            this.expressionExecutorsMap.put(expressionExecutorStrategy.getExpressionKind(), expressionExecutorStrategy);
        }
        this.logger = logger;
    }

    @Override
    public Object evaluate(SExpression expression, Map<Integer, Object> resolvedExpressions) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        return this.evaluate(expression, null, resolvedExpressions);
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        boolean isTraceEnable = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (isTraceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "evaluate"));
        }
        if (dependencyValues == null) {
            dependencyValues = new HashMap<String, Object>(1);
        }
        ExpressionExecutorStrategy expressionExecutorStrategy = this.expressionExecutorsMap.get(expression.getExpressionKind());
        String expressContent = expression.getContent();
        if (expressionExecutorStrategy == null) {
            if (isTraceEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "evaluate", "Unable to find an executor for expression type " + expression.getExpressionKind()));
            }
            throw new SExpressionTypeUnknownException("Unable to find an executor for expression type " + expression.getExpressionKind());
        }
        try {
            expressionExecutorStrategy.validate(expression);
        }
        catch (SInvalidExpressionException e) {
            if (isTraceEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "evaluate", "Invalid Expression: " + expressContent));
            }
            throw e;
        }
        Object expressionResult = expressionExecutorStrategy.evaluate(expression, dependencyValues, resolvedExpressions);
        this.checkReturnType(expression, expressionResult);
        if (isTraceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "evaluate"));
        }
        return expressionResult;
    }

    @Override
    public List<Object> evaluate(ExpressionKind expressionKind, List<SExpression> expressions, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        ExpressionExecutorStrategy expressionExecutorStrategy;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "evaluate"));
        }
        if ((expressionExecutorStrategy = this.expressionExecutorsMap.get(expressionKind)) == null) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "evaluate", "Unable to find an executor for expression type " + expressionKind));
            }
            throw new SExpressionTypeUnknownException("Unable to find an executor for expression type " + expressionKind);
        }
        List<Object> list = expressionExecutorStrategy.evaluate(expressions, dependencyValues, resolvedExpressions);
        if (list == null || list.size() != expressions.size()) {
            String exceptionMessage = "Result list size " + (list == null ? 0 : list.size()) + " is different from expression list size " + expressions.size();
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "evaluate", exceptionMessage));
            }
            throw new SExpressionEvaluationException(exceptionMessage);
        }
        for (int i = 0; i < list.size(); ++i) {
            this.checkReturnType(expressions.get(i), list.get(i));
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "evaluate"));
        }
        return list;
    }

    private void checkReturnType(SExpression expression, Object result) throws SInvalidExpressionException {
        if (this.mustCheckExpressionReturnType() && result != null) {
            try {
                Class<?> declaredReturnedType = Thread.currentThread().getContextClassLoader().loadClass(expression.getReturnType());
                Class<?> evaluatedReturnedType = result.getClass();
                if (!declaredReturnedType.isAssignableFrom(evaluatedReturnedType)) {
                    throw new SInvalidExpressionException("Declared return type " + declaredReturnedType + " is not compatible with evaluated type " + evaluatedReturnedType + " for expression " + expression.getName());
                }
            }
            catch (ClassNotFoundException e) {
                throw new SInvalidExpressionException("Declared return type unknown: " + expression.getReturnType() + " for expression " + expression.getName(), e);
            }
        }
    }

    @Override
    public boolean mustCheckExpressionReturnType() {
        return this.checkExpressionReturnType;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext(ExpressionKind expressionKind) {
        return this.expressionExecutorsMap.get(expressionKind).mustPutEvaluatedExpressionInContext();
    }
}

