/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathReadExpressionExecutorStrategy
implements ExpressionExecutorStrategy {
    @Override
    public Object evaluate(SExpression expression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException, SExpressionDependencyMissingException {
        try {
            if (expression.getDependencies().size() != 1 || expression.getDependencies().get(0) == null) {
                throw new SExpressionDependencyMissingException("XPathReadExpressionExecutorStrategy must have exactly one dependency");
            }
            String returnType = expression.getReturnType();
            QName qname = this.getXPathConstants(returnType);
            if (qname == null) {
                throw new SExpressionEvaluationException("XPathReadExpressionExecutorStrategy return type not supported: " + expression.getReturnType());
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            SExpression dep = expression.getDependencies().get(0);
            String xmlContent = (String)resolvedExpressions.get(dep.getDiscriminant());
            if (xmlContent == null || xmlContent.isEmpty()) {
                throw new SExpressionEvaluationException("The content of the xml is nul or empty: " + expression);
            }
            Document document = builder.parse(new InputSource(new StringReader(xmlContent)));
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xpath = xpFactory.newXPath();
            XPathExpression exp = xpath.compile(expression.getContent());
            return this.transType(exp.evaluate(document, qname), returnType);
        }
        catch (XPathExpressionException e) {
            throw new SExpressionEvaluationException("Error evaluating expression " + expression + " with strategy XPathReadExpressionExecutorStrategy", e);
        }
        catch (ParserConfigurationException e) {
            throw new SExpressionEvaluationException("Error evaluating expression " + expression + " with strategy XPathReadExpressionExecutorStrategy", e);
        }
        catch (SAXException e) {
            throw new SExpressionEvaluationException("Error evaluating expression " + expression + " with strategy XPathReadExpressionExecutorStrategy", e);
        }
        catch (IOException e) {
            throw new SExpressionEvaluationException("Error evaluating expression " + expression + " with strategy XPathReadExpressionExecutorStrategy", e);
        }
    }

    private Object transType(Object result, String returnType) throws SExpressionEvaluationException {
        try {
            if (Boolean.class.getName().equals(returnType)) {
                return result != null && (((String)result).equalsIgnoreCase("true") || result.equals("1"));
            }
            if (Long.class.getName().equals(returnType)) {
                return Long.parseLong((String)result);
            }
            if (Double.class.getName().equals(returnType)) {
                return Double.parseDouble((String)result);
            }
            if (Float.class.getName().equals(returnType)) {
                return Float.valueOf(Float.parseFloat((String)result));
            }
            if (Integer.class.getName().equals(returnType)) {
                return Integer.parseInt((String)result);
            }
            if (String.class.getName().equals(returnType)) {
                return result;
            }
        }
        catch (NumberFormatException e) {
            throw new SExpressionEvaluationException("Wrong format for " + returnType + " value was " + result);
        }
        return result;
    }

    private QName getXPathConstants(String expReturnType) {
        if (String.class.getName().equals(expReturnType)) {
            return XPathConstants.STRING;
        }
        if (Long.class.getName().equals(expReturnType) || Double.class.getName().equals(expReturnType) || Float.class.getName().equals(expReturnType) || Integer.class.getName().equals(expReturnType)) {
            return XPathConstants.STRING;
        }
        if (Boolean.class.getName().equals(expReturnType)) {
            return XPathConstants.STRING;
        }
        if (Node.class.getName().equals(expReturnType)) {
            return XPathConstants.NODE;
        }
        if (NodeList.class.getName().equals(expReturnType)) {
            return XPathConstants.NODESET;
        }
        return null;
    }

    @Override
    public void validate(SExpression expression) throws SInvalidExpressionException {
        if (expression == null) {
            throw new SInvalidExpressionException("The expression cannot be null.");
        }
        String expressionContent = expression.getContent();
        if (expressionContent == null) {
            throw new SInvalidExpressionException("The expression content cannot be null: " + expression);
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_XPATH_READ;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException, SExpressionDependencyMissingException {
        ArrayList<Object> list = new ArrayList<Object>(expressions.size());
        for (SExpression expression : expressions) {
            list.add(this.evaluate(expression, dependencyValues, resolvedExpressions));
        }
        return list;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }
}

