/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.commons.CollectionUtil;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilder;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SGroupCreationException;
import org.bonitasoft.engine.identity.SGroupDeletionException;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.SMembershipDeletionException;
import org.bonitasoft.engine.identity.SRoleDeletionException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserCreationException;
import org.bonitasoft.engine.identity.SUserDeletionException;
import org.bonitasoft.engine.identity.SUserMembershipCreationException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.SUserUpdateException;
import org.bonitasoft.engine.identity.impl.CredentialsEncrypter;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SProfileMetadataDefinition;
import org.bonitasoft.engine.identity.model.SProfileMetadataValue;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.model.builder.IdentityModelBuilder;
import org.bonitasoft.engine.identity.model.builder.SContactInfoBuilder;
import org.bonitasoft.engine.identity.model.builder.SContactInfoLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SGroupLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SProfileMetadataDefinitionLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SRoleLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserLogBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserMembershipLogBuilder;
import org.bonitasoft.engine.identity.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteAllRecord;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class IdentityServiceImpl
implements IdentityService {
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final SEventBuilder eventBuilder;
    private final IdentityModelBuilder identityModelBuilder;
    private final TechnicalLoggerService logger;
    private final QueriableLoggerService queriableLoggerService;
    private final EventService eventService;
    private final CredentialsEncrypter encrypter;

    public IdentityServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, IdentityModelBuilder identityModelBuilder, TechnicalLoggerService logger, QueriableLoggerService queriableLoggerService, CredentialsEncrypter encrypter) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.eventBuilder = eventService.getEventBuilder();
        this.identityModelBuilder = identityModelBuilder;
        this.logger = logger;
        this.queriableLoggerService = queriableLoggerService;
        this.encrypter = encrypter;
    }

    @Override
    public void createGroup(SGroup group) throws SGroupCreationException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createGroup"));
        }
        long objectId = group.getId();
        SGroupLogBuilder logBuilder = this.getGroupLog(HasCRUDEAction.ActionType.CREATED, "Adding a new group with name " + group.getName());
        try {
            InsertRecord insertRecord = new InsertRecord(group);
            SInsertEvent insertEvent = this.getInsertEvent(group, "GROUP");
            this.recorder.recordInsert(insertRecord, insertEvent);
            boolean status = true;
            this.initiateLogBuilder(insertRecord.getEntity().getId(), 1, logBuilder, "createGroup");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createGroup"));
            }
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createGroup", re));
            }
            boolean status = false;
            this.initiateLogBuilder(objectId, 0, logBuilder, "createGroup");
            throw new SGroupCreationException(re);
        }
    }

    private SInsertEvent getInsertEvent(Object object, String type) {
        if (this.eventService.hasHandlers(type, EventActionType.CREATED)) {
            return (SInsertEvent)this.eventBuilder.createInsertEvent(type).setObject(object).done();
        }
        return null;
    }

    private SDeleteEvent getDeleteEvent(Object object, String type) {
        if (this.eventService.hasHandlers(type, EventActionType.DELETED)) {
            return (SDeleteEvent)this.eventBuilder.createDeleteEvent(type).setObject(object).done();
        }
        return null;
    }

    @Override
    public void createProfileMetadataDefinition(SProfileMetadataDefinition metadata) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createProfileMetadataDefinition"));
        }
        SProfileMetadataDefinitionLogBuilder logBuilder = this.getSProfileMetadataDefinitionLog(HasCRUDEAction.ActionType.CREATED, "Adding a profile metadata with name " + metadata.getName());
        try {
            InsertRecord insertRecord = new InsertRecord(metadata);
            SInsertEvent insertEvent = this.getInsertEvent(metadata, "METADATA");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(metadata.getId(), 1, logBuilder, "createProfileMetadataDefinition");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createProfileMetadataDefinition"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createProfileMetadataDefinition", e));
            }
            this.initiateLogBuilder(metadata.getId(), 0, logBuilder, "createProfileMetadataDefinition");
            throw new SIdentityException("Can't add profile metadata " + metadata, e);
        }
    }

    @Override
    public void createProfileMetadataValue(SProfileMetadataValue metadataValue) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createProfileMetadataValue"));
        }
        try {
            InsertRecord insertRecord = new InsertRecord(metadataValue);
            SInsertEvent insertEvent = this.getInsertEvent(metadataValue, "METADATAVALUE");
            this.recorder.recordInsert(insertRecord, insertEvent);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createProfileMetadataValue"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createProfileMetadataValue", e));
            }
            throw new SIdentityException("Can't add metadata value " + metadataValue, e);
        }
    }

    @Override
    public void createRole(SRole role) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createRole"));
        }
        SRoleLogBuilder logBuilder = this.getRoleLog(HasCRUDEAction.ActionType.CREATED, "Adding a new role with name " + role.getName());
        try {
            InsertRecord insertRecord = new InsertRecord(role);
            SInsertEvent insertEvent = this.getInsertEvent(role, "ROLE");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(role.getId(), 1, logBuilder, "createRole");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createRole"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createRole", e));
            }
            this.initiateLogBuilder(role.getId(), 0, logBuilder, "createRole");
            throw new SIdentityException("Can't add role " + role, e);
        }
    }

    @Override
    public SUser createUser(SUser user) throws SUserCreationException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createUser"));
        }
        String message = "Adding a new user with user name " + user.getUserName() + ", first name " + user.getFirstName() + ", last name " + user.getLastName();
        SUserLogBuilder logBuilder = this.getUserLog(HasCRUDEAction.ActionType.CREATED, message);
        String hash = this.encrypter.hash(user.getPassword());
        SUser hashedUser = this.identityModelBuilder.getUserBuilder().createNewInstance(user).setPassword(hash).done();
        try {
            InsertRecord insertRecord = new InsertRecord(hashedUser);
            SInsertEvent insertEvent = this.getInsertEvent(hashedUser, "USER");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(hashedUser.getId(), 1, logBuilder, "createUser");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createUser"));
            }
            return hashedUser;
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createUser", re));
            }
            this.initiateLogBuilder(hashedUser.getId(), 0, logBuilder, "createUser");
            throw new SUserCreationException(re);
        }
    }

    @Override
    public SContactInfo createUserContactInfo(SContactInfo contactInfo) throws SUserCreationException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createUserContactInfo"));
        }
        String message = "Adding a new user contact information for user with id " + contactInfo.getUserId();
        SContactInfoLogBuilder logBuilder = this.getUserContactInfoLog(HasCRUDEAction.ActionType.CREATED, message, contactInfo);
        try {
            InsertRecord insertRecord = new InsertRecord(contactInfo);
            SInsertEvent insertEvent = this.getInsertEvent(contactInfo, "USER_CONTACT_INFO");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(contactInfo.getId(), 1, logBuilder, "createUserContactInfo");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createUserContactInfo"));
            }
            return contactInfo;
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createUserContactInfo", re));
            }
            this.initiateLogBuilder(contactInfo.getId(), 0, logBuilder, "createUserContactInfo");
            throw new SUserCreationException(re);
        }
    }

    @Override
    public void createUserMembership(SUserMembership userMembership) throws SUserMembershipCreationException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createUserMembership"));
        }
        String message = "Adding a new user membership for user " + userMembership.getUsername() + " with role " + userMembership.getRoleName() + " in group " + userMembership.getGroupName();
        SUserMembershipLogBuilder logBuilder = this.getUserMembershipLog(HasCRUDEAction.ActionType.CREATED, message, userMembership);
        try {
            InsertRecord insertRecord = new InsertRecord(userMembership);
            SInsertEvent insertEvent = this.getInsertEvent(userMembership, "USERMEMBERSHIP");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(userMembership.getId(), 1, logBuilder, "createUserMembership");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createUserMembership"));
            }
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createUserMembership", re));
            }
            this.initiateLogBuilder(userMembership.getId(), 0, logBuilder, "createUserMembership");
            throw new SUserMembershipCreationException(re);
        }
    }

    @Override
    public void deleteGroup(long groupId) throws SGroupNotFoundException, SGroupDeletionException {
        SGroup group = this.getGroup(groupId);
        this.deleteGroup(group);
    }

    @Override
    public void deleteGroup(SGroup group) throws SGroupDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteGroup"));
        }
        SGroupLogBuilder logBuilder = this.getGroupLog(HasCRUDEAction.ActionType.DELETED, "Deleting group " + group.getName());
        try {
            DeleteRecord deleteRecord = new DeleteRecord(group);
            SDeleteEvent deleteEvent = this.getDeleteEvent(group, "GROUP");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(group.getId(), 1, logBuilder, "deleteGroup");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteGroup"));
            }
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteGroup", re));
            }
            this.initiateLogBuilder(group.getId(), 0, logBuilder, "deleteGroup");
            throw new SGroupDeletionException(re);
        }
    }

    @Override
    public void deleteAllGroups() throws SGroupDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SGroup.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SGroupDeletionException("Can't delete all groups.", e);
        }
    }

    @Override
    public List<Long> deleteChildrenGroup(long groupId) throws SGroupDeletionException, SGroupNotFoundException {
        ArrayList<Long> deletedGroups = new ArrayList<Long>();
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteChildrenGroup"));
        }
        try {
            List<SGroup> childrenGroup;
            int nbGroup = 20;
            while (!(childrenGroup = this.getGroupChildren(groupId, 0, 20)).isEmpty()) {
                for (SGroup sGroup : childrenGroup) {
                    deletedGroups.addAll(this.deleteChildrenGroup(sGroup.getId()));
                    deletedGroups.add(sGroup.getId());
                    this.deleteGroup(sGroup);
                }
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteChildrenGroup"));
            }
        }
        catch (SGroupNotFoundException e) {
            throw e;
        }
        catch (SIdentityException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteChildrenGroup", e));
            }
            throw new SGroupDeletionException(e);
        }
        return deletedGroups;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.createNewInstance().actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(HasCRUDEAction.ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    private SGroupLogBuilder getGroupLog(HasCRUDEAction.ActionType actionType, String message) {
        SGroupLogBuilder logBuilder = this.identityModelBuilder.getSIdentityGroupLogBuilder();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private SRoleLogBuilder getRoleLog(HasCRUDEAction.ActionType actionType, String message) {
        SRoleLogBuilder logBuilder = this.identityModelBuilder.getSIdentityRoleLogBuilder();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private SProfileMetadataDefinitionLogBuilder getSProfileMetadataDefinitionLog(HasCRUDEAction.ActionType actionType, String message) {
        SProfileMetadataDefinitionLogBuilder logBuilder = this.identityModelBuilder.getSIdentitySProfileMetadataDefinitionLogBuilder();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private SUserLogBuilder getUserLog(HasCRUDEAction.ActionType actionType, String message) {
        SUserLogBuilder logBuilder = this.identityModelBuilder.getSIdentityUserLogBuilder();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private SContactInfoLogBuilder getUserContactInfoLog(HasCRUDEAction.ActionType actionType, String message, SContactInfo contactInfo) {
        SContactInfoLogBuilder logBuilder = this.identityModelBuilder.getSIdentityUserContactInfoLogBuilder();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.setContactInfoUserId(contactInfo.getUserId());
        return logBuilder;
    }

    private SUserMembershipLogBuilder getUserMembershipLog(HasCRUDEAction.ActionType actionType, String message, SUserMembership userMemberShip) {
        SUserMembershipLogBuilder logBuilder = this.identityModelBuilder.getSIdentityUserMembershipLogBuilder();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.identityUserId(userMemberShip.getUserId());
        logBuilder.roleID(userMemberShip.getRoleId());
        logBuilder.groupId(userMemberShip.getGroupId());
        return logBuilder;
    }

    @Override
    public void deleteProfileMetadataDefinition(long metadataDefinitionId) throws SIdentityException {
        this.deleteProfileMetadataDefinition(this.getProfileMetadataDefinition(metadataDefinitionId));
    }

    @Override
    public void deleteProfileMetadataDefinition(SProfileMetadataDefinition metadata) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteProfileMetadataDefinition"));
        }
        SProfileMetadataDefinitionLogBuilder logBuilder = this.getSProfileMetadataDefinitionLog(HasCRUDEAction.ActionType.DELETED, "Deleting profile metadata with name " + metadata.getName());
        try {
            DeleteRecord deleteRecord = new DeleteRecord(metadata);
            SDeleteEvent deleteEvent = this.getDeleteEvent(metadata, "METADATA");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(metadata.getId(), 1, logBuilder, "deleteProfileMetadataDefinition");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteProfileMetadataDefinition"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteProfileMetadataDefinition", e));
            }
            this.initiateLogBuilder(metadata.getId(), 0, logBuilder, "deleteProfileMetadataDefinition");
            throw new SIdentityException("Can't delete profile metadata " + metadata, e);
        }
    }

    @Override
    public void deleteProfileMetadataValue(long metadataValueId) throws SIdentityException {
        this.deleteProfileMetadataValue(this.getProfileMetadataValue(metadataValueId));
    }

    @Override
    public void deleteProfileMetadataValue(SProfileMetadataValue metadataValue) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteProfileMetadataValue"));
        }
        try {
            DeleteRecord deleteRecord = new DeleteRecord(metadataValue);
            SDeleteEvent deleteEvent = this.getDeleteEvent(metadataValue, "METADATAVALUE");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteProfileMetadataDefinition"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteProfileMetadataValue", e));
            }
            throw new SIdentityException("Can't delete membership " + metadataValue, e);
        }
    }

    @Override
    public void deleteRole(long roleId) throws SRoleNotFoundException, SRoleDeletionException {
        SRole role = this.getRole(roleId);
        this.deleteRole(role);
    }

    @Override
    public void deleteRole(SRole role) throws SRoleDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteRole"));
        }
        SRoleLogBuilder logBuilder = this.getRoleLog(HasCRUDEAction.ActionType.DELETED, "Deleting role with name " + role.getName());
        try {
            DeleteRecord deleteRecord = new DeleteRecord(role);
            SDeleteEvent deleteEvent = this.getDeleteEvent(role, "ROLE");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(role.getId(), 1, logBuilder, "deleteRole");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteRole"));
            }
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteRole", re));
            }
            this.initiateLogBuilder(role.getId(), 0, logBuilder, "deleteRole");
            throw new SRoleDeletionException(re);
        }
    }

    @Override
    public void deleteAllRoles() throws SRoleDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SRole.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SRoleDeletionException("Can't delete all roles.", e);
        }
    }

    @Override
    public void deleteUser(long userId) throws SUserDeletionException {
        try {
            SUser user = this.getUser(userId);
            this.deleteUser(user);
        }
        catch (SUserNotFoundException e) {
            // empty catch block
        }
    }

    @Override
    public void deleteUser(SUser user) throws SUserDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteUser"));
        }
        SUserLogBuilder logBuilder = this.getUserLog(HasCRUDEAction.ActionType.DELETED, "Deleting user with username " + user.getUserName());
        try {
            DeleteRecord deleteRecord = new DeleteRecord(user);
            SDeleteEvent deleteEvent = this.getDeleteEvent(user, "USER");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(user.getId(), 1, logBuilder, "deleteUser");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteUser"));
            }
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteUser", re));
            }
            this.initiateLogBuilder(user.getId(), 0, logBuilder, "deleteUser");
            throw new SUserDeletionException(re);
        }
    }

    @Override
    public void deleteAllUsers() throws SUserDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SUser.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SUserDeletionException("Can't delete all users.", e);
        }
    }

    @Override
    public SUserMembership getLightUserMembership(long userMembershipId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getLightUserMembership"));
        }
        try {
            SUserMembership selectOne = this.persistenceService.selectById(SelectDescriptorBuilder.getLightElementById(SUserMembership.class, "SUserMembership", userMembershipId));
            if (selectOne == null) {
                throw new SIdentityException("Can't get the userMembership with id " + userMembershipId, null);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getLightUserMembership"));
            }
            return selectOne;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getLightUserMembership", e));
            }
            throw new SIdentityException("Can't get the user membership with id " + userMembershipId, e);
        }
    }

    @Override
    public void deleteUserMembership(SUserMembership userMembership) throws SMembershipDeletionException {
        try {
            if (userMembership.getGroupName() != null || userMembership.getUsername() != null || userMembership.getRoleName() != null) {
                userMembership = this.getLightUserMembership(userMembership.getId());
            }
            this.deleteLightUserMembership(userMembership);
        }
        catch (SIdentityException e) {
            throw new SMembershipDeletionException("Can't delete membership " + userMembership, e);
        }
    }

    @Override
    public void deleteUserMembership(long id) throws SMembershipDeletionException {
        try {
            SUserMembership userMembership = this.getLightUserMembership(id);
            this.deleteLightUserMembership(userMembership);
        }
        catch (SIdentityException e) {
            throw new SMembershipDeletionException("Can't delete membership with id " + id, e);
        }
    }

    @Override
    public void deleteLightUserMembership(SUserMembership userMembership) throws SMembershipDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteUserMembership"));
        }
        String message = "Deleting user membership for user " + userMembership.getUsername() + " with role " + userMembership.getRoleName() + " in group " + userMembership.getGroupName();
        SUserMembershipLogBuilder logBuilder = this.getUserMembershipLog(HasCRUDEAction.ActionType.DELETED, message, userMembership);
        try {
            DeleteRecord deleteRecord = new DeleteRecord(userMembership);
            SDeleteEvent deleteEvent = this.getDeleteEvent(userMembership, "USERMEMBERSHIP");
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(userMembership.getId(), 1, logBuilder, "deleteUserMembership");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteUserMembership"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteUserMembership", e));
            }
            this.initiateLogBuilder(userMembership.getId(), 0, logBuilder, "deleteUserMembership");
            throw new SMembershipDeletionException("Can't delete membership " + userMembership, e);
        }
    }

    @Override
    public void deleteAllUserMemberships() throws SMembershipDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SUserMembership.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SMembershipDeletionException("Can't delete all user memberships.", e);
        }
    }

    @Override
    public SGroup getGroup(long groupId) throws SGroupNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getGroup"));
        }
        try {
            SGroup group = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SGroup.class, "Group", groupId));
            if (group == null) {
                throw new SGroupNotFoundException("No group exists with id: " + groupId);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getGroup"));
            }
            return group;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getGroup", bre));
            }
            throw new SGroupNotFoundException(bre);
        }
    }

    @Override
    public List<SGroup> getGroupChildren(long groupId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getGroupChildren"));
        }
        try {
            SGroup group = this.getGroup(groupId);
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getChildrenOfGroup(group));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getGroupChildren"));
            }
            return listGroups;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getGroupChildren", e));
            }
            throw new SIdentityException("Can't get the children of the group", e);
        }
    }

    @Override
    public List<SGroup> getGroupChildren(long groupId, int fromIndex, int numberOfGroups) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getGroupChildren"));
        }
        try {
            SGroup group = this.getGroup(groupId);
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getChildrenOfGroup(group, fromIndex, numberOfGroups));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getGroupChildren"));
            }
            return listGroups;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getGroupChildren", e));
            }
            throw new SIdentityException("Can't get the children of the group", e);
        }
    }

    @Override
    public List<SGroup> getGroupChildren(long groupId, int fromIndex, int numberOfGroups, String field, OrderByType order) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getGroupChildren"));
        }
        try {
            SGroup group = this.getGroup(groupId);
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getChildrenOfGroup(group, field, order, fromIndex, numberOfGroups));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getGroupChildren"));
            }
            return listGroups;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getGroupChildren", e));
            }
            throw new SIdentityException("Can't get the children of the group", e);
        }
    }

    @Override
    public List<SGroup> getGroups(int fromIndex, int numberOfGroups) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getGroups"));
        }
        try {
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SGroup.class, "Group", fromIndex, numberOfGroups));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getGroups"));
            }
            return listGroups;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getGroups", e));
            }
            throw new SIdentityException("Can't get the groups", e);
        }
    }

    @Override
    public List<SGroup> getGroups(int fromIndex, int numberOfGroups, String field, OrderByType order) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getGroups"));
        }
        try {
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SGroup.class, "Group", field, order, fromIndex, numberOfGroups));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getGroups"));
            }
            return listGroups;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getGroups", e));
            }
            throw new SIdentityException("Can't get the groups", e);
        }
    }

    @Override
    public List<SGroup> getGroups(List<Long> groupIds) throws SGroupNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getGroups"));
        }
        if (groupIds == null || groupIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<SGroup> listGroups = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SGroup.class, "Group", groupIds));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getGroups"));
            }
            return listGroups;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getGroups", e));
            }
            throw new SGroupNotFoundException(e);
        }
    }

    @Override
    public Set<SGroup> getGroupsByName(String groupName) throws SGroupNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getGroupsByName"));
        }
        try {
            Set<SGroup> setGroups = CollectionUtil.buildHashSetFromList(SGroup.class, this.persistenceService.selectList(SelectDescriptorBuilder.getGroupsByName(groupName)));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getGroupsByName"));
            }
            return setGroups;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getGroupsByName", bre));
            }
            throw new SGroupNotFoundException(bre);
        }
    }

    @Override
    public List<SUserMembership> getUserMemberships(int fromIndex, int numberOfResult, OrderByOption orderByOption) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMemberships"));
        }
        try {
            List<SUserMembership> listSUserMembership = orderByOption.getClazz() == SRole.class ? this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsWithRole(new QueryOptions(fromIndex, numberOfResult, Collections.singletonList(orderByOption)))) : (orderByOption.getClazz() == SGroup.class ? this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsWithGroup(new QueryOptions(fromIndex, numberOfResult, Collections.singletonList(orderByOption)))) : this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SUserMembership.class, "UserMembership", new QueryOptions(fromIndex, numberOfResult, Collections.singletonList(orderByOption)))));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMemberships"));
            }
            return listSUserMembership;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMemberships", e));
            }
            throw new SIdentityException("Can't get the memberships", e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfGroup(long groupId, int startIndex, int maxResults) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMembershipsOfGroup"));
        }
        try {
            List<SUserMembership> selectList = this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsByGroup(groupId, startIndex, maxResults));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMembershipsOfGroup"));
            }
            return selectList;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMembershipsOfGroup", e));
            }
            throw new SIdentityException("Can't get the users memberships the group " + groupId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfRole(long roleId, int startIndex, int maxResults) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMembershipsOfRole"));
        }
        try {
            List<SUserMembership> memberships = this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsByRole(roleId, startIndex, maxResults));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMembershipsOfRole"));
            }
            return memberships;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMembershipsOfRole", e));
            }
            throw new SIdentityException("Can't get the memberships having the role " + roleId, e);
        }
    }

    @Override
    public long getNumberOfGroupChildren(long parentGroupId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfGroupChildren"));
        }
        try {
            SGroup parentGroup = this.getGroup(parentGroupId);
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfGroupChildren(parentGroup.getPath()));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfGroupChildren"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfGroupChildren", e));
            }
            throw new SIdentityException("Can't get the number children of group", e);
        }
    }

    @Override
    public long getNumberOfGroups() throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfGroups"));
        }
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("SGroup", SGroup.class));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfGroups"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfGroups", e));
            }
            throw new SIdentityException("Can't get the number of group", e);
        }
    }

    @Override
    public long getNumberOfProfileMetadataDefinition() throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfProfileMetadataDefinition"));
        }
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("ProfileMetadata", SProfileMetadataDefinition.class));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfProfileMetadataDefinition"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfProfileMetadataDefinition", e));
            }
            throw new SIdentityException("Can't get the number of profile metadata", e);
        }
    }

    @Override
    public long getNumberOfRoles() throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfRoles"));
        }
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("SRole", SRole.class));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfRoles"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfRoles", e));
            }
            throw new SIdentityException("Can't get the number of role", e);
        }
    }

    @Override
    public long getNumberOfUsers() throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfUsers"));
        }
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("SUser", SUser.class));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfUsers"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfUsers", e));
            }
            throw new SIdentityException("Can't get the number of user", e);
        }
    }

    @Override
    public long getNumberOfUserMembershipsOfUser(long userId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfUserMembershipsOfUser"));
        }
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfUserMembershipsOfUser(userId));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfUserMembershipsOfUser"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfUserMembershipsOfUser", e));
            }
            throw new SIdentityException("Can't get the number of usermemberships having the user " + userId, e);
        }
    }

    @Override
    public long getNumberOfUsersByGroup(long groupId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfUsersByGroup"));
        }
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfUsersByGroup(groupId));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfUsersByGroup"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfUsersByGroup", e));
            }
            throw new SIdentityException("Can't get the number of users having the group " + groupId, e);
        }
    }

    @Override
    public long getNumberOfUsersByRole(long roleId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfUsersByRole"));
        }
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfUsersByRole(roleId));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfUsersByRole"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfUsersByRole", e));
            }
            throw new SIdentityException("Can't get the number of users having the role " + roleId, e);
        }
    }

    @Override
    public long getNumberOfUsersByMembership(long groupId, long roleId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfUsersByMembership"));
        }
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfUsersByMembership(groupId, roleId));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfUsersByMembership"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfUsersByMembership", e));
            }
            throw new SIdentityException("Can't get the number of users having the membership with group:" + groupId + " and role:" + roleId, e);
        }
    }

    @Override
    public SProfileMetadataDefinition getProfileMetadataByName(String metadataName) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getProfileMetadataByName"));
        }
        try {
            SProfileMetadataDefinition sProfileMetadataDefinition = this.persistenceService.selectOne(SelectDescriptorBuilder.getMetadataByName(metadataName));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getProfileMetadataByName"));
            }
            return sProfileMetadataDefinition;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getProfileMetadataByName", e));
            }
            throw new SIdentityException("Can't get the metadata with name " + metadataName, e);
        }
    }

    @Override
    public List<SProfileMetadataDefinition> getProfileMetadataDefinition(int fromIndex, int numberOfMetadata) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getProfileMetadataDefinition"));
        }
        try {
            List<SProfileMetadataDefinition> listSProfileMetadataDefinition = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SProfileMetadataDefinition.class, "ProfileMetadata", fromIndex, numberOfMetadata));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getProfileMetadataDefinition"));
            }
            return listSProfileMetadataDefinition;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getProfileMetadataDefinition", e));
            }
            throw new SIdentityException("Can't get the profile metadata", e);
        }
    }

    @Override
    public SProfileMetadataDefinition getProfileMetadataDefinition(long profileMetadataId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getProfileMetadataDefinition"));
        }
        try {
            SProfileMetadataDefinition selectOne = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SProfileMetadataDefinition.class, "ProfileMetadata", profileMetadataId));
            if (selectOne == null) {
                throw new SIdentityException("Can't get the profile metadata with id " + profileMetadataId, null);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getProfileMetadataDefinition"));
            }
            return selectOne;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getProfileMetadataDefinition", e));
            }
            throw new SIdentityException("Can't get the profile metadata with id " + profileMetadataId, e);
        }
    }

    @Override
    public List<SProfileMetadataDefinition> getProfileMetadataDefinitions(List<Long> profileMetadataDefinitionIds) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getProfileMetadataDefinitions"));
        }
        if (profileMetadataDefinitionIds == null || profileMetadataDefinitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<SProfileMetadataDefinition> listSProfileMetadataDefinition = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SProfileMetadataDefinition.class, "SProfileMetadataDefinition", profileMetadataDefinitionIds));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getProfileMetadataDefinitions"));
            }
            return listSProfileMetadataDefinition;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getProfileMetadataDefinitions", e));
            }
            throw new SIdentityException("Can't get profiles metadata with ids " + Arrays.toString(profileMetadataDefinitionIds.toArray()), e);
        }
    }

    @Override
    public SProfileMetadataValue getProfileMetadataValue(long profileMetadataValueId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getProfileMetadataValue"));
        }
        try {
            SProfileMetadataValue selectOne = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SProfileMetadataValue.class, "SProfileMetadataValue", profileMetadataValueId));
            if (selectOne == null) {
                throw new SIdentityException("Can't get the profile metadata value with id " + profileMetadataValueId, null);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getProfileMetadataValue"));
            }
            return selectOne;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getProfileMetadataValue", e));
            }
            throw new SIdentityException("Can't get the profile metadata value with id " + profileMetadataValueId, e);
        }
    }

    @Override
    public List<SProfileMetadataValue> getProfileMetadataValues(List<Long> profileMetadataValueIds) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getProfileMetadataValues"));
        }
        if (profileMetadataValueIds == null || profileMetadataValueIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getProfileMetadataValues"));
            }
            return this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SProfileMetadataValue.class, "SProfileMetadataValue", profileMetadataValueIds));
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getProfileMetadataValues", e));
            }
            throw new SIdentityException("Can't get profiles metadata values with ids " + Arrays.toString(profileMetadataValueIds.toArray()), e);
        }
    }

    @Override
    public SRole getRole(long roleId) throws SRoleNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getRole"));
        }
        try {
            SRole selectOne = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SRole.class, "Role", roleId));
            if (selectOne == null) {
                throw new SRoleNotFoundException("The role with id= " + roleId + " does not exist");
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getRole"));
            }
            return selectOne;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getRole", e));
            }
            throw new SRoleNotFoundException(e);
        }
    }

    @Override
    public SRole getRoleByName(String roleName) throws SRoleNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getRoleByName"));
        }
        try {
            SRole role = this.persistenceService.selectOne(SelectDescriptorBuilder.getRoleByName(roleName));
            if (role == null) {
                throw new SRoleNotFoundException("The role named " + roleName + " does not exist");
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getRoleByName"));
            }
            return role;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getRoleByName", e));
            }
            throw new SRoleNotFoundException(e);
        }
    }

    @Override
    public SGroup getGroupByPath(String groupPath) throws SGroupNotFoundException {
        SelectOneDescriptor<SGroup> descriptor;
        String groupName;
        int lastIndexOf;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getGroupByPath"));
        }
        if ((lastIndexOf = groupPath.lastIndexOf(47)) > 0) {
            groupName = groupPath.substring(lastIndexOf + 1);
            String parentPath = groupPath.substring(0, lastIndexOf);
            descriptor = SelectDescriptorBuilder.getGroupByPath(parentPath, groupName);
        } else if (lastIndexOf == 0) {
            groupName = groupPath.substring(lastIndexOf + 1);
            descriptor = SelectDescriptorBuilder.getGroupByName(groupName);
        } else {
            descriptor = SelectDescriptorBuilder.getGroupByName(groupPath);
        }
        try {
            SGroup group = this.persistenceService.selectOne(descriptor);
            if (group == null) {
                throw new SGroupNotFoundException("The group '" + groupPath + "' does not exist");
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getGroupByPath"));
            }
            return group;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getGroupByPath", bre));
            }
            throw new SGroupNotFoundException(bre);
        }
    }

    @Override
    public List<SRole> getRoles(int fromIndex, int numberOfRoles) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getRoles"));
        }
        try {
            List<SRole> listSRole = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SRole.class, "Role", fromIndex, numberOfRoles));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getRoles"));
            }
            return listSRole;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getRoles", e));
            }
            throw new SIdentityException("Can't get the roles", e);
        }
    }

    @Override
    public List<SRole> getRoles(int fromIndex, int numberOfRoles, String field, OrderByType order) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getRoles"));
        }
        try {
            List<SRole> listSRole = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SRole.class, "Role", field, order, fromIndex, numberOfRoles));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getRoles"));
            }
            return listSRole;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getRoles", e));
            }
            throw new SIdentityException("Can't get the roles", e);
        }
    }

    @Override
    public List<SRole> getRoles(List<Long> roleIds) throws SRoleNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getRoles"));
        }
        if (roleIds == null || roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<SRole> listSRoles = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SRole.class, "Role", roleIds));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getRoles"));
            }
            return listSRoles;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getRoles", e));
            }
            throw new SRoleNotFoundException(e);
        }
    }

    @Override
    public SUser getUser(long userId) throws SUserNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUser"));
        }
        try {
            SUser user = this.persistenceService.selectById(SelectDescriptorBuilder.getElementById(SUser.class, "User", userId));
            if (user == null) {
                throw new SUserNotFoundException(userId);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUser"));
            }
            return user;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUser", e));
            }
            throw new SUserNotFoundException("Cannot get user with id: " + userId, e);
        }
    }

    @Override
    public SContactInfo getUserContactInfo(long userId, boolean isPersonal) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserContactInfo"));
        }
        try {
            SContactInfo contactInfo = this.persistenceService.selectOne(SelectDescriptorBuilder.getUserContactInfo(userId, isPersonal));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserContactInfo"));
            }
            return contactInfo;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserContactInfo", e));
            }
            throw new SUserNotFoundException("Cannot get user contact info for user id: " + userId, e);
        }
    }

    @Override
    public SUser getUserByUserName(String userName) throws SUserNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserByUserName"));
        }
        try {
            SUser user = this.persistenceService.selectOne(SelectDescriptorBuilder.getUserByUserName(userName));
            if (user == null) {
                throw new SUserNotFoundException(userName);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserByUserName"));
            }
            return user;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserByUserName", e));
            }
            throw new SUserNotFoundException("Cannot get user: " + userName, e);
        }
    }

    @Override
    public SUserMembership getUserMembership(long userMembershipId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMembership"));
        }
        try {
            Map<String, Object> parameters = Collections.singletonMap("id", userMembershipId);
            SelectOneDescriptor desc = new SelectOneDescriptor("getSUserMembershipById", parameters, SUserMembership.class);
            SUserMembership selectOne = (SUserMembership)this.persistenceService.selectOne(desc);
            if (selectOne == null) {
                throw new SIdentityException("Can't get the userMembership with id " + userMembershipId, null);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMembership"));
            }
            return selectOne;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMembership", e));
            }
            throw new SIdentityException("Can't get the user membership with id " + userMembershipId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfUser(long userId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMembershipsOfUser"));
        }
        try {
            List<SUserMembership> listSUserMembership = this.persistenceService.selectList(SelectDescriptorBuilder.getUserMembershipsOfUser(userId));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMembershipsOfUser"));
            }
            return listSUserMembership;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMembershipsOfUser", e));
            }
            throw new SIdentityException("Can't get memberships of user: " + userId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMemberships(List<Long> userMembershipIds) throws SIdentityException {
        List<Long> localUserMembershipIds = userMembershipIds;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMemberships"));
        }
        if (localUserMembershipIds == null || localUserMembershipIds.isEmpty()) {
            localUserMembershipIds = Collections.emptyList();
        }
        try {
            List<SUserMembership> listSUserMembership = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SUserMembership.class, "SUserMembership", localUserMembershipIds));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMemberships"));
            }
            return listSUserMembership;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMemberships", e));
            }
            throw new SIdentityException("Can't get users memberships with ids " + Arrays.toString(localUserMembershipIds.toArray()), e);
        }
    }

    @Override
    public List<SUser> getUsers(int fromIndex, int numberOfUsers) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsers"));
        }
        try {
            List<SUser> listSUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SUser.class, "User", fromIndex, numberOfUsers));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsers"));
            }
            return listSUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsers", e));
            }
            throw new SIdentityException("Can't get the users", e);
        }
    }

    @Override
    public List<SUser> getUsers(int fromIndex, int numberOfUsers, String field, OrderByType order) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsers"));
        }
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getElements(SUser.class, "User", field, order, fromIndex, numberOfUsers));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsers"));
            }
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsers", e));
            }
            throw new SIdentityException("Can't get the users", e);
        }
    }

    @Override
    public List<SUser> getUsers(List<Long> userIds) throws SUserNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsers"));
        }
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getElementsByIds(SUser.class, "User", userIds));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsers"));
            }
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsers", e));
            }
            throw new SUserNotFoundException(e);
        }
    }

    @Override
    public List<SUser> getUsersByUsername(List<String> userNames) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsersByName"));
        }
        if (userNames == null || userNames.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Map<String, Object> parameters = Collections.singletonMap("userNames", userNames);
            List<SUser> users = this.persistenceService.selectList(new SelectListDescriptor("getUsersByName", parameters, SUser.class));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsersByName"));
            }
            return users;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsersByName", e));
            }
            throw new SUserNotFoundException(e);
        }
    }

    @Override
    public List<SUser> getUsersByDelegee(long delegateId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsersByDelegee"));
        }
        try {
            SUser delegee = this.getUser(delegateId);
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByDelegee(delegee.getUserName()));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsersByDelegee"));
            }
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsersByDelegee", e));
            }
            throw new SIdentityException("Can't get the users having the delegee " + delegateId, e);
        }
    }

    @Override
    public List<SUser> getUsersByGroup(long groupId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsersByGroup"));
        }
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByGroup(groupId));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsersByGroup"));
            }
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsersByGroup", e));
            }
            throw new SIdentityException("Can't get the users having the group " + groupId, e);
        }
    }

    @Override
    public List<SUser> getUsersByGroup(long groupId, int fromIndex, int numberOfUsers) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsersByGroup"));
        }
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByGroup(groupId, fromIndex, numberOfUsers));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsersByGroup"));
            }
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsersByGroup", e));
            }
            throw new SIdentityException("Can't get the users having the group " + groupId, e);
        }
    }

    @Override
    public List<SUser> getUsersByGroup(long groupId, int fromIndex, int numberOfUsers, String field, OrderByType order) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsersByGroup"));
        }
        try {
            List<SUser> listsSUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByGroup(groupId, field, order, fromIndex, numberOfUsers));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsersByGroup"));
            }
            return listsSUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsersByGroup", e));
            }
            throw new SIdentityException("Can't get the users having the group " + groupId, e);
        }
    }

    @Override
    public List<SUser> getUsersByManager(long managerId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsersByManager"));
        }
        try {
            List<SUser> listsSUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByManager(managerId));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsersByManager"));
            }
            return listsSUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsersByManager", e));
            }
            throw new SIdentityException("Can't get the users having the manager " + managerId, e);
        }
    }

    @Override
    public List<SUser> getUsersByRole(long roleId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsersByRole"));
        }
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByRole(roleId));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsersByRole"));
            }
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsersByRole", e));
            }
            throw new SIdentityException("Can't get the users having the role " + roleId, e);
        }
    }

    @Override
    public List<SUser> getUsersByRole(long roleId, int fromIndex, int numberOfUsers) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsersByRole"));
        }
        try {
            List<SUser> listsSUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByRole(roleId, fromIndex, numberOfUsers));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsersByRole"));
            }
            return listsSUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsersByRole", e));
            }
            throw new SIdentityException("Can't get the users having the role " + roleId, e);
        }
    }

    @Override
    public List<SUser> getUsersByRole(long roleId, int fromIndex, int numberOfUsers, String field, OrderByType order) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUsersByRole"));
        }
        try {
            List<SUser> listsUsers = this.persistenceService.selectList(SelectDescriptorBuilder.getUsersByRole(roleId, field, order, fromIndex, numberOfUsers));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUsersByRole"));
            }
            return listsUsers;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUsersByRole", e));
            }
            throw new SIdentityException("Can't get the users having the role " + roleId, e);
        }
    }

    @Override
    public void updateGroup(SGroup group, EntityUpdateDescriptor descriptor) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "updateGroup"));
        }
        SGroupLogBuilder logBuilder = this.getGroupLog(HasCRUDEAction.ActionType.UPDATED, "Updating the group");
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)group, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("GROUP", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)this.eventBuilder.createUpdateEvent("GROUP").setObject(group).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(group.getId(), 1, logBuilder, "updateGroup");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "updateGroup"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "updateGroup", e));
            }
            this.initiateLogBuilder(group.getId(), 0, logBuilder, "updateGroup");
            throw new SIdentityException("Can't update group " + group, e);
        }
    }

    @Override
    public void updateProfileMetadataDefinition(SProfileMetadataDefinition metadata, EntityUpdateDescriptor descriptor) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "updateProfileMetadataDefinition"));
        }
        SProfileMetadataDefinitionLogBuilder logBuilder = this.getSProfileMetadataDefinitionLog(HasCRUDEAction.ActionType.UPDATED, "Updating the profile metadata definition with name " + metadata.getName());
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)metadata, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("METADATA", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)this.eventBuilder.createUpdateEvent("METADATA").setObject(metadata).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(metadata.getId(), 1, logBuilder, "updateProfileMetadataDefinition");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "updateProfileMetadataDefinition"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "updateProfileMetadataDefinition", e));
            }
            this.initiateLogBuilder(metadata.getId(), 0, logBuilder, "updateProfileMetadataDefinition");
            throw new SIdentityException("Can't update profile metadata definition " + metadata, e);
        }
    }

    @Override
    public void updateProfileMetadataValue(SProfileMetadataValue metadataValue, EntityUpdateDescriptor descriptor) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "updateProfileMetadataValue"));
        }
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)metadataValue, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("METADATAVALUE", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)this.eventBuilder.createUpdateEvent("METADATAVALUE").setObject(metadataValue).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "updateProfileMetadataValue"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "updateProfileMetadataValue", e));
            }
            throw new SIdentityException("Can't update profile metadata definition " + metadataValue, e);
        }
    }

    @Override
    public void updateRole(SRole role, EntityUpdateDescriptor descriptor) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "updateRole"));
        }
        SRoleLogBuilder logBuilder = this.getRoleLog(HasCRUDEAction.ActionType.UPDATED, "Updating the role with name " + role.getName());
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)role, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("ROLE", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)this.eventBuilder.createUpdateEvent("ROLE").setObject(role).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "updateRole"));
            }
            this.initiateLogBuilder(role.getId(), 0, logBuilder, "updateRole");
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "updateRole", e));
            }
            this.initiateLogBuilder(role.getId(), 0, logBuilder, "updateRole");
            throw new SIdentityException("Can't update role " + role, e);
        }
    }

    @Override
    public void updateUser(SUser user, EntityUpdateDescriptor descriptor) throws SUserUpdateException {
        this.updateUser(user, descriptor, false);
    }

    @Override
    @Deprecated
    public void updateUser(SUser user, EntityUpdateDescriptor descriptor, boolean isPasswordEncrypted) throws SUserUpdateException {
        String password;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "updateUser"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Updating user with user name ");
        sb.append(user.getUserName());
        sb.append(", first name ");
        sb.append(user.getFirstName());
        sb.append(", last name ");
        sb.append(user.getLastName());
        if (!isPasswordEncrypted && (password = (String)descriptor.getFields().get("password")) != null) {
            String hash = this.encrypter.hash(password);
            descriptor.getFields().put("password", hash);
        }
        SUserLogBuilder logBuilder = this.getUserLog(HasCRUDEAction.ActionType.UPDATED, sb.toString());
        try {
            SUserBuilder userBuilder = this.identityModelBuilder.getUserBuilder();
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)user, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("USER", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)this.eventBuilder.createUpdateEvent("USER").setObject(user).done();
                SUser oldUser = userBuilder.createNewInstance(user).done();
                updateEvent.setOldObject(oldUser);
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(user.getId(), 1, logBuilder, "updateUser");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "updateUser"));
            }
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "updateUser", re));
            }
            this.initiateLogBuilder(user.getId(), 0, logBuilder, "updateUser");
            throw new SUserUpdateException(re);
        }
    }

    @Override
    public void updateUserContactInfo(SContactInfo contactInfo, EntityUpdateDescriptor descriptor) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "updateUserContactInfo"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Updating " + (contactInfo.isPersonal() ? "personal" : "professional") + " user contact Info for user with Id ");
        sb.append(contactInfo.getUserId());
        SContactInfoLogBuilder logBuilder = this.getUserContactInfoLog(HasCRUDEAction.ActionType.UPDATED, sb.toString(), contactInfo);
        try {
            SContactInfoBuilder contactInfoBuilder = this.identityModelBuilder.getUserContactInfoBuilder();
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)contactInfo, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("USER_CONTACT_INFO", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)this.eventBuilder.createUpdateEvent("USER_CONTACT_INFO").setObject(contactInfo).done();
                SContactInfo oldContactInfo = contactInfoBuilder.createNewInstance(contactInfo).done();
                updateEvent.setOldObject(oldContactInfo);
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(contactInfo.getId(), 1, logBuilder, "updateUserContactInfo");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "updateUserContactInfo"));
            }
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "updateUserContactInfo", re));
            }
            this.initiateLogBuilder(contactInfo.getId(), 0, logBuilder, "updateUserContactInfo");
            throw new SUserUpdateException(re);
        }
    }

    @Override
    public void updateUserMembership(SUserMembership userMembership, EntityUpdateDescriptor descriptor) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "updateUserMembership"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Updating user membership for user ");
        sb.append(userMembership.getUsername());
        sb.append(" with role ");
        sb.append(userMembership.getRoleName());
        sb.append(" in group ");
        sb.append(userMembership.getGroupName());
        SUserMembershipLogBuilder logBuilder = this.getUserMembershipLog(HasCRUDEAction.ActionType.UPDATED, sb.toString(), userMembership);
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)userMembership, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("USERMEMBERSHIP", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)this.eventBuilder.createUpdateEvent("USERMEMBERSHIP").setObject(userMembership).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "updateUserMembership"));
            }
            this.initiateLogBuilder(userMembership.getId(), 1, logBuilder, "updateUserMembership");
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "updateUserMembership", e));
            }
            this.initiateLogBuilder(userMembership.getId(), 0, logBuilder, "updateUserMembership");
            throw new SIdentityException("Can't update user membership " + userMembership, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMemberships(int fromIndex, int numberOfUserMemberships) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMemberships"));
        }
        SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getElements(SUserMembership.class, "UserMembership", fromIndex, numberOfUserMemberships);
        try {
            List<SUserMembership> listsUserMemberships = this.persistenceService.selectList(descriptor);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMemberships"));
            }
            return listsUserMemberships;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMemberships", e));
            }
            throw new SIdentityException("Can't get the user memberships", e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfUser(long userId, int fromIndex, int numberOfUsers) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMembershipsOfUser"));
        }
        try {
            SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getUserMembershipsOfUser(userId, fromIndex, numberOfUsers);
            List<SUserMembership> listsSUserMemberships = this.persistenceService.selectList(descriptor);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMembershipsOfUser"));
            }
            return listsSUserMemberships;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMembershipsOfUser", e));
            }
            throw new SIdentityException("Can't get the memberships having the user " + userId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfUser(long userId, int fromIndex, int numberOfMemberships, String field, OrderByType order) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMembershipsOfUser"));
        }
        try {
            SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getUserMembershipsOfUser(userId, field, order, fromIndex, numberOfMemberships);
            List<SUserMembership> listsSUserMemberships = this.persistenceService.selectList(descriptor);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMembershipsOfUser"));
            }
            return listsSUserMemberships;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMembershipsOfUser", e));
            }
            throw new SIdentityException("Can't get the memberships having the user" + userId, e);
        }
    }

    @Override
    public List<SUserMembership> getUserMembershipsOfUser(long userId, int fromIndex, int numberPerPage, OrderByOption orderByOption) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMembershipsOfUser"));
        }
        try {
            SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getUserMembershipsOfUser(userId, new QueryOptions(fromIndex, numberPerPage, Collections.singletonList(orderByOption)));
            List<SUserMembership> listsUserMemberships = this.persistenceService.selectList(descriptor);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMembershipsOfUser"));
            }
            return listsUserMemberships;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMembershipsOfUser", e));
            }
            throw new SIdentityException("Can't get the memberships having the user" + userId, e);
        }
    }

    @Override
    public SUserMembership getUserMembership(long userId, long groupId, long roleId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getUserMembership"));
        }
        SelectOneDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getUserMembership(userId, groupId, roleId);
        try {
            SUserMembership sUserMembership = this.persistenceService.selectOne(descriptor);
            if (sUserMembership == null) {
                throw new SIdentityException(new Object[]{"Can't get the userMembership with userId = " + userId + ", groupId = " + groupId + ", roleId = " + roleId});
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getUserMembership"));
            }
            return sUserMembership;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getUserMembership", e));
            }
            throw new SIdentityException("Can't get the userMembership with userId = " + userId + ", groupId = " + groupId + ", roleId = " + roleId, e);
        }
    }

    @Override
    public SUserMembership getLightUserMembership(long userId, long groupId, long roleId) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getLightUserMembership"));
        }
        SelectOneDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getLightUserMembership(userId, groupId, roleId);
        try {
            SUserMembership sUserMembership = this.persistenceService.selectOne(descriptor);
            if (sUserMembership == null) {
                throw new SIdentityException(new Object[]{"Can't get the userMembership with userId = " + userId + ", groupId = " + groupId + ", roleId = " + roleId});
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getLightUserMembership"));
            }
            return sUserMembership;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getLightUserMembership", e));
            }
            throw new SIdentityException("Can't get the userMembership with userId = " + userId + ", groupId = " + groupId + ", roleId = " + roleId, e);
        }
    }

    @Override
    public long getNumberOfUserMemberships() throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfUserMemberships"));
        }
        try {
            long number = this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("UserMembership", SUserMembership.class));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfUserMemberships"));
            }
            return number;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfUserMemberships", e));
            }
            throw new SIdentityException("Can't get the number of user membership", e);
        }
    }

    @Override
    public List<SUserMembership> getLightUserMemberships(int startIndex, int numberOfElements) throws SIdentityException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getLightUserMemberships"));
        }
        SelectListDescriptor<SUserMembership> descriptor = SelectDescriptorBuilder.getElements(SUserMembership.class, "LightUserMembership", startIndex, numberOfElements);
        try {
            List<SUserMembership> listsUserMemberships = this.persistenceService.selectList(descriptor);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getLightUserMemberships"));
            }
            return listsUserMemberships;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getLightUserMemberships", e));
            }
            throw new SIdentityException("Can't get the user memberships", e);
        }
    }

    @Override
    public long getNumberOfUsers(QueryOptions options) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfUsers"));
        }
        try {
            long number = this.persistenceService.getNumberOfEntities(SUser.class, options, null);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfUsers"));
            }
            return number;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfUsers", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SUser> searchUsers(QueryOptions options) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "searchUsers"));
        }
        try {
            List<SUser> listsSUsers = this.persistenceService.searchEntity(SUser.class, options, null);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "searchUsers"));
            }
            return listsSUsers;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "searchUsers", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfRoles(QueryOptions options) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfRoles"));
        }
        try {
            long number = this.persistenceService.getNumberOfEntities(SRole.class, options, null);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfRoles"));
            }
            return number;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfRoles", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SRole> searchRoles(QueryOptions options) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "searchRoles"));
        }
        try {
            List<SRole> listsRoles = this.persistenceService.searchEntity(SRole.class, options, null);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "searchRoles"));
            }
            return listsRoles;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "searchRoles", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfGroups(QueryOptions options) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfGroups"));
        }
        try {
            long number = this.persistenceService.getNumberOfEntities(SGroup.class, options, null);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfGroups"));
            }
            return number;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfGroups", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SGroup> searchGroups(QueryOptions options) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "searchGroups"));
        }
        try {
            List<SGroup> listsGroups = this.persistenceService.searchEntity(SGroup.class, options, null);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "searchGroups"));
            }
            return listsGroups;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "searchGroups", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String methodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), methodName, log);
        }
    }

    @Override
    public boolean chechCredentials(SUser user, String password) {
        String hashPassword = user.getPassword();
        return this.encrypter.check(password, hashPassword);
    }

    @Override
    @Deprecated
    public SUser createUserWithoutEncryptingPassword(SUser user) throws SUserCreationException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createUser"));
        }
        String message = "Adding a new user with user name " + user.getUserName() + ", first name " + user.getFirstName() + ", last name " + user.getLastName();
        SUserLogBuilder logBuilder = this.getUserLog(HasCRUDEAction.ActionType.CREATED, message);
        SUser hashedUser = this.identityModelBuilder.getUserBuilder().createNewInstance(user).done();
        try {
            InsertRecord insertRecord = new InsertRecord(hashedUser);
            SInsertEvent insertEvent = this.getInsertEvent(hashedUser, "USER");
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(hashedUser.getId(), 1, logBuilder, "createUser");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createUser"));
            }
            return hashedUser;
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createUser", re));
            }
            this.initiateLogBuilder(hashedUser.getId(), 0, logBuilder, "createUser");
            throw new SUserCreationException(re);
        }
    }
}

