/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.platform.session.impl;

import java.util.Date;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.ReflectException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.session.PlatformSessionProvider;
import org.bonitasoft.engine.platform.session.PlatformSessionService;
import org.bonitasoft.engine.platform.session.SSessionException;
import org.bonitasoft.engine.platform.session.SSessionNotFoundException;
import org.bonitasoft.engine.platform.session.impl.PlatformSessionIdGenerator;
import org.bonitasoft.engine.platform.session.model.SPlatformSession;
import org.bonitasoft.engine.platform.session.model.builder.SPlatformSessionModelBuilder;

public class PlatformSessionServiceImpl
implements PlatformSessionService {
    private final long DEFAULT_SESSION_DURATION = 3600000L;
    private final SPlatformSessionModelBuilder platformSessionModelBuilder;
    private final PlatformSessionProvider platformSessionProvider;
    private final TechnicalLoggerService logger;
    private long sessionDuration = 3600000L;

    public PlatformSessionServiceImpl(PlatformSessionProvider platformSessionProvider, SPlatformSessionModelBuilder platformSessionModelBuilder, TechnicalLoggerService logger) {
        this.platformSessionModelBuilder = platformSessionModelBuilder;
        this.platformSessionProvider = platformSessionProvider;
        this.logger = logger;
    }

    @Override
    public SPlatformSession createSession(String username) throws SSessionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createSession"));
        }
        long sessionId = PlatformSessionIdGenerator.getNextId();
        long duration = this.getSessionsDuration();
        SPlatformSession session = this.platformSessionModelBuilder.getSessionBuilder().createNewInstance(sessionId, duration, username).done();
        this.platformSessionProvider.addSession(session);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createSession"));
        }
        return session;
    }

    @Override
    public void deleteSession(long sessionId) throws SSessionNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteSession"));
        }
        this.platformSessionProvider.removeSession(sessionId);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteSession"));
        }
    }

    @Override
    public boolean isValid(long sessionId) throws SSessionNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "isValid"));
        }
        SPlatformSession session = this.platformSessionProvider.getSession(sessionId);
        Date now = new Date();
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "isValid"));
        }
        return session.getExpirationDate().after(now);
    }

    @Override
    public SPlatformSession getSession(long sessionId) throws SSessionNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getSession"));
        }
        SPlatformSession session = this.platformSessionProvider.getSession(sessionId);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getSession"));
        }
        return this.platformSessionModelBuilder.getSessionBuilder().copy(session);
    }

    @Override
    public void setSessionDuration(long duration) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "setSessionDuration"));
        }
        if (duration <= 0L) {
            throw new IllegalArgumentException("The duration must be greater then 0");
        }
        this.sessionDuration = duration;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "setSessionDuration"));
        }
    }

    @Override
    public long getDefaultSessionDuration() {
        return 3600000L;
    }

    @Override
    public long getSessionsDuration() {
        return this.sessionDuration;
    }

    @Override
    public void renewSession(long sessionId) throws SSessionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "renewSession"));
        }
        SPlatformSession session = this.getSession(sessionId);
        try {
            ClassReflector.invokeSetter(session, "setLastRenewDate", Date.class, new Date());
            this.platformSessionProvider.updateSession(session);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "renewSession"));
            }
        }
        catch (ReflectException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "renewSession", e));
            }
            throw new SSessionException(e);
        }
    }
}

