/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.queriablelogger.model.builder.impl;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.SIndexedLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.impl.MissingMandatoryFieldsException;
import org.bonitasoft.engine.queriablelogger.model.impl.SQueriableLogImpl;

public class SIndexedLogBuilderImpl
implements SIndexedLogBuilder {
    private SQueriableLogImpl entity;
    private List<String> problems;
    private static final String TIME_STAMP = "timeStamp";
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY_OF_YEAR = "dayOfYear";
    private static final String WEEK_OF_YEAR = "weekOfYear";
    private static final String USERID = "userId";
    private static final String THREAD_NUMBER = "threadNumber";
    private static final String CLUSTER_NODE = "clusterNode";
    private static final String PRODUCT_VERSION = "productVersion";
    private static final String SEVERTITY = "severity";
    private static final String ACTION_TYPE = "actionType";
    private static final String ACTION_SCOPE = "actionScope";
    private static final String ACTION_STATUS = "actionStatus";
    private static final String RAW_MESSAGE = "rawMessage";
    private static final String CALLER_CLASS_NAME = "callerClassName";
    private static final String CALLER_METHOD_NAME = "callerMethodName";
    private static final String NUMERIC_INDEX1 = "numericIndex1";
    private static final String NUMERIC_INDEX2 = "numericIndex2";
    private static final String NUMERIC_INDEX3 = "numericIndex3";
    private static final String NUMERIC_INDEX4 = "numericIndex4";
    private static final String NUMERIC_INDEX5 = "numericIndex5";

    @Override
    public SIndexedLogBuilder createNewInstance() {
        this.entity = new SQueriableLogImpl();
        return this;
    }

    @Override
    public SIndexedLogBuilder fromInstance(SQueriableLog log) {
        if (log instanceof SQueriableLogImpl) {
            this.entity = (SQueriableLogImpl)log;
        }
        if (this.entity == null) {
            this.entity = new SQueriableLogImpl();
        }
        return this;
    }

    @Override
    public SIndexedLogBuilder userId(String userId) {
        this.entity.setUserId(userId);
        return this;
    }

    @Override
    public SIndexedLogBuilder clusterNode(String clusterNode) {
        this.entity.setClusterNode(clusterNode);
        return this;
    }

    @Override
    public SIndexedLogBuilder productVersion(String productVersion) {
        this.entity.setProductVersion(productVersion);
        return this;
    }

    @Override
    public SIndexedLogBuilder severity(SQueriableLogSeverity severity) {
        this.entity.setSeverity(severity);
        return this;
    }

    @Override
    public SIndexedLogBuilder actionType(String actionType) {
        this.entity.setActionType(actionType);
        return this;
    }

    @Override
    public SIndexedLogBuilder actionScope(String scope) {
        this.entity.setActionScope(scope);
        return this;
    }

    @Override
    public SIndexedLogBuilder actionStatus(int status) {
        this.entity.setActionStatus(status);
        return this;
    }

    @Override
    public SIndexedLogBuilder rawMessage(String rawMessage) {
        this.entity.setRawMessage(rawMessage);
        return this;
    }

    @Override
    public SIndexedLogBuilder callerClassName(String callerClassName) {
        this.entity.setCallerClassName(callerClassName);
        return this;
    }

    @Override
    public SIndexedLogBuilder callerMethodName(String callerMethodName) {
        this.entity.setCallerMethodName(callerMethodName);
        return this;
    }

    @Override
    public SIndexedLogBuilder numericIndex(int pos, long value) {
        this.entity.setNumericIndex(pos, value);
        return this;
    }

    @Override
    public SQueriableLog done() {
        this.problems = new ArrayList<String>();
        this.checkMandatoryFields();
        if (this.problems.size() > 0) {
            throw new MissingMandatoryFieldsException("Some mandatoryFildes are missing: " + this.problems);
        }
        return this.entity;
    }

    private void checkMandatoryFields() {
        if (this.entity.getSeverity() == null) {
            this.problems.add(SEVERTITY);
        }
        if (this.entity.getActionType() == null) {
            this.problems.add(ACTION_TYPE);
        }
        if (0 != this.entity.getActionStatus() && this.entity.getActionScope() == null) {
            this.problems.add(ACTION_SCOPE);
        }
        if (this.entity.getActionStatus() != 0 && this.entity.getActionStatus() != 1) {
            this.problems.add("actionStatus (must be 0, for fail or 1, for ok)");
        }
        if (this.entity.getRawMessage() == null) {
            this.problems.add(RAW_MESSAGE);
        }
    }

    @Override
    public Class<? extends SQueriableLog> getModelClass() {
        return SQueriableLogImpl.class;
    }

    @Override
    public String getTimeStampKey() {
        return TIME_STAMP;
    }

    @Override
    public String getActionStatusKey() {
        return ACTION_STATUS;
    }

    @Override
    public String getYearKey() {
        return YEAR;
    }

    @Override
    public String getMonthKey() {
        return MONTH;
    }

    @Override
    public String getDayOfYearKey() {
        return DAY_OF_YEAR;
    }

    @Override
    public String getWeekOfYearKey() {
        return WEEK_OF_YEAR;
    }

    @Override
    public String getUserIdKey() {
        return USERID;
    }

    @Override
    public String getThreadNumberKey() {
        return THREAD_NUMBER;
    }

    @Override
    public String getClusterNodeKey() {
        return CLUSTER_NODE;
    }

    @Override
    public String getProductVersionKey() {
        return PRODUCT_VERSION;
    }

    @Override
    public String getSeverityKey() {
        return SEVERTITY;
    }

    @Override
    public String getActionTypeKey() {
        return ACTION_TYPE;
    }

    @Override
    public String getActionScopeKey() {
        return ACTION_SCOPE;
    }

    @Override
    public String getRawMessageKey() {
        return RAW_MESSAGE;
    }

    @Override
    public String getCallerClassNameKey() {
        return CALLER_CLASS_NAME;
    }

    @Override
    public String getCallerMethodNameKey() {
        return CALLER_METHOD_NAME;
    }

    @Override
    public String getNumericIndexKey(int pos) {
        switch (pos) {
            case 1: {
                return NUMERIC_INDEX1;
            }
            case 2: {
                return NUMERIC_INDEX2;
            }
            case 3: {
                return NUMERIC_INDEX3;
            }
            case 4: {
                return NUMERIC_INDEX4;
            }
            case 5: {
                return NUMERIC_INDEX5;
            }
        }
        return null;
    }
}

