/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.recorder.impl;

import java.util.List;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.FireEventException;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.BatchInsertRecord;
import org.bonitasoft.engine.recorder.model.DeleteAllRecord;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.UpdateDescriptor;

public class RecorderImpl
implements Recorder {
    private final TechnicalLoggerService logger;
    private final PersistenceService persistenceService;
    private final EventService eventService;

    public RecorderImpl(PersistenceService persistenceService, TechnicalLoggerService logger, EventService eventService) {
        this.persistenceService = persistenceService;
        this.logger = logger;
        this.eventService = eventService;
    }

    @Override
    public void recordInsert(InsertRecord record, SInsertEvent insertEvent) throws SRecorderException {
        String methodName = "recordInsert";
        this.traceBeforeMethod("recordInsert");
        try {
            this.persistenceService.insert(record.getEntity());
            this.fireEvent(insertEvent);
            this.traceAfterMethod("recordInsert");
        }
        catch (FireEventException e) {
            this.logFireEventExceptionAndThrowSRecorderException(e, "recordInsert");
        }
        catch (Exception e) {
            this.traceException("recordInsert", e);
            throw new SRecorderException(e);
        }
    }

    @Override
    public void recordBatchInsert(BatchInsertRecord record, SInsertEvent insertEvent) throws SRecorderException {
        String methodName = "recordBatchInsert";
        this.traceBeforeMethod("recordBatchInsert");
        try {
            this.persistenceService.insertInBatch(record.getEntity());
            this.fireEvent(insertEvent);
            this.traceAfterMethod("recordBatchInsert");
        }
        catch (FireEventException e) {
            this.logFireEventExceptionAndThrowSRecorderException(e, "recordBatchInsert");
        }
        catch (Exception e) {
            this.traceException("recordBatchInsert", e);
            throw new SRecorderException(e);
        }
    }

    @Override
    public void recordDelete(DeleteRecord record, SDeleteEvent deleteEvent) throws SRecorderException {
        String methodName = "recordDelete";
        this.traceBeforeMethod("recordDelete");
        try {
            this.persistenceService.delete(record.getEntity());
            this.fireEvent(deleteEvent);
            this.traceAfterMethod("recordDelete");
        }
        catch (FireEventException e) {
            this.logFireEventExceptionAndThrowSRecorderException(e, "recordDelete");
        }
        catch (Exception e) {
            this.traceException("recordDelete", e);
            throw new SRecorderException(e);
        }
    }

    @Override
    public void recordDeleteAll(DeleteAllRecord record) throws SRecorderException {
        String methodName = "recordDeleteAll";
        this.traceBeforeMethod("recordDeleteAll");
        try {
            this.persistenceService.deleteByTenant(record.getEntityClass(), record.getFilters());
            this.traceAfterMethod("recordDeleteAll");
        }
        catch (Exception e) {
            this.traceException("recordDeleteAll", e);
            throw new SRecorderException(e);
        }
    }

    @Override
    public void recordUpdate(UpdateRecord record, SUpdateEvent updateEvent) throws SRecorderException {
        String methodName = "recordUpdate";
        this.traceBeforeMethod(methodName);
        UpdateDescriptor desc = UpdateDescriptor.buildSetFields(record.getEntity(), record.getFields());
        try {
            this.persistenceService.update(desc);
            this.fireEvent(updateEvent);
            this.traceAfterMethod(methodName);
        }
        catch (FireEventException e) {
            this.logFireEventExceptionAndThrowSRecorderException(e, methodName);
        }
        catch (Exception e) {
            this.traceException(methodName, e);
            throw new SRecorderException(e);
        }
    }

    protected void logFireEventExceptionAndThrowSRecorderException(FireEventException e, String methodName) throws SRecorderException {
        List<Exception> handlerExceptions = e.getHandlerExceptions();
        for (Exception exception : handlerExceptions) {
            this.traceException(methodName, exception);
        }
        throw new SRecorderException(e);
    }

    private void fireEvent(SEvent evt) throws FireEventException {
        if (evt != null) {
            this.eventService.fireEvent(evt);
        }
    }

    private boolean isTraceLoggable() {
        return this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
    }

    private void logTrace(String text) {
        this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, text);
    }

    private void traceException(String methodName, Exception e) {
        if (this.isTraceLoggable()) {
            this.logTrace(LogUtil.getLogOnExceptionMethod(this.getClass(), methodName, e));
        }
    }

    private void traceAfterMethod(String methodName) {
        if (this.isTraceLoggable()) {
            this.logTrace(LogUtil.getLogAfterMethod(this.getClass(), methodName));
        }
    }

    private void traceBeforeMethod(String methodName) {
        if (this.isTraceLoggable()) {
            this.logTrace(LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }
}

