/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.supervisor.mapping.model.impl;

import org.bonitasoft.engine.queriablelogger.model.builder.impl.MissingMandatoryFieldsException;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisor;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisorBuilder;
import org.bonitasoft.engine.supervisor.mapping.model.impl.SProcessSupervisorImpl;

public class SProcessSupervisorBuilderImpl
implements SProcessSupervisorBuilder {
    private static final String ID_KEY = "id";
    private static final String USER_ID_KEY = "userId";
    private static final String GROUP_ID_KEY = "groupId";
    private static final String ROLE_ID_KEY = "roleId";
    private static final String PROCESS_DEF_ID_KEY = "processDefId";
    private SProcessSupervisorImpl supervisor;

    @Override
    public SProcessSupervisorBuilder createNewInstance(long processDefId) {
        this.supervisor = new SProcessSupervisorImpl(processDefId);
        return this;
    }

    @Override
    public SProcessSupervisorBuilder setUserId(long userId) {
        this.supervisor.setUserId(userId);
        return this;
    }

    @Override
    public SProcessSupervisorBuilder setGroupId(long groupId) {
        this.supervisor.setGroupId(groupId);
        return this;
    }

    @Override
    public SProcessSupervisorBuilder setRoleId(long roleId) {
        this.supervisor.setRoleId(roleId);
        return this;
    }

    @Override
    public SProcessSupervisor done() {
        if (this.supervisor.getUserId() == -1L && this.supervisor.getGroupId() == -1L && this.supervisor.getRoleId() == -1L) {
            throw new MissingMandatoryFieldsException("you must set at least one of the following fields: userId, groupId, roleId");
        }
        return this.supervisor;
    }

    @Override
    public String getIdKey() {
        return ID_KEY;
    }

    @Override
    public String getUserIdKey() {
        return USER_ID_KEY;
    }

    @Override
    public String getProcessDefIdKey() {
        return PROCESS_DEF_ID_KEY;
    }

    @Override
    public String getGroupIdKey() {
        return GROUP_ID_KEY;
    }

    @Override
    public String getRoleIdKey() {
        return ROLE_ID_KEY;
    }
}

