/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro.jms;

import java.io.Serializable;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;

public class JMSProducer {
    public static final String TOPIC_CONNECTION_FACTORY = "bonita/jms/TopicConnectionFactory";
    public static final String TOPIC_NAME = "synchroServiceTopic";
    private final TopicConnectionFactory topicConnectionFactory;
    private final TopicConnection topicConnection;
    private final Session session;
    private final Topic topic;
    private final MessageProducer producer;
    private final long timeout;
    private static JMSProducer jmsProducer;

    private JMSProducer(long timeout) throws JMSException {
        String brokerURL = System.getProperty("broker.url");
        this.topicConnectionFactory = new ActiveMQConnectionFactory(brokerURL);
        this.topicConnection = this.topicConnectionFactory.createTopicConnection();
        this.session = this.topicConnection.createSession(false, 1);
        this.topic = this.session.createTopic(TOPIC_NAME);
        this.topicConnection.start();
        this.producer = this.session.createProducer((Destination)this.topic);
        this.timeout = timeout;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    JMSProducer.this.topicConnection.stop();
                    JMSProducer.this.producer.close();
                    JMSProducer.this.session.close();
                    JMSProducer.this.topicConnection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static JMSProducer getInstance(long messageTimeout) {
        if (jmsProducer == null) {
            try {
                jmsProducer = new JMSProducer(messageTimeout);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return jmsProducer;
    }

    public void sendMessage(Map<String, Serializable> properties, long body) throws JMSException {
        MapMessage message = this.session.createMapMessage();
        for (Map.Entry<String, Serializable> property : properties.entrySet()) {
            message.setObjectProperty(property.getKey(), (Object)property.getValue());
        }
        message.setLong("body-id", body);
        message.setJMSExpiration(System.currentTimeMillis() + this.timeout);
        this.producer.send((Message)message);
    }
}

