/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.transaction.BonitaTransactionManagerLookup;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.JTATransactionWrapper;
import org.bonitasoft.engine.transaction.STransactionCommitException;
import org.bonitasoft.engine.transaction.STransactionCreationException;
import org.bonitasoft.engine.transaction.STransactionException;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.STransactionRollbackException;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.transaction.TransactionState;

public class JTATransactionServiceImpl
implements TransactionService {
    protected final TechnicalLoggerService logger;
    private final TransactionManager txManager;
    private List<BonitaTransactionSynchronization> synchronizations;
    private final AtomicLong numberOfActiveTransactions = new AtomicLong(0L);

    public JTATransactionServiceImpl(TechnicalLoggerService logger, BonitaTransactionManagerLookup txManagerLookup) {
        this(logger, txManagerLookup.getTransactionManager());
    }

    public JTATransactionServiceImpl(TechnicalLoggerService logger, TransactionManager txManager) {
        this.logger = logger;
        if (txManager == null) {
            throw new IllegalArgumentException("The parameter txManager can't be null.");
        }
        this.txManager = txManager;
    }

    @Override
    public void begin() throws STransactionCreationException {
        block9: {
            try {
                if (this.txManager.getStatus() == 6) {
                    boolean transactionStarted = false;
                    try {
                        this.txManager.begin();
                        transactionStarted = true;
                        this.numberOfActiveTransactions.getAndIncrement();
                        Transaction tx = this.txManager.getTransaction();
                        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "Beginning transaction in thread " + Thread.currentThread().getId() + " " + tx.toString());
                        }
                        if (this.synchronizations != null) {
                            this.synchronizations.clear();
                        }
                        this.synchronizations = new ArrayList<BonitaTransactionSynchronization>();
                        break block9;
                    }
                    catch (NotSupportedException e) {
                        throw new STransactionCreationException(e);
                    }
                    catch (Throwable t) {
                        if (transactionStarted) {
                            this.txManager.rollback();
                            this.numberOfActiveTransactions.getAndDecrement();
                        }
                        throw new STransactionCreationException(t);
                    }
                }
                throw new STransactionCreationException("We do not support nested transaction.");
            }
            catch (SystemException e) {
                throw new STransactionCreationException(e);
            }
        }
    }

    @Override
    public void complete() throws STransactionCommitException, STransactionRollbackException {
        block20: {
            try {
                int status;
                Transaction tx = this.txManager.getTransaction();
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "Completing transaction in thread " + Thread.currentThread().getId() + " " + tx.toString());
                }
                if ((status = this.txManager.getStatus()) == 1) {
                    try {
                        this.txManager.rollback();
                        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "Rollbacking transaction in thread " + Thread.currentThread().getId() + " " + tx.toString());
                        }
                        break block20;
                    }
                    catch (IllegalStateException e) {
                        throw new STransactionRollbackException("", e);
                    }
                    catch (SecurityException e) {
                        throw new STransactionRollbackException("", e);
                    }
                    finally {
                        this.numberOfActiveTransactions.getAndDecrement();
                    }
                }
                try {
                    this.txManager.commit();
                }
                catch (SecurityException e) {
                    throw new STransactionCommitException("", e);
                }
                catch (IllegalStateException e) {
                    throw new STransactionCommitException("", e);
                }
                catch (RollbackException e) {
                    throw new STransactionCommitException("", e);
                }
                catch (HeuristicMixedException e) {
                    throw new STransactionCommitException("", e);
                }
                catch (HeuristicRollbackException e) {
                    throw new STransactionCommitException("", e);
                }
                finally {
                    this.numberOfActiveTransactions.getAndDecrement();
                }
            }
            catch (SystemException e) {
                throw new STransactionCommitException("", e);
            }
        }
    }

    @Override
    public TransactionState getState() throws STransactionException {
        try {
            int status = this.txManager.getStatus();
            switch (status) {
                case 0: {
                    return TransactionState.ACTIVE;
                }
                case 3: {
                    return TransactionState.COMMITTED;
                }
                case 1: {
                    return TransactionState.ROLLBACKONLY;
                }
                case 4: {
                    return TransactionState.ROLLEDBACK;
                }
                case 6: {
                    return TransactionState.NO_TRANSACTION;
                }
            }
            throw new STransactionException("Can't map the JTA status : " + status);
        }
        catch (SystemException e) {
            throw new STransactionException("", e);
        }
    }

    @Override
    public boolean isTransactionActive() throws STransactionException {
        try {
            return this.txManager.getStatus() == 0;
        }
        catch (SystemException e) {
            throw new STransactionException("", e);
        }
    }

    @Override
    public void setRollbackOnly() throws STransactionException {
        try {
            this.txManager.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            throw new STransactionException("", e);
        }
        catch (SystemException e) {
            throw new STransactionException("", e);
        }
    }

    @Override
    public boolean isRollbackOnly() throws STransactionException {
        try {
            return this.txManager.getStatus() == 1;
        }
        catch (SystemException e) {
            throw new STransactionException("Error while trying to get the transaction's status.", e);
        }
    }

    @Override
    public void registerBonitaSynchronization(BonitaTransactionSynchronization txSync) throws STransactionNotFoundException {
        try {
            Transaction transaction = this.txManager.getTransaction();
            if (transaction == null) {
                throw new STransactionNotFoundException("No active transaction");
            }
            transaction.registerSynchronization((Synchronization)new JTATransactionWrapper(txSync));
            this.synchronizations.add(txSync);
        }
        catch (IllegalStateException e) {
            throw new STransactionNotFoundException(e.getMessage());
        }
        catch (RollbackException e) {
            throw new STransactionNotFoundException(e.getMessage());
        }
        catch (SystemException e) {
            throw new STransactionNotFoundException(e.getMessage());
        }
    }

    @Override
    public List<BonitaTransactionSynchronization> getBonitaSynchronizations() {
        return this.synchronizations;
    }

    @Override
    public <T> T executeInTransaction(Callable<T> callable) throws Exception {
        this.begin();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            this.setRollbackOnly();
            throw e;
        }
        finally {
            this.complete();
        }
    }

    @Override
    public long getNumberOfActiveTransactions() {
        return this.numberOfActiveTransactions.get();
    }
}

