/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bonitasoft.engine.work.BonitaExecutorServiceFactory;
import org.bonitasoft.engine.work.WorkerThreadFactory;

public class DefaultBonitaExecutorServiceFactory
implements BonitaExecutorServiceFactory {
    private final int corePoolSize;
    private final int queueCapacity;
    private final int maximumPoolSize;
    private final long keepAliveTimeSeconds;

    public DefaultBonitaExecutorServiceFactory(int corePoolSize, int queueCapacity, int maximumPoolSize, long keepAliveTimeSeconds) {
        this.corePoolSize = corePoolSize;
        this.queueCapacity = queueCapacity;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
    }

    @Override
    public ThreadPoolExecutor createExecutorService() {
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(this.queueCapacity);
        QueueRejectedExecutionHandler handler = new QueueRejectedExecutionHandler();
        WorkerThreadFactory threadFactory = new WorkerThreadFactory("Bonita-Worker", this.maximumPoolSize);
        return new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTimeSeconds, TimeUnit.SECONDS, workQueue, threadFactory, handler);
    }

    private final class QueueRejectedExecutionHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            throw new RejectedExecutionException("Unable to run the task " + task + "\n your work queue is full you might consider changing your configuration to scale more");
        }
    }
}

