/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.actor.xml;

import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.actor.xml.Actor;
import org.bonitasoft.engine.actor.xml.ActorMapping;
import org.bonitasoft.engine.bpm.bar.xml.XMLProcessDefinition;
import org.bonitasoft.engine.xml.XMLNode;

public class ActorMappingNodeBuilder {
    private static final String NS_PREFIX = "actormappings";
    private static final String NAME_SPACE = "http://www.bonitasoft.org/ns/actormapping/6.0";

    public static XMLNode getDocument(ActorMapping actorMapping) {
        XMLNode actorMappingNode = new XMLNode("actormappings:actorMappings");
        actorMappingNode.addAttribute("xmlns:actormappings", NAME_SPACE);
        List<Actor> actors = actorMapping.getActors();
        for (Actor actor : actors) {
            XMLNode actorNode = ActorMappingNodeBuilder.getActor(actor);
            actorMappingNode.addChild(actorNode);
        }
        return actorMappingNode;
    }

    private static XMLNode getActor(Actor actor) {
        Set<XMLProcessDefinition.BEntry<String, String>> memberships;
        Set<String> groups;
        Set<String> roles;
        XMLNode actorNode = new XMLNode("actorMapping");
        actorNode.addAttribute("name", actor.getName());
        Set<String> users = actor.getUsers();
        if (!users.isEmpty()) {
            XMLNode usersNode = ActorMappingNodeBuilder.getUsers(users);
            actorNode.addChild(usersNode);
        }
        if (!(roles = actor.getRoles()).isEmpty()) {
            XMLNode rolesNode = ActorMappingNodeBuilder.getRoles(roles);
            actorNode.addChild(rolesNode);
        }
        if (!(groups = actor.getGroups()).isEmpty()) {
            XMLNode groupsNode = ActorMappingNodeBuilder.getGroups(groups);
            actorNode.addChild(groupsNode);
        }
        if (!(memberships = actor.getMemberships()).isEmpty()) {
            XMLNode membershipsNode = ActorMappingNodeBuilder.getMemberships(memberships);
            actorNode.addChild(membershipsNode);
        }
        return actorNode;
    }

    private static XMLNode getMemberships(Set<XMLProcessDefinition.BEntry<String, String>> memberships) {
        XMLNode membershipsNode = new XMLNode("memberships");
        for (XMLProcessDefinition.BEntry<String, String> membership : memberships) {
            XMLNode membershipNode = new XMLNode("membership");
            XMLNode groupNode = new XMLNode("group");
            groupNode.setContent((String)membership.getKey());
            XMLNode roleNode = new XMLNode("role");
            roleNode.setContent((String)membership.getValue());
            membershipNode.addChild(roleNode);
            membershipNode.addChild(groupNode);
            membershipsNode.addChild(membershipNode);
        }
        return membershipsNode;
    }

    private static XMLNode getUsers(Set<String> users) {
        XMLNode usersNode = new XMLNode("users");
        for (String user : users) {
            XMLNode userNode = new XMLNode("user");
            userNode.setContent(user);
            usersNode.addChild(userNode);
        }
        return usersNode;
    }

    private static XMLNode getRoles(Set<String> roles) {
        XMLNode rolesNode = new XMLNode("roles");
        for (String role : roles) {
            XMLNode roleNode = new XMLNode("role");
            roleNode.setContent(role);
            rolesNode.addChild(roleNode);
        }
        return rolesNode;
    }

    private static XMLNode getGroups(Set<String> groups) {
        XMLNode groupsNode = new XMLNode("groups");
        for (String group : groups) {
            XMLNode groupNode = new XMLNode("group");
            groupNode.setContent(group);
            groupsNode.addChild(groupNode);
        }
        return groupsNode;
    }
}

