/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorMemberCreationException;
import org.bonitasoft.engine.actor.mapping.SActorNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.actor.mapping.model.SActorUpdateBuilder;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.impl.DeepRegexFileFilter;
import org.bonitasoft.engine.api.impl.OrderAndFields;
import org.bonitasoft.engine.api.impl.ProcessDefinitionDeployInfoComparator;
import org.bonitasoft.engine.api.impl.ProcessManagementAPIImplDelegate;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.api.impl.resolver.ProcessDependencyResolver;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.api.impl.transaction.activity.GetActivityInstance;
import org.bonitasoft.engine.api.impl.transaction.activity.GetArchivedActivityInstance;
import org.bonitasoft.engine.api.impl.transaction.activity.GetArchivedActivityInstances;
import org.bonitasoft.engine.api.impl.transaction.activity.GetNumberOfActivityInstance;
import org.bonitasoft.engine.api.impl.transaction.actor.ExportActorMapping;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActor;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActorMembers;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActorsByActorIds;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActorsByPagination;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfActorMembers;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfActors;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfGroupsOfActor;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfMembershipsOfActor;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfRolesOfActor;
import org.bonitasoft.engine.api.impl.transaction.actor.GetNumberOfUsersOfActor;
import org.bonitasoft.engine.api.impl.transaction.actor.ImportActorMapping;
import org.bonitasoft.engine.api.impl.transaction.actor.RemoveActorMember;
import org.bonitasoft.engine.api.impl.transaction.category.CreateCategory;
import org.bonitasoft.engine.api.impl.transaction.category.DeleteSCategory;
import org.bonitasoft.engine.api.impl.transaction.category.GetCategories;
import org.bonitasoft.engine.api.impl.transaction.category.GetCategory;
import org.bonitasoft.engine.api.impl.transaction.category.GetNumberOfCategories;
import org.bonitasoft.engine.api.impl.transaction.category.GetNumberOfCategoriesOfProcess;
import org.bonitasoft.engine.api.impl.transaction.category.RemoveCategoriesFromProcessDefinition;
import org.bonitasoft.engine.api.impl.transaction.category.RemoveProcessDefinitionsOfCategory;
import org.bonitasoft.engine.api.impl.transaction.category.UpdateCategory;
import org.bonitasoft.engine.api.impl.transaction.comment.AddComment;
import org.bonitasoft.engine.api.impl.transaction.connector.GetConnectorImplementation;
import org.bonitasoft.engine.api.impl.transaction.connector.GetConnectorImplementations;
import org.bonitasoft.engine.api.impl.transaction.connector.GetNumberOfConnectorImplementations;
import org.bonitasoft.engine.api.impl.transaction.data.GetNumberOfDataInstanceForContainer;
import org.bonitasoft.engine.api.impl.transaction.document.AttachDocumentVersion;
import org.bonitasoft.engine.api.impl.transaction.document.AttachDocumentVersionAndStoreContent;
import org.bonitasoft.engine.api.impl.transaction.document.GetArchivedDocument;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocument;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentByName;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentByNameAtActivityCompletion;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentByNameAtProcessInstantiation;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentContent;
import org.bonitasoft.engine.api.impl.transaction.document.GetDocumentsOfProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.document.GetNumberOfDocumentsOfProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.event.GetEventInstances;
import org.bonitasoft.engine.api.impl.transaction.expression.EvaluateExpressionsDefinitionLevel;
import org.bonitasoft.engine.api.impl.transaction.expression.EvaluateExpressionsInstanceLevel;
import org.bonitasoft.engine.api.impl.transaction.expression.EvaluateExpressionsInstanceLevelAndArchived;
import org.bonitasoft.engine.api.impl.transaction.flownode.GetFlowNodeInstance;
import org.bonitasoft.engine.api.impl.transaction.flownode.HideTasks;
import org.bonitasoft.engine.api.impl.transaction.flownode.IsTaskHidden;
import org.bonitasoft.engine.api.impl.transaction.flownode.SetExpectedEndDate;
import org.bonitasoft.engine.api.impl.transaction.flownode.UnhideTasks;
import org.bonitasoft.engine.api.impl.transaction.identity.GetSUser;
import org.bonitasoft.engine.api.impl.transaction.process.AddProcessDefinitionToCategory;
import org.bonitasoft.engine.api.impl.transaction.process.DeleteArchivedProcessInstances;
import org.bonitasoft.engine.api.impl.transaction.process.EnableProcess;
import org.bonitasoft.engine.api.impl.transaction.process.GetArchivedProcessInstanceList;
import org.bonitasoft.engine.api.impl.transaction.process.GetLastArchivedProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.process.GetLatestProcessDefinitionId;
import org.bonitasoft.engine.api.impl.transaction.process.GetNumberOfArchivedProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.process.GetNumberOfProcessDeploymentInfos;
import org.bonitasoft.engine.api.impl.transaction.process.GetNumberOfProcessDeploymentInfosUnrelatedToCategory;
import org.bonitasoft.engine.api.impl.transaction.process.GetNumberOfProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinition;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfo;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfoFromArchivedProcessInstanceIds;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfoFromProcessInstanceIds;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfos;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForGroup;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForGroups;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForRole;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForRoles;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForUser;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionDeployInfosWithActorOnlyForUsers;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinitionIDByNameAndVersion;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDeploymentInfosFromIds;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessInstance;
import org.bonitasoft.engine.api.impl.transaction.process.SetProcessInstanceState;
import org.bonitasoft.engine.api.impl.transaction.process.UpdateProcessDeploymentInfo;
import org.bonitasoft.engine.api.impl.transaction.task.AssignOrUnassignUserTask;
import org.bonitasoft.engine.api.impl.transaction.task.GetAssignedTasks;
import org.bonitasoft.engine.api.impl.transaction.task.GetHumanTaskInstance;
import org.bonitasoft.engine.api.impl.transaction.task.GetNumberOfAssignedUserTaskInstances;
import org.bonitasoft.engine.api.impl.transaction.task.GetNumberOfOpenTasksForUsers;
import org.bonitasoft.engine.api.impl.transaction.task.GetNumberOfOverdueOpenTasksForUsers;
import org.bonitasoft.engine.api.impl.transaction.task.SetTaskPriority;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.bpm.actor.ActorCriterion;
import org.bonitasoft.engine.bpm.actor.ActorInstance;
import org.bonitasoft.engine.bpm.actor.ActorMappingExportException;
import org.bonitasoft.engine.bpm.actor.ActorMappingImportException;
import org.bonitasoft.engine.bpm.actor.ActorMember;
import org.bonitasoft.engine.bpm.actor.ActorNotFoundException;
import org.bonitasoft.engine.bpm.actor.ActorUpdater;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveBuilder;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveFactory;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.bar.ProcessDefinitionBARContribution;
import org.bonitasoft.engine.bpm.category.Category;
import org.bonitasoft.engine.bpm.category.CategoryCriterion;
import org.bonitasoft.engine.bpm.category.CategoryNotFoundException;
import org.bonitasoft.engine.bpm.category.CategoryUpdater;
import org.bonitasoft.engine.bpm.comment.ArchivedComment;
import org.bonitasoft.engine.bpm.comment.Comment;
import org.bonitasoft.engine.bpm.connector.ArchivedConnectorInstance;
import org.bonitasoft.engine.bpm.connector.ConnectorCriterion;
import org.bonitasoft.engine.bpm.connector.ConnectorExecutionException;
import org.bonitasoft.engine.bpm.connector.ConnectorImplementationDescriptor;
import org.bonitasoft.engine.bpm.connector.ConnectorInstance;
import org.bonitasoft.engine.bpm.connector.ConnectorNotFoundException;
import org.bonitasoft.engine.bpm.data.ArchivedDataInstance;
import org.bonitasoft.engine.bpm.data.ArchivedDataNotFoundException;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.DataInstance;
import org.bonitasoft.engine.bpm.data.DataNotFoundException;
import org.bonitasoft.engine.bpm.document.ArchivedDocument;
import org.bonitasoft.engine.bpm.document.ArchivedDocumentNotFoundException;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentAttachmentException;
import org.bonitasoft.engine.bpm.document.DocumentCriterion;
import org.bonitasoft.engine.bpm.document.DocumentException;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.flownode.ActivityExecutionException;
import org.bonitasoft.engine.bpm.flownode.ActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceCriterion;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceNotFoundException;
import org.bonitasoft.engine.bpm.flownode.ArchivedActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedFlowNodeInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedFlowNodeInstanceNotFoundException;
import org.bonitasoft.engine.bpm.flownode.ArchivedHumanTaskInstance;
import org.bonitasoft.engine.bpm.flownode.EventCriterion;
import org.bonitasoft.engine.bpm.flownode.EventInstance;
import org.bonitasoft.engine.bpm.flownode.FlowNodeExecutionException;
import org.bonitasoft.engine.bpm.flownode.FlowNodeInstance;
import org.bonitasoft.engine.bpm.flownode.FlowNodeInstanceNotFoundException;
import org.bonitasoft.engine.bpm.flownode.FlowNodeType;
import org.bonitasoft.engine.bpm.flownode.HumanTaskInstance;
import org.bonitasoft.engine.bpm.flownode.SendEventException;
import org.bonitasoft.engine.bpm.flownode.TaskPriority;
import org.bonitasoft.engine.bpm.process.ActivationState;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.ConfigurationState;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.InvalidProcessDefinitionException;
import org.bonitasoft.engine.bpm.process.Problem;
import org.bonitasoft.engine.bpm.process.ProcessActivationException;
import org.bonitasoft.engine.bpm.process.ProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDeployException;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoCriterion;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoUpdater;
import org.bonitasoft.engine.bpm.process.ProcessEnablementException;
import org.bonitasoft.engine.bpm.process.ProcessExecutionException;
import org.bonitasoft.engine.bpm.process.ProcessExportException;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessInstanceCriterion;
import org.bonitasoft.engine.bpm.process.ProcessInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.bpm.process.impl.ProcessDeploymentInfoImpl;
import org.bonitasoft.engine.bpm.supervisor.ProcessSupervisor;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.commons.transaction.TransactionExecutor;
import org.bonitasoft.engine.core.category.CategoryService;
import org.bonitasoft.engine.core.category.exception.SCategoryAlreadyExistsException;
import org.bonitasoft.engine.core.category.exception.SCategoryInProcessAlreadyExistsException;
import org.bonitasoft.engine.core.category.exception.SCategoryNotFoundException;
import org.bonitasoft.engine.core.category.model.SCategory;
import org.bonitasoft.engine.core.category.model.SProcessCategoryMapping;
import org.bonitasoft.engine.core.category.model.builder.SCategoryBuilderAccessor;
import org.bonitasoft.engine.core.category.model.builder.SCategoryUpdateBuilder;
import org.bonitasoft.engine.core.category.model.builder.SProcessCategoryMappingBuilder;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.connector.exception.SConnectorException;
import org.bonitasoft.engine.core.connector.parser.SConnectorImplementationDescriptor;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.filter.FilterResult;
import org.bonitasoft.engine.core.filter.UserFilterService;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.operation.model.SOperatorType;
import org.bonitasoft.engine.core.operation.model.builder.SOperationBuilders;
import org.bonitasoft.engine.core.process.comment.api.SCommentNotFoundException;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.model.SComment;
import org.bonitasoft.engine.core.process.comment.model.archive.SAComment;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDeletionException;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SActorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SHumanTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinitionDeployInfo;
import org.bonitasoft.engine.core.process.definition.model.SUserFilterDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.BPMDefinitionBuilders;
import org.bonitasoft.engine.core.process.definition.model.builder.ProcessDefinitionDeployInfoBuilder;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionDeployInfoUpdateBuilder;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SThrowMessageEventTriggerDefinitionBuilder;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SThrowSignalEventTriggerDefinitionBuilder;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowSignalEventTriggerDefinition;
import org.bonitasoft.engine.core.process.document.api.ProcessDocumentService;
import org.bonitasoft.engine.core.process.document.mapping.model.builder.SDocumentMappingBuilderAccessor;
import org.bonitasoft.engine.core.process.document.model.SAProcessDocument;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilder;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilders;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SAProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceHierarchicalDeletionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SPendingActivityMapping;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.STaskPriority;
import org.bonitasoft.engine.core.process.instance.model.SUserTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAProcessInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.core.process.instance.model.builder.SAutomaticTaskInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SEndEventInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilder;
import org.bonitasoft.engine.data.definition.model.builder.SDataDefinitionBuilders;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.archive.SADataInstance;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.model.builder.DependencyBuilderAccessor;
import org.bonitasoft.engine.document.SDocumentNotFoundException;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.NotSerializableException;
import org.bonitasoft.engine.exception.ProcessInstanceHierarchicalDeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.SUnreleasableTaskException;
import org.bonitasoft.engine.execution.TransactionalProcessInstanceInterruptor;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.expression.ExpressionEvaluationException;
import org.bonitasoft.engine.expression.ExpressionType;
import org.bonitasoft.engine.expression.InvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilders;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.MemberType;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.User;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.io.IOUtil;
import org.bonitasoft.engine.job.FailedJob;
import org.bonitasoft.engine.lock.BonitaLock;
import org.bonitasoft.engine.lock.LockService;
import org.bonitasoft.engine.lock.SLockException;
import org.bonitasoft.engine.log.LogMessageBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperationBuilder;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderAndField;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.model.SFailedJob;
import org.bonitasoft.engine.scheduler.model.SJobParameter;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SSearchException;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.activity.SearchActivityInstances;
import org.bonitasoft.engine.search.activity.SearchArchivedActivityInstances;
import org.bonitasoft.engine.search.comment.SearchArchivedComments;
import org.bonitasoft.engine.search.comment.SearchComments;
import org.bonitasoft.engine.search.comment.SearchCommentsInvolvingUser;
import org.bonitasoft.engine.search.comment.SearchCommentsManagedBy;
import org.bonitasoft.engine.search.connector.SearchArchivedConnectorInstance;
import org.bonitasoft.engine.search.connector.SearchConnectorInstances;
import org.bonitasoft.engine.search.descriptor.SearchEntitiesDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchProcessDefinitionsDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchProcessInstanceDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchProcessSupervisorDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchUserDescriptor;
import org.bonitasoft.engine.search.document.SearchArchivedDocuments;
import org.bonitasoft.engine.search.document.SearchArchivedDocumentsSupervisedBy;
import org.bonitasoft.engine.search.document.SearchDocuments;
import org.bonitasoft.engine.search.document.SearchDocumentsSupervisedBy;
import org.bonitasoft.engine.search.flownode.SearchArchivedFlowNodeInstances;
import org.bonitasoft.engine.search.flownode.SearchFlowNodeInstances;
import org.bonitasoft.engine.search.identity.SearchUsersWhoCanStartProcessDeploymentInfo;
import org.bonitasoft.engine.search.impl.SearchResultImpl;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstances;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstancesInvolvingUser;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstancesSupervisedBy;
import org.bonitasoft.engine.search.process.SearchArchivedProcessInstancesWithoutSubProcess;
import org.bonitasoft.engine.search.process.SearchOpenProcessInstancesInvolvingUser;
import org.bonitasoft.engine.search.process.SearchOpenProcessInstancesInvolvingUsersManagedBy;
import org.bonitasoft.engine.search.process.SearchOpenProcessInstancesSupervisedBy;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfos;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfosStartedBy;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfosUserCanStart;
import org.bonitasoft.engine.search.process.SearchProcessDeploymentInfosUsersManagedByCanStart;
import org.bonitasoft.engine.search.process.SearchProcessInstances;
import org.bonitasoft.engine.search.process.SearchUncategorizedProcessDeploymentInfos;
import org.bonitasoft.engine.search.process.SearchUncategorizedProcessDeploymentInfosSupervisedBy;
import org.bonitasoft.engine.search.process.SearchUncategorizedProcessDeploymentInfosUserCanStart;
import org.bonitasoft.engine.search.supervisor.SearchArchivedTasksSupervisedBy;
import org.bonitasoft.engine.search.supervisor.SearchAssignedTasksSupervisedBy;
import org.bonitasoft.engine.search.supervisor.SearchProcessDeploymentInfosSupervised;
import org.bonitasoft.engine.search.supervisor.SearchSupervisors;
import org.bonitasoft.engine.search.task.SearchArchivedTasks;
import org.bonitasoft.engine.search.task.SearchArchivedTasksManagedBy;
import org.bonitasoft.engine.search.task.SearchAssignedTaskManagedBy;
import org.bonitasoft.engine.search.task.SearchHumanTaskInstances;
import org.bonitasoft.engine.search.task.SearchPendingHiddenTasks;
import org.bonitasoft.engine.search.task.SearchPendingTasksForUser;
import org.bonitasoft.engine.search.task.SearchPendingTasksManagedBy;
import org.bonitasoft.engine.search.task.SearchPendingTasksSupervisedBy;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.supervisor.mapping.SSupervisorAlreadyExistsException;
import org.bonitasoft.engine.supervisor.mapping.SSupervisorCreationException;
import org.bonitasoft.engine.supervisor.mapping.SSupervisorDeletionException;
import org.bonitasoft.engine.supervisor.mapping.SSupervisorNotFoundException;
import org.bonitasoft.engine.supervisor.mapping.SupervisorMappingService;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisor;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisorBuilder;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisorBuilders;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.XMLWriter;

public class ProcessAPIImpl
implements ProcessAPI {
    private static final String CONTAINER_TYPE_PROCESS_INSTANCE = "PROCESS_INSTANCE";
    private static final String CONTAINER_TYPE_ACTIVITY_INSTANCE = "ACTIVITY_INSTANCE";
    private final ProcessManagementAPIImplDelegate processManagementAPIImplDelegate = this.instantiateProcessManagementAPIDelegate();

    protected ProcessManagementAPIImplDelegate instantiateProcessManagementAPIDelegate() {
        return new ProcessManagementAPIImplDelegate();
    }

    protected static TenantServiceAccessor getTenantAccessor() {
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long tenantId = sessionAccessor.getTenantId();
            return TenantServiceSingleton.getInstance(tenantId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SearchResult<HumanTaskInstance> searchHumanTaskInstances(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchHumanTaskInstances searchHumanTasksTransaction = new SearchHumanTaskInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getHumanTaskInstanceDescriptor(), searchOptions);
        try {
            searchHumanTasksTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchHumanTasksTransaction.getResult();
    }

    public void deleteProcessDefinition(long processDefinitionId) throws DeletionException {
        SearchOptionsBuilder builder = new SearchOptionsBuilder(0, 1);
        builder.filter("processDefinitionId", (Serializable)Long.valueOf(processDefinitionId));
        SearchOptions searchOptions = builder.done();
        try {
            boolean hasArchivedProcessInstances;
            boolean hasOpenProcessInstances;
            boolean bl = hasOpenProcessInstances = this.searchProcessInstances(ProcessAPIImpl.getTenantAccessor(), searchOptions).getCount() > 0L;
            if (hasOpenProcessInstances) {
                throw new DeletionException("Some active process instances are still found, process #" + processDefinitionId + " can't be deleted.");
            }
            boolean bl2 = hasArchivedProcessInstances = this.searchArchivedProcessInstances(searchOptions).getCount() > 0L;
            if (hasArchivedProcessInstances) {
                throw new DeletionException("Some archived process instances are still found, process #" + processDefinitionId + " can't be deleted.");
            }
            this.processManagementAPIImplDelegate.deleteProcessDefinition(processDefinitionId);
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public void deleteProcessDefinitions(List<Long> processDefinitionIds) throws DeletionException {
        for (Long processDefinitionId : processDefinitionIds) {
            this.deleteProcessDefinition(processDefinitionId);
        }
    }

    @CustomTransactions
    @Deprecated
    public void deleteProcess(final long processDefinitionId) throws DeletionException {
        final TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        TransactionService transactionService = tenantAccessor.getTransactionService();
        try {
            transactionService.executeInTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ProcessAPIImpl.this.deleteProcessInstancesFromProcessDefinition(processDefinitionId, tenantAccessor, tenantAccessor.getTenantId());
                    try {
                        ProcessAPIImpl.this.processManagementAPIImplDelegate.deleteProcessDefinition(processDefinitionId);
                    }
                    catch (BonitaHomeNotSetException e) {
                        throw new SProcessDeletionException(e);
                    }
                    catch (IOException e) {
                        throw new SProcessDeletionException(e);
                    }
                    return null;
                }
            });
        }
        catch (SProcessInstanceHierarchicalDeletionException e) {
            throw new ProcessInstanceHierarchicalDeletionException(e.getMessage(), e.getProcessInstanceId());
        }
        catch (Exception e) {
            throw new DeletionException((Throwable)e);
        }
    }

    private void deleteProcessInstancesFromProcessDefinition(long processDefinitionId, TenantServiceAccessor tenantAccessor, long tenantId) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        List<ProcessInstance> processInstances;
        int maxResults = 1000;
        do {
            if ((processInstances = this.searchProcessInstancesFromProcessDefinition(tenantAccessor, processDefinitionId, 0, 1000)).size() <= 0) continue;
            this.deleteProcessInstancesInsideLocks(tenantAccessor, true, processInstances, tenantAccessor.getTenantId());
        } while (!processInstances.isEmpty());
    }

    private void deleteProcessInstancesInsideLocks(TenantServiceAccessor tenantAccessor, boolean ignoreProcessInstanceNotFound, List<ProcessInstance> processInstances, long tenantId) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        ArrayList<Long> processInstanceIds = new ArrayList<Long>(processInstances.size());
        for (ProcessInstance processInstance : processInstances) {
            processInstanceIds.add(processInstance.getId());
        }
        this.deleteProcessInstancesInsideLocksFromIds(tenantAccessor, ignoreProcessInstanceNotFound, processInstanceIds, tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProcessInstancesInsideLocksFromIds(TenantServiceAccessor tenantAccessor, boolean ignoreProcessInstanceNotFound, List<Long> processInstanceIds, long tenantId) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        LockService lockService = tenantAccessor.getLockService();
        String objectType = SFlowElementsContainerType.PROCESS.name();
        ArrayList<Long> lockedProcesses = new ArrayList<Long>();
        ArrayList<BonitaLock> locks = null;
        try {
            locks = this.createLocks(lockService, objectType, lockedProcesses, processInstanceIds, tenantId);
            this.deleteProcessInstancesInTransaction(tenantAccessor, ignoreProcessInstanceNotFound, processInstanceIds);
        }
        finally {
            this.releaseLocks(tenantAccessor, lockService, locks, tenantId);
        }
    }

    private void releaseLocks(TenantServiceAccessor tenantAccessor, LockService lockService, List<BonitaLock> locks, long tenantId) {
        if (locks == null) {
            return;
        }
        for (BonitaLock lock : locks) {
            try {
                lockService.unlock(lock, tenantId);
            }
            catch (SLockException e) {
                this.log(tenantAccessor, e);
            }
        }
    }

    private ArrayList<BonitaLock> createLocks(LockService lockService, String objectType, List<Long> lockedProcesses, List<Long> processInstanceIds, long tenantId) throws SLockException {
        ArrayList<BonitaLock> locks = new ArrayList<BonitaLock>(processInstanceIds.size());
        for (Long processInstanceId : processInstanceIds) {
            BonitaLock lock = lockService.lock(processInstanceId, objectType, tenantId);
            locks.add(lock);
            lockedProcesses.add(processInstanceId);
        }
        return locks;
    }

    private void deleteProcessInstancesInTransaction(TenantServiceAccessor tenantAccessor, boolean ignoreProcessInstanceNotFound, List<Long> processInstanceIds) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        this.deleteProcessInstances(processInstanceService, logger, ignoreProcessInstanceNotFound, activityInstanceService, processInstanceIds);
    }

    private void deleteProcessInstances(ProcessInstanceService processInstanceService, TechnicalLoggerService logger, boolean ignoreProcessInstanceNotFound, ActivityInstanceService activityInstanceService, List<Long> processInstanceIds) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        for (Long processInstanceId : processInstanceIds) {
            try {
                this.deleteProcessInstance(processInstanceService, processInstanceId, activityInstanceService);
            }
            catch (SProcessInstanceNotFoundException e) {
                if (ignoreProcessInstanceNotFound) {
                    if (!logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) continue;
                    logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e.getMessage() + ". It has probably completed.");
                    continue;
                }
                throw e;
            }
        }
    }

    private void deleteProcessInstance(ProcessInstanceService processInstanceService, Long processInstanceId, ActivityInstanceService activityInstanceService) throws SBonitaException, SProcessInstanceHierarchicalDeletionException {
        SProcessInstance processInstance = processInstanceService.getProcessInstance(processInstanceId);
        long callerId = processInstance.getCallerId();
        if (callerId > 0L) {
            try {
                SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(callerId);
                throw new SProcessInstanceHierarchicalDeletionException("Unable to delete the process instance because the parent is still active: activity " + flowNodeInstance.getName() + " with id " + flowNodeInstance.getId(), flowNodeInstance.getRootProcessInstanceId());
            }
            catch (SFlowNodeNotFoundException e) {
                // empty catch block
            }
        }
        processInstanceService.deleteArchivedProcessInstanceElements(processInstanceId, processInstance.getProcessDefinitionId());
        processInstanceService.deleteArchivedProcessInstancesOfProcessInstance(processInstanceId);
        processInstanceService.deleteProcessInstance(processInstance);
    }

    private List<ProcessInstance> searchProcessInstancesFromProcessDefinition(TenantServiceAccessor tenantAccessor, long processDefinitionId, int startIndex, int maxResults) throws SSearchException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(startIndex, maxResults);
        searchOptionsBuilder.filter("processDefinitionId", (Serializable)Long.valueOf(processDefinitionId));
        searchOptionsBuilder.sort("callerId", Order.ASC);
        return this.searchProcessInstances(tenantAccessor, searchOptionsBuilder.done()).getResult();
    }

    @CustomTransactions
    @Deprecated
    public void deleteProcesses(List<Long> processDefinitionIds) throws DeletionException {
        for (Long processDefinitionId : processDefinitionIds) {
            this.deleteProcess(processDefinitionId);
        }
    }

    public ProcessDefinition deployAndEnableProcess(DesignProcessDefinition designProcessDefinition) throws ProcessDeployException, ProcessEnablementException, AlreadyExistsException, InvalidProcessDefinitionException {
        BusinessArchive businessArchive;
        try {
            businessArchive = new BusinessArchiveBuilder().createNewBusinessArchive().setProcessDefinition(designProcessDefinition).done();
        }
        catch (InvalidBusinessArchiveFormatException ibafe) {
            throw new InvalidProcessDefinitionException(ibafe.getMessage());
        }
        return this.deployAndEnableProcess(businessArchive);
    }

    public ProcessDefinition deployAndEnableProcess(BusinessArchive businessArchive) throws ProcessDeployException, ProcessEnablementException, AlreadyExistsException {
        ProcessDefinition processDefinition = this.deploy(businessArchive);
        try {
            this.enableProcess(processDefinition.getId());
        }
        catch (ProcessDefinitionNotFoundException pdnfe) {
            throw new ProcessEnablementException(pdnfe.getMessage());
        }
        return processDefinition;
    }

    public ProcessDefinition deploy(DesignProcessDefinition designProcessDefinition) throws AlreadyExistsException, ProcessDeployException {
        try {
            BusinessArchive businessArchive = new BusinessArchiveBuilder().createNewBusinessArchive().setProcessDefinition(designProcessDefinition).done();
            return this.deploy(businessArchive);
        }
        catch (InvalidBusinessArchiveFormatException ibafe) {
            throw new ProcessDeployException((Throwable)ibafe);
        }
    }

    public ProcessDefinition deploy(BusinessArchive businessArchive) throws ProcessDeployException, AlreadyExistsException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        BPMDefinitionBuilders bpmDefinitionBuilders = tenantAccessor.getBPMDefinitionBuilders();
        SExpressionBuilders sExpressionBuilders = tenantAccessor.getSExpressionBuilders();
        SDataDefinitionBuilders sDataDefinitionBuilders = tenantAccessor.getSDataDefinitionBuilders();
        SOperationBuilders sOperationBuilders = tenantAccessor.getSOperationBuilders();
        DependencyService dependencyService = tenantAccessor.getDependencyService();
        DependencyBuilderAccessor dependencyBuilderAccessor = tenantAccessor.getDependencyBuilderAccessor();
        DesignProcessDefinition designProcessDefinition = businessArchive.getProcessDefinition();
        SProcessDefinition sProcessDefinition = bpmDefinitionBuilders.getProcessDefinitionBuilder().createNewInstance(designProcessDefinition, sExpressionBuilders, sDataDefinitionBuilders, sOperationBuilders).done();
        try {
            try {
                processDefinitionService.getProcessDefinitionId(designProcessDefinition.getName(), designProcessDefinition.getVersion());
                throw new AlreadyExistsException("The process " + designProcessDefinition.getName() + " in version " + designProcessDefinition.getVersion() + " already exists.");
            }
            catch (SProcessDefinitionReadException e) {
                processDefinitionService.store(sProcessDefinition, designProcessDefinition.getDisplayName(), designProcessDefinition.getDisplayDescription());
                this.unzipBar(businessArchive, sProcessDefinition, tenantAccessor.getTenantId());
                boolean isResolved = tenantAccessor.getDependencyResolver().resolveDependencies(this, businessArchive, tenantAccessor, sProcessDefinition);
                if (isResolved) {
                    tenantAccessor.getDependencyResolver().resolveAndCreateDependencies(businessArchive, processDefinitionService, dependencyService, dependencyBuilderAccessor, sProcessDefinition);
                }
            }
        }
        catch (BonitaHomeNotSetException e) {
            throw new ProcessDeployException((Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessDeployException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ProcessDeployException((Throwable)e);
        }
        ProcessDefinition processDefinition = ModelConvertor.toProcessDefinition(sProcessDefinition);
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, "The user <" + SessionInfos.getUserNameFromSession() + "> has installed process <" + sProcessDefinition.getName() + "> in version <" + sProcessDefinition.getVersion() + "> with id <" + sProcessDefinition.getId() + ">");
        }
        return processDefinition;
    }

    public void importActorMapping(long pDefinitionId, byte[] actorMappingXML) throws ActorMappingImportException {
        if (actorMappingXML != null) {
            String actorMapping = new String(actorMappingXML, Charset.forName("UTF-8"));
            this.importActorMapping(pDefinitionId, actorMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exportBarProcessContentUnderHome(long processDefinitionId) throws ProcessExportException {
        byte[] byArray;
        String processesFolder;
        try {
            long tenantId = ProcessAPIImpl.getTenantAccessor().getTenantId();
            processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
        }
        catch (BonitaHomeNotSetException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
        File file = new File(processesFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        File processFolder = new File(file, String.valueOf(processDefinitionId));
        File actormappF = new File(processFolder.getPath(), "actorMapping.xml");
        if (!actormappF.exists()) {
            actormappF.createNewFile();
        }
        String xmlcontent = "";
        try {
            xmlcontent = this.exportActorMapping(processDefinitionId);
        }
        catch (ActorMappingExportException e) {
            throw new ProcessExportException((Throwable)e);
        }
        IOUtil.write((File)actormappF, (String)xmlcontent);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            IOUtil.zipDir((String)processFolder.getPath(), (ZipOutputStream)zos, (String)processFolder.getPath());
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                zos.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ProcessExportException((Throwable)e);
            }
        }
        zos.close();
        return byArray;
    }

    protected void unzipBar(BusinessArchive businessArchive, SProcessDefinition sProcessDefinition, long tenantId) throws BonitaHomeNotSetException, IOException {
        File processFolder = this.getProcessFolder(sProcessDefinition.getId(), tenantId);
        BusinessArchiveFactory.writeBusinessArchiveToFolder((BusinessArchive)businessArchive, (File)processFolder);
    }

    private File getProcessFolder(long processDefinitionId, long tenantId) throws BonitaHomeNotSetException {
        String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
        File file = new File(processesFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, String.valueOf(processDefinitionId));
    }

    @CustomTransactions
    @Deprecated
    public void disableAndDelete(final long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessActivationException, DeletionException {
        TransactionExecutor transactionExecutor = ProcessAPIImpl.getTenantAccessor().getTransactionExecutor();
        try {
            transactionExecutor.execute(new TransactionContent(){

                @Override
                public void execute() throws SBonitaException {
                    ProcessAPIImpl.this.processManagementAPIImplDelegate.disableProcess(processDefinitionId);
                }
            });
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ProcessActivationException((Exception)e);
        }
        this.deleteProcess(processDefinitionId);
    }

    public void disableAndDeleteProcessDefinition(long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessActivationException, DeletionException {
        this.disableProcess(processDefinitionId);
        this.deleteProcessDefinition(processDefinitionId);
    }

    public void disableProcess(long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessActivationException {
        try {
            this.processManagementAPIImplDelegate.disableProcess(processDefinitionId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ProcessActivationException((Exception)e);
        }
    }

    public void enableProcess(long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessEnablementException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        EventsHandler eventsHandler = tenantAccessor.getEventsHandler();
        try {
            EnableProcess enableProcess = new EnableProcess(processDefinitionService, processDefinitionId, eventsHandler, tenantAccessor.getTechnicalLoggerService(), SessionInfos.getUserNameFromSession());
            enableProcess.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException sbe) {
            throw new ProcessEnablementException((Throwable)sbe);
        }
        catch (Exception e) {
            throw new ProcessEnablementException((Throwable)e);
        }
    }

    @CustomTransactions
    public void executeFlowNode(long flownodeInstanceId) throws FlowNodeExecutionException {
        this.executeFlowNode(0L, flownodeInstanceId, true);
    }

    @CustomTransactions
    public void executeFlowNode(long userId, long flownodeInstanceId) throws FlowNodeExecutionException {
        this.executeFlowNode(userId, flownodeInstanceId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeFlowNode(final long userId, final long flownodeInstanceId, boolean wrapInTransaction) throws FlowNodeExecutionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        final ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        final ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        LockService lockService = tenantAccessor.getLockService();
        final TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        TransactionContent transactionContent = new TransactionContent(){

            @Override
            public void execute() throws SBonitaException {
                SSession session = SessionInfos.getSession();
                long starterId = userId == 0L ? (session != null ? session.getUserId() : -1L) : userId;
                SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(flownodeInstanceId);
                boolean isFirstState = flowNodeInstance.getStateId() == 0;
                processExecutor.executeFlowNode(flownodeInstanceId, null, null, flowNodeInstance.getParentProcessInstanceId(), starterId, session.getId());
                if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO) && !isFirstState) {
                    String message = LogMessageBuilder.builUserActionPrefix(session, starterId) + "has performed the task" + LogMessageBuilder.buildFlowNodeContextMessage(flowNodeInstance);
                    logger.log(this.getClass(), TechnicalLogSeverity.INFO, message);
                }
            }
        };
        try {
            GetFlowNodeInstance getFlowNodeInstance = new GetFlowNodeInstance(activityInstanceService, flownodeInstanceId);
            this.executeTransactionContent(tenantAccessor, getFlowNodeInstance, wrapInTransaction);
            BonitaLock lock = lockService.lock(getFlowNodeInstance.getResult().getParentProcessInstanceId(), SFlowElementsContainerType.PROCESS.name(), tenantAccessor.getTenantId());
            try {
                this.executeTransactionContent(tenantAccessor, transactionContent, wrapInTransaction);
            }
            finally {
                lockService.unlock(lock, tenantAccessor.getTenantId());
            }
        }
        catch (SBonitaException e) {
            throw new FlowNodeExecutionException((Throwable)e);
        }
    }

    private void executeTransactionContent(TenantServiceAccessor tenantAccessor, TransactionContent transactionContent, boolean wrapInTransaction) throws SBonitaException {
        if (wrapInTransaction) {
            TransactionExecutor transactionExecutor = tenantAccessor.getTransactionExecutor();
            transactionExecutor.execute(transactionContent);
        } else {
            transactionContent.execute();
        }
    }

    public List<ActivityInstance> getActivities(long processInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        try {
            return ModelConvertor.toActivityInstances(activityInstanceService.getActivityInstances(processInstanceId, startIndex, maxResults, null, null), flowNodeStateManager);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long getNumberOfProcessDeploymentInfos() {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetNumberOfProcessDeploymentInfos transactionContentWithResult = new GetNumberOfProcessDeploymentInfos(processDefinitionService);
        try {
            transactionContentWithResult.execute();
            return (Long)transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public ProcessDefinition getProcessDefinition(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            SProcessDefinition sProcessDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
            return ModelConvertor.toProcessDefinition(sProcessDefinition);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SProcessDefinitionReadException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public DesignProcessDefinition getDesignProcessDefinition(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        try {
            File processFolder = this.getProcessFolder(processDefinitionId, tenantAccessor.getTenantId());
            File processDesignFile = new File(processFolder, "process-design.xml");
            ProcessDefinitionBARContribution processDefinitionBARContribution = new ProcessDefinitionBARContribution();
            return processDefinitionBARContribution.deserializeProcessDefinition(processDesignFile);
        }
        catch (BonitaHomeNotSetException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (InvalidBusinessArchiveFormatException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessDefinitionNotFoundException(processDefinitionId, (Throwable)e);
        }
    }

    public ProcessDeploymentInfo getProcessDeploymentInfo(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            GetProcessDefinitionDeployInfo transactionContentWithResult = new GetProcessDefinitionDeployInfo(processDefinitionId, processDefinitionService);
            transactionContentWithResult.execute();
            return ModelConvertor.toProcessDeploymentInfo((SProcessDefinitionDeployInfo)transactionContentWithResult.getResult());
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    private void log(TenantServiceAccessor tenantAccessor, Exception e) {
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) {
            logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
        }
    }

    public ProcessInstance getProcessInstance(long processInstanceId) throws ProcessInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessInstanceDescriptor searchProcessInstanceDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessInstanceDescriptor();
        try {
            GetProcessInstance getProcessInstance = new GetProcessInstance(processInstanceService, processDefinitionService, searchProcessInstanceDescriptor, processInstanceId);
            getProcessInstance.execute();
            return getProcessInstance.getResult();
        }
        catch (SProcessInstanceNotFoundException notFound) {
            throw new ProcessInstanceNotFoundException((Throwable)notFound);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ArchivedProcessInstance> getArchivedProcessInstances(long processInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        GetArchivedProcessInstanceList getProcessInstanceList = new GetArchivedProcessInstanceList(processInstanceService, searchEntitiesDescriptor, processInstanceId, startIndex, maxResults);
        try {
            getProcessInstanceList.execute();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException((Throwable)e);
        }
        return getProcessInstanceList.getResult();
    }

    public ArchivedProcessInstance getArchivedProcessInstance(long id) throws ArchivedProcessInstanceNotFoundException, RetrieveException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            SAProcessInstance archivedProcessInstance = processInstanceService.getArchivedProcessInstance(id);
            return ModelConvertor.toArchivedProcessInstance(archivedProcessInstance);
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new ArchivedProcessInstanceNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public ArchivedProcessInstance getFinalArchivedProcessInstance(long processInstanceId) throws ArchivedProcessInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        GetLastArchivedProcessInstance getProcessInstance = new GetLastArchivedProcessInstance(processInstanceService, processInstanceId, tenantAccessor.getSearchEntitiesDescriptor());
        try {
            getProcessInstance.execute();
        }
        catch (SProcessInstanceNotFoundException e) {
            this.log(tenantAccessor, e);
            throw new ArchivedProcessInstanceNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException((Throwable)e);
        }
        return getProcessInstance.getResult();
    }

    public ProcessInstance startProcess(long processDefinitionId) throws ProcessActivationException, ProcessExecutionException {
        try {
            return this.startProcess(SessionInfos.getUserIdFromSession(), processDefinitionId);
        }
        catch (ProcessDefinitionNotFoundException e) {
            throw new ProcessExecutionException((Throwable)e);
        }
    }

    public ProcessInstance startProcess(long userId, long processDefinitionId) throws ProcessDefinitionNotFoundException, ProcessExecutionException, ProcessActivationException {
        return this.startProcess(userId, processDefinitionId, null, null);
    }

    public int getNumberOfActors(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetNumberOfActors getNumberofActors = new GetNumberOfActors(processDefinitionService, processDefinitionId);
        try {
            getNumberofActors.execute();
        }
        catch (SBonitaException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        return getNumberofActors.getResult();
    }

    public List<ActorInstance> getActors(long processDefinitionId, int startIndex, int maxResults, ActorCriterion sort) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            GetActorsByPagination getActorsByPaging = new GetActorsByPagination(actorMappingService, processDefinitionId, startIndex, maxResults, sort);
            getActorsByPaging.execute();
            return ModelConvertor.toActors((List<SActor>)getActorsByPaging.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ActorMember> getActorMembers(long actorId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            GetActorMembers getActorMembers = new GetActorMembers(actorMappingService, actorId, startIndex, maxResults);
            getActorMembers.execute();
            return ModelConvertor.toActorMembers((List<SActorMember>)getActorMembers.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long getNumberOfActorMembers(long actorId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfActorMembers numberOfActorMembers = new GetNumberOfActorMembers(actorMappingService, actorId);
        try {
            numberOfActorMembers.execute();
            return numberOfActorMembers.getResult();
        }
        catch (SBonitaException sbe) {
            return 0L;
        }
    }

    public long getNumberOfUsersOfActor(long actorId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfUsersOfActor numberOfUsersOfActor = new GetNumberOfUsersOfActor(actorMappingService, actorId);
        numberOfUsersOfActor.execute();
        return numberOfUsersOfActor.getResult();
    }

    public long getNumberOfRolesOfActor(long actorId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfRolesOfActor numberOfRolesOfActor = new GetNumberOfRolesOfActor(actorMappingService, actorId);
        numberOfRolesOfActor.execute();
        return numberOfRolesOfActor.getResult();
    }

    public long getNumberOfGroupsOfActor(long actorId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfGroupsOfActor numberOfGroupsOfActor = new GetNumberOfGroupsOfActor(actorMappingService, actorId);
        numberOfGroupsOfActor.execute();
        return numberOfGroupsOfActor.getResult();
    }

    public long getNumberOfMembershipsOfActor(long actorId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetNumberOfMembershipsOfActor getNumber = new GetNumberOfMembershipsOfActor(actorMappingService, actorId);
        getNumber.execute();
        return getNumber.getResult();
    }

    public ActorInstance updateActor(long actorId, ActorUpdater descriptor) throws ActorNotFoundException, UpdateException {
        if (descriptor == null || descriptor.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        SActorUpdateBuilder actorUpdateBuilder = tenantAccessor.getSActorBuilders().getSActorUpdateBuilder();
        Map fields = descriptor.getFields();
        for (Map.Entry field : fields.entrySet()) {
            switch ((ActorUpdater.ActorField)field.getKey()) {
                case DISPLAY_NAME: {
                    actorUpdateBuilder.updateDisplayName((String)field.getValue());
                    break;
                }
                case DESCRIPTION: {
                    actorUpdateBuilder.updateDescription((String)field.getValue());
                    break;
                }
            }
        }
        EntityUpdateDescriptor updateDescriptor = actorUpdateBuilder.done();
        try {
            SActor updateActor = actorMappingService.updateActor(actorId, updateDescriptor);
            return ModelConvertor.toActorInstance(updateActor);
        }
        catch (SActorNotFoundException e) {
            throw new ActorNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public ActorMember addUserToActor(long actorId, long userId) throws CreationException, AlreadyExistsException {
        ActorMember clientActorMember;
        long processDefinitionId;
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            SActorMember actorMember = actorMappingService.addUserToActor(actorId, userId);
            processDefinitionId = actorMappingService.getActor(actorId).getScopeId();
            clientActorMember = ModelConvertor.toActorMember(actorMember);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
        tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
        return clientActorMember;
    }

    public ActorMember addUserToActor(String actorName, ProcessDefinition processDefinition, long userId) throws CreationException, AlreadyExistsException, ActorNotFoundException {
        List<ActorInstance> actors = this.getActors(processDefinition.getId(), 0, Integer.MAX_VALUE, ActorCriterion.NAME_ASC);
        for (ActorInstance ai : actors) {
            if (!actorName.equals(ai.getName())) continue;
            return this.addUserToActor(ai.getId(), userId);
        }
        throw new ActorNotFoundException("Actor " + actorName + " not found in process definition " + processDefinition.getName());
    }

    public ActorMember addGroupToActor(long actorId, long groupId) throws CreationException, AlreadyExistsException {
        ActorMember clientActorMember;
        long processDefinitionId;
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            this.checkAlreadyExistingGroupMapping(actorId, groupId, actorMappingService);
            SActorMember actorMember = actorMappingService.addGroupToActor(actorId, groupId);
            processDefinitionId = actorMappingService.getActor(actorId).getScopeId();
            clientActorMember = ModelConvertor.toActorMember(actorMember);
        }
        catch (SActorNotFoundException e) {
            throw new CreationException((Throwable)e);
        }
        catch (SActorMemberCreationException e) {
            throw new CreationException((Throwable)e);
        }
        catch (SBonitaReadException e) {
            throw new CreationException((Throwable)e);
        }
        tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
        return clientActorMember;
    }

    public ActorMember addGroupToActor(String actorName, long groupId, ProcessDefinition processDefinition) throws CreationException, AlreadyExistsException, ActorNotFoundException {
        List<ActorInstance> actors = this.getActors(processDefinition.getId(), 0, Integer.MAX_VALUE, ActorCriterion.NAME_ASC);
        for (ActorInstance ai : actors) {
            if (!actorName.equals(ai.getName())) continue;
            return this.addGroupToActor(ai.getId(), groupId);
        }
        throw new ActorNotFoundException("Actor " + actorName + " not found in process definition " + processDefinition.getName());
    }

    private void checkAlreadyExistingGroupMapping(long actorId, long groupId, ActorMappingService actorMappingService) throws AlreadyExistsException, CreationException {
        try {
            List<SActorMember> actorMembersOfGroup;
            int startIndex = 0;
            do {
                actorMembersOfGroup = actorMappingService.getActorMembers(actorId, startIndex, 50);
                for (SActorMember sActorMember : actorMembersOfGroup) {
                    if (sActorMember.getGroupId() != groupId || sActorMember.getRoleId() != -1L || sActorMember.getUserId() != -1L) continue;
                    throw new AlreadyExistsException("This group / actor mapping already exists");
                }
                startIndex += 50;
            } while (actorMembersOfGroup.size() > 0);
        }
        catch (SBonitaReadException e2) {
            throw new CreationException("Read problem when checking for duplicate actor member", (Throwable)e2);
        }
    }

    public ActorMember addRoleToActor(long actorId, long roleId) throws CreationException {
        ActorMember clientActorMember;
        long processDefinitionId;
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            SActorMember actorMember = actorMappingService.addRoleToActor(actorId, roleId);
            processDefinitionId = actorMappingService.getActor(actorId).getScopeId();
            clientActorMember = ModelConvertor.toActorMember(actorMember);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
        tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
        return clientActorMember;
    }

    public ActorMember addRoleToActor(String actorName, ProcessDefinition processDefinition, long roleId) throws ActorNotFoundException, CreationException {
        List<ActorInstance> actors = this.getActors(processDefinition.getId(), 0, Integer.MAX_VALUE, ActorCriterion.NAME_ASC);
        for (ActorInstance ai : actors) {
            if (!actorName.equals(ai.getName())) continue;
            return this.addRoleToActor(ai.getId(), roleId);
        }
        throw new ActorNotFoundException("Actor " + actorName + " not found in process definition " + processDefinition.getName());
    }

    public ActorMember addRoleAndGroupToActor(String actorName, ProcessDefinition processDefinition, long roleId, long groupId) throws ActorNotFoundException, CreationException {
        List<ActorInstance> actors = this.getActors(processDefinition.getId(), 0, Integer.MAX_VALUE, ActorCriterion.NAME_ASC);
        for (ActorInstance ai : actors) {
            if (!actorName.equals(ai.getName())) continue;
            return this.addRoleAndGroupToActor(ai.getId(), roleId, groupId);
        }
        throw new ActorNotFoundException("Actor " + actorName + " not found in process definition " + processDefinition.getName());
    }

    public ActorMember addRoleAndGroupToActor(long actorId, long roleId, long groupId) throws CreationException {
        ActorMember clientActorMember;
        long processDefinitionId;
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            SActorMember actorMember = actorMappingService.addRoleAndGroupToActor(actorId, roleId, groupId);
            processDefinitionId = actorMappingService.getActor(actorId).getScopeId();
            clientActorMember = ModelConvertor.toActorMember(actorMember);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
        tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
        return clientActorMember;
    }

    public void removeActorMember(long actorMemberId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        RemoveActorMember removeActorMember = new RemoveActorMember(actorMappingService, actorMemberId);
        try {
            removeActorMember.execute();
            SActorMember actorMember = removeActorMember.getResult();
            long processDefinitionId = this.getActor(actorMember.getActorId()).getProcessDefinitionId();
            tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
        catch (ActorNotFoundException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public ActorInstance getActor(long actorId) throws ActorNotFoundException {
        try {
            TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
            ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
            GetActor getActor = new GetActor(actorMappingService, actorId);
            getActor.execute();
            return ModelConvertor.toActorInstance(getActor.getResult());
        }
        catch (SBonitaException e) {
            throw new ActorNotFoundException((Throwable)e);
        }
    }

    public ActivityInstance getActivityInstance(long activityInstanceId) throws ActivityInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        GetActivityInstance getActivityInstance = new GetActivityInstance(activityInstanceService, activityInstanceId);
        try {
            getActivityInstance.execute();
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new ActivityInstanceNotFoundException(activityInstanceId);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toActivityInstance(getActivityInstance.getResult(), flowNodeStateManager);
    }

    public FlowNodeInstance getFlowNodeInstance(long flowNodeInstanceId) throws FlowNodeInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        GetFlowNodeInstance getFlowNodeInstance = new GetFlowNodeInstance(activityInstanceService, flowNodeInstanceId);
        try {
            getFlowNodeInstance.execute();
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new FlowNodeInstanceNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toFlowNodeInstance(getFlowNodeInstance.getResult(), flowNodeStateManager);
    }

    public List<HumanTaskInstance> getAssignedHumanTaskInstances(long userId, int startIndex, int maxResults, ActivityInstanceCriterion pagingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SUserTaskInstanceBuilder modelBuilder = tenantAccessor.getBPMInstanceBuilders().getUserTaskInstanceBuilder();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForActivityInstance(pagingCriterion, modelBuilder);
        ActivityInstanceService instanceService = tenantAccessor.getActivityInstanceService();
        try {
            GetAssignedTasks getAssignedTasks = new GetAssignedTasks(instanceService, userId, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder());
            getAssignedTasks.execute();
            Object assignedTasks = getAssignedTasks.getResult();
            return ModelConvertor.toHumanTaskInstances((List<? extends SHumanTaskInstance>)assignedTasks, flowNodeStateManager);
        }
        catch (SUserNotFoundException e) {
            return Collections.emptyList();
        }
        catch (SBonitaException e) {
            return Collections.emptyList();
        }
    }

    public List<HumanTaskInstance> getPendingHumanTaskInstances(long userId, int startIndex, int maxResults, ActivityInstanceCriterion pagingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SUserTaskInstanceBuilder modelBuilder = tenantAccessor.getBPMInstanceBuilders().getUserTaskInstanceBuilder();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForActivityInstance(pagingCriterion, modelBuilder);
        ProcessDefinitionService definitionService = tenantAccessor.getProcessDefinitionService();
        ActivityInstanceService instanceService = tenantAccessor.getActivityInstanceService();
        try {
            Set<Long> actorIds = this.getActorsForUser(userId, actorMappingService, definitionService);
            List<SHumanTaskInstance> pendingTasks = instanceService.getPendingTasks(userId, actorIds, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder());
            return ModelConvertor.toHumanTaskInstances(pendingTasks, flowNodeStateManager);
        }
        catch (SBonitaException e) {
            return Collections.emptyList();
        }
    }

    private Set<Long> getActorsForUser(long userId, ActorMappingService actorMappingService, ProcessDefinitionService definitionService) throws SBonitaReadException, SProcessDefinitionReadException {
        long numberOfProcesses = definitionService.getNumberOfProcessDeploymentInfo(ActivationState.ENABLED);
        List<Long> processDefIds = definitionService.getProcessDefinitionIds(ActivationState.ENABLED, 0, numberOfProcesses);
        HashSet<Long> processDefinitionIds = new HashSet<Long>(processDefIds);
        if (processDefinitionIds.isEmpty()) {
            return Collections.emptySet();
        }
        List<SActor> actors = actorMappingService.getActors(processDefinitionIds, userId);
        if (actors.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> actorIds = new HashSet<Long>();
        for (SActor sActor : actors) {
            actorIds.add(sActor.getId());
        }
        return actorIds;
    }

    public ArchivedActivityInstance getArchivedActivityInstance(long activityInstanceId) throws ActivityInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        GetArchivedActivityInstance getActivityInstance = new GetArchivedActivityInstance(activityInstanceService, activityInstanceId);
        try {
            getActivityInstance.execute();
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new ActivityInstanceNotFoundException(activityInstanceId, (Exception)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toArchivedActivityInstance(getActivityInstance.getResult(), flowNodeStateManager);
    }

    public ArchivedFlowNodeInstance getArchivedFlowNodeInstance(long archivedFlowNodeInstanceId) throws ArchivedFlowNodeInstanceNotFoundException, RetrieveException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        ArchiveService archiveService = tenantAccessor.getArchiveService();
        ReadPersistenceService persistenceService = archiveService.getDefinitiveArchiveReadPersistenceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        try {
            SAFlowNodeInstance archivedFlowNodeInstance = activityInstanceService.getArchivedFlowNodeInstance(archivedFlowNodeInstanceId, persistenceService);
            return ModelConvertor.toArchivedFlowNodeInstance(archivedFlowNodeInstance, flowNodeStateManager);
        }
        catch (SFlowNodeNotFoundException e) {
            throw new ArchivedFlowNodeInstanceNotFoundException(archivedFlowNodeInstanceId);
        }
        catch (SFlowNodeReadException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessInstance> getProcessInstances(int startIndex, int maxResults, ProcessInstanceCriterion criterion) {
        List result;
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SAProcessInstanceBuilder modelBuilder = tenantAccessor.getBPMInstanceBuilders().getSAProcessInstanceBuilder();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForProcessInstance(criterion, modelBuilder);
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(startIndex, maxResults);
        searchOptionsBuilder.sort(orderAndField.getField(), Order.valueOf((String)orderAndField.getOrder().name()));
        try {
            result = this.searchProcessInstances(tenantAccessor, searchOptionsBuilder.done()).getResult();
        }
        catch (SSearchException e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public long getNumberOfProcessInstances() {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        try {
            GetNumberOfProcessInstance transactionContent = new GetNumberOfProcessInstance(processInstanceService, processDefinitionService, searchEntitiesDescriptor);
            transactionContent.execute();
            return (Long)transactionContent.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    protected SearchResult<ProcessInstance> searchProcessInstances(TenantServiceAccessor tenantAccessor, SearchOptions searchOptions) throws SSearchException {
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        try {
            SearchProcessInstances searchProcessInstances = new SearchProcessInstances(processInstanceService, searchEntitiesDescriptor.getProcessInstanceDescriptor(), searchOptions, processDefinitionService);
            searchProcessInstances.execute();
            return searchProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SSearchException(sbe);
        }
    }

    public List<ArchivedProcessInstance> getArchivedProcessInstances(int startIndex, int maxResults, ProcessInstanceCriterion criterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SAProcessInstanceBuilder modelBuilder = tenantAccessor.getBPMInstanceBuilders().getSAProcessInstanceBuilder();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForProcessInstance(criterion, modelBuilder);
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(startIndex, maxResults);
        searchOptionsBuilder.sort(orderAndField.getField(), Order.valueOf((String)orderAndField.getOrder().name()));
        searchOptionsBuilder.filter("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.COMPLETED.getId()));
        searchOptionsBuilder.filter("callerId", (Serializable)Integer.valueOf(-1));
        SearchArchivedProcessInstances searchArchivedProcessInstances = this.searchArchivedProcessInstances(tenantAccessor, searchOptionsBuilder.done());
        try {
            searchArchivedProcessInstances.execute();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return searchArchivedProcessInstances.getResult().getResult();
    }

    private SearchArchivedProcessInstances searchArchivedProcessInstances(TenantServiceAccessor tenantAccessor, SearchOptions searchOptions) throws RetrieveException {
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        return new SearchArchivedProcessInstances(processInstanceService, searchEntitiesDescriptor.getArchivedProcessInstancesDescriptor(), searchOptions);
    }

    public long getNumberOfArchivedProcessInstances() {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SAProcessInstanceBuilder saProcessInstanceBuilder = tenantAccessor.getBPMInstanceBuilders().getSAProcessInstanceBuilder();
        try {
            GetNumberOfArchivedProcessInstance transactionContent = new GetNumberOfArchivedProcessInstance(processInstanceService, searchEntitiesDescriptor, saProcessInstanceBuilder);
            transactionContent.execute();
            return (Long)transactionContent.getResult();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<ArchivedProcessInstance> searchArchivedProcessInstances(SearchOptions searchOptions) throws RetrieveException, SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedProcessInstancesWithoutSubProcess searchArchivedProcessInstances = new SearchArchivedProcessInstancesWithoutSubProcess(processInstanceService, searchEntitiesDescriptor.getArchivedProcessInstancesDescriptor(), searchOptions);
        try {
            searchArchivedProcessInstances.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchArchivedProcessInstances.getResult();
    }

    public List<ActivityInstance> getOpenActivityInstances(long processInstanceId, int startIndex, int maxResults, ActivityInstanceCriterion criterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SUserTaskInstanceBuilder modelBuilder = tenantAccessor.getBPMInstanceBuilders().getSUserTaskInstanceBuilder();
        try {
            int totalNumber = activityInstanceService.getNumberOfOpenActivityInstances(processInstanceId);
            if (totalNumber == 0) {
                return Collections.emptyList();
            }
            OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForActivityInstance(criterion, modelBuilder);
            return ModelConvertor.toActivityInstances(activityInstanceService.getOpenActivityInstances(processInstanceId, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder()), flowNodeStateManager);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ArchivedActivityInstance> getArchivedActivityInstances(long processInstanceId, int startIndex, int maxResults, ActivityInstanceCriterion criterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        List<ArchivedActivityInstance> archivedActivityInstances = this.getArchivedActivityInstances(processInstanceId, startIndex, maxResults, criterion, tenantAccessor);
        return archivedActivityInstances;
    }

    private List<ArchivedActivityInstance> getArchivedActivityInstances(long processInstanceId, int pageIndex, int numberPerPage, ActivityInstanceCriterion pagingCriterion, TenantServiceAccessor tenantAccessor) throws RetrieveException {
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SUserTaskInstanceBuilder modelBuilder = ProcessAPIImpl.getTenantAccessor().getBPMInstanceBuilders().getSUserTaskInstanceBuilder();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForActivityInstance(pagingCriterion, modelBuilder);
        GetArchivedActivityInstances getActivityInstances = new GetArchivedActivityInstances(activityInstanceService, processInstanceId, pageIndex, numberPerPage, orderAndField.getField(), orderAndField.getOrder());
        try {
            getActivityInstances.execute();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toArchivedActivityInstances((List<SAActivityInstance>)getActivityInstances.getResult(), flowNodeStateManager);
    }

    public int getNumberOfOpenedActivityInstances(long processInstanceId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        GetNumberOfActivityInstance transactionContentWithResult = new GetNumberOfActivityInstance(processInstanceId, activityInstanceService);
        try {
            transactionContentWithResult.execute();
            return (Integer)transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Category createCategory(String name, String description) throws AlreadyExistsException, CreationException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            CreateCategory createCategory = new CreateCategory(name, description, categoryService);
            createCategory.execute();
            return ModelConvertor.toCategory(createCategory.getResult());
        }
        catch (SCategoryAlreadyExistsException scaee) {
            throw new AlreadyExistsException((Throwable)scaee);
        }
        catch (SBonitaException e) {
            throw new CreationException("Category create exception!", (Throwable)e);
        }
    }

    public Category getCategory(long categoryId) throws CategoryNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            GetCategory getCategory = new GetCategory(categoryService, categoryId);
            getCategory.execute();
            SCategory sCategory = getCategory.getResult();
            return ModelConvertor.toCategory(sCategory);
        }
        catch (SBonitaException sbe) {
            throw new CategoryNotFoundException((Throwable)sbe);
        }
    }

    public long getNumberOfCategories() {
        CategoryService categoryService = ProcessAPIImpl.getTenantAccessor().getCategoryService();
        try {
            GetNumberOfCategories getNumberOfCategories = new GetNumberOfCategories(categoryService);
            getNumberOfCategories.execute();
            return getNumberOfCategories.getResult();
        }
        catch (SBonitaException e) {
            return 0L;
        }
    }

    public List<Category> getCategories(int startIndex, int maxResults, CategoryCriterion sortCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SCategoryBuilderAccessor modelBuilderAccessor = tenantAccessor.getCategoryModelBuilderAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        String field = null;
        OrderByType order = null;
        switch (sortCriterion) {
            case NAME_ASC: {
                field = modelBuilderAccessor.getCategoryBuilder().getNameKey();
                order = OrderByType.ASC;
                break;
            }
            case NAME_DESC: {
                field = modelBuilderAccessor.getCategoryBuilder().getNameKey();
                order = OrderByType.DESC;
            }
        }
        try {
            GetCategories getCategories = new GetCategories(startIndex, maxResults, field, categoryService, order);
            getCategories.execute();
            return ModelConvertor.toCategories((List<SCategory>)getCategories.getResult());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void addCategoriesToProcess(long processDefinitionId, List<Long> categoryIds) throws AlreadyExistsException, CreationException {
        try {
            CategoryService categoryService = ProcessAPIImpl.getTenantAccessor().getCategoryService();
            ProcessDefinitionService processDefinitionService = ProcessAPIImpl.getTenantAccessor().getProcessDefinitionService();
            for (Long categoryId : categoryIds) {
                new AddProcessDefinitionToCategory(categoryId, processDefinitionId, categoryService, processDefinitionService).execute();
            }
        }
        catch (SCategoryInProcessAlreadyExistsException scipaee) {
            throw new AlreadyExistsException((Throwable)scipaee);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public void removeCategoriesFromProcess(long processDefinitionId, List<Long> categoryIds) throws DeletionException {
        try {
            CategoryService categoryService = ProcessAPIImpl.getTenantAccessor().getCategoryService();
            RemoveCategoriesFromProcessDefinition transactionContent = new RemoveCategoriesFromProcessDefinition(processDefinitionId, categoryIds, categoryService);
            transactionContent.execute();
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public void addProcessDefinitionToCategory(long categoryId, long processDefinitionId) throws AlreadyExistsException, CreationException {
        try {
            CategoryService categoryService = ProcessAPIImpl.getTenantAccessor().getCategoryService();
            ProcessDefinitionService processDefinitionService = ProcessAPIImpl.getTenantAccessor().getProcessDefinitionService();
            AddProcessDefinitionToCategory transactionContent = new AddProcessDefinitionToCategory(categoryId, processDefinitionId, categoryService, processDefinitionService);
            transactionContent.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new CreationException((Throwable)e);
        }
        catch (SCategoryNotFoundException scnfe) {
            throw new CreationException((Throwable)scnfe);
        }
        catch (SCategoryInProcessAlreadyExistsException cipaee) {
            throw new AlreadyExistsException((Throwable)cipaee);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public void addProcessDefinitionsToCategory(long categoryId, List<Long> processDefinitionIds) throws AlreadyExistsException, CreationException {
        try {
            CategoryService categoryService = ProcessAPIImpl.getTenantAccessor().getCategoryService();
            ProcessDefinitionService processDefinitionService = ProcessAPIImpl.getTenantAccessor().getProcessDefinitionService();
            for (Long processDefinitionId : processDefinitionIds) {
                new AddProcessDefinitionToCategory(categoryId, processDefinitionId, categoryService, processDefinitionService).execute();
            }
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new CreationException((Throwable)e);
        }
        catch (SCategoryNotFoundException scnfe) {
            throw new CreationException((Throwable)scnfe);
        }
        catch (SCategoryInProcessAlreadyExistsException cipaee) {
            throw new AlreadyExistsException((Throwable)cipaee);
        }
        catch (SBonitaException sbe) {
            throw new CreationException((Throwable)sbe);
        }
    }

    public long getNumberOfCategories(long processDefinitionId) {
        try {
            TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
            CategoryService categoryService = tenantAccessor.getCategoryService();
            GetNumberOfCategoriesOfProcess getNumberOfCategoriesOfProcess = new GetNumberOfCategoriesOfProcess(categoryService, processDefinitionId);
            getNumberOfCategoriesOfProcess.execute();
            return getNumberOfCategoriesOfProcess.getResult();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public long getNumberOfProcessDefinitionsOfCategory(long categoryId) {
        try {
            CategoryService categoryService = ProcessAPIImpl.getTenantAccessor().getCategoryService();
            List<Long> ids = categoryService.getProcessDefinitionIdsOfCategory(categoryId);
            if (ids != null) {
                return ids.size();
            }
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return 0L;
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosOfCategory(long categoryId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        OrderByType order = this.getOrderByType(sortCriterion);
        try {
            List<SProcessDefinitionDeployInfo> processDefinitionDeployInfoList;
            List<Long> processDefinitionIds = categoryService.getProcessDefinitionIdsOfCategory(categoryId);
            if (processDefinitionIds != null && processDefinitionIds.size() > 0 && (processDefinitionDeployInfoList = processDefinitionService.getProcessDeploymentInfos(processDefinitionIds)) != null) {
                Collections.sort(processDefinitionDeployInfoList, new ProcessDefinitionDeployInfoComparator());
                if (order != null && order == OrderByType.DESC) {
                    Collections.reverse(processDefinitionDeployInfoList);
                }
                if (startIndex >= processDefinitionDeployInfoList.size()) {
                    return Collections.emptyList();
                }
                int toIndex = Math.min(processDefinitionDeployInfoList.size(), startIndex + maxResults);
                return ModelConvertor.toProcessDeploymentInfo(new ArrayList<SProcessDefinitionDeployInfo>(processDefinitionDeployInfoList.subList(startIndex, toIndex)));
            }
            return Collections.emptyList();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    private OrderByType getOrderByType(ProcessDeploymentInfoCriterion sortCriterion) {
        if (sortCriterion != null) {
            switch (sortCriterion) {
                case NAME_ASC: {
                    return OrderByType.ASC;
                }
                case NAME_DESC: {
                    return OrderByType.DESC;
                }
                case DEFAULT: {
                    return OrderByType.ASC;
                }
            }
            return null;
        }
        return null;
    }

    private OrderByType mapPagingCriterionToOrderByType(CategoryCriterion pagingCriterion) {
        OrderByType order = null;
        switch (pagingCriterion) {
            case NAME_ASC: {
                order = OrderByType.ASC;
                break;
            }
            case NAME_DESC: {
                order = OrderByType.DESC;
            }
        }
        return order;
    }

    public List<Category> getCategoriesOfProcessDefinition(long processDefinitionId, int startIndex, int maxResults, CategoryCriterion pagingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            OrderByType order = this.mapPagingCriterionToOrderByType(pagingCriterion);
            return ModelConvertor.toCategories(categoryService.getCategoriesOfProcessDefinition(processDefinitionId, startIndex, maxResults, order));
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<Category> getCategoriesUnrelatedToProcessDefinition(long processDefinitionId, int startIndex, int maxResults, CategoryCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            OrderByType order = this.mapPagingCriterionToOrderByType(sortingCriterion);
            return ModelConvertor.toCategories(categoryService.getCategoriesUnrelatedToProcessDefinition(processDefinitionId, startIndex, maxResults, order));
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public void updateCategory(long categoryId, CategoryUpdater updater) throws CategoryNotFoundException, UpdateException {
        if (updater == null || updater.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            SCategoryUpdateBuilder categoryUpdateBuilder = tenantAccessor.getCategoryModelBuilderAccessor().getCategoryUpdateBuilder();
            EntityUpdateDescriptor updateDescriptor = this.getCategoryUpdateDescriptor(categoryUpdateBuilder, updater);
            UpdateCategory updateCategory = new UpdateCategory(categoryService, categoryId, updateDescriptor);
            updateCategory.execute();
        }
        catch (SCategoryNotFoundException scnfe) {
            throw new CategoryNotFoundException((Throwable)scnfe);
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    private EntityUpdateDescriptor getCategoryUpdateDescriptor(SCategoryUpdateBuilder descriptorBuilder, CategoryUpdater updater) {
        String description;
        Map fields = updater.getFields();
        String name = (String)fields.get(CategoryUpdater.CategoryField.NAME);
        if (name != null) {
            descriptorBuilder.updateName(name);
        }
        if ((description = (String)fields.get(CategoryUpdater.CategoryField.DESCRIPTION)) != null) {
            descriptorBuilder.updateDescription(description);
        }
        return descriptorBuilder.done();
    }

    public void deleteCategory(long categoryId) throws DeletionException {
        if (categoryId <= 0L) {
            throw new DeletionException("Category id can not be less than 0!");
        }
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        DeleteSCategory deleteSCategory = new DeleteSCategory(categoryService, categoryId);
        try {
            deleteSCategory.execute();
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public long getNumberOfUncategorizedProcessDefinitions() {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            long numberOfProcessDefinitions = processDefinitionService.getNumberOfProcessDeploymentInfos();
            List<Long> processDefinitionIds = processDefinitionService.getProcessDefinitionIds(0, numberOfProcessDefinitions);
            long number = processDefinitionIds.isEmpty() ? 0L : (long)processDefinitionIds.size() - categoryService.getNumberOfCategorizedProcessIds(processDefinitionIds);
            return number;
        }
        catch (SBonitaException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getUncategorizedProcessDeploymentInfos(int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        try {
            OrderByType order;
            long numberOfProcessDefinitions = processDefinitionService.getNumberOfProcessDeploymentInfos();
            List<Long> processDefinitionIds = processDefinitionService.getProcessDefinitionIds(0, numberOfProcessDefinitions);
            processDefinitionIds.removeAll(categoryService.getCategorizedProcessIds(processDefinitionIds));
            switch (sortCriterion) {
                case NAME_ASC: {
                    order = OrderByType.ASC;
                    break;
                }
                case NAME_DESC: {
                    order = OrderByType.DESC;
                    break;
                }
                case DEFAULT: {
                    order = OrderByType.ASC;
                    break;
                }
                default: {
                    order = null;
                }
            }
            List<SProcessDefinitionDeployInfo> processDefinitionDeployInfos = processDefinitionService.getProcessDeploymentInfos(processDefinitionIds, startIndex, maxResults, "name", order);
            return ModelConvertor.toProcessDeploymentInfo(processDefinitionDeployInfos);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public long getNumberOfProcessDeploymentInfosUnrelatedToCategory(long categoryId) {
        try {
            TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
            ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
            GetNumberOfProcessDeploymentInfosUnrelatedToCategory transactionContentWithResult = new GetNumberOfProcessDeploymentInfosUnrelatedToCategory(categoryId, processDefinitionService);
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosUnrelatedToCategory(long categoryId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            return ModelConvertor.toProcessDeploymentInfo(processDefinitionService.getProcessDeploymentInfosUnrelatedToCategory(categoryId, startIndex, maxResults, sortingCriterion));
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    @Deprecated
    public void removeAllCategoriesFromProcessDefinition(long processDefinitionId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        SProcessCategoryMappingBuilder sProcessCategoryMappingBuilder = tenantAccessor.getCategoryModelBuilderAccessor().getSProcessCategoryMappingBuilder();
        RemoveProcessDefinitionsOfCategory transactionContent = new RemoveProcessDefinitionsOfCategory(processDefinitionId, sProcessCategoryMappingBuilder, categoryService);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    @Deprecated
    public void removeAllProcessDefinitionsFromCategory(long categoryId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        SProcessCategoryMappingBuilder sProcessCategoryMappingBuilder = tenantAccessor.getCategoryModelBuilderAccessor().getSProcessCategoryMappingBuilder();
        RemoveProcessDefinitionsOfCategory remove = new RemoveProcessDefinitionsOfCategory(categoryService, sProcessCategoryMappingBuilder, categoryId);
        try {
            remove.execute();
        }
        catch (SBonitaException sbe) {
            throw new DeletionException((Throwable)sbe);
        }
    }

    public long removeCategoriesFromProcessDefinition(long processDefinitionId, int startIndex, int maxResults) throws DeletionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        SProcessCategoryMappingBuilder sProcessCategoryMappingBuilder = tenantAccessor.getCategoryModelBuilderAccessor().getSProcessCategoryMappingBuilder();
        try {
            FilterOption filterOption = new FilterOption(SProcessCategoryMapping.class, sProcessCategoryMappingBuilder.getProcessIdKey(), processDefinitionId);
            OrderByOption order = new OrderByOption(SProcessCategoryMapping.class, sProcessCategoryMappingBuilder.getIdKey(), OrderByType.ASC);
            QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, Collections.singletonList(order), Collections.singletonList(filterOption), null);
            List<SProcessCategoryMapping> processCategoryMappings = categoryService.searchProcessCategoryMappings(queryOptions);
            return categoryService.deleteProcessCategoryMappings(processCategoryMappings);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public long removeProcessDefinitionsFromCategory(long categoryId, int startIndex, int maxResults) throws DeletionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        CategoryService categoryService = tenantAccessor.getCategoryService();
        SProcessCategoryMappingBuilder sProcessCategoryMappingBuilder = tenantAccessor.getCategoryModelBuilderAccessor().getSProcessCategoryMappingBuilder();
        try {
            FilterOption filterOption = new FilterOption(SProcessCategoryMapping.class, sProcessCategoryMappingBuilder.getCategoryIdKey(), categoryId);
            OrderByOption order = new OrderByOption(SProcessCategoryMapping.class, sProcessCategoryMappingBuilder.getIdKey(), OrderByType.ASC);
            QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, Collections.singletonList(order), Collections.singletonList(filterOption), null);
            List<SProcessCategoryMapping> processCategoryMappings = categoryService.searchProcessCategoryMappings(queryOptions);
            return categoryService.deleteProcessCategoryMappings(processCategoryMappings);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public List<EventInstance> getEventInstances(long rootContainerId, int startIndex, int maxResults, EventCriterion criterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        EventInstanceService eventInstanceService = tenantAccessor.getEventInstanceService();
        SEndEventInstanceBuilder eventInstanceBuilder = tenantAccessor.getBPMInstanceBuilders().getSEndEventInstanceBuilder();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForEvent(criterion, eventInstanceBuilder);
        GetEventInstances getEventInstances = new GetEventInstances(eventInstanceService, rootContainerId, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder());
        try {
            getEventInstances.execute();
            Object result = getEventInstances.getResult();
            return ModelConvertor.toEventInstances((Collection<SEventInstance>)result, flowNodeStateManager);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void assignUserTask(long userTaskId, long userId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        SCommentService scommentService = tenantAccessor.getCommentService();
        IdentityService identityService = tenantAccessor.getIdentityService();
        try {
            AssignOrUnassignUserTask assignUserTask = new AssignOrUnassignUserTask(userId, userTaskId, activityInstanceService, scommentService, identityService);
            assignUserTask.execute();
        }
        catch (SUserNotFoundException sunfe) {
            throw new UpdateException((Throwable)sunfe);
        }
        catch (SActivityInstanceNotFoundException sainfe) {
            throw new UpdateException((Throwable)sainfe);
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    public void updateActorsOfUserTask(long userTaskId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        try {
            TechnicalLoggerService technicalLoggerService;
            SUserFilterDefinition sUserFilterDefinition;
            SFlowNodeInstance flowNodeInstance = tenantAccessor.getActivityInstanceService().getFlowNodeInstance(userTaskId);
            if (!(flowNodeInstance instanceof SHumanTaskInstance)) {
                throw new UpdateException("The identifier does not refer to a human task");
            }
            SHumanTaskInstance humanTaskInstance = (SHumanTaskInstance)flowNodeInstance;
            long processDefinitionId = humanTaskInstance.getLogicalGroup(0);
            SProcessDefinition processDefinition = tenantAccessor.getProcessDefinitionService().getProcessDefinition(processDefinitionId);
            SHumanTaskDefinition humanTaskDefinition = (SHumanTaskDefinition)processDefinition.getProcessContainer().getFlowNode(humanTaskInstance.getFlowNodeDefinitionId());
            if (humanTaskDefinition != null && (sUserFilterDefinition = humanTaskDefinition.getSUserFilterDefinition()) != null) {
                ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
                if (humanTaskInstance.getAssigneeId() > 0L) {
                    activityInstanceService.assignHumanTask(userTaskId, 0L);
                }
                String actorName = humanTaskDefinition.getActorName();
                ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
                UserFilterService userFilterService = tenantAccessor.getUserFilterService();
                BPMInstanceBuilders instanceBuilders = tenantAccessor.getBPMInstanceBuilders();
                ClassLoader processClassloader = classLoaderService.getLocalClassLoader("process", processDefinitionId);
                SExpressionContext expressionContext = new SExpressionContext((Long)humanTaskInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), humanTaskInstance.getLogicalGroup(0));
                FilterResult result = userFilterService.executeFilter(processDefinitionId, sUserFilterDefinition, sUserFilterDefinition.getInputs(), processClassloader, expressionContext, actorName);
                List<Long> userIds = result.getResult();
                if (userIds == null || userIds.isEmpty() || userIds.contains(0L) || userIds.contains(-1L)) {
                    throw new UpdateException("no user id returned by the user filter " + sUserFilterDefinition + " on activity " + humanTaskDefinition.getName());
                }
                for (Long userId : userIds) {
                    SPendingActivityMapping mapping = instanceBuilders.getSPendingActivityMappingBuilder().createNewInstanceForUser(humanTaskInstance.getId(), userId).done();
                    activityInstanceService.addPendingActivityMappings(mapping);
                }
                if (userIds.size() == 1 && result.shouldAutoAssignTaskIfSingleResult()) {
                    activityInstanceService.assignHumanTask(humanTaskInstance.getId(), userIds.get(0));
                }
            }
            if ((technicalLoggerService = tenantAccessor.getTechnicalLoggerService()).isLoggable(ProcessAPIImpl.class, TechnicalLogSeverity.INFO)) {
                StringBuilder builder = new StringBuilder("User '");
                builder.append(SessionInfos.getUserNameFromSession()).append("' has re-executed assignation on activity ").append(humanTaskInstance.getId());
                builder.append(" of process instance ").append(humanTaskInstance.getLogicalGroup(1)).append(" of process named '").append(processDefinition.getName()).append("' in version ").append(processDefinition.getVersion());
                technicalLoggerService.log(ProcessAPIImpl.class, TechnicalLogSeverity.INFO, builder.toString());
            }
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    public List<DataDefinition> getActivityDataDefinitions(long processDefinitionId, String activityName, int startIndex, int maxResults) throws ActivityDefinitionNotFoundException, ProcessDefinitionNotFoundException {
        List<DataDefinition> subDataDefinitionList = Collections.emptyList();
        List<SDataDefinition> sdataDefinitionList = Collections.emptyList();
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            getProcessDefinition.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        SProcessDefinition sProcessDefinition = getProcessDefinition.getResult();
        if (sProcessDefinition != null) {
            boolean activityFound = false;
            SFlowElementContainerDefinition processContainer = sProcessDefinition.getProcessContainer();
            Set<SActivityDefinition> activityDefList = processContainer.getActivities();
            for (SActivityDefinition sActivityDefinition : activityDefList) {
                if (!activityName.equals(sActivityDefinition.getName())) continue;
                sdataDefinitionList = sActivityDefinition.getSDataDefinitions();
                activityFound = true;
                break;
            }
            if (!activityFound) {
                throw new ActivityDefinitionNotFoundException(activityName);
            }
            List<DataDefinition> dataDefinitionList = ModelConvertor.toDataDefinitions(sdataDefinitionList);
            if (startIndex >= dataDefinitionList.size()) {
                return Collections.emptyList();
            }
            int toIndex = Math.min(dataDefinitionList.size(), startIndex + maxResults);
            subDataDefinitionList = new ArrayList<DataDefinition>(dataDefinitionList.subList(startIndex, toIndex));
        }
        return subDataDefinitionList;
    }

    public List<DataDefinition> getProcessDataDefinitions(long processDefinitionId, int startIndex, int maxResults) throws ProcessDefinitionNotFoundException {
        List<DataDefinition> subDataDefinitionList = Collections.emptyList();
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            getProcessDefinition.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        SProcessDefinition sProcessDefinition = getProcessDefinition.getResult();
        if (sProcessDefinition != null) {
            SFlowElementContainerDefinition processContainer = sProcessDefinition.getProcessContainer();
            List<SDataDefinition> sdataDefinitionList = processContainer.getDataDefinitions();
            List<DataDefinition> dataDefinitionList = ModelConvertor.toDataDefinitions(sdataDefinitionList);
            if (startIndex >= dataDefinitionList.size()) {
                return Collections.emptyList();
            }
            int toIndex = Math.min(dataDefinitionList.size(), startIndex + maxResults);
            subDataDefinitionList = new ArrayList<DataDefinition>(dataDefinitionList.subList(startIndex, toIndex));
        }
        return subDataDefinitionList;
    }

    public HumanTaskInstance getHumanTaskInstance(long activityInstanceId) throws ActivityInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        GetHumanTaskInstance getHumanTaskInstance = new GetHumanTaskInstance(activityInstanceService, activityInstanceId);
        try {
            getHumanTaskInstance.execute();
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new ActivityInstanceNotFoundException(activityInstanceId, (Exception)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return ModelConvertor.toHumanTaskInstance(getHumanTaskInstance.getResult(), flowNodeStateManager);
    }

    public long getNumberOfAssignedHumanTaskInstances(long userId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            GetNumberOfAssignedUserTaskInstances transactionContent = new GetNumberOfAssignedUserTaskInstances(userId, activityInstanceService);
            transactionContent.execute();
            return (Long)transactionContent.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Map<Long, Long> getNumberOfOpenTasks(List<Long> userIds) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            GetNumberOfOpenTasksForUsers transactionContent = new GetNumberOfOpenTasksForUsers(userIds, activityInstanceService);
            transactionContent.execute();
            return transactionContent.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long getNumberOfPendingHumanTaskInstances(long userId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        ProcessDefinitionService processDefService = tenantAccessor.getProcessDefinitionService();
        try {
            Set<Long> actorIds = this.getActorsForUser(userId, actorMappingService, processDefService);
            if (actorIds.isEmpty()) {
                return 0L;
            }
            return activityInstanceService.getNumberOfPendingTasksForUser(userId, QueryOptions.defaultQueryOptions());
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Map<String, byte[]> getProcessResources(long processDefinitionId, String filenamesPattern) throws RetrieveException {
        String processesFolder;
        try {
            TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
            processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantAccessor.getTenantId());
        }
        catch (BonitaHomeNotSetException e) {
            throw new RetrieveException("Problem accessing basic Bonita Home server resources", (Throwable)e);
        }
        processesFolder = processesFolder.replaceAll("\\\\", "/");
        if (!processesFolder.endsWith("/")) {
            processesFolder = processesFolder + "/";
        }
        processesFolder = processesFolder + processDefinitionId + "/";
        Collection files = FileUtils.listFiles((File)new File(processesFolder), (IOFileFilter)new DeepRegexFileFilter(processesFolder + filenamesPattern), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        HashMap<String, byte[]> res = new HashMap<String, byte[]>(files.size());
        try {
            for (File f : files) {
                res.put(f.getAbsolutePath().replaceAll("\\\\", "/").replaceFirst(processesFolder, ""), IOUtil.getAllContentFrom((File)f));
            }
        }
        catch (IOException e) {
            throw new RetrieveException("Problem accessing resources " + filenamesPattern + " for processDefinitionId: " + processDefinitionId, (Throwable)e);
        }
        return res;
    }

    public long getLatestProcessDefinitionId(String processName) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetLatestProcessDefinitionId transactionContent = new GetLatestProcessDefinitionId(processDefinitionService, processName);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        return (Long)transactionContent.getResult();
    }

    public List<DataInstance> getProcessDataInstances(long processInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long processDefinitionId = processInstanceService.getProcessInstance(processInstanceId).getProcessDefinitionId();
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader("process", processDefinitionId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            List<SDataInstance> dataInstances = dataInstanceService.getDataInstances(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.name(), startIndex, maxResults);
            List<DataInstance> list = ModelConvertor.toDataInstances(dataInstances);
            return list;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public DataInstance getProcessDataInstance(String dataName, long processInstanceId) throws DataNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long processDefinitionId = processInstanceService.getProcessInstance(processInstanceId).getProcessDefinitionId();
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader("process", processDefinitionId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            SDataInstance sDataInstance = dataInstanceService.getDataInstance(dataName, processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString());
            DataInstance dataInstance = ModelConvertor.toDataInstance(sDataInstance);
            return dataInstance;
        }
        catch (SBonitaException e) {
            throw new DataNotFoundException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void updateProcessDataInstance(String dataName, long processInstanceId, Serializable dataValue) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long processDefinitionId = processInstanceService.getProcessInstance(processInstanceId).getProcessDefinitionId();
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader("process", processDefinitionId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            SDataInstance sDataInstance = dataInstanceService.getDataInstance(dataName, processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString());
            EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
            entityUpdateDescriptor.addField("value", dataValue);
            dataInstanceService.updateDataInstance(sDataInstance, entityUpdateDescriptor);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public List<DataInstance> getActivityDataInstances(long activityInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = tenantAccessor.getBPMInstanceBuilders().getSAutomaticTaskInstanceBuilder().getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long parentProcessInstanceId = activityInstanceService.getFlowNodeInstance(activityInstanceId).getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader("process", parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            List<SDataInstance> dataInstances = dataInstanceService.getDataInstances(activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), startIndex, maxResults);
            List<DataInstance> list = ModelConvertor.toDataInstances(dataInstances);
            return list;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public DataInstance getActivityDataInstance(String dataName, long activityInstanceId) throws DataNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = tenantAccessor.getBPMInstanceBuilders().getSAutomaticTaskInstanceBuilder().getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long parentProcessInstanceId = activityInstanceService.getFlowNodeInstance(activityInstanceId).getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader("process", parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            SDataInstance sDataInstance = dataInstanceService.getDataInstance(dataName, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
            DataInstance dataInstance = ModelConvertor.toDataInstance(sDataInstance);
            return dataInstance;
        }
        catch (SBonitaException e) {
            throw new DataNotFoundException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void updateActivityDataInstance(String dataName, long activityInstanceId, Serializable dataValue) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = tenantAccessor.getBPMInstanceBuilders().getSAutomaticTaskInstanceBuilder().getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long parentProcessInstanceId = activityInstanceService.getFlowNodeInstance(activityInstanceId).getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader("process", parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            SDataInstance sDataInstance = dataInstanceService.getDataInstance(dataName, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
            EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
            entityUpdateDescriptor.addField("value", dataValue);
            dataInstanceService.updateDataInstance(sDataInstance, entityUpdateDescriptor);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void importActorMapping(long processDefinitionId, String xmlContent) throws ActorMappingImportException {
        if (xmlContent != null) {
            TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
            ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
            IdentityService identityService = tenantAccessor.getIdentityService();
            Parser parser = tenantAccessor.getActorMappingParser();
            try {
                new ImportActorMapping(actorMappingService, identityService, parser, processDefinitionId, xmlContent).execute();
                tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor);
            }
            catch (SBonitaException sbe) {
                throw new ActorMappingImportException((Throwable)sbe);
            }
        }
    }

    public String exportActorMapping(long processDefinitionId) throws ActorMappingExportException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        IdentityService identityService = tenantAccessor.getIdentityService();
        XMLWriter writer = tenantAccessor.getXMLWriter();
        try {
            ExportActorMapping exportActorMapping = new ExportActorMapping(actorMappingService, identityService, writer, processDefinitionId);
            exportActorMapping.execute();
            return exportActorMapping.getResult();
        }
        catch (SBonitaException sbe) {
            throw new ActorMappingExportException((Throwable)sbe);
        }
    }

    public boolean isInvolvedInProcessInstance(long userId, long processInstanceId) throws ProcessInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        try {
            int totalNumber = activityInstanceService.getNumberOfActivityInstances(processInstanceId);
            List<SActivityInstance> activityInstances = activityInstanceService.getActivityInstances(processInstanceId, 0, totalNumber, null, null);
            for (SActivityInstance activityInstance : activityInstances) {
                if (!(activityInstance instanceof SUserTaskInstance)) continue;
                SUserTaskInstance userTaskInstance = (SUserTaskInstance)activityInstance;
                if (userId == userTaskInstance.getAssigneeId()) {
                    return true;
                }
                long actorId = userTaskInstance.getActorId();
                int numOfActorMembers = (int)actorMappingService.getNumberOfActorMembers(actorId);
                int numberPerPage = 100;
                for (int i = 0; i < numOfActorMembers % 100; ++i) {
                    GetActorMembers getActorMembers = new GetActorMembers(actorMappingService, actorId, i, 100);
                    getActorMembers.execute();
                    Iterator i$ = getActorMembers.getResult().iterator();
                    while (i$.hasNext()) {
                        SActorMember actorMember = (SActorMember)i$.next();
                        if (actorMember.getUserId() == userId) {
                            return true;
                        }
                        SUser user = identityService.getUser(actorMember.getUserId());
                        if (userId != user.getManagerUserId()) continue;
                        return true;
                    }
                }
            }
            if (activityInstances.isEmpty()) {
                try {
                    tenantAccessor.getProcessInstanceService().getProcessInstance(processInstanceId);
                }
                catch (SProcessInstanceNotFoundException e) {
                    throw new ProcessInstanceNotFoundException(processInstanceId);
                }
            }
            return false;
        }
        catch (SBonitaException e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public long getProcessInstanceIdFromActivityInstanceId(long activityInstanceId) throws ProcessInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        GetActivityInstance getActivityInstance = new GetActivityInstance(activityInstanceService, activityInstanceId);
        try {
            getActivityInstance.execute();
            SActivityInstance activity = getActivityInstance.getResult();
            return activity.getRootContainerId();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new ProcessInstanceNotFoundException(e.getMessage());
        }
    }

    public long getProcessDefinitionIdFromActivityInstanceId(long activityInstanceId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            SActivityInstance activity = activityInstanceService.getActivityInstance(activityInstanceId);
            return processInstanceService.getProcessInstance(activity.getParentProcessInstanceId()).getProcessDefinitionId();
        }
        catch (SBonitaException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
    }

    public long getProcessDefinitionIdFromProcessInstanceId(long processInstanceId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessInstanceDescriptor searchProcessInstanceDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessInstanceDescriptor();
        try {
            GetProcessInstance getProcessInstance = new GetProcessInstance(processInstanceService, processDefinitionService, searchProcessInstanceDescriptor, processInstanceId);
            getProcessInstance.execute();
            ProcessInstance processInstance = getProcessInstance.getResult();
            return processInstance.getProcessDefinitionId();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new ProcessDefinitionNotFoundException(e.getMessage());
        }
    }

    public Date getActivityReachedStateDate(long activityInstanceId, String stateName) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int stateId = ModelConvertor.getServerActivityStateId(stateName);
        GetArchivedActivityInstance getArchivedActivityInstance = new GetArchivedActivityInstance(activityInstanceId, stateId, activityInstanceService);
        try {
            getArchivedActivityInstance.execute();
            long reachedDate = getArchivedActivityInstance.getResult().getReachedStateDate();
            return new Date(reachedDate);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Set<String> getSupportedStates(FlowNodeType nodeType) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        return flowNodeStateManager.getSupportedState(nodeType);
    }

    public void updateActivityInstanceVariables(long activityInstanceId, Map<String, Serializable> variables) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = tenantAccessor.getBPMInstanceBuilders().getSAutomaticTaskInstanceBuilder().getProcessDefinitionIndex();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long parentProcessInstanceId = activityInstanceService.getFlowNodeInstance(activityInstanceId).getLogicalGroup(processDefinitionIndex);
            ClassLoader processClassLoader = classLoaderService.getLocalClassLoader("process", parentProcessInstanceId);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            for (Map.Entry<String, Serializable> variable : variables.entrySet()) {
                SDataInstance sDataInstance = dataInstanceService.getDataInstance(variable.getKey(), activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
                EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
                entityUpdateDescriptor.addField("value", variable.getValue());
                dataInstanceService.updateDataInstance(sDataInstance, entityUpdateDescriptor);
            }
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void updateActivityInstanceVariables(List<Operation> operations, long activityInstanceId, Map<String, Serializable> expressionContexts) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        OperationService operationService = tenantAccessor.getOperationService();
        SOperationBuilders sOperationBuilders = tenantAccessor.getSOperationBuilders();
        SExpressionBuilders sExpressionBuilders = tenantAccessor.getSExpressionBuilders();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        int processDefinitionIndex = tenantAccessor.getBPMInstanceBuilders().getSAutomaticTaskInstanceBuilder().getProcessDefinitionIndex();
        ArrayList<String> dataNames = new ArrayList<String>(operations.size());
        for (Operation operation : operations) {
            dataNames.add(operation.getLeftOperand().getName());
        }
        try {
            List<SDataInstance> dataInstances = dataInstanceService.getDataInstances(dataNames, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
            SActivityInstance activityInstance = activityInstanceService.getActivityInstance(activityInstanceId);
            for (int i = 0; i < dataInstances.size(); ++i) {
                SDataInstance dataInstance = dataInstances.get(i);
                Operation operation = operations.get(i);
                SOperation sOperation = this.toSOperation(operation, sOperationBuilders, sExpressionBuilders);
                SExpressionContext sExpressionContext = new SExpressionContext((Long)activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString(), activityInstance.getLogicalGroup(processDefinitionIndex));
                sExpressionContext.setSerializableInputValues(expressionContexts);
                operationService.execute(sOperation, dataInstance.getContainerId(), dataInstance.getContainerType(), sExpressionContext);
            }
        }
        catch (SDataInstanceException e) {
            throw new UpdateException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public long getOneAssignedUserTaskInstanceOfProcessInstance(long processInstanceId, long userId) throws RetrieveException {
        int assignedUserTaskInstanceNumber = (int)this.getNumberOfAssignedHumanTaskInstances(userId);
        List<HumanTaskInstance> userTaskInstances = this.getAssignedHumanTaskInstances(userId, 0, assignedUserTaskInstanceNumber, ActivityInstanceCriterion.DEFAULT);
        if (userTaskInstances.size() != 0) {
            for (HumanTaskInstance userTaskInstance : userTaskInstances) {
                String stateName = userTaskInstance.getState();
                long userTaskInstanceId = userTaskInstance.getId();
                if (!stateName.equals("ready") || userTaskInstance.getParentContainerId() != processInstanceId) continue;
                return userTaskInstanceId;
            }
        }
        return -1L;
    }

    public long getOneAssignedUserTaskInstanceOfProcessDefinition(long processDefinitionId, long userId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessInstanceDescriptor searchProcessInstanceDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessInstanceDescriptor();
        int assignedUserTaskInstanceNumber = (int)this.getNumberOfAssignedHumanTaskInstances(userId);
        List<HumanTaskInstance> userTaskInstances = this.getAssignedHumanTaskInstances(userId, 0, assignedUserTaskInstanceNumber, ActivityInstanceCriterion.DEFAULT);
        if (userTaskInstances.size() != 0) {
            for (HumanTaskInstance userTaskInstance : userTaskInstances) {
                ProcessInstance processInstance;
                String stateName = userTaskInstance.getState();
                try {
                    GetProcessInstance getProcessInstance = new GetProcessInstance(processInstanceService, processDefinitionService, searchProcessInstanceDescriptor, userTaskInstance.getRootContainerId());
                    getProcessInstance.execute();
                    processInstance = getProcessInstance.getResult();
                }
                catch (SBonitaException e) {
                    throw new RetrieveException((Throwable)e);
                }
                if (!stateName.equals("ready") || processInstance.getProcessDefinitionId() != processDefinitionId) continue;
                return userTaskInstance.getId();
            }
        }
        return -1L;
    }

    public String getActivityInstanceState(long activityInstanceId) throws ActivityInstanceNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        try {
            GetActivityInstance getActivityInstance = new GetActivityInstance(activityInstanceService, activityInstanceId);
            getActivityInstance.execute();
            SActivityInstance sActivity = getActivityInstance.getResult();
            ActivityInstance activityInstance = ModelConvertor.toActivityInstance(sActivity, flowNodeStateManager);
            return activityInstance.getState();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new ActivityInstanceNotFoundException(activityInstanceId);
        }
    }

    public boolean canExecuteTask(long activityInstanceId, long userId) throws ActivityInstanceNotFoundException, RetrieveException {
        HumanTaskInstance userTaskInstance = this.getHumanTaskInstance(activityInstanceId);
        return userTaskInstance.getState().equalsIgnoreCase("ready") && userTaskInstance.getAssigneeId() == userId;
    }

    public long getProcessDefinitionId(String name, String version) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinitionIDByNameAndVersion transactionContent = new GetProcessDefinitionIDByNameAndVersion(processDefinitionService, name, version);
        try {
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        return (Long)transactionContent.getResult();
    }

    public void releaseUserTask(long userTaskId) throws ActivityInstanceNotFoundException, UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            AssignOrUnassignUserTask assignUserTask = new AssignOrUnassignUserTask(0L, userTaskId, activityInstanceService, null, null);
            assignUserTask.execute();
        }
        catch (SUnreleasableTaskException e) {
            throw new UpdateException((Throwable)e);
        }
        catch (SActivityInstanceNotFoundException e) {
            throw new ActivityInstanceNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new UpdateException((Throwable)e);
        }
    }

    public void updateProcessDeploymentInfo(long processDefinitionId, ProcessDeploymentInfoUpdater processDeploymentInfoUpdater) throws ProcessDefinitionNotFoundException, UpdateException {
        if (processDeploymentInfoUpdater == null || processDeploymentInfoUpdater.getFields().isEmpty()) {
            throw new UpdateException("The update descriptor does not contain field updates");
        }
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SProcessDefinitionDeployInfoUpdateBuilder processDeploymentInfoUpdateBuilder = tenantAccessor.getBPMDefinitionBuilders().getProcessDefinitionDeployInfoUpdateBuilder();
        UpdateProcessDeploymentInfo updateProcessDeploymentInfo = new UpdateProcessDeploymentInfo(processDefinitionService, processDeploymentInfoUpdateBuilder, processDefinitionId, processDeploymentInfoUpdater);
        try {
            updateProcessDeploymentInfo.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException sbe) {
            throw new UpdateException((Throwable)sbe);
        }
    }

    public List<ProcessDeploymentInfo> getStartableProcessDeploymentInfosForActors(Set<Long> actorIds, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ProcessDefinitionDeployInfoBuilder builder = tenantAccessor.getBPMDefinitionBuilders().getProcessDefinitionDeployInfoBuilder();
        try {
            List<SActor> actors = actorMappingService.getActors(new ArrayList<Long>(actorIds));
            HashSet<Long> processDefIds = new HashSet<Long>(actors.size());
            for (SActor sActor : actors) {
                if (!sActor.isInitiator()) continue;
                processDefIds.add(sActor.getScopeId());
            }
            String field = null;
            OrderByType order = null;
            switch (sortingCriterion) {
                case DEFAULT: {
                    break;
                }
                case LABEL_ASC: {
                    break;
                }
                case LABEL_DESC: {
                    break;
                }
                case NAME_ASC: {
                    field = builder.getNameKey();
                    order = OrderByType.ASC;
                    break;
                }
                case NAME_DESC: {
                    field = builder.getNameKey();
                    order = OrderByType.DESC;
                    break;
                }
                case ACTIVATION_STATE_ASC: {
                    field = builder.getActivationStateKey();
                    order = OrderByType.ASC;
                    break;
                }
                case ACTIVATION_STATE_DESC: {
                    field = builder.getActivationStateKey();
                    order = OrderByType.DESC;
                    break;
                }
                case CONFIGURATION_STATE_ASC: {
                    field = builder.getConfigurationStateKey();
                    order = OrderByType.ASC;
                    break;
                }
                case CONFIGURATION_STATE_DESC: {
                    field = builder.getConfigurationStateKey();
                    order = OrderByType.DESC;
                    break;
                }
                case VERSION_ASC: {
                    field = builder.getVersionKey();
                    order = OrderByType.ASC;
                    break;
                }
                case VERSION_DESC: {
                    field = builder.getVersionKey();
                    order = OrderByType.DESC;
                    break;
                }
            }
            List<SProcessDefinitionDeployInfo> processDefinitionDeployInfos = processDefinitionService.getProcessDeploymentInfos(new ArrayList<Long>(processDefIds), startIndex, maxResults, field, order);
            return ModelConvertor.toProcessDeploymentInfo(processDefinitionDeployInfos);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public boolean isAllowedToStartProcess(long processDefinitionId, Set<Long> actorIds) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        GetActorsByActorIds getActorsByActorIds = new GetActorsByActorIds(actorMappingService, new ArrayList<Long>(actorIds));
        try {
            getActorsByActorIds.execute();
            Object actors = getActorsByActorIds.getResult();
            boolean isAllowedToStartProcess = true;
            Iterator iterator = actors.iterator();
            while (isAllowedToStartProcess && iterator.hasNext()) {
                SActor actor = (SActor)iterator.next();
                if (actor.getScopeId() == processDefinitionId && actor.isInitiator()) continue;
                isAllowedToStartProcess = false;
            }
            return isAllowedToStartProcess;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public ActorInstance getActorInitiator(long processDefinitionId) throws ActorNotFoundException, ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        ActorInstance actorInstance = null;
        try {
            SProcessDefinition definition = processDefinitionService.getProcessDefinition(processDefinitionId);
            SActorDefinition sActorDefinition = definition.getActorInitiator();
            if (sActorDefinition == null) {
                throw new ActorNotFoundException("No actor initiator defined on the process");
            }
            String name = sActorDefinition.getName();
            SActor sActor = actorMappingService.getActor(name, processDefinitionId);
            actorInstance = ModelConvertor.toActorInstance(sActor);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return actorInstance;
    }

    public int getNumberOfActivityDataDefinitions(long processDefinitionId, String activityName) throws ProcessDefinitionNotFoundException, ActivityDefinitionNotFoundException {
        List<Object> sdataDefinitionList = Collections.emptyList();
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            getProcessDefinition.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        SProcessDefinition sProcessDefinition = getProcessDefinition.getResult();
        if (sProcessDefinition != null) {
            boolean found = false;
            SFlowElementContainerDefinition processContainer = sProcessDefinition.getProcessContainer();
            Set<SActivityDefinition> activityDefList = processContainer.getActivities();
            for (SActivityDefinition sActivityDefinition : activityDefList) {
                if (!activityName.equals(sActivityDefinition.getName())) continue;
                sdataDefinitionList = sActivityDefinition.getSDataDefinitions();
                found = true;
                break;
            }
            if (!found) {
                throw new ActivityDefinitionNotFoundException(activityName);
            }
            return sdataDefinitionList.size();
        }
        return 0;
    }

    public int getNumberOfProcessDataDefinitions(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
        try {
            getProcessDefinition.execute();
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        SProcessDefinition sProcessDefinition = getProcessDefinition.getResult();
        SFlowElementContainerDefinition processContainer = sProcessDefinition.getProcessContainer();
        return processContainer.getDataDefinitions().size();
    }

    public ProcessInstance startProcess(long processDefinitionId, Map<String, Serializable> initialVariables) throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException {
        ClassLoaderService classLoaderService = ProcessAPIImpl.getTenantAccessor().getClassLoaderService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        try {
            ClassLoader localClassLoader = classLoaderService.getLocalClassLoader("process", processDefinitionId);
            Thread.currentThread().setContextClassLoader(localClassLoader);
            if (initialVariables != null) {
                for (Map.Entry<String, Serializable> initialVariable : initialVariables.entrySet()) {
                    String name = initialVariable.getKey();
                    Serializable value = initialVariable.getValue();
                    Expression expression = new ExpressionBuilder().createExpression(name, name, value.getClass().getName(), ExpressionType.TYPE_INPUT);
                    Operation operation = new OperationBuilder().createSetDataOperation(name, expression);
                    operations.add(operation);
                }
            }
        }
        catch (ClassLoaderException cle) {
            throw new ProcessExecutionException((Throwable)cle);
        }
        catch (InvalidExpressionException iee) {
            throw new ProcessExecutionException((Throwable)iee);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return this.startProcess(processDefinitionId, operations, initialVariables);
    }

    public ProcessInstance startProcess(long processDefinitionId, List<Operation> operations, Map<String, Serializable> context) throws ProcessExecutionException, ProcessDefinitionNotFoundException, ProcessActivationException {
        try {
            return this.startProcess(0L, processDefinitionId, operations, context);
        }
        catch (RetrieveException e) {
            throw new ProcessExecutionException((Throwable)e);
        }
    }

    public ProcessInstance startProcess(long userId, long processDefinitionId, List<Operation> operations, Map<String, Serializable> context) throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException {
        SProcessInstance startedInstance;
        SProcessDefinition sProcessDefinition;
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        SOperationBuilders sOperationBuilders = tenantAccessor.getSOperationBuilders();
        SExpressionBuilders sExpressionBuilders = tenantAccessor.getSExpressionBuilders();
        long userIdFromSession = SessionInfos.getUserIdFromSession();
        long starterId = userId == 0L ? userIdFromSession : userId;
        try {
            SProcessDefinitionDeployInfo deployInfo = processDefinitionService.getProcessDeploymentInfo(processDefinitionId);
            if (ActivationState.DISABLED.name().equals(deployInfo.getActivationState())) {
                throw new ProcessActivationException("Process disabled");
            }
            sProcessDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        try {
            List<SOperation> sOperations = this.toSOperation(operations, sOperationBuilders, sExpressionBuilders);
            Map<String, Object> operationContext = context != null ? new HashMap<String, Serializable>(context) : Collections.emptyMap();
            startedInstance = processExecutor.start(sProcessDefinition, starterId, userIdFromSession, sOperations, operationContext, null);
        }
        catch (SBonitaException e) {
            throw new ProcessExecutionException((Throwable)e);
        }
        ProcessInstance processInstance = ModelConvertor.toProcessInstance(sProcessDefinition, startedInstance);
        TechnicalLoggerService logger = tenantAccessor.getTechnicalLoggerService();
        if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            StringBuilder stb = new StringBuilder();
            stb.append("The user <");
            stb.append(SessionInfos.getUserNameFromSession());
            if (starterId != userIdFromSession) {
                stb.append(">acting as delegate of user with id <");
                stb.append(starterId);
            }
            stb.append("> has started instance <");
            stb.append(processInstance.getId());
            stb.append("> of process <");
            stb.append(sProcessDefinition.getName());
            stb.append("> in version <");
            stb.append(sProcessDefinition.getVersion());
            stb.append("> and id <");
            stb.append(sProcessDefinition.getId());
            stb.append(">");
            logger.log(this.getClass(), TechnicalLogSeverity.INFO, stb.toString());
        }
        return processInstance;
    }

    private List<SOperation> toSOperation(List<Operation> operations, SOperationBuilders sOperationBuilders, SExpressionBuilders sExpressionBuilders) {
        if (operations == null) {
            return null;
        }
        if (operations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SOperation> sOperations = new ArrayList<SOperation>(operations.size());
        for (Operation operation : operations) {
            SOperation sOperation = this.toSOperation(operation, sOperationBuilders, sExpressionBuilders);
            sOperations.add(sOperation);
        }
        return sOperations;
    }

    private SOperation toSOperation(Operation operation, SOperationBuilders sOperationBuilders, SExpressionBuilders sExpressionBuilders) {
        SExpression rightOperand = ModelConvertor.constructSExpression(operation.getRightOperand(), sExpressionBuilders.getExpressionBuilder());
        SOperatorType operatorType = SOperatorType.valueOf(operation.getType().name());
        SLeftOperand sLeftOperand = this.toSLeftOperand(operation.getLeftOperand(), sOperationBuilders);
        return sOperationBuilders.getSOperationBuilder().createNewInstance().setOperator(operation.getOperator()).setRightOperand(rightOperand).setType(operatorType).setLeftOperand(sLeftOperand).done();
    }

    private SLeftOperand toSLeftOperand(LeftOperand variableToSet, SOperationBuilders sOperationBuilders) {
        return sOperationBuilders.getSLeftOperandBuilder().createNewInstance().setName(variableToSet.getName()).done();
    }

    public long getNumberOfActivityDataInstances(long activityInstanceId) throws ActivityInstanceNotFoundException {
        try {
            return this.getNumberOfDataInstancesOfContainer(activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE);
        }
        catch (SBonitaException e) {
            throw new ActivityInstanceNotFoundException(activityInstanceId);
        }
    }

    private long getNumberOfDataInstancesOfContainer(long activityInstanceId, DataInstanceContainer containerType) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        GetNumberOfDataInstanceForContainer getNumberOfDataInstance = new GetNumberOfDataInstanceForContainer(activityInstanceId, containerType, dataInstanceService);
        getNumberOfDataInstance.execute();
        return getNumberOfDataInstance.getResult();
    }

    public long getNumberOfProcessDataInstances(long processInstanceId) throws ProcessInstanceNotFoundException {
        try {
            return this.getNumberOfDataInstancesOfContainer(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE);
        }
        catch (SBonitaException e) {
            throw new ProcessInstanceNotFoundException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Serializable> executeOperations(ConnectorResult connectorResult, List<Operation> operations, Map<String, Serializable> operationInputValues, SExpressionContext expressionContext, ClassLoader classLoader, TenantServiceAccessor tenantAccessor) throws SBonitaException {
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        OperationService operationService = tenantAccessor.getOperationService();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            HashMap<String, Serializable> externalDataValue = new HashMap<String, Serializable>(operations.size());
            for (Operation operation : operations) {
                SOperation sOperation = ModelConvertor.constructSOperation(operation, tenantAccessor);
                HashMap<String, Object> inputValues = new HashMap<String, Object>(operationInputValues);
                inputValues.putAll(connectorResult.getResult());
                expressionContext.setInputValues(inputValues);
                Long containerId = expressionContext.getContainerId();
                operationService.execute(sOperation, containerId == null ? -1L : containerId, expressionContext.getContainerType(), expressionContext);
                LeftOperand leftOperand = operation.getLeftOperand();
                if (!leftOperand.isExternal()) continue;
                externalDataValue.put(leftOperand.getName(), (Serializable)expressionContext.getInputValues().get(leftOperand.getName()));
            }
            connectorService.disconnect(connectorResult);
            HashMap<String, Serializable> hashMap = externalDataValue;
            return hashMap;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private Map<String, Serializable> toSerializableMap(Map<String, Object> map, String connectorDefinitionId, String connectorDefinitionVersion) throws NotSerializableException {
        HashMap<String, Serializable> resMap = new HashMap<String, Serializable>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                resMap.put(entry.getKey(), (Serializable)entry.getValue());
            }
            catch (ClassCastException e) {
                throw new NotSerializableException(connectorDefinitionId, connectorDefinitionVersion, entry.getKey(), entry.getValue());
            }
        }
        return resMap;
    }

    public Map<String, Serializable> executeConnectorOnProcessDefinition(String connectorDefinitionId, String connectorDefinitionVersion, Map<String, Expression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues, long processDefinitionId) throws ConnectorExecutionException {
        return this.executeConnectorOnProcessDefinitionWithOrWithoutOperations(connectorDefinitionId, connectorDefinitionVersion, connectorInputParameters, inputValues, null, null, processDefinitionId);
    }

    public Map<String, Serializable> executeConnectorOnProcessDefinition(String connectorDefinitionId, String connectorDefinitionVersion, Map<String, Expression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues, List<Operation> operations, Map<String, Serializable> operationInputValues, long processDefinitionId) throws ConnectorExecutionException {
        return this.executeConnectorOnProcessDefinitionWithOrWithoutOperations(connectorDefinitionId, connectorDefinitionVersion, connectorInputParameters, inputValues, operations, operationInputValues, processDefinitionId);
    }

    private Map<String, Serializable> executeConnectorOnProcessDefinitionWithOrWithoutOperations(String connectorDefinitionId, String connectorDefinitionVersion, Map<String, Expression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues, List<Operation> operations, Map<String, Serializable> operationInputValues, long processDefinitionId) throws ConnectorExecutionException {
        this.checkConnectorParameters(connectorInputParameters, inputValues);
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SExpressionBuilders sExpressionBuilders = tenantAccessor.getSExpressionBuilders();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        ClassLoaderService classLoaderService = tenantAccessor.getClassLoaderService();
        try {
            ClassLoader classLoader = classLoaderService.getLocalClassLoader("process", processDefinitionId);
            Map<String, SExpression> connectorsExps = ModelConvertor.constructExpressions(sExpressionBuilders, connectorInputParameters);
            SExpressionContext expcontext = new SExpressionContext();
            expcontext.setProcessDefinitionId(processDefinitionId);
            SProcessDefinition processDef = processDefinitionService.getProcessDefinition(processDefinitionId);
            if (processDef != null) {
                expcontext.setProcessDefinition(processDef);
            }
            ConnectorResult connectorResult = connectorService.executeMutipleEvaluation(processDefinitionId, connectorDefinitionId, connectorDefinitionVersion, connectorsExps, inputValues, classLoader, expcontext);
            if (operations != null) {
                return this.executeOperations(connectorResult, operations, operationInputValues, expcontext, classLoader, tenantAccessor);
            }
            return this.getSerializableResultOfConnector(connectorDefinitionVersion, connectorResult, connectorService);
        }
        catch (SBonitaException e) {
            throw new ConnectorExecutionException((Throwable)e);
        }
        catch (NotSerializableException e) {
            throw new ConnectorExecutionException((Throwable)e);
        }
    }

    protected Map<String, Serializable> getSerializableResultOfConnector(String connectorDefinitionVersion, ConnectorResult connectorResult, ConnectorService connectorService) throws NotSerializableException, SConnectorException {
        connectorService.disconnect(connectorResult);
        return this.toSerializableMap(connectorResult.getResult(), connectorDefinitionVersion, connectorDefinitionVersion);
    }

    protected void checkConnectorParameters(Map<String, Expression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues) throws ConnectorExecutionException {
        if (connectorInputParameters.size() != inputValues.size()) {
            throw new ConnectorExecutionException("The number of input parameters is not consistent with the number of input values. Input parameters: " + connectorInputParameters.size() + ", number of input values: " + inputValues.size());
        }
    }

    public void setActivityStateByName(long activityInstanceId, String state) throws UpdateException {
        this.setActivityStateById(activityInstanceId, ModelConvertor.getServerActivityStateId(state));
    }

    public void setActivityStateById(long activityInstanceId, int stateId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeExecutor flowNodeExecutor = tenantAccessor.getFlowNodeExecutor();
        try {
            GetActivityInstance getActivityInstance = new GetActivityInstance(activityInstanceService, activityInstanceId);
            getActivityInstance.execute();
            SActivityInstance activityInstance = getActivityInstance.getResult();
            flowNodeExecutor.setStateByStateId(activityInstance.getLogicalGroup(0), activityInstance.getId(), stateId);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public void setTaskPriority(long humanTaskInstanceId, TaskPriority priority) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            SetTaskPriority transactionContent = new SetTaskPriority(activityInstanceService, humanTaskInstanceId, STaskPriority.valueOf(priority.name()));
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    @Deprecated
    public void deleteProcessInstances(long processDefinitionId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        try {
            this.deleteProcessInstancesFromProcessDefinition(processDefinitionId, tenantAccessor, tenantAccessor.getTenantId());
            new DeleteArchivedProcessInstances(tenantAccessor, processDefinitionId).execute();
        }
        catch (SProcessInstanceHierarchicalDeletionException e) {
            throw new ProcessInstanceHierarchicalDeletionException(e.getMessage(), e.getProcessInstanceId());
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    private void deleteProcessInstanceInTransaction(TenantServiceAccessor tenantAccessor, long processInstanceId) throws SBonitaException {
        TransactionService transactionService = tenantAccessor.getTransactionService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        transactionService.begin();
        try {
            processInstanceService.deleteParentProcessInstanceAndElements(processInstanceId);
        }
        catch (SBonitaException e) {
            transactionService.setRollbackOnly();
            throw e;
        }
        finally {
            transactionService.complete();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @CustomTransactions
    public long deleteProcessInstances(long processDefinitionId, int startIndex, int maxResults) throws DeletionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SProcessInstanceBuilder sProcessInstanceBuilder = tenantAccessor.getBPMInstanceBuilders().getSProcessInstanceBuilder();
        TransactionService txService = tenantAccessor.getTransactionService();
        try {
            List<SProcessInstance> sProcessInstances;
            txService.begin();
            try {
                sProcessInstances = this.searchProcessInstancesFromProcessDefinition(processInstanceService, sProcessInstanceBuilder, processDefinitionId, startIndex, maxResults);
            }
            catch (SBonitaSearchException e) {
                txService.setRollbackOnly();
                throw e;
            }
            finally {
                txService.complete();
            }
            if (sProcessInstances.isEmpty()) {
                return 0L;
            }
            LockService lockService = tenantAccessor.getLockService();
            String objectType = SFlowElementsContainerType.PROCESS.name();
            List<BonitaLock> locks = null;
            try {
                locks = this.createLockProcessInstances(lockService, objectType, sProcessInstances, tenantAccessor.getTenantId());
                txService.begin();
                try {
                    long l = processInstanceService.deleteParentProcessInstanceAndElements(sProcessInstances);
                    return l;
                }
                catch (Exception e) {
                    txService.setRollbackOnly();
                    throw new DeletionException((Throwable)e);
                }
                finally {
                    txService.complete();
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.releaseLocks(tenantAccessor, lockService, locks, tenantAccessor.getTenantId());
            }
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    private List<SProcessInstance> searchProcessInstancesFromProcessDefinition(ProcessInstanceService processInstanceService, SProcessInstanceBuilder sProcessInstanceBuilder, long processDefinitionId, int startIndex, int maxResults) throws SBonitaSearchException {
        FilterOption filterOption = new FilterOption(SProcessInstance.class, sProcessInstanceBuilder.getProcessDefinitionIdKey(), processDefinitionId);
        OrderByOption order2 = new OrderByOption(SProcessInstance.class, sProcessInstanceBuilder.getIdKey(), OrderByType.ASC);
        OrderByOption order = new OrderByOption(SProcessInstance.class, sProcessInstanceBuilder.getCallerIdKey(), OrderByType.ASC);
        ArrayList<OrderByOption> orders = new ArrayList<OrderByOption>();
        orders.add(order);
        orders.add(order2);
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, orders, Collections.singletonList(filterOption), null);
        return processInstanceService.searchProcessInstances(queryOptions);
    }

    public long deleteArchivedProcessInstances(long processDefinitionId, int startIndex, int maxResults) throws DeletionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SAProcessInstanceBuilder saProcessInstanceBuilder = tenantAccessor.getBPMInstanceBuilders().getSAProcessInstanceBuilder();
        try {
            List<SAProcessInstance> saProcessInstances = this.searchArchivedProcessInstancesFromProcessDefinition(processInstanceService, saProcessInstanceBuilder, processDefinitionId, startIndex, maxResults);
            if (!saProcessInstances.isEmpty()) {
                return processInstanceService.deleteParentArchivedProcessInstancesAndElements(saProcessInstances);
            }
            return 0L;
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    private List<SAProcessInstance> searchArchivedProcessInstancesFromProcessDefinition(ProcessInstanceService processInstanceService, SAProcessInstanceBuilder saProcessInstanceBuilder, long processDefinitionId, int startIndex, int maxResults) throws SBonitaSearchException {
        FilterOption filterOption = new FilterOption(SAProcessInstance.class, saProcessInstanceBuilder.getProcessDefinitionIdKey(), processDefinitionId);
        OrderByOption order = new OrderByOption(SAProcessInstance.class, saProcessInstanceBuilder.getIdKey(), OrderByType.ASC);
        OrderByOption order2 = new OrderByOption(SAProcessInstance.class, saProcessInstanceBuilder.getCallerIdKey(), OrderByType.ASC);
        ArrayList<OrderByOption> orders = new ArrayList<OrderByOption>();
        orders.add(order);
        orders.add(order2);
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, orders, Collections.singletonList(filterOption), null);
        return processInstanceService.searchArchivedProcessInstances(queryOptions);
    }

    private List<BonitaLock> createLockProcessInstances(LockService lockService, String objectType, List<SProcessInstance> sProcessInstances, long tenantId) throws SLockException {
        ArrayList<BonitaLock> locks = new ArrayList<BonitaLock>();
        for (SProcessInstance sProcessInstance : sProcessInstances) {
            BonitaLock bonitaLock = lockService.lock(sProcessInstance.getId(), objectType, tenantId);
            locks.add(bonitaLock);
        }
        return locks;
    }

    @CustomTransactions
    public void deleteProcessInstance(long processInstanceId) throws DeletionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        LockService lockService = tenantAccessor.getLockService();
        String objectType = SFlowElementsContainerType.PROCESS.name();
        try {
            BonitaLock lock = lockService.lock(processInstanceId, objectType, tenantAccessor.getTenantId());
            this.deleteProcessInstanceInTransaction(tenantAccessor, processInstanceId);
            lockService.unlock(lock, tenantAccessor.getTenantId());
        }
        catch (SLockException e) {
            throw new DeletionException("Lock was not released. Object type: " + objectType + ", id: " + processInstanceId);
        }
        catch (SProcessInstanceHierarchicalDeletionException e) {
            throw new ProcessInstanceHierarchicalDeletionException(e.getMessage(), e.getProcessInstanceId());
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new DeletionException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public SearchResult<ProcessInstance> searchOpenProcessInstances(SearchOptions searchOptions) throws SearchException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(searchOptions);
        searchOptionsBuilder.differentFrom("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.COMPLETED.getId()));
        searchOptionsBuilder.filter("callerId", (Serializable)Integer.valueOf(-1));
        try {
            return this.searchProcessInstances(ProcessAPIImpl.getTenantAccessor(), searchOptionsBuilder.done());
        }
        catch (SSearchException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public SearchResult<ProcessInstance> searchOpenProcessInstancesSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        IdentityService identityService = tenantAccessor.getIdentityService();
        GetSUser getUser = new GetSUser(identityService, userId);
        try {
            getUser.execute();
        }
        catch (SBonitaException e) {
            return new SearchResultImpl(0L, Collections.emptyList());
        }
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchOpenProcessInstancesSupervisedBy searchOpenProcessInstances = new SearchOpenProcessInstancesSupervisedBy(processInstanceService, searchEntitiesDescriptor.getProcessInstanceDescriptor(), userId, searchOptions, processDefinitionService);
        try {
            searchOpenProcessInstances.execute();
            return searchOpenProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosStartedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosStartedBy searcher = new SearchProcessDeploymentInfosStartedBy(processDefinitionService, searchDescriptor, userId, searchOptions);
        try {
            searcher.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Can't get ProcessDeploymentInfo startedBy userid " + userId, (Throwable)e);
        }
        return searcher.getResult();
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfos(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfos transactionSearch = new SearchProcessDeploymentInfos(processDefinitionService, searchDescriptor, searchOptions);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Can't get processDefinition's executing searchProcessDefinitions()", (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfos(long userId, SearchOptions searchOptions) throws RetrieveException, SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosUserCanStart transactionSearch = new SearchProcessDeploymentInfosUserCanStart(processDefinitionService, searchDescriptor, searchOptions, userId);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Error while retrieving process definitions: " + e.getMessage(), (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosUsersManagedByCanStart(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = serviceAccessor.getProcessDefinitionService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosUsersManagedByCanStart transactionSearch = new SearchProcessDeploymentInfosUsersManagedByCanStart(processDefinitionService, searchDescriptor, searchOptions, managerUserId);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = serviceAccessor.getProcessDefinitionService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getProcessDefinitionsDescriptor();
        SearchProcessDeploymentInfosSupervised searcher = new SearchProcessDeploymentInfosSupervised(processDefinitionService, searchDescriptor, searchOptions, userId);
        try {
            searcher.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searcher.getResult();
    }

    public SearchResult<HumanTaskInstance> searchAssignedTasksSupervisedBy(long supervisorId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = ProcessAPIImpl.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = serviceAccessor.getFlowNodeStateManager();
        ActivityInstanceService activityInstanceService = serviceAccessor.getActivityInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchAssignedTasksSupervisedBy searchedTasksTransaction = new SearchAssignedTasksSupervisedBy(supervisorId, activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getHumanTaskInstanceDescriptor(), searchOptions);
        try {
            searchedTasksTransaction.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searchedTasksTransaction.getResult();
    }

    public SearchResult<ArchivedHumanTaskInstance> searchArchivedHumanTasksSupervisedBy(long supervisorId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = ProcessAPIImpl.getTenantAccessor();
        FlowNodeStateManager flowNodeStateManager = serviceAccessor.getFlowNodeStateManager();
        ActivityInstanceService activityInstanceService = serviceAccessor.getActivityInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = serviceAccessor.getSearchEntitiesDescriptor();
        SearchArchivedTasksSupervisedBy searchedTasksTransaction = new SearchArchivedTasksSupervisedBy(supervisorId, activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getArchivedHumanTaskInstanceDescriptor(), searchOptions);
        try {
            searchedTasksTransaction.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searchedTasksTransaction.getResult();
    }

    public SearchResult<ProcessSupervisor> searchProcessSupervisors(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor serviceAccessor = ProcessAPIImpl.getTenantAccessor();
        SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
        SProcessSupervisorBuilders supervisorBuilders = serviceAccessor.getSSupervisorBuilders();
        SearchProcessSupervisorDescriptor searchDescriptor = new SearchProcessSupervisorDescriptor(supervisorBuilders);
        SearchSupervisors searchSupervisorsTransaction = new SearchSupervisors(supervisorService, searchDescriptor, searchOptions);
        try {
            searchSupervisorsTransaction.execute();
            return searchSupervisorsTransaction.getResult();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public boolean isUserProcessSupervisor(long processDefinitionId, long userId) {
        TenantServiceAccessor serviceAccessor = ProcessAPIImpl.getTenantAccessor();
        SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
        try {
            return supervisorService.isProcessSupervisor(processDefinitionId, userId);
        }
        catch (SBonitaReadException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public void deleteSupervisor(long supervisorId) throws DeletionException {
        TenantServiceAccessor serviceAccessor = ProcessAPIImpl.getTenantAccessor();
        SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
        try {
            supervisorService.deleteSupervisor(supervisorId);
        }
        catch (SSupervisorNotFoundException e) {
            throw new DeletionException("supervisor not found with id " + supervisorId);
        }
        catch (SSupervisorDeletionException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public void deleteSupervisor(Long processDefinitionId, Long userId, Long roleId, Long groupId) throws DeletionException {
        TenantServiceAccessor serviceAccessor = ProcessAPIImpl.getTenantAccessor();
        SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
        SProcessSupervisorBuilders supervisorBuilders = serviceAccessor.getSSupervisorBuilders();
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 1);
        searchOptionsBuilder.sort("id", Order.ASC);
        searchOptionsBuilder.filter("processDefId", (Serializable)Long.valueOf(processDefinitionId == null ? -1L : processDefinitionId));
        searchOptionsBuilder.filter("userId", (Serializable)Long.valueOf(userId == null ? -1L : userId));
        searchOptionsBuilder.filter("roleId", (Serializable)Long.valueOf(roleId == null ? -1L : roleId));
        searchOptionsBuilder.filter("groupId", (Serializable)Long.valueOf(groupId == null ? -1L : groupId));
        SearchProcessSupervisorDescriptor searchDescriptor = new SearchProcessSupervisorDescriptor(supervisorBuilders);
        SearchSupervisors searchSupervisorsTransaction = new SearchSupervisors(supervisorService, searchDescriptor, searchOptionsBuilder.done());
        try {
            searchSupervisorsTransaction.execute();
            SearchResult result = searchSupervisorsTransaction.getResult();
            if (result.getCount() <= 0L) {
                throw new SSupervisorNotFoundException("No supervisor was found with userId = " + userId + ", roleId = " + roleId + ", groupId = " + groupId + ", processDefinitionId = " + processDefinitionId);
            }
            List processSupervisors = result.getResult();
            supervisorService.deleteSupervisor(((ProcessSupervisor)processSupervisors.get(0)).getSupervisorId());
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public ProcessSupervisor createProcessSupervisorForUser(long processDefinitionId, long userId) throws CreationException, AlreadyExistsException {
        return this.createSupervisor(processDefinitionId, userId, null, null, MemberType.USER);
    }

    public ProcessSupervisor createProcessSupervisorForRole(long processDefinitionId, long roleId) throws CreationException, AlreadyExistsException {
        return this.createSupervisor(processDefinitionId, null, null, roleId, MemberType.ROLE);
    }

    public ProcessSupervisor createProcessSupervisorForGroup(long processDefinitionId, long groupId) throws CreationException, AlreadyExistsException {
        return this.createSupervisor(processDefinitionId, null, groupId, null, MemberType.GROUP);
    }

    public ProcessSupervisor createProcessSupervisorForMembership(long processDefinitionId, long groupId, long roleId) throws CreationException, AlreadyExistsException {
        return this.createSupervisor(processDefinitionId, null, groupId, roleId, MemberType.MEMBERSHIP);
    }

    private ProcessSupervisor createSupervisor(long processDefinitionId, Long userId, Long groupId, Long roleId, MemberType memberType) throws CreationException, AlreadyExistsException {
        TenantServiceAccessor serviceAccessor = ProcessAPIImpl.getTenantAccessor();
        SupervisorMappingService supervisorService = serviceAccessor.getSupervisorService();
        SProcessSupervisorBuilder supervisorBuilder = serviceAccessor.getSSupervisorBuilders().getSSupervisorBuilder();
        try {
            supervisorBuilder.createNewInstance(processDefinitionId);
            switch (memberType) {
                case USER: {
                    supervisorBuilder.setUserId(userId);
                    break;
                }
                case GROUP: {
                    supervisorBuilder.setGroupId(groupId);
                    break;
                }
                case ROLE: {
                    supervisorBuilder.setRoleId(roleId);
                    break;
                }
                case MEMBERSHIP: {
                    supervisorBuilder.setGroupId(groupId);
                    supervisorBuilder.setRoleId(roleId);
                }
            }
            SProcessSupervisor supervisor = supervisorBuilder.done();
            supervisor = supervisorService.createSupervisor(supervisor);
            return ModelConvertor.toProcessSupervisor(supervisor);
        }
        catch (SSupervisorAlreadyExistsException e) {
            throw new AlreadyExistsException("This supervisor already exists");
        }
        catch (SSupervisorCreationException e) {
            throw new CreationException((Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfosUserCanStart(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getProcessDefinitionsDescriptor();
        SearchUncategorizedProcessDeploymentInfosUserCanStart transactionSearch = new SearchUncategorizedProcessDeploymentInfosUserCanStart(processDefinitionService, searchDescriptor, searchOptions, userId);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Error while retrieving process definitions", (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public SearchResult<ArchivedHumanTaskInstance> searchArchivedHumanTasksManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedTasksManagedBy searchTransaction = new SearchArchivedTasksManagedBy(managerUserId, searchOptions, activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getArchivedHumanTaskInstanceDescriptor());
        try {
            searchTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchTransaction.getResult();
    }

    public SearchResult<ProcessInstance> searchOpenProcessInstancesInvolvingUser(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchOpenProcessInstancesInvolvingUser searchOpenProcessInstances = new SearchOpenProcessInstancesInvolvingUser(processInstanceService, searchEntitiesDescriptor.getProcessInstanceDescriptor(), userId, searchOptions, processDefinitionService);
        try {
            searchOpenProcessInstances.execute();
            return searchOpenProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<ProcessInstance> searchOpenProcessInstancesInvolvingUsersManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchOpenProcessInstancesInvolvingUsersManagedBy searchOpenProcessInstances = new SearchOpenProcessInstancesInvolvingUsersManagedBy(processInstanceService, searchEntitiesDescriptor.getProcessInstanceDescriptor(), managerUserId, searchOptions, processDefinitionService);
        try {
            searchOpenProcessInstances.execute();
            return searchOpenProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<ArchivedHumanTaskInstance> searchArchivedHumanTasks(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedTasks searchArchivedTasks = new SearchArchivedTasks(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getArchivedHumanTaskInstanceDescriptor(), searchOptions);
        try {
            searchArchivedTasks.execute();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
        return searchArchivedTasks.getResult();
    }

    public SearchResult<HumanTaskInstance> searchAssignedTasksManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchAssignedTaskManagedBy searchAssignedTaskManagedBy = new SearchAssignedTaskManagedBy(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getHumanTaskInstanceDescriptor(), managerUserId, searchOptions);
        try {
            searchAssignedTaskManagedBy.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchAssignedTaskManagedBy.getResult();
    }

    public SearchResult<ArchivedProcessInstance> searchArchivedProcessInstancesSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedProcessInstancesSupervisedBy searchArchivedProcessInstances = new SearchArchivedProcessInstancesSupervisedBy(userId, processInstanceService, searchEntitiesDescriptor.getArchivedProcessInstancesDescriptor(), searchOptions);
        try {
            searchArchivedProcessInstances.execute();
            return searchArchivedProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<ArchivedProcessInstance> searchArchivedProcessInstancesInvolvingUser(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchArchivedProcessInstancesInvolvingUser searchArchivedProcessInstances = new SearchArchivedProcessInstancesInvolvingUser(userId, processInstanceService, searchEntitiesDescriptor.getArchivedProcessInstancesDescriptor(), searchOptions);
        try {
            searchArchivedProcessInstances.execute();
            return searchArchivedProcessInstances.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<HumanTaskInstance> searchPendingTasksForUser(long userId, SearchOptions searchOptions) throws SearchException {
        return this.searchTasksForUser(userId, searchOptions, false);
    }

    private SearchResult<HumanTaskInstance> searchTasksForUser(long userId, SearchOptions searchOptions, boolean orAssignedToUser) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchPendingTasksForUser searchPendingTasksForUser = new SearchPendingTasksForUser(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getHumanTaskInstanceDescriptor(), userId, searchOptions, orAssignedToUser);
        try {
            searchPendingTasksForUser.execute();
            return searchPendingTasksForUser.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<HumanTaskInstance> searchMyAvailableHumanTasks(long userId, SearchOptions searchOptions) throws SearchException {
        return this.searchTasksForUser(userId, searchOptions, true);
    }

    public SearchResult<HumanTaskInstance> searchPendingTasksSupervisedBy(long userId, SearchOptions searchOptions) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchPendingTasksSupervisedBy searchPendingTasksSupervisedBy = new SearchPendingTasksSupervisedBy(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getHumanTaskInstanceDescriptor(), userId, searchOptions);
        try {
            searchPendingTasksSupervisedBy.execute();
            return searchPendingTasksSupervisedBy.getResult();
        }
        catch (SBonitaException sbe) {
            throw new BonitaRuntimeException((Throwable)sbe);
        }
    }

    public SearchResult<Comment> searchComments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SCommentService commentService = tenantAccessor.getCommentService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchComments searchComments = new SearchComments(searchEntitiesDescriptor.getCommentDescriptor(), searchOptions, commentService);
        try {
            searchComments.execute();
            return searchComments.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public Comment addProcessComment(long processInstanceId, String comment) throws CreationException {
        try {
            return this.addComment(processInstanceId, comment);
        }
        catch (RetrieveException e) {
            throw new CreationException("Cannot add a comment on a finished or inexistant process instance", e.getCause());
        }
    }

    @Deprecated
    public Comment addComment(long processInstanceId, String comment) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        try {
            tenantAccessor.getProcessInstanceService().getProcessInstance(processInstanceId);
        }
        catch (SProcessInstanceReadException e) {
            throw new RetrieveException("Cannot add a comment on a finished or inexistant process instance", (Throwable)e);
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new RetrieveException("Cannot add a comment on a finished or inexistant process instance", (Throwable)e);
        }
        SCommentService commentService = tenantAccessor.getCommentService();
        AddComment addComment = new AddComment(commentService, processInstanceId, comment);
        try {
            addComment.execute();
            SComment sComment = addComment.getResult();
            return ModelConvertor.toComment(sComment);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<Comment> getComments(long processInstanceId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SCommentService commentService = tenantAccessor.getCommentService();
        try {
            List<SComment> sComments = commentService.getComments(processInstanceId);
            return ModelConvertor.toComments(sComments);
        }
        catch (SBonitaReadException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public Document attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, String url) throws DocumentAttachmentException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SProcessDocumentBuilders documentBuilders = tenantAccessor.getProcessDocumentBuilders();
        long author = SessionInfos.getUserIdFromSession();
        try {
            SProcessDocument document = this.attachDocument(processInstanceId, documentName, fileName, mimeType, url, processDocumentService, documentBuilders, author);
            return ModelConvertor.toDocument(document);
        }
        catch (SBonitaException sbe) {
            throw new DocumentAttachmentException((Throwable)sbe);
        }
    }

    protected SProcessDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, String url, ProcessDocumentService processDocumentService, SProcessDocumentBuilders documentBuilders, long authorId) throws SBonitaException {
        SProcessDocument attachment = this.buildExternalProcessDocumentReference(documentBuilders, processInstanceId, documentName, fileName, mimeType, authorId, url);
        return processDocumentService.attachDocumentToProcessInstance(attachment);
    }

    private SProcessDocument buildExternalProcessDocumentReference(SProcessDocumentBuilders documentBuilders, long processInstanceId, String documentName, String fileName, String mimeType, long authorId, String url) {
        SProcessDocumentBuilder documentBuilder = documentBuilders.getSProcessDocumentBuilder();
        this.initDocumentBuilder(documentBuilder, processInstanceId, documentName, fileName, mimeType, authorId);
        documentBuilder.setURL(url);
        documentBuilder.setHasContent(false);
        return documentBuilder.done();
    }

    private SProcessDocument buildProcessDocument(SProcessDocumentBuilders documentBuilders, long processInstanceId, String documentName, String fileName, String mimetype, long authorId) {
        SProcessDocumentBuilder documentBuilder = documentBuilders.getSProcessDocumentBuilder();
        this.initDocumentBuilder(documentBuilder, processInstanceId, documentName, fileName, mimetype, authorId);
        documentBuilder.setHasContent(true);
        return documentBuilder.done();
    }

    private void initDocumentBuilder(SProcessDocumentBuilder documentBuilder, long processInstanceId, String documentName, String fileName, String mimetype, long authorId) {
        documentBuilder.createNewInstance();
        documentBuilder.setName(documentName);
        documentBuilder.setFileName(fileName);
        documentBuilder.setContentMimeType(mimetype);
        documentBuilder.setProcessInstanceId(processInstanceId);
        documentBuilder.setAuthor(authorId);
        documentBuilder.setCreationDate(System.currentTimeMillis());
    }

    public Document attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, byte[] documentContent) throws DocumentAttachmentException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SProcessDocumentBuilders documentBuilders = tenantAccessor.getProcessDocumentBuilders();
        long authorId = SessionInfos.getUserIdFromSession();
        try {
            SProcessDocument document = this.attachDocument(processInstanceId, documentName, fileName, mimeType, documentContent, processDocumentService, documentBuilders, authorId);
            return ModelConvertor.toDocument(document);
        }
        catch (SBonitaException sbe) {
            throw new DocumentAttachmentException((Throwable)sbe);
        }
    }

    protected SProcessDocument attachDocument(long processInstanceId, String documentName, String fileName, String mimeType, byte[] documentContent, ProcessDocumentService processDocumentService, SProcessDocumentBuilders documentBuilders, long authorId) throws SBonitaException {
        SProcessDocument attachment = this.buildProcessDocument(documentBuilders, processInstanceId, documentName, fileName, mimeType, authorId);
        return processDocumentService.attachDocumentToProcessInstance(attachment, documentContent);
    }

    public Document attachNewDocumentVersion(long processInstanceId, String documentName, String fileName, String mimeType, String url) throws DocumentAttachmentException {
        ProcessAPIImpl.getTenantAccessor();
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SProcessDocumentBuilders documentBuilders = tenantAccessor.getProcessDocumentBuilders();
        long authorId = SessionInfos.getUserIdFromSession();
        try {
            SProcessDocument attachment = this.buildExternalProcessDocumentReference(documentBuilders, processInstanceId, documentName, fileName, mimeType, authorId, url);
            AttachDocumentVersion attachDocumentTransationContent = new AttachDocumentVersion(processDocumentService, attachment);
            attachDocumentTransationContent.execute();
            return ModelConvertor.toDocument(attachDocumentTransationContent.getResult());
        }
        catch (SBonitaException sbe) {
            throw new DocumentAttachmentException((Throwable)sbe);
        }
    }

    public Document attachNewDocumentVersion(long processInstanceId, String documentName, String contentFileName, String contentMimeType, byte[] documentContent) throws DocumentAttachmentException {
        ProcessAPIImpl.getTenantAccessor();
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SProcessDocumentBuilders documentBuilders = tenantAccessor.getProcessDocumentBuilders();
        long authorId = SessionInfos.getUserIdFromSession();
        try {
            SProcessDocument attachment = this.buildProcessDocument(documentBuilders, processInstanceId, documentName, contentFileName, contentMimeType, authorId);
            AttachDocumentVersionAndStoreContent attachDocumentTransationContent = new AttachDocumentVersionAndStoreContent(processDocumentService, attachment, documentContent);
            attachDocumentTransationContent.execute();
            return ModelConvertor.toDocument(attachDocumentTransationContent.getResult());
        }
        catch (SBonitaException sbe) {
            throw new DocumentAttachmentException((Throwable)sbe);
        }
    }

    public Document getDocument(long documentId) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            GetDocument attachDocumentTransationContent = new GetDocument(processDocumentService, documentId);
            attachDocumentTransationContent.execute();
            return ModelConvertor.toDocument(attachDocumentTransationContent.getResult());
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public List<Document> getLastVersionOfDocuments(long processInstanceId, int pageIndex, int numberPerPage, DocumentCriterion pagingCriterion) throws DocumentException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SDocumentMappingBuilderAccessor builder = tenantAccessor.getDocumentMappingBuilderAccessor();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForDocument(pagingCriterion, builder.getSDocumentMappingBuilder());
        try {
            GetDocumentsOfProcessInstance transationContent = new GetDocumentsOfProcessInstance(processDocumentService, processInstanceId, pageIndex, numberPerPage, orderAndField.getField(), orderAndField.getOrder());
            transationContent.execute();
            Object attachments = transationContent.getResult();
            if (attachments != null && !attachments.isEmpty()) {
                ArrayList<Document> result = new ArrayList<Document>(attachments.size());
                Iterator i$ = attachments.iterator();
                while (i$.hasNext()) {
                    SProcessDocument attachment = (SProcessDocument)i$.next();
                    result.add(ModelConvertor.toDocument(attachment));
                }
                return result;
            }
            return Collections.emptyList();
        }
        catch (SBonitaException sbe) {
            throw new DocumentException((Throwable)sbe);
        }
    }

    public byte[] getDocumentContent(String documentStorageId) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            GetDocumentContent transationContent = new GetDocumentContent(processDocumentService, documentStorageId);
            transationContent.execute();
            return transationContent.getResult();
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public Document getLastDocument(long processInstaneId, String documentName) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            GetDocumentByName transationContent = new GetDocumentByName(processDocumentService, processInstaneId, documentName);
            transationContent.execute();
            SProcessDocument attachment = transationContent.getResult();
            return ModelConvertor.toDocument(attachment);
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public long getNumberOfDocuments(long processInstanceId) throws DocumentException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            GetNumberOfDocumentsOfProcessInstance transationContent = new GetNumberOfDocumentsOfProcessInstance(processDocumentService, processInstanceId);
            transationContent.execute();
            return transationContent.getResult();
        }
        catch (SBonitaException sbe) {
            throw new DocumentException((Throwable)sbe);
        }
    }

    public Document getDocumentAtProcessInstantiation(long processInstanceId, String documentName) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SAProcessInstanceBuilder saProcessInstanceBuilder = tenantAccessor.getBPMInstanceBuilders().getSAProcessInstanceBuilder();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        try {
            GetDocumentByNameAtProcessInstantiation transationContent = new GetDocumentByNameAtProcessInstantiation(processDocumentService, processInstanceService, saProcessInstanceBuilder, searchEntitiesDescriptor, processInstanceId, documentName);
            transationContent.execute();
            SProcessDocument attachment = transationContent.getResult();
            return ModelConvertor.toDocument(attachment);
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public Document getDocumentAtActivityInstanceCompletion(long activityInstanceId, String documentName) throws DocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            GetDocumentByNameAtActivityCompletion transationContent = new GetDocumentByNameAtActivityCompletion(processDocumentService, activityInstanceId, documentName, activityInstanceService);
            transationContent.execute();
            SProcessDocument attachment = transationContent.getResult();
            return ModelConvertor.toDocument(attachment);
        }
        catch (SBonitaException sbe) {
            throw new DocumentNotFoundException((Throwable)sbe);
        }
    }

    public SearchResult<HumanTaskInstance> searchPendingTasksManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchPendingTasksManagedBy searchPendingTasksManagedBy = new SearchPendingTasksManagedBy(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getHumanTaskInstanceDescriptor(), managerUserId, searchOptions);
        try {
            searchPendingTasksManagedBy.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchPendingTasksManagedBy.getResult();
    }

    public Map<Long, Long> getNumberOfOverdueOpenTasks(List<Long> userIds) throws RetrieveException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            GetNumberOfOverdueOpenTasksForUsers transactionContent = new GetNumberOfOverdueOpenTasksForUsers(userIds, activityInstanceService);
            transactionContent.execute();
            return transactionContent.getResult();
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new RetrieveException(e.getMessage());
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfos(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getProcessDefinitionsDescriptor();
        SearchUncategorizedProcessDeploymentInfos transactionSearch = new SearchUncategorizedProcessDeploymentInfos(processDefinitionService, searchDescriptor, searchOptions);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Problem encountered while searching for Uncategorized Process Definitions", (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public SearchResult<Comment> searchCommentsManagedBy(long managerUserId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SCommentService commentService = tenantAccessor.getCommentService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchCommentsManagedBy searchComments = new SearchCommentsManagedBy(searchEntitiesDescriptor.getCommentDescriptor(), searchOptions, commentService, managerUserId);
        try {
            searchComments.execute();
            return searchComments.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public SearchResult<Comment> searchCommentsInvolvingUser(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SCommentService commentService = tenantAccessor.getCommentService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchCommentsInvolvingUser searchComments = new SearchCommentsInvolvingUser(searchEntitiesDescriptor.getCommentDescriptor(), searchOptions, commentService, userId);
        try {
            searchComments.execute();
            return searchComments.getResult();
        }
        catch (SBonitaException sbe) {
            throw new SearchException((Throwable)sbe);
        }
    }

    public List<Long> getChildrenInstanceIdsOfProcessInstance(long processInstanceId, int startIndex, int maxResults, ProcessInstanceCriterion criterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SAProcessInstanceBuilder modelBuilder = tenantAccessor.getBPMInstanceBuilders().getSAProcessInstanceBuilder();
        try {
            long totalNumber = processInstanceService.getNumberOfChildInstancesOfProcessInstance(processInstanceId);
            if (totalNumber == 0L) {
                return Collections.emptyList();
            }
            OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForProcessInstance(criterion, modelBuilder);
            return processInstanceService.getChildInstanceIdsOfProcessInstance(processInstanceId, startIndex, maxResults, orderAndField.getField(), orderAndField.getOrder());
        }
        catch (SProcessInstanceReadException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfosSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor searchDescriptor = searchEntitiesDescriptor.getProcessDefinitionsDescriptor();
        SearchUncategorizedProcessDeploymentInfosSupervisedBy transactionSearch = new SearchUncategorizedProcessDeploymentInfosSupervisedBy(processDefinitionService, searchDescriptor, searchOptions, userId);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException("Problem encountered while searching for Uncategorized Process Definitions for a supervisor", (Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromIds(List<Long> processDefinitionIds) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            GetProcessDeploymentInfosFromIds processDefinitions = new GetProcessDeploymentInfosFromIds(processDefinitionIds, processDefinitionService);
            processDefinitions.execute();
            List<ProcessDeploymentInfo> processDeploymentInfos = ModelConvertor.toProcessDeploymentInfo((List<SProcessDefinitionDeployInfo>)processDefinitions.getResult());
            HashMap<Long, ProcessDeploymentInfo> mProcessDefinitions = new HashMap<Long, ProcessDeploymentInfo>();
            for (ProcessDeploymentInfo p : processDeploymentInfos) {
                mProcessDefinitions.put(p.getProcessId(), p);
            }
            return mProcessDefinitions;
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ConnectorImplementationDescriptor> getConnectorImplementations(long processDefinitionId, int startIndex, int maxsResults, ConnectorCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        OrderAndField orderAndField = OrderAndFields.getOrderAndFieldForConnectorImplementation(sortingCriterion);
        GetConnectorImplementations transactionContent = new GetConnectorImplementations(connectorService, processDefinitionId, tenantAccessor.getTenantId(), startIndex, maxsResults, orderAndField.getField(), orderAndField.getOrder());
        try {
            transactionContent.execute();
            Object sConnectorImplementationDescriptors = transactionContent.getResult();
            return ModelConvertor.toConnectorImplementationDescriptors((List<SConnectorImplementationDescriptor>)sConnectorImplementationDescriptors);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long getNumberOfConnectorImplementations(long processDefinitionId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        GetNumberOfConnectorImplementations transactionContent = new GetNumberOfConnectorImplementations(connectorService, processDefinitionId, tenantAccessor.getTenantId());
        try {
            transactionContent.execute();
            return transactionContent.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<ActivityInstance> searchActivities(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchActivityInstances searchActivityInstancesTransaction = new SearchActivityInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getActivityInstanceDescriptor(), searchOptions);
        try {
            searchActivityInstancesTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchActivityInstancesTransaction.getResult();
    }

    public SearchResult<ArchivedFlowNodeInstance> searchArchivedFlowNodeInstances(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchArchivedFlowNodeInstances searchTransaction = new SearchArchivedFlowNodeInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getArchivedFlowNodeInstanceDescriptor(), searchOptions);
        try {
            searchTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchTransaction.getResult();
    }

    public SearchResult<FlowNodeInstance> searchFlowNodeInstances(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchFlowNodeInstances searchFlowNodeInstancesTransaction = new SearchFlowNodeInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getFlowNodeInstanceDescriptor(), searchOptions);
        try {
            searchFlowNodeInstancesTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchFlowNodeInstancesTransaction.getResult();
    }

    public SearchResult<ArchivedActivityInstance> searchArchivedActivities(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchArchivedActivityInstances searchActivityInstancesTransaction = new SearchArchivedActivityInstances(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getArchivedActivityInstanceDescriptor(), searchOptions);
        try {
            searchActivityInstancesTransaction.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchActivityInstancesTransaction.getResult();
    }

    public ConnectorImplementationDescriptor getConnectorImplementation(long processDefinitionId, String connectorId, String connectorVersion) throws ConnectorNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ConnectorService connectorService = tenantAccessor.getConnectorService();
        GetConnectorImplementation transactionContent = new GetConnectorImplementation(connectorService, processDefinitionId, connectorId, connectorVersion, tenantAccessor.getTenantId());
        try {
            transactionContent.execute();
            SConnectorImplementationDescriptor sConnectorImplementationDescriptor = transactionContent.getResult();
            return ModelConvertor.toConnectorImplementationDescriptor(sConnectorImplementationDescriptor);
        }
        catch (SBonitaException e) {
            throw new ConnectorNotFoundException((Throwable)e);
        }
    }

    public void cancelProcessInstance(long processInstanceId) throws RetrieveException, UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        BPMInstanceBuilders bpmInstanceBuilders = tenantAccessor.getBPMInstanceBuilders();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        LockService lockService = tenantAccessor.getLockService();
        TransactionalProcessInstanceInterruptor processInstanceInterruptor = new TransactionalProcessInstanceInterruptor(bpmInstanceBuilders, processInstanceService, activityInstanceService, processExecutor, tenantAccessor.getTechnicalLoggerService());
        String objectType = SFlowElementsContainerType.PROCESS.name();
        BonitaLock lock = null;
        try {
            lock = lockService.lock(processInstanceId, objectType, tenantAccessor.getTenantId());
            processInstanceInterruptor.interruptProcessInstance(processInstanceId, SStateCategory.CANCELLING, SessionInfos.getUserIdFromSession());
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
        finally {
            try {
                lockService.unlock(lock, tenantAccessor.getTenantId());
            }
            catch (SLockException e) {}
        }
    }

    public void setProcessInstanceState(ProcessInstance processInstance, String state) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            ProcessInstanceState processInstanceState = ModelConvertor.getProcessInstanceState(state);
            SetProcessInstanceState transactionContent = new SetProcessInstanceState(processInstanceService, processInstance.getId(), processInstanceState);
            transactionContent.execute();
        }
        catch (SBonitaException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromProcessInstanceIds(List<Long> processInstantsIds) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinitionDeployInfoFromProcessInstanceIds processDefinitions = new GetProcessDefinitionDeployInfoFromProcessInstanceIds(processInstantsIds, processDefinitionService);
        try {
            processDefinitions.execute();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        Object sProcessDeploymentInfos = processDefinitions.getResult();
        return this.getProcessDeploymentInfosFromMap((List<Map<String, String>>)sProcessDeploymentInfos);
    }

    private Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromMap(List<Map<String, String>> sProcessDeploymentInfos) {
        HashMap<Long, ProcessDeploymentInfo> mProcessDeploymentInfos = new HashMap<Long, ProcessDeploymentInfo>();
        long processInstanceId = 0L;
        long id = 0L;
        long processDefinitionId = 0L;
        String name = "";
        String version = "";
        String description = "";
        long deploymentDate = 0L;
        long deployedBy = 0L;
        ActivationState activationState = null;
        ConfigurationState configurationState = null;
        String displayName = "";
        long lastUpdateDate = 0L;
        String iconPath = "";
        String displayDescription = "";
        for (Map<String, String> m : sProcessDeploymentInfos) {
            for (Map.Entry<String, String> entry : m.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if ("processInstanceId".equals(key)) {
                    processInstanceId = Long.parseLong(value.toString());
                    continue;
                }
                if ("id".equals(key)) {
                    id = Long.parseLong(value.toString());
                    continue;
                }
                if ("processId".equals(key)) {
                    processDefinitionId = Long.parseLong(value.toString());
                    continue;
                }
                if ("name".equals(key)) {
                    name = m.get(key);
                    continue;
                }
                if ("version".equals(key)) {
                    version = m.get(key);
                    continue;
                }
                if ("description".equals(key)) {
                    description = String.valueOf(m.get(key));
                    continue;
                }
                if ("deploymentDate".equals(key)) {
                    deploymentDate = Long.parseLong(value.toString());
                    continue;
                }
                if ("deployedBy".equals(key)) {
                    deployedBy = Long.parseLong(value.toString());
                    continue;
                }
                if ("activationState".equals(key)) {
                    activationState = ActivationState.valueOf((String)m.get(key));
                    continue;
                }
                if ("configurationState".equals(key)) {
                    configurationState = ConfigurationState.valueOf((String)m.get(key));
                    continue;
                }
                if ("displayName".equals(key)) {
                    displayName = m.get(key);
                    continue;
                }
                if ("lastUpdateDate".equals(key)) {
                    lastUpdateDate = Long.parseLong(value.toString());
                    continue;
                }
                if ("iconPath".equals(key)) {
                    iconPath = m.get(key);
                    continue;
                }
                if (!"displayDescription".equals(key)) continue;
                displayDescription = String.valueOf(m.get(key));
            }
            ProcessDeploymentInfoImpl pDeplInfoImpl = new ProcessDeploymentInfoImpl(id, processDefinitionId, name, version, description, new Date(deploymentDate), deployedBy, activationState, configurationState, displayName, new Date(lastUpdateDate), iconPath, displayDescription);
            mProcessDeploymentInfos.put(processInstanceId, (ProcessDeploymentInfo)pDeplInfoImpl);
        }
        return mProcessDeploymentInfos;
    }

    public SearchResult<Document> searchDocuments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SearchDocuments searchDocuments = new SearchDocuments(processDocumentService, searchEntitiesDescriptor.getDocumentDescriptor(), searchOptions);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public SearchResult<Document> searchDocumentsSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SearchDocumentsSupervisedBy searchDocuments = new SearchDocumentsSupervisedBy(processDocumentService, searchEntitiesDescriptor.getDocumentDescriptor(), searchOptions, userId);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public SearchResult<ArchivedDocument> searchArchivedDocuments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SearchArchivedDocuments searchDocuments = new SearchArchivedDocuments(processDocumentService, searchEntitiesDescriptor.getArchivedDocumentDescriptor(), searchOptions);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public SearchResult<ArchivedDocument> searchArchivedDocumentsSupervisedBy(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        SearchArchivedDocumentsSupervisedBy searchDocuments = new SearchArchivedDocumentsSupervisedBy(userId, processDocumentService, searchEntitiesDescriptor.getArchivedDocumentDescriptor(), searchOptions);
        try {
            searchDocuments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchDocuments.getResult();
    }

    public void retryTask(long activityInstanceId) throws ActivityExecutionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        FlowNodeExecutor flowNodeExecutor = tenantAccessor.getFlowNodeExecutor();
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        SAutomaticTaskInstanceBuilder keyProvider = tenantAccessor.getBPMInstanceBuilders().getSAutomaticTaskInstanceBuilder();
        try {
            SFlowNodeInstance activity = activityInstanceService.getFlowNodeInstance(activityInstanceId);
            long processDefinitionId = activity.getLogicalGroup(keyProvider.getProcessDefinitionIndex());
            FlowNodeState flowNodeState = flowNodeStateManager.getState(activity.getStateId());
            int stateId = activity.getPreviousStateId();
            FlowNodeState state = flowNodeStateManager.getState(stateId);
            if (!"failed".equals(flowNodeState.getName())) {
                throw new ActivityExecutionException("Unable to retry a task that is not failed - task name=" + activity.getName() + " id=" + activityInstanceId + " that was in state " + flowNodeState);
            }
            flowNodeExecutor.setStateByStateId(processDefinitionId, activity.getId(), stateId);
            if (!state.isTerminal()) {
                long userIdFromSession = SessionInfos.getUserIdFromSession();
                processExecutor.executeFlowNode(activityInstanceId, null, null, activity.getParentProcessInstanceId(), userIdFromSession, userIdFromSession);
            }
        }
        catch (SBonitaException e) {
            throw new ActivityExecutionException((Throwable)e);
        }
    }

    public ArchivedDocument getArchivedVersionOfProcessDocument(long sourceObjectId) throws ArchivedDocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        GetArchivedDocument getArchivedDocument = new GetArchivedDocument(processDocumentService, sourceObjectId);
        try {
            getArchivedDocument.execute();
        }
        catch (SBonitaException e) {
            throw new ArchivedDocumentNotFoundException((Throwable)e);
        }
        return ModelConvertor.toArchivedDocument(getArchivedDocument.getResult());
    }

    public ArchivedDocument getArchivedProcessDocument(long archivedProcessDocumentId) throws ArchivedDocumentNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDocumentService processDocumentService = tenantAccessor.getProcessDocumentService();
        try {
            SAProcessDocument archivedDocument = processDocumentService.getArchivedDocument(archivedProcessDocumentId);
            return ModelConvertor.toArchivedDocument(archivedDocument);
        }
        catch (SDocumentNotFoundException e) {
            throw new ArchivedDocumentNotFoundException((Throwable)e);
        }
    }

    public SearchResult<ArchivedComment> searchArchivedComments(SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SCommentService sCommentService = tenantAccessor.getCommentService();
        SearchArchivedComments searchArchivedComments = new SearchArchivedComments(sCommentService, searchEntitiesDescriptor.getArchivedCommentsDescriptor(), searchOptions);
        try {
            searchArchivedComments.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchArchivedComments.getResult();
    }

    public ArchivedComment getArchivedComment(long archivedCommentId) throws RetrieveException, NotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SCommentService sCommentService = tenantAccessor.getCommentService();
        try {
            SAComment archivedComment = sCommentService.getArchivedComment(archivedCommentId);
            return ModelConvertor.toArchivedComment(archivedComment);
        }
        catch (SCommentNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public Map<Long, ActorInstance> getActorsFromActorIds(List<Long> actorIds) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        HashMap<Long, ActorInstance> res = new HashMap<Long, ActorInstance>();
        ActorMappingService actormappingService = tenantAccessor.getActorMappingService();
        GetActorsByActorIds getActorsByActorIds = new GetActorsByActorIds(actormappingService, actorIds);
        try {
            getActorsByActorIds.execute();
        }
        catch (SBonitaException e1) {
            throw new RetrieveException((Throwable)e1);
        }
        Object actors = getActorsByActorIds.getResult();
        Iterator i$ = actors.iterator();
        while (i$.hasNext()) {
            SActor actor = (SActor)i$.next();
            res.put(actor.getId(), ModelConvertor.toActorInstance(actor));
        }
        return res;
    }

    public Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromArchivedProcessInstanceIds(List<Long> archivedProcessInstantsIds) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        GetProcessDefinitionDeployInfoFromArchivedProcessInstanceIds getProcessDeploymentInfoFromArchivedProcessInstanceIds = new GetProcessDefinitionDeployInfoFromArchivedProcessInstanceIds(archivedProcessInstantsIds, processDefinitionService);
        try {
            getProcessDeploymentInfoFromArchivedProcessInstanceIds.execute();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        Object sProcessDeploymentInfos = getProcessDeploymentInfoFromArchivedProcessInstanceIds.getResult();
        if (sProcessDeploymentInfos != null && !sProcessDeploymentInfos.isEmpty()) {
            HashMap<Long, ProcessDeploymentInfo> processDeploymentInfos = new HashMap<Long, ProcessDeploymentInfo>();
            Set entries = sProcessDeploymentInfos.entrySet();
            for (Map.Entry entry : entries) {
                processDeploymentInfos.put((Long)entry.getKey(), ModelConvertor.toProcessDeploymentInfo((SProcessDefinitionDeployInfo)entry.getValue()));
            }
            return processDeploymentInfos;
        }
        return Collections.emptyMap();
    }

    public SearchResult<HumanTaskInstance> searchPendingHiddenTasks(long userId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        SearchPendingHiddenTasks searchHiddenTasksTx = new SearchPendingHiddenTasks(activityInstanceService, flowNodeStateManager, searchEntitiesDescriptor.getHumanTaskInstanceDescriptor(), userId, searchOptions);
        try {
            searchHiddenTasksTx.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return searchHiddenTasksTx.getResult();
    }

    public void hideTasks(long userId, Long ... activityInstanceId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        HideTasks hideTasksTx = new HideTasks(tenantAccessor.getActivityInstanceService(), userId, activityInstanceId);
        try {
            hideTasksTx.execute();
        }
        catch (SBonitaException e) {
            throw new UpdateException("Error while trying to hide tasks: " + Arrays.toString((Object[])activityInstanceId) + " from user with ID " + userId, (Throwable)e);
        }
    }

    public void unhideTasks(long userId, Long ... activityInstanceId) throws UpdateException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        UnhideTasks unhideTasksTx = new UnhideTasks(tenantAccessor.getActivityInstanceService(), userId, activityInstanceId);
        try {
            unhideTasksTx.execute();
        }
        catch (SBonitaException e) {
            throw new UpdateException("Error while trying to un-hide tasks: " + Arrays.toString((Object[])activityInstanceId) + " from user with ID " + userId, (Throwable)e);
        }
    }

    public Serializable evaluateExpressionOnProcessDefinition(Expression expression, Map<String, Serializable> context, long processDefinitionId) throws ExpressionEvaluationException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ExpressionResolverService expressionResolverService = tenantAccessor.getExpressionResolverService();
        SExpressionBuilders sExpressionBuilders = tenantAccessor.getSExpressionBuilders();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SExpression sExpression = ServerModelConvertor.convertExpression(sExpressionBuilders, expression);
        SExpressionContext expcontext = new SExpressionContext();
        expcontext.setProcessDefinitionId(processDefinitionId);
        try {
            SProcessDefinition processDef = processDefinitionService.getProcessDefinition(processDefinitionId);
            if (processDef != null) {
                expcontext.setProcessDefinition(processDef);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(context);
            expcontext.setInputValues(hashMap);
            return (Serializable)expressionResolverService.evaluate(sExpression, expcontext);
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
    }

    public void updateDueDateOfTask(long userTaskId, Date dueDate) throws UpdateException {
        if (dueDate == null) {
            throw new UpdateException("Unable to update a due date to null");
        }
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            SetExpectedEndDate updateProcessInstance = new SetExpectedEndDate(activityInstanceService, userTaskId, dueDate);
            updateProcessInstance.execute();
        }
        catch (SFlowNodeNotFoundException e) {
            throw new UpdateException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new UpdateException((Throwable)e);
        }
    }

    public boolean isTaskHidden(long userTaskId, long userId) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        IsTaskHidden hideTasksTx = new IsTaskHidden(tenantAccessor.getActivityInstanceService(), userId, userTaskId);
        try {
            hideTasksTx.execute();
            return hideTasksTx.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long countComments(SearchOptions searchOptions) throws SearchException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 0).setFilters(searchOptions.getFilters()).searchTerm(searchOptions.getSearchTerm());
        SearchResult<Comment> searchResult = this.searchComments(searchOptionsBuilder.done());
        return searchResult.getCount();
    }

    public long countAttachments(SearchOptions searchOptions) throws SearchException {
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 0).setFilters(searchOptions.getFilters()).searchTerm(searchOptions.getSearchTerm());
        SearchResult<Document> searchResult = this.searchDocuments(searchOptionsBuilder.done());
        return searchResult.getCount();
    }

    public void sendSignal(String signalName) throws SendEventException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        EventsHandler eventsHandler = tenantAccessor.getEventsHandler();
        SThrowSignalEventTriggerDefinitionBuilder signalEventTriggerDefinitionBuilder = tenantAccessor.getBPMDefinitionBuilders().getThrowSignalEventTriggerDefinitionBuilder();
        SThrowSignalEventTriggerDefinition signalEventTriggerDefinition = signalEventTriggerDefinitionBuilder.createNewInstance(signalName).done();
        try {
            eventsHandler.handleThrowEvent(signalEventTriggerDefinition);
        }
        catch (SBonitaException e) {
            throw new SendEventException((Throwable)e);
        }
    }

    public void sendMessage(String messageName, Expression targetProcess, Expression targetFlowNode, Map<Expression, Expression> messageContent) throws SendEventException {
        this.sendMessage(messageName, targetProcess, targetFlowNode, messageContent, null);
    }

    public void sendMessage(String messageName, Expression targetProcess, Expression targetFlowNode, Map<Expression, Expression> messageContent, Map<Expression, Expression> correlations) throws SendEventException {
        if (correlations != null && correlations.size() > 5) {
            throw new SendEventException("Too many correlations: a message can not have more than 5 correlations.");
        }
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        EventsHandler eventsHandler = tenantAccessor.getEventsHandler();
        SExpressionBuilders sExpressionBuilders = tenantAccessor.getSExpressionBuilders();
        SDataDefinitionBuilders sDataDefinitionBuilders = tenantAccessor.getSDataDefinitionBuilders();
        ExpressionResolverService expressionResolverService = tenantAccessor.getExpressionResolverService();
        SThrowMessageEventTriggerDefinitionBuilder messageEventTriggerDefinitionBuilder = tenantAccessor.getBPMDefinitionBuilders().getThrowMessageEventTriggerDefinitionBuilder();
        SExpression targetProcessNameExp = ServerModelConvertor.convertExpression(sExpressionBuilders, targetProcess);
        SExpression targetFlowNodeNameExp = null;
        if (targetFlowNode != null) {
            targetFlowNodeNameExp = ServerModelConvertor.convertExpression(sExpressionBuilders, targetFlowNode);
        }
        messageEventTriggerDefinitionBuilder.createNewInstance(messageName, targetProcessNameExp, targetFlowNodeNameExp);
        if (correlations != null && !correlations.isEmpty()) {
            this.addMessageCorrelations(messageEventTriggerDefinitionBuilder, sExpressionBuilders, correlations);
        }
        try {
            if (messageContent != null && !messageContent.isEmpty()) {
                this.addMessageContent(messageEventTriggerDefinitionBuilder, sExpressionBuilders, sDataDefinitionBuilders, expressionResolverService, messageContent);
            }
            SThrowMessageEventTriggerDefinition messageEventTriggerDefinition = messageEventTriggerDefinitionBuilder.done();
            eventsHandler.handleThrowEvent(messageEventTriggerDefinition);
        }
        catch (SBonitaException e) {
            throw new SendEventException((Throwable)e);
        }
    }

    private void addMessageContent(SThrowMessageEventTriggerDefinitionBuilder messageEventTriggerDefinitionBuilder, SExpressionBuilders sExpressionBuilders, SDataDefinitionBuilders sDataDefinitionBuilders, ExpressionResolverService expressionResolverService, Map<Expression, Expression> messageContent) throws SBonitaException {
        for (Map.Entry<Expression, Expression> entry : messageContent.entrySet()) {
            expressionResolverService.evaluate(ServerModelConvertor.convertExpression(sExpressionBuilders, entry.getKey()));
            SDataDefinitionBuilder dataDefinitionBuilder = sDataDefinitionBuilders.getDataDefinitionBuilder().createNewInstance(entry.getKey().getContent(), entry.getValue().getReturnType());
            dataDefinitionBuilder.setDefaultValue(ServerModelConvertor.convertExpression(sExpressionBuilders, entry.getValue()));
            messageEventTriggerDefinitionBuilder.addData(dataDefinitionBuilder.done());
        }
    }

    private void addMessageCorrelations(SThrowMessageEventTriggerDefinitionBuilder messageEventTriggerDefinitionBuilder, SExpressionBuilders sExpressionBuilders, Map<Expression, Expression> messageCorrelations) {
        for (Map.Entry<Expression, Expression> entry : messageCorrelations.entrySet()) {
            messageEventTriggerDefinitionBuilder.addCorrelation(ServerModelConvertor.convertExpression(sExpressionBuilders, entry.getKey()), ServerModelConvertor.convertExpression(sExpressionBuilders, entry.getValue()));
        }
    }

    public List<Problem> getProcessResolutionProblems(long processDefinitionId) throws ProcessDefinitionNotFoundException {
        SProcessDefinition processDefinition;
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        List<ProcessDependencyResolver> resolvers = tenantAccessor.getDependencyResolver().getResolvers();
        try {
            processDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        catch (SProcessDefinitionReadException e) {
            throw new ProcessDefinitionNotFoundException((Throwable)e);
        }
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (ProcessDependencyResolver resolver : resolvers) {
            List<Problem> problem = resolver.checkResolution(tenantAccessor, processDefinition);
            if (problem == null) continue;
            problems.addAll(problem);
        }
        return problems;
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfos(int startIndex, int maxResults, ProcessDeploymentInfoCriterion pagingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfos transactionContentWithResult = new GetProcessDefinitionDeployInfos(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, pagingCriterion);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForGroup(long groupId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForGroup transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForGroup(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, groupId);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForGroups(List<Long> groupIds, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForGroups transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForGroups(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, groupIds);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForRole(long roleId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForRole transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForRole(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, roleId);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForRoles(List<Long> roleIds, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForRoles transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForRoles(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, roleIds);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForUser(long userId, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForUser transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForUser(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, userId);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForUsers(List<Long> userIds, int startIndex, int maxResults, ProcessDeploymentInfoCriterion sortingCriterion) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchProcessDefinitionsDescriptor processDefinitionsDescriptor = tenantAccessor.getSearchEntitiesDescriptor().getProcessDefinitionsDescriptor();
        GetProcessDefinitionDeployInfosWithActorOnlyForUsers transactionContentWithResult = new GetProcessDefinitionDeployInfosWithActorOnlyForUsers(processDefinitionService, processDefinitionsDescriptor, startIndex, maxResults, sortingCriterion, userIds);
        try {
            transactionContentWithResult.execute();
            return transactionContentWithResult.getResult();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public SearchResult<ConnectorInstance> searchConnectorInstances(SearchOptions searchOptions) throws RetrieveException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ConnectorInstanceService connectorInstanceService = tenantAccessor.getConnectorInstanceService();
        SearchConnectorInstances searchConnector = new SearchConnectorInstances(connectorInstanceService, searchEntitiesDescriptor.getConnectorInstanceDescriptor(), searchOptions);
        try {
            searchConnector.execute();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return searchConnector.getResult();
    }

    public SearchResult<ArchivedConnectorInstance> searchArchivedConnectorInstances(SearchOptions searchOptions) throws RetrieveException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        ConnectorInstanceService connectorInstanceService = tenantAccessor.getConnectorInstanceService();
        ArchiveService archiveService = tenantAccessor.getArchiveService();
        ReadPersistenceService persistenceService = archiveService.getDefinitiveArchiveReadPersistenceService();
        SearchArchivedConnectorInstance searchArchivedConnectorInstance = new SearchArchivedConnectorInstance(connectorInstanceService, searchEntitiesDescriptor.getArchivedConnectorInstanceDescriptor(), searchOptions, persistenceService);
        try {
            searchArchivedConnectorInstance.execute();
        }
        catch (SBonitaException e) {
            throw new RetrieveException((Throwable)e);
        }
        return searchArchivedConnectorInstance.getResult();
    }

    public List<HumanTaskInstance> getHumanTaskInstances(long processInstanceId, String taskName, int startIndex, int maxResults) {
        try {
            return this.getHumanTaskInstances(processInstanceId, taskName, startIndex, maxResults, "processInstanceId", Order.ASC);
        }
        catch (NotFoundException e) {
            return Collections.emptyList();
        }
    }

    public HumanTaskInstance getLastStateHumanTaskInstance(long processInstanceId, String taskName) throws NotFoundException {
        return this.getHumanTaskInstances(processInstanceId, taskName, 0, 1, "reachedStateDate", Order.DESC).get(0);
    }

    private List<HumanTaskInstance> getHumanTaskInstances(long processInstanceId, String taskName, int startIndex, int maxResults, String field, Order order) throws NotFoundException {
        SearchOptionsBuilder builder = new SearchOptionsBuilder(startIndex, maxResults);
        builder.filter("processInstanceId", (Serializable)Long.valueOf(processInstanceId)).filter("name", (Serializable)((Object)taskName));
        builder.sort(field, order);
        try {
            SearchResult<HumanTaskInstance> searchHumanTasks = this.searchHumanTaskInstances(builder.done());
            if (searchHumanTasks.getCount() == 0L) {
                throw new NotFoundException("Task '" + taskName + "' not found");
            }
            return searchHumanTasks.getResult();
        }
        catch (SearchException se) {
            throw new RetrieveException((Throwable)se);
        }
    }

    public SearchResult<User> searchUsersWhoCanStartProcessDefinition(long processDefinitionId, SearchOptions searchOptions) throws SearchException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchUserDescriptor searchDescriptor = searchEntitiesDescriptor.getUserDescriptor();
        SearchUsersWhoCanStartProcessDeploymentInfo transactionSearch = new SearchUsersWhoCanStartProcessDeploymentInfo(processDefinitionService, searchDescriptor, processDefinitionId, searchOptions);
        try {
            transactionSearch.execute();
        }
        catch (SBonitaException e) {
            throw new SearchException((Throwable)e);
        }
        return transactionSearch.getResult();
    }

    public Map<String, Serializable> evaluateExpressionsAtProcessInstanciation(long processInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        try {
            try {
                SProcessInstance processInstance = processInstanceService.getProcessInstance(processInstanceId);
                int stateId = processInstance.getStateId();
                if (stateId == 0 || stateId == 1) {
                    long evaluationDate = stateId == 0 ? System.currentTimeMillis() : processInstance.getStartDate();
                    return this.evaluateExpressionsInstanceLevelAndArchived(expressions, processInstanceId, CONTAINER_TYPE_PROCESS_INSTANCE, processInstance.getProcessDefinitionId(), evaluationDate);
                }
            }
            catch (SProcessInstanceNotFoundException spinfe) {
                // empty catch block
            }
            ArchivedProcessInstance archiveProcessInstance = this.getStartedArchivedProcessInstance(processInstanceId);
            Map<String, Serializable> evaluateExpressionInArchiveProcessInstance = this.evaluateExpressionsInstanceLevelAndArchived(expressions, processInstanceId, CONTAINER_TYPE_PROCESS_INSTANCE, archiveProcessInstance.getProcessDefinitionId(), archiveProcessInstance.getStartDate().getTime());
            return evaluateExpressionInArchiveProcessInstance;
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
    }

    public Map<String, Serializable> evaluateExpressionOnCompletedProcessInstance(long processInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            ArchivedProcessInstance lastArchivedProcessInstance = this.getLastArchivedProcessInstance(processInstanceId);
            return this.evaluateExpressionsInstanceLevelAndArchived(expressions, processInstanceId, CONTAINER_TYPE_PROCESS_INSTANCE, lastArchivedProcessInstance.getProcessDefinitionId(), lastArchivedProcessInstance.getArchiveDate().getTime());
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
    }

    public Map<String, Serializable> evaluateExpressionsOnProcessInstance(long processInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            return this.evaluateExpressionsInstanceLevel(expressions, processInstanceId, CONTAINER_TYPE_PROCESS_INSTANCE, this.getProcessInstance(processInstanceId).getProcessDefinitionId());
        }
        catch (BonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
    }

    public Map<String, Serializable> evaluateExpressionsOnProcessDefinition(long processDefinitionId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            return this.evaluateExpressionsDefinitionLevel(expressions, processDefinitionId);
        }
        catch (SProcessInstanceNotFoundException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
    }

    public Map<String, Serializable> evaluateExpressionsOnActivityInstance(long activityInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            ActivityInstance activityInstance = this.getActivityInstance(activityInstanceId);
            ProcessInstance processInstance = this.getProcessInstance(activityInstance.getParentProcessInstanceId());
            return this.evaluateExpressionsInstanceLevel(expressions, activityInstanceId, CONTAINER_TYPE_ACTIVITY_INSTANCE, processInstance.getProcessDefinitionId());
        }
        catch (BonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
    }

    public Map<String, Serializable> evaluateExpressionsOnCompletedActivityInstance(long activityInstanceId, Map<Expression, Map<String, Serializable>> expressions) throws ExpressionEvaluationException {
        try {
            ArchivedActivityInstance activityInstance = this.getArchivedActivityInstance(activityInstanceId);
            ArchivedProcessInstance lastArchivedProcessInstance = this.getLastArchivedProcessInstance(activityInstance.getParentContainerId());
            return this.evaluateExpressionsInstanceLevelAndArchived(expressions, activityInstanceId, CONTAINER_TYPE_ACTIVITY_INSTANCE, lastArchivedProcessInstance.getProcessDefinitionId(), activityInstance.getArchiveDate().getTime());
        }
        catch (ActivityInstanceNotFoundException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
        catch (SBonitaException e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
    }

    private Map<String, Serializable> evaluateExpressionsDefinitionLevel(Map<Expression, Map<String, Serializable>> expressionsAndTheirPartialContext, long processDefinitionId) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ExpressionResolverService expressionResolverService = tenantAccessor.getExpressionResolverService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        SExpressionBuilders expBuilder = tenantAccessor.getSExpressionBuilders();
        EvaluateExpressionsDefinitionLevel evaluations = new EvaluateExpressionsDefinitionLevel(expressionsAndTheirPartialContext, processDefinitionId, expressionResolverService, expBuilder, processDefinitionService);
        evaluations.execute();
        return evaluations.getResult();
    }

    private Map<String, Serializable> evaluateExpressionsInstanceLevel(Map<Expression, Map<String, Serializable>> expressions, long containerId, String containerType, long processDefinitionId) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ExpressionResolverService expressionService = tenantAccessor.getExpressionResolverService();
        SExpressionBuilders expBuilder = tenantAccessor.getSExpressionBuilders();
        EvaluateExpressionsInstanceLevel evaluations = new EvaluateExpressionsInstanceLevel(expressions, containerId, containerType, processDefinitionId, expressionService, expBuilder);
        evaluations.execute();
        return evaluations.getResult();
    }

    private Map<String, Serializable> evaluateExpressionsInstanceLevelAndArchived(Map<Expression, Map<String, Serializable>> expressions, long containerId, String containerType, long processDefinitionId, long time) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ExpressionResolverService expressionService = tenantAccessor.getExpressionResolverService();
        SExpressionBuilders expBuilder = tenantAccessor.getSExpressionBuilders();
        EvaluateExpressionsInstanceLevelAndArchived evaluations = new EvaluateExpressionsInstanceLevelAndArchived(expressions, containerId, containerType, processDefinitionId, time, expressionService, expBuilder);
        evaluations.execute();
        return evaluations.getResult();
    }

    private ArchivedProcessInstance getStartedArchivedProcessInstance(long processInstanceId) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        SearchOptionsBuilder searchOptionsBuilder = new SearchOptionsBuilder(0, 2);
        searchOptionsBuilder.sort("archiveDate", Order.ASC);
        searchOptionsBuilder.filter("sourceObjectId", (Serializable)Long.valueOf(processInstanceId));
        searchOptionsBuilder.filter("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.STARTED.getId()));
        SearchArchivedProcessInstances searchArchivedProcessInstances = new SearchArchivedProcessInstances(processInstanceService, searchEntitiesDescriptor.getArchivedProcessInstancesDescriptor(), searchOptionsBuilder.done());
        searchArchivedProcessInstances.execute();
        try {
            return (ArchivedProcessInstance)searchArchivedProcessInstances.getResult().getResult().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SAProcessInstanceNotFoundException(processInstanceId, ProcessInstanceState.STARTED.name());
        }
    }

    private ArchivedProcessInstance getLastArchivedProcessInstance(long processInstanceId) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        SearchEntitiesDescriptor searchEntitiesDescriptor = tenantAccessor.getSearchEntitiesDescriptor();
        GetLastArchivedProcessInstance searchArchivedProcessInstances = new GetLastArchivedProcessInstance(processInstanceService, processInstanceId, searchEntitiesDescriptor);
        searchArchivedProcessInstances.execute();
        return searchArchivedProcessInstances.getResult();
    }

    public List<FailedJob> getFailedJobs(int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        JobService jobService = tenantAccessor.getJobService();
        try {
            List<SFailedJob> failedJobs = jobService.getFailedJobs(startIndex, maxResults);
            return ModelConvertor.toFailedJobs(failedJobs);
        }
        catch (SSchedulerException sse) {
            throw new RetrieveException((Throwable)sse);
        }
    }

    public void replayFailedJob(long jobDescriptorId) throws ExecutionException {
        this.replayFailedJob(jobDescriptorId, null);
    }

    public void replayFailedJob(long jobDescriptorId, Map<String, Serializable> parameters) throws ExecutionException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        SchedulerService schedulerService = tenantAccessor.getSchedulerService();
        try {
            if (parameters == null || parameters.isEmpty()) {
                schedulerService.executeAgain(jobDescriptorId);
            } else {
                ArrayList<SJobParameter> jobParameters = new ArrayList<SJobParameter>();
                for (Map.Entry<String, Serializable> parameter : parameters.entrySet()) {
                    jobParameters.add(schedulerService.getJobParameterBuilder().createNewInstance(parameter.getKey(), parameter.getValue()).done());
                }
                schedulerService.executeAgain(jobDescriptorId, jobParameters);
            }
        }
        catch (SSchedulerException sse) {
            throw new ExecutionException((Throwable)sse);
        }
    }

    public ArchivedDataInstance getArchivedProcessDataInstance(String dataName, long processInstanceId) throws ArchivedDataNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        try {
            SADataInstance dataInstance = dataInstanceService.getLastSADataInstance(dataName, processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString());
            return ModelConvertor.toArchivedDataInstance(dataInstance);
        }
        catch (SDataInstanceException sdie) {
            throw new ArchivedDataNotFoundException((Throwable)sdie);
        }
    }

    public ArchivedDataInstance getArchivedActivityDataInstance(String dataName, long activityInstanceId) throws ArchivedDataNotFoundException {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        try {
            SADataInstance dataInstance = dataInstanceService.getLastSADataInstance(dataName, activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString());
            return ModelConvertor.toArchivedDataInstance(dataInstance);
        }
        catch (SDataInstanceException sdie) {
            throw new ArchivedDataNotFoundException((Throwable)sdie);
        }
    }

    public List<ArchivedDataInstance> getArchivedProcessDataInstances(long processInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        try {
            List<SADataInstance> dataInstances = dataInstanceService.getLastLocalSADataInstances(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString(), startIndex, maxResults);
            return ModelConvertor.toArchivedDataInstances(dataInstances);
        }
        catch (SDataInstanceException sdie) {
            throw new RetrieveException((Throwable)sdie);
        }
    }

    public List<ArchivedDataInstance> getArchivedActivityDataInstances(long activityInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        try {
            List<SADataInstance> dataInstances = dataInstanceService.getLastLocalSADataInstances(activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.toString(), startIndex, maxResults);
            return ModelConvertor.toArchivedDataInstances(dataInstances);
        }
        catch (SDataInstanceException sdie) {
            throw new RetrieveException((Throwable)sdie);
        }
    }

    public List<User> getPossibleUsersOfPendingHumanTask(long humanTaskInstanceId, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        try {
            List<Long> userIds = activityInstanceService.getPossibleUserIdsOfPendingTasks(humanTaskInstanceId, startIndex, maxResults);
            IdentityService identityService = ProcessAPIImpl.getTenantAccessor().getIdentityService();
            List<SUser> sUsers = identityService.getUsers(userIds);
            return ModelConvertor.toUsers(sUsers);
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }

    public List<User> getPossibleUsersOfHumanTask(long processDefinitionId, String humanTaskName, int startIndex, int maxResults) {
        TenantServiceAccessor tenantAccessor = ProcessAPIImpl.getTenantAccessor();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        try {
            SProcessDefinition processDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
            SFlowNodeDefinition flowNode = processDefinition.getProcessContainer().getFlowNode(humanTaskName);
            if (!(flowNode instanceof SHumanTaskDefinition)) {
                return Collections.emptyList();
            }
            SHumanTaskDefinition humanTask = (SHumanTaskDefinition)flowNode;
            String actorName = humanTask.getActorName();
            ActorMappingService actorMappingService = ProcessAPIImpl.getTenantAccessor().getActorMappingService();
            SActor actor = actorMappingService.getActor(actorName, processDefinitionId);
            List<Long> userIds = actorMappingService.getPossibleUserIdsOfActorId(actor.getId(), startIndex, maxResults);
            List<SUser> users = tenantAccessor.getIdentityService().getUsers(userIds);
            return ModelConvertor.toUsers(users);
        }
        catch (SProcessDefinitionNotFoundException spdnfe) {
            return Collections.emptyList();
        }
        catch (SBonitaException sbe) {
            throw new RetrieveException((Throwable)sbe);
        }
    }
}

