/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.command;

import org.bonitasoft.engine.command.CommandService;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.command.model.SCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;

public class GetTenantCommand
implements TransactionContentWithResult<TenantCommand> {
    private final CommandService commandService;
    private final String name;
    private long id = -1L;
    private TenantCommand tenantCommand;

    public GetTenantCommand(CommandService commandService, String name) {
        this.commandService = commandService;
        this.name = name;
    }

    public GetTenantCommand(CommandService commandService, long id) {
        this.commandService = commandService;
        this.id = id;
        this.name = null;
    }

    @Override
    public void execute() throws SBonitaException {
        try {
            SCommand sCommand = this.id != -1L ? this.commandService.get(this.id) : this.commandService.get(this.name);
            String tenantCommandClassName = sCommand.getImplementation();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            this.tenantCommand = (TenantCommand)contextClassLoader.loadClass(tenantCommandClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new SCommandParameterizationException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new SCommandParameterizationException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new SCommandParameterizationException(iae);
        }
    }

    @Override
    public TenantCommand getResult() {
        return this.tenantCommand;
    }
}

