/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.bpm.process.Problem;
import org.bonitasoft.engine.bpm.process.impl.ProblemImpl;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.connector.exception.SConnectorException;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;

public class CheckConnectorImplementations
implements TransactionContent {
    private final ConnectorService connectorService;
    private final long tenantId;
    private final SProcessDefinition sDefinition;
    private List<Problem> problems;

    public CheckConnectorImplementations(ConnectorService connectorService, long tenantId, SProcessDefinition sDefinition) {
        this.connectorService = connectorService;
        this.sDefinition = sDefinition;
        this.tenantId = tenantId;
    }

    @Override
    public void execute() {
        Set<SFlowNodeDefinition> flowNodes;
        this.problems = new ArrayList<Problem>();
        List<SConnectorDefinition> processConnectors = this.sDefinition.getProcessContainer().getConnectors();
        if (processConnectors != null) {
            for (SConnectorDefinition sConnectorDefinition : processConnectors) {
                try {
                    this.connectorService.getConnectorImplementation(this.sDefinition.getId(), sConnectorDefinition.getConnectorId(), sConnectorDefinition.getVersion(), this.tenantId);
                }
                catch (SConnectorException e) {
                    ProblemImpl problem = new ProblemImpl(Problem.Level.ERROR, sConnectorDefinition.getName(), "connector", "The process connector '" + sConnectorDefinition.getName() + "' has no implementation");
                    this.problems.add((Problem)problem);
                }
            }
        }
        if ((flowNodes = this.sDefinition.getProcessContainer().getFlowNodes()) != null) {
            for (SFlowNodeDefinition sFlowNodeDefinition : flowNodes) {
                List<SConnectorDefinition> flowNodeConnectors = sFlowNodeDefinition.getConnectors();
                if (flowNodeConnectors == null) continue;
                for (SConnectorDefinition sConnectorDefinition : flowNodeConnectors) {
                    try {
                        this.connectorService.getConnectorImplementation(this.sDefinition.getId(), sConnectorDefinition.getConnectorId(), sConnectorDefinition.getVersion(), this.tenantId);
                    }
                    catch (SConnectorException e) {
                        ProblemImpl problem = new ProblemImpl(Problem.Level.ERROR, sConnectorDefinition.getId().longValue(), "connector", "The connector '" + sConnectorDefinition.getName() + "' of flow node '" + sFlowNodeDefinition.getName() + "' has no implementation");
                        this.problems.add((Problem)problem);
                    }
                }
            }
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }
}

