/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.data;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.data.DataService;
import org.bonitasoft.engine.data.model.SDataSource;
import org.bonitasoft.engine.data.model.SDataSourceState;
import org.bonitasoft.engine.data.model.builder.SDataSourceModelBuilder;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;

public class CreateDefaultDataSource
implements TransactionContent {
    private final DataService dataService;
    private final SDataSourceModelBuilder sDataSourceModelBuilder;
    private final SessionService sessionService;
    private final long tenantId;
    private final String username;

    public CreateDefaultDataSource(SDataSourceModelBuilder sDataSourceModelBuilder, DataService dataService, SessionService sessionService, long tenantId, String username) {
        this.sDataSourceModelBuilder = sDataSourceModelBuilder;
        this.dataService = dataService;
        this.sessionService = sessionService;
        this.username = username;
        this.tenantId = tenantId;
    }

    @Override
    public void execute() throws SBonitaException {
        SSession session = this.sessionService.createSession(this.tenantId, this.username);
        SDataSource bonitaDataSource = this.sDataSourceModelBuilder.getDataSourceBuilder().createNewInstance("bonita_data_source", "6.0", SDataSourceState.ACTIVE, "org.bonitasoft.engine.data.instance.DataInstanceDataSourceImpl").done();
        this.dataService.createDataSource(bonitaDataSource);
        SDataSource transientDataSource = this.sDataSourceModelBuilder.getDataSourceBuilder().createNewInstance("bonita_transient_data_source", "6.0", SDataSourceState.ACTIVE, "org.bonitasoft.engine.core.data.instance.impl.TransientDataInstanceDataSource").done();
        this.dataService.createDataSource(transientDataSource);
        this.sessionService.deleteSession(session.getId());
    }
}

