/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.expression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.api.impl.transaction.expression.AbstractEvaluateExpressionsInstance;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilders;

public class EvaluateExpressionsDefinitionLevel
extends AbstractEvaluateExpressionsInstance
implements TransactionContentWithResult<Map<String, Serializable>> {
    private final Map<Expression, Map<String, Serializable>> expressionsAndTheirPartialContext;
    private final long processDefinitionId;
    private final ExpressionResolverService expressionResolver;
    private final ProcessDefinitionService processDefinitionService;
    private final SExpressionBuilders expBuilder;
    private final Map<String, Serializable> results = new HashMap<String, Serializable>(0);

    public EvaluateExpressionsDefinitionLevel(Map<Expression, Map<String, Serializable>> expressions, long processDefinitionId, ExpressionResolverService expressionResolverService, SExpressionBuilders expBuilder, ProcessDefinitionService processDefinitionService) {
        this.expressionsAndTheirPartialContext = expressions;
        this.processDefinitionId = processDefinitionId;
        this.expressionResolver = expressionResolverService;
        this.expBuilder = expBuilder;
        this.processDefinitionService = processDefinitionService;
    }

    @Override
    public void execute() throws SBonitaException {
        if (this.expressionsAndTheirPartialContext != null && !this.expressionsAndTheirPartialContext.isEmpty()) {
            SExpressionContext context = new SExpressionContext();
            if (this.processDefinitionId != 0L) {
                SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(this.processDefinitionId);
                Set<Expression> exps = this.expressionsAndTheirPartialContext.keySet();
                for (Expression exp : exps) {
                    Map<String, Serializable> inputValues = this.expressionsAndTheirPartialContext.get(exp);
                    if (inputValues == null) {
                        inputValues = new HashMap<String, Serializable>();
                    }
                    inputValues.put("processDefinition", processDefinition);
                    context.setProcessDefinitionId(this.processDefinitionId);
                    context.setSerializableInputValues(inputValues);
                    SExpression sexp = ServerModelConvertor.convertExpression(this.expBuilder, exp);
                    Serializable res = (Serializable)this.expressionResolver.evaluate(sexp, context);
                    this.results.put(this.buildName(exp), res);
                }
            }
        }
    }

    @Override
    public Map<String, Serializable> getResult() {
        return this.results;
    }
}

