/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.expression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.api.impl.transaction.expression.AbstractEvaluateExpressionsInstance;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilders;

public class EvaluateExpressionsInstanceLevel
extends AbstractEvaluateExpressionsInstance
implements TransactionContentWithResult<Map<String, Serializable>> {
    private final Map<Expression, Map<String, Serializable>> expressions;
    private final long containerId;
    private final long processDefinitionId;
    private final String containerType;
    private final ExpressionResolverService expressionResolver;
    private final SExpressionBuilders expBuilders;
    private final Map<String, Serializable> results = new HashMap<String, Serializable>(0);

    public EvaluateExpressionsInstanceLevel(Map<Expression, Map<String, Serializable>> expressions, long containerId, String containerType, long processDefinitionId, ExpressionResolverService expressionService, SExpressionBuilders expBuilder) {
        this.expressions = expressions;
        this.containerId = containerId;
        this.expressionResolver = expressionService;
        this.expBuilders = expBuilder;
        this.processDefinitionId = processDefinitionId;
        this.containerType = containerType;
    }

    @Override
    public void execute() throws SBonitaException {
        if (this.expressions != null && !this.expressions.isEmpty()) {
            SExpressionContext context = new SExpressionContext();
            context.setContainerId(this.containerId);
            context.setContainerType(this.containerType);
            context.setProcessDefinitionId(this.processDefinitionId);
            Set<Expression> exps = this.expressions.keySet();
            for (Expression exp : exps) {
                Map<String, Serializable> partialContext = this.expressions.get(exp);
                context.setSerializableInputValues(partialContext);
                SExpression sexp = ServerModelConvertor.convertExpression(this.expBuilders, exp);
                Serializable res = (Serializable)this.expressionResolver.evaluate(sexp, context);
                this.results.put(this.buildName(exp), res);
            }
        }
    }

    @Override
    public Map<String, Serializable> getResult() {
        return this.results;
    }
}

