/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.model.SPlatform;
import org.bonitasoft.engine.platform.model.SPlatformProperties;

public class CheckPlatformVersion
implements TransactionContent {
    private final PlatformService platformService;
    private boolean same;
    private SPlatform platform;
    private SPlatformProperties platformProperties;

    public CheckPlatformVersion(PlatformService platformService) {
        this.platformService = platformService;
    }

    @Override
    public void execute() throws SBonitaException {
        this.platform = this.platformService.getPlatform();
        this.platformProperties = this.platformService.getSPlatformProperties();
        String platformMinorVersion = this.format(this.platform.getVersion());
        String propertiesMinorVersion = this.format(this.platformProperties.getPlatformVersion());
        this.same = platformMinorVersion.equals(propertiesMinorVersion);
    }

    private String format(String version) {
        String trimVersion = version.trim();
        int endIndex = trimVersion.indexOf(".", 2);
        if (endIndex == -1) {
            return trimVersion;
        }
        return trimVersion.substring(0, endIndex);
    }

    public Boolean sameVersion() {
        return this.same;
    }

    public SPlatform getPlatform() {
        return this.platform;
    }

    public SPlatformProperties getPlatformProperties() {
        return this.platformProperties;
    }
}

