/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public final class EnableProcess
implements TransactionContent {
    private final ProcessDefinitionService processDefinitionService;
    private final long processId;
    private final EventsHandler eventsHandler;
    private final TechnicalLoggerService logger;
    private final String userName;

    public EnableProcess(ProcessDefinitionService processDefinitionService, long processId, EventsHandler eventsHandler, TechnicalLoggerService logger, String userName) {
        this.processDefinitionService = processDefinitionService;
        this.processId = processId;
        this.eventsHandler = eventsHandler;
        this.logger = logger;
        this.userName = userName;
    }

    @Override
    public void execute() throws SBonitaException {
        SProcessDefinition sProcessDefinition = this.processDefinitionService.getProcessDefinition(this.processId);
        this.handleStartEvents(sProcessDefinition);
        this.processDefinitionService.enableProcessDeploymentInfo(this.processId);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "The user <" + this.userName + "> has enabled process <" + sProcessDefinition.getName() + "> in version <" + sProcessDefinition.getVersion() + "> with id <" + sProcessDefinition.getId() + ">");
        }
    }

    private void handleStartEvents(SProcessDefinition sProcessDefinition) throws SBonitaException {
        SFlowElementContainerDefinition processContainer = sProcessDefinition.getProcessContainer();
        for (SStartEventDefinition sStartEventDefinition : processContainer.getStartEvents()) {
            this.eventsHandler.handleCatchEvent(sProcessDefinition, sStartEventDefinition, null);
        }
    }
}

