/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.internal.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.engine.io.IOUtil;

public abstract class ServletCall {
    private static final String BINARY_PARAMETER = "binaryParameter";
    private String inputStream = null;
    protected Map<String, String> parameters = null;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final List<byte[]> binaryParameters;
    private PrintWriter outputWriter = null;

    public ServletCall(HttpServletRequest request, HttpServletResponse response) throws FileUploadException, IOException {
        this.request = request;
        this.response = response;
        this.parameters = new HashMap<String, String>();
        this.binaryParameters = new ArrayList<byte[]>();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                try {
                    FileItemStream item = iter.next();
                    InputStream stream = item.openStream();
                    if (item.getFieldName().startsWith(BINARY_PARAMETER)) {
                        this.binaryParameters.add(IOUtil.getAllContentFrom((InputStream)stream));
                    } else {
                        String value = new String(IOUtil.getAllContentFrom((InputStream)stream));
                        this.parameters.put(item.getFieldName(), value);
                    }
                    stream.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new IOException(t);
                }
            }
        } else {
            Map parameterMap = this.request.getParameterMap();
            Set entrySet = parameterMap.entrySet();
            for (Map.Entry entry : entrySet) {
                this.parameters.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
        }
    }

    public List<byte[]> getBinaryParameters() {
        return this.binaryParameters;
    }

    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(obj);
        return b.toByteArray();
    }

    public Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream b = new ByteArrayInputStream(bytes);
        ObjectInputStream o = new ObjectInputStream(b);
        return o.readObject();
    }

    public HttpSession getHttpSession() {
        return this.request.getSession();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public final String getRequestURL() {
        return this.request.getRequestURL().toString();
    }

    public final String getInputStream() {
        if (this.inputStream == null) {
            try {
                BufferedReader reader = this.request.getReader();
                StringBuilder sb = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line + "\n");
                    line = reader.readLine();
                }
                reader.close();
                this.inputStream = sb.toString();
            }
            catch (IOException e) {
                throw new RuntimeException("Can't read input Stream.", e);
            }
        }
        return this.inputStream;
    }

    public final int countParameters() {
        return this.parameters.size();
    }

    public final List<String> getParameterAsList(String name) {
        return this.getParameterAsList(name, null);
    }

    public final List<String> getParameterAsList(String name, String defaultValue) {
        if (this.parameters.containsKey(name)) {
            return Arrays.asList(this.parameters.get(name));
        }
        if (defaultValue != null) {
            ArrayList<String> results = new ArrayList<String>();
            results.add(defaultValue);
            return results;
        }
        return null;
    }

    public final String getParameter(String name) {
        return this.getParameter(name, null);
    }

    public final String getParameter(String name, String defaultValue) {
        if (this.parameters.containsKey(name)) {
            return this.parameters.get(name);
        }
        return defaultValue;
    }

    protected final void head(String name, String value) {
        this.response.addHeader(name, value);
    }

    protected final void output(File file) {
        try {
            this.output(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            this.error("Can not download file.", 500);
        }
    }

    protected void output(InputStream stream, String filename) {
        this.response.addHeader("Content-Disposition", "attachment; filename=" + filename + ";");
        this.output(stream);
    }

    protected void output(InputStream stream) {
        this.response.setContentType("application/octet-stream");
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)this.response.getOutputStream());
        }
        catch (IOException e) {
            this.error("Can not download stream.", 500);
        }
    }

    protected void error(String message, int errorCode) {
        this.output(message);
        this.response.setStatus(errorCode);
    }

    protected final void output(String string) {
        PrintWriter outputWriter = this.getOutputWriter();
        outputWriter.print(string);
        outputWriter.flush();
    }

    protected final void output(Object object) {
        PrintWriter outputWriter = this.getOutputWriter();
        outputWriter.print(object.toString());
        outputWriter.flush();
    }

    private PrintWriter getOutputWriter() {
        if (this.outputWriter == null) {
            this.response.setContentType("application/json;charset=UTF-8");
            try {
                this.outputWriter = this.response.getWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.outputWriter;
    }

    public abstract void doGet();

    public abstract void doPost();

    public abstract void doPut();

    public abstract void doDelete();
}

