/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.category.impl;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.category.CategoryService;
import org.bonitasoft.engine.core.category.exception.SCategoryAlreadyExistsException;
import org.bonitasoft.engine.core.category.exception.SCategoryCreationException;
import org.bonitasoft.engine.core.category.exception.SCategoryDeletionException;
import org.bonitasoft.engine.core.category.exception.SCategoryException;
import org.bonitasoft.engine.core.category.exception.SCategoryInProcessAlreadyExistsException;
import org.bonitasoft.engine.core.category.exception.SCategoryNotFoundException;
import org.bonitasoft.engine.core.category.model.SCategory;
import org.bonitasoft.engine.core.category.model.SProcessCategoryMapping;
import org.bonitasoft.engine.core.category.model.builder.SCategoryBuilder;
import org.bonitasoft.engine.core.category.model.builder.SCategoryBuilderAccessor;
import org.bonitasoft.engine.core.category.model.builder.SCategoryLogBuilder;
import org.bonitasoft.engine.core.category.model.builder.SProcessCategoryMappingBuilder;
import org.bonitasoft.engine.core.category.persistence.SelectDescriptorBuilder;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilder;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;

public class CategoryServiceImpl
implements CategoryService {
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final EventService eventService;
    private final SessionService sessionService;
    private final ReadSessionAccessor sessionAccessor;
    private final SCategoryBuilderAccessor categoryBuilderAccessor;
    private final QueriableLoggerService queriableLoggerService;

    public CategoryServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, SessionService sessionService, ReadSessionAccessor sessionAccessor, SCategoryBuilderAccessor categoryBuilderAccessor, QueriableLoggerService queriableLoggerService) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
        this.categoryBuilderAccessor = categoryBuilderAccessor;
        this.queriableLoggerService = queriableLoggerService;
    }

    @Override
    public SCategory createCategory(String name, String description) throws SCategoryAlreadyExistsException, SCategoryCreationException {
        if (name == null) {
            throw new SCategoryCreationException("Category name can not be null!");
        }
        try {
            this.getCategoryByName(name);
            throw new SCategoryAlreadyExistsException("Category with name " + name + " already exists!");
        }
        catch (SCategoryNotFoundException scnfe) {
            return this.addCategory(name, description);
        }
    }

    private SCategory addCategory(String name, String description) throws SCategoryCreationException {
        long creator;
        SCategoryBuilder categoryBuilder = this.categoryBuilderAccessor.getCategoryBuilder();
        SCategoryLogBuilder logBuilder = this.getQueriableLog(HasCRUDEAction.ActionType.CREATED, "Creating a new category with name " + name);
        SEventBuilder eventBuilder = this.eventService.getEventBuilder();
        try {
            creator = this.getCreator();
        }
        catch (SSessionNotFoundException e) {
            throw new SCategoryCreationException(e);
        }
        SCategory sCategory = categoryBuilder.createNewInstance(name, creator).setDescription(description).done();
        InsertRecord insertRecord = new InsertRecord(sCategory);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("CATEGORY", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)eventBuilder.createInsertEvent("CATEGORY").setObject(sCategory).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(insertRecord.getEntity().getId(), 1, logBuilder, "addCategory");
            return sCategory;
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(insertRecord.getEntity().getId(), 0, logBuilder, "addCategory");
            throw new SCategoryCreationException(e);
        }
    }

    private long getCreator() throws SSessionNotFoundException {
        SSession session;
        try {
            session = this.sessionService.getSession(this.sessionAccessor.getSessionId());
        }
        catch (SessionIdNotSetException e) {
            return -1L;
        }
        return session.getUserId();
    }

    @Override
    public SCategory getCategory(long id) throws SCategoryNotFoundException {
        SelectByIdDescriptor<SCategory> selectByIdDescriptor = SelectDescriptorBuilder.getCategory(id);
        try {
            SCategory category = this.persistenceService.selectById(selectByIdDescriptor);
            if (category == null) {
                throw new SCategoryNotFoundException(id + " does not refer to any category");
            }
            return category;
        }
        catch (SBonitaReadException bre) {
            throw new SCategoryNotFoundException(bre);
        }
    }

    @Override
    public SCategory getCategoryByName(String name) throws SCategoryNotFoundException {
        SelectOneDescriptor<SCategory> descriptor = SelectDescriptorBuilder.getCategory(name);
        try {
            SCategory category = this.persistenceService.selectOne(descriptor);
            if (category == null) {
                throw new SCategoryNotFoundException("Category not found with name: " + name);
            }
            return category;
        }
        catch (SBonitaReadException bre) {
            throw new SCategoryNotFoundException(bre);
        }
    }

    @Override
    public void updateCategory(long categoryId, EntityUpdateDescriptor descriptor) throws SCategoryException {
        SCategoryLogBuilder logBuilder = this.getQueriableLog(HasCRUDEAction.ActionType.UPDATED, "Updating category");
        SCategory persistedCategory = this.getCategory(categoryId);
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)persistedCategory, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("CATEGORY", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)this.eventService.getEventBuilder().createUpdateEvent("CATEGORY").setObject(persistedCategory).done();
                updateEvent.setOldObject(persistedCategory);
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(categoryId, 1, logBuilder, "updateCategory");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(categoryId, 0, logBuilder, "updateCategory");
            throw new SCategoryException("Can't update category " + persistedCategory, e);
        }
        catch (Exception e) {
            throw new SCategoryException("Can't update category " + persistedCategory, e);
        }
    }

    @Override
    public void deleteCategory(long categoryId) throws SCategoryNotFoundException, SCategoryDeletionException {
        SCategory sCategory = this.getCategory(categoryId);
        DeleteRecord record = new DeleteRecord(sCategory);
        SCategoryLogBuilder logBuilder = this.getQueriableLog(HasCRUDEAction.ActionType.DELETED, "Deleting a category");
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("CATEGORY", EventActionType.DELETED)) {
            SEventBuilder eventBuilder = this.eventService.getEventBuilder();
            deleteEvent = (SDeleteEvent)eventBuilder.createDeleteEvent("CATEGORY").setObject(sCategory).done();
        }
        try {
            this.recorder.recordDelete(record, deleteEvent);
            this.initiateLogBuilder(categoryId, 1, logBuilder, "deleteCategory");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(categoryId, 0, logBuilder, "deleteCategory");
            throw new SCategoryDeletionException("Can't delete process category " + sCategory, e);
        }
    }

    @Override
    public long getNumberOfCategories() throws SCategoryException {
        try {
            return this.persistenceService.selectOne(SelectDescriptorBuilder.getNumberOfElement("Category", SCategory.class));
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException("Can't get the number of process category", e);
        }
    }

    @Override
    public List<SCategory> getCategories(int fromIndex, int numberOfCategories, String field, OrderByType order) throws SCategoryException {
        SelectListDescriptor<SCategory> descriptor = SelectDescriptorBuilder.getCategories(field, order, fromIndex, numberOfCategories);
        try {
            return this.persistenceService.selectList(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    @Override
    public void addProcessDefinitionToCategory(long categoryId, long processDefinitionId) throws SCategoryException {
        this.getCategory(categoryId);
        if (this.isCategoryExistsInProcess(categoryId, processDefinitionId)) {
            throw new SCategoryInProcessAlreadyExistsException("The category '" + categoryId + "' is already in process '" + processDefinitionId + "'");
        }
        SProcessCategoryMappingBuilder mappingBuilder = this.categoryBuilderAccessor.getSProcessCategoryMappingBuilder();
        SProcessCategoryMapping mapping = mappingBuilder.createNewInstance(categoryId, processDefinitionId).done();
        InsertRecord insertRecord = new InsertRecord(mapping);
        String logMessage = "Creating a new category mapping {categoryId:" + categoryId + " --> processDefinitionId:" + processDefinitionId + "}";
        SCategoryLogBuilder logBuilder = this.getQueriableLog(HasCRUDEAction.ActionType.CREATED, logMessage);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("CATEGORY", EventActionType.CREATED)) {
            SEventBuilder eventBuilder = this.eventService.getEventBuilder();
            insertEvent = (SInsertEvent)eventBuilder.createInsertEvent("CATEGORY").setObject(mapping).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(categoryId, 1, logBuilder, "addProcessDefinitionToCategory");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(categoryId, 0, logBuilder, "addProcessDefinitionToCategory");
            throw new SCategoryException(e);
        }
    }

    private boolean isCategoryExistsInProcess(long categoryId, long processDefinitionId) throws SCategoryException {
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.isCategoryExistsInProcess(categoryId, processDefinitionId);
        try {
            return this.persistenceService.selectOne(descriptor) != 0L;
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    @Override
    public void addProcessDefinitionsToCategory(long categoryId, List<Long> processDefinitionIds) throws SCategoryException {
        for (long processDefinitionId : processDefinitionIds) {
            this.addProcessDefinitionToCategory(categoryId, processDefinitionId);
        }
    }

    @Override
    public long getNumberOfCategoriesOfProcess(long processDefinitionId) throws SCategoryException {
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.getNumberOfCategoriesOfProcess(processDefinitionId);
        try {
            return this.persistenceService.selectOne(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    @Override
    public long getNumberOfCategoriesUnrelatedToProcess(long processDefinitionId) throws SCategoryException {
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.getNumberOfCategoriesUnrelatedToProcess(processDefinitionId);
        try {
            return this.persistenceService.selectOne(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    @Override
    public List<Long> getProcessDefinitionIdsOfCategory(long categoryId) throws SCategoryException {
        SelectListDescriptor<Long> descriptor = SelectDescriptorBuilder.getProcessIdsOfCategory(categoryId);
        try {
            return this.persistenceService.selectList(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    @Override
    public List<SCategory> getCategoriesOfProcessDefinition(long processDefinitionId, int fromIndex, int numberOfCategories, OrderByType order) throws SCategoryException {
        SelectListDescriptor<SCategory> descriptor = SelectDescriptorBuilder.getCategoriesOfProcess(processDefinitionId, fromIndex, numberOfCategories, order);
        try {
            return this.persistenceService.selectList(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    @Override
    public List<SCategory> getCategoriesUnrelatedToProcessDefinition(long processDefinitionId, int fromIndex, int numberOfCategories, OrderByType order) throws SCategoryException {
        SelectListDescriptor<SCategory> descriptor = SelectDescriptorBuilder.getCategoriesUnrelatedToProcess(processDefinitionId, fromIndex, numberOfCategories, order);
        try {
            return this.persistenceService.selectList(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    @Override
    public void removeCategoriesFromProcessDefinition(long processDefinitionId, List<Long> categoryIds) throws SCategoryException {
        SelectListDescriptor<SProcessCategoryMapping> descriptor = SelectDescriptorBuilder.getCategoryMappingOfProcessAndCategories(processDefinitionId, categoryIds);
        try {
            List<SProcessCategoryMapping> mappings = this.persistenceService.selectList(descriptor);
            for (SProcessCategoryMapping mapping : mappings) {
                if (!categoryIds.contains(mapping.getCategoryId())) continue;
                this.deleteProcessCategoryMapping(mapping);
            }
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    @Override
    public List<SProcessCategoryMapping> searchProcessCategoryMappings(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SProcessCategoryMapping.class, queryOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public long deleteProcessCategoryMappings(List<SProcessCategoryMapping> mappings) {
        long nbDeleted = 0L;
        for (SProcessCategoryMapping mapping : mappings) {
            try {
                this.deleteProcessCategoryMapping(mapping);
                nbDeleted = 1L;
            }
            catch (SBonitaException e) {}
        }
        return nbDeleted;
    }

    private void deleteProcessCategoryMapping(SProcessCategoryMapping mapping) throws SCategoryException {
        DeleteRecord deleteRecord = new DeleteRecord(mapping);
        SEventBuilder eventBuilder = this.eventService.getEventBuilder();
        String logMessage = "Deleting a category mapping {processDefinitionId:" + mapping.getProcessId() + " --> categoryId" + mapping.getCategoryId() + "}";
        SCategoryLogBuilder logBuilder = this.getQueriableLog(HasCRUDEAction.ActionType.DELETED, logMessage);
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("CATEGORY", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)eventBuilder.createDeleteEvent("CATEGORY").setObject(mapping).done();
        }
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(mapping.getId(), 1, logBuilder, "deleteProcessCategoryMapping");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(mapping.getId(), 0, logBuilder, "deleteProcessCategoryMapping");
            throw new SCategoryException(e);
        }
    }

    private SCategoryLogBuilder getQueriableLog(HasCRUDEAction.ActionType actionType, String message) {
        SCategoryLogBuilder logBuilder = this.categoryBuilderAccessor.getSCategoryLogBuilder();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.createNewInstance().actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(HasCRUDEAction.ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public long getNumberOfCategorizedProcessIds(List<Long> processIds) throws SCategoryException {
        if (processIds == null || processIds.size() <= 0) {
            return 0L;
        }
        SelectOneDescriptor<Long> descriptor = SelectDescriptorBuilder.getNumberOfCategorizedProcessIds(processIds);
        try {
            return this.persistenceService.selectOne(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    @Override
    public List<Long> getCategorizedProcessIds(List<Long> processIds) throws SCategoryException {
        if (processIds == null || processIds.size() <= 0) {
            return Collections.emptyList();
        }
        SelectListDescriptor<Long> descriptor = SelectDescriptorBuilder.getCategorizedProcessIds(processIds);
        try {
            return this.persistenceService.selectList(descriptor);
        }
        catch (SBonitaReadException e) {
            throw new SCategoryException(e);
        }
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }
}

