/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.bpm.userfilter.UserFilterDefinition;
import org.bonitasoft.engine.core.process.definition.model.SUserFilterDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.impl.SNamedElementImpl;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilders;

public class SUserFilterDefinitionImpl
extends SNamedElementImpl
implements SUserFilterDefinition {
    private static final long serialVersionUID = -6045216424839658552L;
    private final String filterId;
    private final String version;
    private final Map<String, SExpression> inputs;

    public SUserFilterDefinitionImpl(UserFilterDefinition userFilter, SExpressionBuilders sExpressionBuilders) {
        super(userFilter.getName());
        this.filterId = userFilter.getUserFilterId();
        this.version = userFilter.getVersion();
        this.inputs = new HashMap<String, SExpression>(userFilter.getInputs().size());
        for (Map.Entry input : userFilter.getInputs().entrySet()) {
            Expression value = (Expression)input.getValue();
            SExpression sExpression = ServerModelConvertor.convertExpression(sExpressionBuilders, value);
            this.inputs.put((String)input.getKey(), sExpression);
        }
    }

    public SUserFilterDefinitionImpl(String name, String userFilterId, String version) {
        super(name);
        this.filterId = userFilterId;
        this.version = version;
        this.inputs = new HashMap<String, SExpression>();
    }

    @Override
    public String getUserFilterId() {
        return this.filterId;
    }

    @Override
    public Map<String, SExpression> getInputs() {
        return this.inputs;
    }

    public void addInput(String name, SExpression value) {
        this.inputs.put(name, value);
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

