/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.archive;

import java.text.MessageFormat;
import java.util.List;
import org.bonitasoft.engine.SArchivingException;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.archive.SDefinitiveArchiveNotFound;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.model.SComment;
import org.bonitasoft.engine.core.process.comment.model.archive.SAComment;
import org.bonitasoft.engine.core.process.comment.model.archive.builder.SACommentBuilder;
import org.bonitasoft.engine.core.process.comment.model.builder.SCommentBuilders;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.document.mapping.DocumentMappingService;
import org.bonitasoft.engine.core.process.document.mapping.exception.SDocumentMappingException;
import org.bonitasoft.engine.core.process.document.mapping.exception.SPageOutOfRangeException;
import org.bonitasoft.engine.core.process.document.mapping.model.SDocumentMapping;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SAutomaticTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SCallActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SLoopActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SManualTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSendTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSubProcessActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SUserTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAProcessInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.BPMInstanceBuilders;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.SRecorderException;

public class ProcessArchiver {
    private static final int BATCH_SIZE = 100;

    public static void archiveProcessInstance(SProcessInstance processInstance, ArchiveService archiveService, ProcessInstanceService processInstanceService, DataInstanceService dataInstanceService, DocumentMappingService documentMappingService, TechnicalLoggerService logger, BPMInstanceBuilders instancesBuilders, SCommentService commentService, SCommentBuilders commentBuilders, ProcessDefinitionService processDefinitionService, ConnectorInstanceService connectorInstanceService) throws SArchivingException {
        SAProcessInstanceBuilder saProcessInstanceBuilder = instancesBuilders.getSAProcessInstanceBuilder();
        SAProcessInstance saProcessInstance = saProcessInstanceBuilder.createNewInstance(processInstance).done();
        long archiveDate = saProcessInstance.getEndDate();
        try {
            dataInstanceService.removeContainer(processInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.toString());
        }
        catch (SDataInstanceException e) {
            throw new SArchivingException("unable to delete data mapping", e);
        }
        SProcessDefinition processDefinition = null;
        try {
            processDefinition = processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
        }
        catch (SBonitaException e) {
            throw new SArchivingException(e);
        }
        if (!processDefinition.getProcessContainer().getDataDefinitions().isEmpty()) {
            ProcessArchiver.archiveDataInstances(processInstance, dataInstanceService, archiveDate);
        }
        ProcessArchiver.archiveComments(processInstance, archiveService, logger, instancesBuilders, commentService, commentBuilders, archiveDate);
        ProcessArchiver.archiveDocumentMappings(processInstance, documentMappingService, archiveDate);
        if (!processDefinition.getProcessContainer().getConnectors().isEmpty()) {
            ProcessArchiver.archiveConnectors(connectorInstanceService, archiveDate, processInstance.getId(), "process");
        }
        ProcessArchiver.archiveProcessInstance(processInstance, archiveService, processInstanceService, logger, instancesBuilders, saProcessInstance, archiveDate);
    }

    private static void archiveConnectors(ConnectorInstanceService connectorInstanceService, long archiveDate, long containerId, String containerType) throws SArchivingException {
        try {
            List<SConnectorInstance> connectorInstances;
            int i = 0;
            do {
                connectorInstances = connectorInstanceService.getConnectorInstances(containerId, containerType, i, i + 100, null, null);
                i += 100;
                for (SConnectorInstance sConnectorInstance : connectorInstances) {
                    connectorInstanceService.archiveConnectorInstance(sConnectorInstance, archiveDate);
                }
            } while (connectorInstances.size() == 100);
        }
        catch (SBonitaException e) {
            throw new SArchivingException("Unable to archive the container instance with id " + containerId, e);
        }
    }

    private static void archiveProcessInstance(SProcessInstance processInstance, ArchiveService archiveService, ProcessInstanceService processInstanceService, TechnicalLoggerService logger, BPMInstanceBuilders instancesBuilders, SAProcessInstance saProcessInstance, long archiveDate) throws SArchivingException {
        block6: {
            try {
                ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saProcessInstance);
                archiveService.recordInsert(archiveDate, insertRecord);
                if (logger.isLoggable(ProcessArchiver.class, TechnicalLogSeverity.DEBUG)) {
                    logger.log(ProcessArchiver.class, TechnicalLogSeverity.DEBUG, MessageFormat.format("archiving {0} with id {1} and state {2}", processInstance.getClass().getSimpleName(), processInstance.getId(), processInstance.getStateId()));
                }
                try {
                    processInstanceService.deleteProcessInstance(processInstance.getId());
                }
                catch (SBonitaException e) {
                    throw new SArchivingException("Unable to delete the process instance during the archiving", e);
                }
            }
            catch (SRecorderException e) {
                throw new SArchivingException("Unable to archive the process instance with id " + processInstance.getId(), e);
            }
            catch (SDefinitiveArchiveNotFound e) {
                if (!logger.isLoggable(ProcessArchiver.class, TechnicalLogSeverity.ERROR)) break block6;
                logger.log(ProcessArchiver.class, TechnicalLogSeverity.ERROR, "the process instance was not archived id=" + processInstance.getId(), e);
            }
        }
    }

    private static void archiveDocumentMappings(SProcessInstance processInstance, DocumentMappingService documentMappingService, long archiveDate) throws SArchivingException {
        List<SDocumentMapping> sDocumentMappings = null;
        do {
            try {
                sDocumentMappings = documentMappingService.getDocumentMappingsForProcessInstance(processInstance.getId(), 0, 100, null, null);
            }
            catch (SPageOutOfRangeException e1) {
                throw new SArchivingException("Unable to archive the process instance with id " + processInstance.getId(), e1);
            }
            catch (SDocumentMappingException e1) {
                throw new SArchivingException("Unable to archive the process instance with id " + processInstance.getId(), e1);
            }
            for (SDocumentMapping sDocumentMapping : sDocumentMappings) {
                try {
                    documentMappingService.archive(sDocumentMapping, archiveDate);
                }
                catch (SDocumentMappingException e) {
                    throw new SArchivingException("Unable to archive the process instance with id " + processInstance.getId(), e);
                }
            }
        } while (sDocumentMappings.size() == 100);
    }

    private static void archiveComments(SProcessInstance processInstance, ArchiveService archiveService, TechnicalLoggerService logger, BPMInstanceBuilders instancesBuilders, SCommentService commentService, SCommentBuilders commentBuilders, long archiveDate) throws SArchivingException {
        List<SComment> sComments = null;
        int startIndex = 0;
        do {
            block5: {
                try {
                    sComments = commentService.getComments(processInstance.getId(), new QueryOptions(startIndex, 100));
                }
                catch (SBonitaReadException e) {
                    if (!logger.isLoggable(ProcessArchiver.class, TechnicalLogSeverity.ERROR)) break block5;
                    logger.log(ProcessArchiver.class, TechnicalLogSeverity.ERROR, "No process comment found for process with id: " + processInstance.getId(), e);
                }
            }
            if (sComments != null) {
                for (SComment sComment : sComments) {
                    ProcessArchiver.archiveComment(processInstance, archiveService, logger, commentBuilders.getSACommentBuilder(), archiveDate, sComment);
                }
            }
            startIndex += 100;
        } while (sComments.size() > 0);
    }

    private static void archiveComment(SProcessInstance processInstance, ArchiveService archiveService, TechnicalLoggerService logger, SACommentBuilder saCommentBuilder, long archiveDate, SComment sComment) throws SArchivingException {
        block4: {
            SAComment saComment = saCommentBuilder.createNewInstance(sComment).done();
            if (saComment != null) {
                ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saComment);
                try {
                    archiveService.recordInsert(archiveDate, insertRecord);
                }
                catch (SRecorderException e) {
                    throw new SArchivingException("Unable to archive the process instance comments with id " + processInstance.getId(), e);
                }
                catch (SDefinitiveArchiveNotFound e) {
                    if (!logger.isLoggable(ProcessArchiver.class, TechnicalLogSeverity.ERROR)) break block4;
                    logger.log(ProcessArchiver.class, TechnicalLogSeverity.ERROR, "the process instance were not archived id=" + processInstance.getId(), e);
                }
            }
        }
    }

    private static void archiveDataInstances(SProcessInstance processInstance, DataInstanceService dataInstanceService, long archiveDate) throws SArchivingException {
        try {
            dataInstanceService.archiveLocalDataInstancesFromProcessInstance(processInstance.getId(), archiveDate);
        }
        catch (SDataInstanceException e) {
            throw new SArchivingException("Unable to archive the process instance with id " + processInstance.getId(), e);
        }
    }

    private static void archiveFlowNodeInstance(SFlowNodeInstance flowNodeInstance, boolean deleteAfterArchive, ProcessInstanceService processInstanceService, ArchiveService archiveService, BPMInstanceBuilders bpmInstanceBuilders, DataInstanceService dataInstanceService, SProcessDefinition processDefinition, ActivityInstanceService activityInstanceService, ConnectorInstanceService connectorInstanceService) throws SActivityExecutionException {
        try {
            long archiveDate = System.currentTimeMillis();
            if (deleteAfterArchive && flowNodeInstance instanceof SActivityInstance) {
                SActivityDefinition activityDef = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
                if (activityDef != null && !activityDef.getSDataDefinitions().isEmpty()) {
                    try {
                        List<SDataInstance> dataInstances;
                        do {
                            dataInstances = dataInstanceService.getLocalDataInstances(flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.toString(), 0, 20);
                            for (SDataInstance sDataInstance : dataInstances) {
                                dataInstanceService.deleteDataInstance(sDataInstance);
                            }
                        } while (dataInstances != null && dataInstances.size() > 0);
                        dataInstanceService.removeContainer(flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.toString());
                    }
                    catch (SDataInstanceException e) {
                        throw new SActivityExecutionException(e);
                    }
                }
                if (activityDef != null && !activityDef.getConnectors().isEmpty()) {
                    ProcessArchiver.archiveConnectors(connectorInstanceService, archiveDate, flowNodeInstance.getId(), "flowNode");
                }
            }
            SAFlowNodeInstance saFlowNodeInstance = null;
            switch (flowNodeInstance.getType()) {
                case AUTOMATIC_TASK: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSAAutomaticTaskInstanceBuilder().createNewAutomaticTaskInstance((SAutomaticTaskInstance)flowNodeInstance).done();
                    break;
                }
                case GATEWAY: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSAGatewayInstanceBuilder().createNewGatewayInstance((SGatewayInstance)flowNodeInstance).done();
                    break;
                }
                case MANUAL_TASK: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSAManualTaskInstanceBuilder().createNewManualTaskInstance((SManualTaskInstance)flowNodeInstance).done();
                    break;
                }
                case USER_TASK: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSAUserTaskInstanceBuilder().createNewUserTaskInstance((SUserTaskInstance)flowNodeInstance).done();
                    break;
                }
                case RECEIVE_TASK: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSAReceiveTaskInstanceBuilder().createNewReceiveTaskInstance((SReceiveTaskInstance)flowNodeInstance).done();
                    break;
                }
                case SEND_TASK: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSASendTaskInstanceBuilder().createNewSendTaskInstance((SSendTaskInstance)flowNodeInstance).done();
                    break;
                }
                case LOOP_ACTIVITY: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSALoopActivitynstanceBuilder().createNewLoopActivityInstance((SLoopActivityInstance)flowNodeInstance).done();
                    break;
                }
                case CALL_ACTIVITY: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSACallActivityInstanceBuilder().createNewArchivedCallActivityInstance((SCallActivityInstance)flowNodeInstance).done();
                    break;
                }
                case MULTI_INSTANCE_ACTIVITY: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSAMultiInstanceActivitynstanceBuilder().createNewMultiInstanceActivityInstance((SMultiInstanceActivityInstance)flowNodeInstance).done();
                    break;
                }
                case SUB_PROCESS: {
                    saFlowNodeInstance = bpmInstanceBuilders.getSASubProcessActivityInstanceBuilder().createNewArchivedSubProcessActivityInstance((SSubProcessActivityInstance)flowNodeInstance).done();
                    break;
                }
                case END_EVENT: {
                    break;
                }
                case START_EVENT: {
                    break;
                }
                case BOUNDARY_EVENT: {
                    break;
                }
                case INTERMEDIATE_CATCH_EVENT: {
                    break;
                }
                case INTERMEDIATE_THROW_EVENT: {
                    break;
                }
            }
            if (saFlowNodeInstance != null) {
                ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saFlowNodeInstance);
                archiveService.recordInsert(archiveDate, insertRecord);
            }
            if (deleteAfterArchive) {
                SFlowNodeInstance flowNodeInstance2 = activityInstanceService.getFlowNodeInstance(flowNodeInstance.getId());
                processInstanceService.deleteFlowNodeInstance(flowNodeInstance2, processDefinition);
            }
        }
        catch (SBonitaException e) {
            throw new SActivityExecutionException(e);
        }
    }

    public static void archiveFlowNodeInstance(SFlowNodeInstance intTxflowNodeInstance, boolean deleteAfterArchive, long processDefinitionId, ProcessInstanceService processInstanceService, ProcessDefinitionService processDefinitionService, ArchiveService archiveService, BPMInstanceBuilders bpmInstanceBuilders, DataInstanceService dataInstanceService, ActivityInstanceService activityInstanceService, ConnectorInstanceService connectorInstanceService) throws SActivityExecutionException {
        SProcessDefinition processDefinition;
        try {
            processDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
        }
        catch (SBonitaException e) {
            throw new SActivityExecutionException(e);
        }
        ProcessArchiver.archiveFlowNodeInstance(intTxflowNodeInstance, deleteAfterArchive, processInstanceService, archiveService, bpmInstanceBuilders, dataInstanceService, processDefinition, activityInstanceService, connectorInstanceService);
    }
}

