/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import java.io.Serializable;
import java.util.HashMap;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SStandardLoopCharacteristics;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SLoopActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SLoopActivityInstanceBuilder;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.execution.StateBehaviors;
import org.bonitasoft.engine.expression.ExpressionConstants;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;

public class InitializingLoopActivityStateImpl
implements FlowNodeState {
    private final ExpressionResolverService expressionResolverService;
    private final BPMInstancesCreator bpmInstancesCreator;
    private final ActivityInstanceService activityInstanceService;
    private final StateBehaviors stateBehaviors;

    public InitializingLoopActivityStateImpl(ExpressionResolverService expressionResolverService, BPMInstancesCreator bpmInstancesCreator, ActivityInstanceService activityInstanceService, StateBehaviors stateBehaviors) {
        this.expressionResolverService = expressionResolverService;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.activityInstanceService = activityInstanceService;
        this.stateBehaviors = stateBehaviors;
    }

    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        this.stateBehaviors.createAttachedBoundaryEvents(processDefinition, (SActivityInstance)flowNodeInstance);
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        Long processDefinitionId = processDefinition.getId();
        SActivityDefinition activity = (SActivityDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        try {
            SLoopActivityInstance loopActivity = (SLoopActivityInstance)this.activityInstanceService.getFlowNodeInstance(flowNodeInstance.getId());
            SLoopCharacteristics loopCharacteristics = activity.getLoopCharacteristics();
            if (loopCharacteristics instanceof SStandardLoopCharacteristics) {
                boolean loop;
                this.bpmInstancesCreator.addChildDataContainer(flowNodeInstance);
                SStandardLoopCharacteristics standardLoop = (SStandardLoopCharacteristics)loopCharacteristics;
                SExpression loopMax = ((SStandardLoopCharacteristics)loopCharacteristics).getLoopMax();
                if (loopMax != null) {
                    String containerType = loopActivity.getLogicalGroup(2) > 0L ? DataInstanceContainer.ACTIVITY_INSTANCE.name() : DataInstanceContainer.PROCESS_INSTANCE.name();
                    Integer intLoopMax = (Integer)this.expressionResolverService.evaluate(loopMax, new SExpressionContext((Long)loopActivity.getId(), containerType, processDefinitionId));
                    this.activityInstanceService.setLoopMax(loopActivity, intLoopMax);
                }
                boolean bl = loop = !standardLoop.isTestBefore() || this.evaluateLoop(standardLoop, loopActivity);
                if (loop) {
                    SLoopActivityInstanceBuilder loopActivityInstanceBuilder = this.bpmInstancesCreator.getBPMInstanceBuilders().getSLoopActivityInstanceBuilder();
                    long rootProcessInstanceId = flowNodeInstance.getLogicalGroup(loopActivityInstanceBuilder.getRootProcessInstanceIndex());
                    long parentProcessInstanceId = flowNodeInstance.getLogicalGroup(loopActivityInstanceBuilder.getParentProcessInstanceIndex());
                    this.bpmInstancesCreator.createFlowNodeInstance(processDefinitionId, flowNodeInstance.getRootContainerId(), flowNodeInstance.getId(), SFlowElementsContainerType.FLOWNODE, activity, rootProcessInstanceId, parentProcessInstanceId, true, 1, SStateCategory.NORMAL, -1L, null);
                    this.activityInstanceService.incrementLoopCounter(loopActivity);
                    this.activityInstanceService.setTokenCount(loopActivity, loopActivity.getTokenCount() + 1);
                }
            }
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException(e);
        }
        return StateCode.DONE;
    }

    private boolean evaluateLoop(SStandardLoopCharacteristics standardLoop, SLoopActivityInstance loopActivity) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        HashMap<String, Serializable> input = new HashMap<String, Serializable>(0);
        input.put(ExpressionConstants.LOOP_COUNTER.getEngineConstantName(), Integer.valueOf(loopActivity.getLoopCounter()));
        SExpressionContext sExpressionContext = new SExpressionContext((Long)loopActivity.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), input);
        return (Boolean)this.expressionResolverService.evaluate(standardLoop.getLoopCondition(), sExpressionContext);
    }

    @Override
    public int getId() {
        return 23;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        return "initializing";
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        return true;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        return true;
    }

    @Override
    public SStateCategory getStateCategory() {
        return SStateCategory.NORMAL;
    }

    @Override
    public boolean mustAddSystemComment(SFlowNodeInstance flowNodeInstance) {
        return false;
    }

    @Override
    public String getSystemComment(SFlowNodeInstance flowNodeInstance) {
        return "";
    }
}

