/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.permission;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActor;
import org.bonitasoft.engine.api.impl.transaction.process.GetProcessDefinition;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SActorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class IsAllowedToStartProcess
extends TenantCommand {
    private TenantServiceAccessor serviceAccessor;
    private static final String PROCESS_DEFINITION_ID_KEY = "PROCESS_DEFINITION_ID_KEY";
    private static final String ACTOR_IDS_KEY = "ACTOR_IDS_KEY";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        boolean isAllowedToStartProcess;
        block5: {
            this.serviceAccessor = serviceAccessor;
            ActorMappingService actorMappingService = this.serviceAccessor.getActorMappingService();
            ProcessDefinitionService processDefinitionService = this.serviceAccessor.getProcessDefinitionService();
            Set actorIds = (Set)((Object)parameters.get(ACTOR_IDS_KEY));
            if (actorIds == null) {
                throw new SCommandParameterizationException("Mandatory parameter ACTOR_IDS_KEY is missing or not convertible to Set<Long>.");
            }
            long processDefinitionId = (Long)parameters.get(PROCESS_DEFINITION_ID_KEY);
            if (processDefinitionId == 0L) {
                throw new SCommandParameterizationException("Mandatory parameter PROCESS_DEFINITION_ID_KEY is missing or not convertible to Long.");
            }
            GetProcessDefinition getProcessDefinition = new GetProcessDefinition(processDefinitionId, processDefinitionService);
            isAllowedToStartProcess = false;
            try {
                getProcessDefinition.execute();
                SProcessDefinition definition = getProcessDefinition.getResult();
                SActorDefinition sActorDefinition = definition.getActorInitiator();
                String name = sActorDefinition.getName();
                GetActor getActor = new GetActor(actorMappingService, name, processDefinitionId);
                getActor.execute();
                SActor sActor = getActor.getResult();
                if (sActor == null) break block5;
                Iterator i$ = actorIds.iterator();
                while (i$.hasNext()) {
                    long actorId = (Long)i$.next();
                    if (sActor.getId() != actorId) continue;
                    isAllowedToStartProcess = true;
                    break;
                }
            }
            catch (SBonitaException e) {
                throw new SCommandExecutionException("Can't get actors For Initiator." + e);
            }
        }
        return Boolean.valueOf(isAllowedToStartProcess);
    }
}

