/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.model.builder.impl;

import org.bonitasoft.engine.identity.model.builder.SContactInfoLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.impl.CRUDELogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.impl.MissingMandatoryFieldsException;

public class SContactInfoLogBuilderImpl
extends CRUDELogBuilder
implements SContactInfoLogBuilder {
    private static final String PREFIX = "IDENTITY_USER_CONTACT_INFO";
    public static final int USER_CONTACT_INFO_INDEX = 1;
    public static final int USER_CONTACT_INFO_USERID_INDEX = 2;
    public static final String USER_CONTACT_INFO_INDEX_NAME = "numericIndex2";
    public static final String USER_CONTACT_INFO_USERID_INDEX_NAME = "numericIndex3";

    @Override
    public SPersistenceLogBuilder objectId(long objectId) {
        this.queriableLogBuilder.numericIndex(1, objectId);
        return this;
    }

    @Override
    public String getObjectIdKey() {
        return USER_CONTACT_INFO_INDEX_NAME;
    }

    @Override
    public SPersistenceLogBuilder setContactInfoUserId(long userId) {
        this.queriableLogBuilder.numericIndex(2, userId);
        return this;
    }

    @Override
    public String getContactInfoUserIdKey() {
        return USER_CONTACT_INFO_USERID_INDEX_NAME;
    }

    @Override
    protected String getActionTypePrefix() {
        return PREFIX;
    }

    @Override
    protected void checkExtraRules(SQueriableLog log) {
        if (log.getActionStatus() != 0 && log.getNumericIndex(2) == 0L) {
            throw new MissingMandatoryFieldsException("Some mandatory fields are missing: Identity Contact info User Id");
        }
    }
}

