/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.model.builder.impl;

import org.bonitasoft.engine.identity.model.builder.SUserMembershipLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.impl.CRUDELogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.impl.MissingMandatoryFieldsException;

public class SUserMembershipLogBuilderImpl
extends CRUDELogBuilder
implements SUserMembershipLogBuilder {
    private static final String PREFIX = "IDENTITY_USER_MEMBERSHIP";
    public static final int USER_MEMBERSHIP_INDEX = 4;
    public static final String USER_MEMBERSHIP_INDEX_NAME = "numericIndex5";
    public static final int ROLE_INDEX = 3;
    public static final String ROLE_INDEX_NAME = "textualIndex4";
    public static final int USER_INDEX = 1;
    public static final String USER_INDEX_NAME = "textualIndex2";
    public static final int GROUP_INDEX = 2;
    public static final String GROUP_INDEX_NAME = "textualIndex3";

    @Override
    public SPersistenceLogBuilder objectId(long objectId) {
        this.queriableLogBuilder.numericIndex(4, objectId);
        return this;
    }

    @Override
    public String getObjectIdKey() {
        return USER_MEMBERSHIP_INDEX_NAME;
    }

    @Override
    protected String getActionTypePrefix() {
        return PREFIX;
    }

    @Override
    protected void checkExtraRules(SQueriableLog log) {
        if (log.getActionStatus() != 0 && log.getNumericIndex(4) == 0L) {
            throw new MissingMandatoryFieldsException("Some mandatoryFildes are missing: UserMembership Id");
        }
        if (log.getNumericIndex(3) == 0L) {
            throw new MissingMandatoryFieldsException("Some mandatoryFildes are missing: Role Id");
        }
        if (log.getNumericIndex(1) == 0L) {
            throw new MissingMandatoryFieldsException("Some mandatoryFildes are missing: User Id");
        }
    }

    @Override
    public SUserMembershipLogBuilder roleID(long roleId) {
        this.queriableLogBuilder.numericIndex(3, roleId);
        return this;
    }

    @Override
    public SUserMembershipLogBuilder identityUserId(long userId) {
        this.queriableLogBuilder.numericIndex(1, userId);
        return this;
    }

    @Override
    public SUserMembershipLogBuilder groupId(long groupId) {
        this.queriableLogBuilder.numericIndex(2, groupId);
        return this;
    }

    @Override
    public String getRoleNameKey() {
        return ROLE_INDEX_NAME;
    }

    @Override
    public String getIdentityUserNameKey() {
        return USER_INDEX_NAME;
    }

    @Override
    public String getGroupPathKey() {
        return GROUP_INDEX_NAME;
    }
}

