/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.log.asyncflush;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.log.asyncflush.AbstractJob;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.scheduler.exception.SJobExecutionException;
import org.bonitasoft.engine.services.QueriableLoggerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueriableLogRecordJob
extends AbstractJob {
    private static final long serialVersionUID = -5222364133911713673L;
    private static final Logger LOGGER = LoggerFactory.getLogger(QueriableLogRecordJob.class);
    private List<SQueriableLog> logs;
    private transient QueriableLoggerService queriableLogService;

    @Override
    public void execute() throws SJobExecutionException {
        if (this.queriableLogService == null) {
            throw new SJobExecutionException("Missing mandatory service: QueriableLoggerService");
        }
        LOGGER.debug("QueriableLogRecordJob calling logger service");
        SQueriableLog[] logsArray = new SQueriableLog[this.logs.size()];
        this.queriableLogService.log(this.getClass().getName(), "execute", this.logs.toArray(logsArray));
        LOGGER.debug("QueriableLogRecordJob has called logger service");
    }

    @Override
    public String getDescription() {
        return "Persist one or more logs when a recording is triggered";
    }

    public void setQueriableLoggerService(QueriableLoggerService queriableLoggerService) {
        this.queriableLogService = queriableLoggerService;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        super.setAttributes(attributes);
        NullCheckingUtil.checkArgsNotNull(attributes.get("logs"));
        this.logs = (List)((Object)attributes.get("logs"));
    }
}

