/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.TenantIdNotSetException;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.TransactionState;
import org.bonitasoft.engine.work.BonitaWork;
import org.bonitasoft.engine.work.ExecutorWorkService;

public abstract class AbstractWorkSynchronization
implements BonitaTransactionSynchronization {
    private final Collection<BonitaWork> works;
    protected final ExecutorService executorService;
    private boolean executed = false;
    private long tenantId;
    private final ExecutorWorkService threadPoolWorkService;

    public AbstractWorkSynchronization(ExecutorWorkService threadPoolWorkService, ExecutorService executorService, SessionAccessor sessionAccessor) {
        this.threadPoolWorkService = threadPoolWorkService;
        this.executorService = executorService;
        this.works = new HashSet<BonitaWork>();
        try {
            this.tenantId = sessionAccessor.getTenantId();
        }
        catch (TenantIdNotSetException e) {
            this.tenantId = -1L;
        }
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public void addWork(BonitaWork work) {
        this.works.add(work);
    }

    @Override
    public void beforeCommit() {
    }

    @Override
    public void afterCompletion(TransactionState transactionStatus) {
        if (TransactionState.COMMITTED == transactionStatus) {
            for (BonitaWork work : this.works) {
                work.setTenantId(this.tenantId);
            }
            if (!this.threadPoolWorkService.isStopped(this.tenantId)) {
                this.executeRunnables(this.works);
            }
        }
        this.executed = true;
    }

    protected abstract void executeRunnables(Collection<BonitaWork> var1);

    public boolean isExecuted() {
        return this.executed;
    }
}

