/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class BonitaWork
implements Runnable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected long tenantId;
    private BonitaWork parentWork;

    public abstract String getDescription();

    public String getRecoveryProcedure() {
        return "No recovery procedure";
    }

    public abstract void work(Map<String, Object> var1) throws Exception;

    @Override
    public void run() {
        try {
            this.work(new HashMap<String, Object>());
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception should be handled by works", e);
        }
    }

    public abstract void handleFailure(Throwable var1, Map<String, Object> var2) throws Exception;

    public long getTenantId() {
        if (this.tenantId <= 0L) {
            throw new IllegalStateException("tenantid not set");
        }
        return this.tenantId;
    }

    public void setTenantId(long tenantId) {
        if (tenantId <= 0L) {
            throw new IllegalStateException("invalid tenantid: " + tenantId);
        }
        this.tenantId = tenantId;
    }

    public void setParent(BonitaWork parentWork) {
        this.parentWork = parentWork;
    }

    public BonitaWork getParent() {
        return this.parentWork;
    }
}

