/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import org.bonitasoft.engine.api.LoginAPI;
import org.bonitasoft.engine.api.impl.AbstractLoginApiImpl;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.api.impl.transaction.identity.UpdateUser;
import org.bonitasoft.engine.api.impl.transaction.platform.GetDefaultTenantInstance;
import org.bonitasoft.engine.api.impl.transaction.platform.GetTenantInstance;
import org.bonitasoft.engine.api.impl.transaction.platform.Logout;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.commons.transaction.TransactionExecutor;
import org.bonitasoft.engine.core.login.LoginService;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.builder.SUserUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserUpdateBuilderFactory;
import org.bonitasoft.engine.platform.LoginException;
import org.bonitasoft.engine.platform.LogoutException;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.model.STenant;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionNotFoundException;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class LoginAPIImpl
extends AbstractLoginApiImpl
implements LoginAPI {
    @CustomTransactions
    public APISession login(String userName, String password) throws LoginException {
        this.checkUsernameAndPassword(userName, password);
        try {
            return this.login(userName, password, null);
        }
        catch (Throwable e) {
            throw new LoginException(e);
        }
    }

    protected void checkUsernameAndPassword(String userName, String password) throws LoginException {
        if (userName == null || userName.isEmpty()) {
            throw new LoginException("User name is null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new LoginException("Password is null or empty");
        }
    }

    protected APISession login(String userName, String password, Long tenantId) throws Throwable {
        PlatformServiceAccessor platformServiceAccessor = ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
        PlatformService platformService = platformServiceAccessor.getPlatformService();
        TransactionExecutor platformTransactionExecutor = platformServiceAccessor.getTransactionExecutor();
        this.putPlatformInCacheIfNecessary(platformServiceAccessor, platformService);
        TransactionContentWithResult<STenant> getTenant = tenantId == null ? new GetDefaultTenantInstance(platformService) : new GetTenantInstance(tenantId, platformService);
        platformTransactionExecutor.execute(getTenant);
        STenant sTenant = getTenant.getResult();
        if (!platformService.isTenantActivated(sTenant)) {
            throw new LoginException("Tenant " + sTenant.getName() + " is not activated");
        }
        long localTenantId = sTenant.getId();
        TenantServiceAccessor serviceAccessor = this.getTenantServiceAccessor(localTenantId);
        LoginService loginService = serviceAccessor.getLoginService();
        IdentityService identityService = serviceAccessor.getIdentityService();
        TransactionExecutor tenantTransactionExecutor = serviceAccessor.getTransactionExecutor();
        LoginAndRetrieveUser txContent = new LoginAndRetrieveUser(loginService, identityService, localTenantId, userName, password);
        try {
            tenantTransactionExecutor.execute(txContent);
        }
        catch (BonitaRuntimeException e) {
            throw e.getCause();
        }
        return ModelConvertor.toAPISession(txContent.getResult(), sTenant.getName());
    }

    protected TenantServiceAccessor getTenantServiceAccessor(long tenantId) {
        return TenantServiceSingleton.getInstance(tenantId);
    }

    @CustomTransactions
    public void logout(APISession session) throws LogoutException, SessionNotFoundException {
        TenantServiceAccessor serviceAccessor = this.getTenantServiceAccessor(session.getTenantId());
        TransactionExecutor transactionExecutor = serviceAccessor.getTransactionExecutor();
        Logout logout = new Logout(serviceAccessor.getLoginService(), session.getId());
        try {
            transactionExecutor.execute(logout);
        }
        catch (SSessionNotFoundException sbe) {
            throw new SessionNotFoundException((Throwable)sbe);
        }
        catch (SBonitaException sbe) {
            throw new LogoutException((Throwable)sbe);
        }
    }

    private class LoginAndRetrieveUser
    implements TransactionContentWithResult<SSession> {
        private final LoginService loginService;
        private final IdentityService identityService;
        private final long tenantId;
        private final String userName;
        private final String password;
        private SSession session;

        public LoginAndRetrieveUser(LoginService loginService, IdentityService identityService, long tenantId, String userName, String password) {
            this.loginService = loginService;
            this.identityService = identityService;
            this.tenantId = tenantId;
            this.userName = userName;
            this.password = password;
        }

        @Override
        public SSession getResult() {
            return this.session;
        }

        @Override
        public void execute() {
            SessionAccessor sessionAccessor = null;
            try {
                this.session = this.loginService.login(this.tenantId, this.userName, this.password);
                if (!this.session.isTechnicalUser()) {
                    sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
                    sessionAccessor.setSessionInfo(this.session.getId(), this.tenantId);
                    SUser sUser = this.identityService.getUserByUserName(this.userName);
                    if (!sUser.isEnabled()) {
                        throw new LoginException("Unable to login: the user is disable");
                    }
                    SUserUpdateBuilder userUpdateBuilder = BuilderFactory.get(SUserUpdateBuilderFactory.class).createNewInstance();
                    long lastConnection = System.currentTimeMillis();
                    EntityUpdateDescriptor updateDescriptor = userUpdateBuilder.updateLastConnection(lastConnection).done();
                    UpdateUser updateUser = new UpdateUser(this.identityService, sUser.getId(), updateDescriptor, null, null);
                    updateUser.execute();
                }
            }
            catch (Exception e) {
                throw new BonitaRuntimeException((Throwable)e);
            }
            finally {
                if (sessionAccessor != null) {
                    sessionAccessor.deleteSessionId();
                }
            }
        }
    }
}

