/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.Date;
import org.bonitasoft.engine.api.PlatformLoginAPI;
import org.bonitasoft.engine.api.impl.AbstractLoginApiImpl;
import org.bonitasoft.engine.api.impl.AvailableOnStoppedNode;
import org.bonitasoft.engine.api.impl.transaction.CustomTransactions;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.platform.login.PlatformLoginService;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.platform.PlatformLoginException;
import org.bonitasoft.engine.platform.PlatformLogoutException;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.session.SSessionNotFoundException;
import org.bonitasoft.engine.platform.session.model.SPlatformSession;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.PlatformSession;
import org.bonitasoft.engine.session.SessionNotFoundException;
import org.bonitasoft.engine.session.impl.PlatformSessionImpl;

public class PlatformLoginAPIImpl
extends AbstractLoginApiImpl
implements PlatformLoginAPI {
    @CustomTransactions
    @AvailableOnStoppedNode
    public PlatformSession login(String userName, String password) throws PlatformLoginException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PlatformLoginException(e.getMessage());
        }
        PlatformLoginService platformLoginService = platformAccessor.getPlatformLoginService();
        PlatformService platformService = platformAccessor.getPlatformService();
        this.putPlatformInCacheIfNecessary(platformAccessor, platformService);
        try {
            SPlatformSession platformSession = platformLoginService.login(userName, password);
            long id = platformSession.getId();
            Date creationDate = platformSession.getCreationDate();
            long duration = platformSession.getDuration();
            long userId = platformSession.getUserId();
            return new PlatformSessionImpl(id, creationDate, duration, userName, userId);
        }
        catch (SBonitaException e) {
            TechnicalLoggerService technicalLoggerService = platformAccessor.getTechnicalLoggerService();
            if (technicalLoggerService.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                technicalLoggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, e);
            }
            throw new PlatformLoginException(e.getMessage());
        }
    }

    @CustomTransactions
    @AvailableOnStoppedNode
    public void logout(PlatformSession session) throws PlatformLogoutException, SessionNotFoundException {
        PlatformServiceAccessor platformAccessor;
        try {
            platformAccessor = ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PlatformLogoutException(e.getMessage());
        }
        PlatformLoginService platformLoginService = platformAccessor.getPlatformLoginService();
        try {
            platformLoginService.logout(session.getId());
        }
        catch (SSessionNotFoundException e) {
            throw new SessionNotFoundException((Throwable)e);
        }
    }
}

