/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorBuilder;
import org.bonitasoft.engine.actor.mapping.model.SActorBuilderFactory;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.impl.resolver.ProcessDependencyResolver;
import org.bonitasoft.engine.api.impl.transaction.actor.ImportActorMapping;
import org.bonitasoft.engine.bpm.actor.ActorMappingImportException;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.process.Problem;
import org.bonitasoft.engine.bpm.process.impl.ProblemImpl;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.SActorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.xml.Parser;

public class ActorProcessDependencyResolver
extends ProcessDependencyResolver {
    @Override
    public boolean resolve(ProcessAPI processApi, TenantServiceAccessor tenantAccessor, BusinessArchive businessArchive, SProcessDefinition sDefinition) throws ActorMappingImportException {
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        BuilderFactory.getInstance();
        SActorBuilderFactory sActorBuilderFactory = BuilderFactory.get(SActorBuilderFactory.class);
        IdentityService identityService = tenantAccessor.getIdentityService();
        Parser parser = null;
        try {
            parser = tenantAccessor.getActorMappingParser();
        }
        catch (IllegalArgumentException e) {
            throw new ActorMappingImportException("unable to instantiate parser of actor mapping", (Throwable)e);
        }
        Set<SActorDefinition> actors = sDefinition.getActors();
        HashSet<SActor> sActors = new HashSet<SActor>(actors.size() + 1);
        SActorDefinition actorInitiator = sDefinition.getActorInitiator();
        String initiatorName = null;
        if (actorInitiator != null) {
            initiatorName = actorInitiator.getName();
            SActorBuilder sActorBuilder = sActorBuilderFactory.create(initiatorName, sDefinition.getId(), true);
            sActorBuilder.addDescription(actorInitiator.getDescription());
            sActors.add(sActorBuilder.getActor());
        }
        for (SActorDefinition actor : actors) {
            if (initiatorName != null && initiatorName.equals(actor.getName())) continue;
            SActorBuilder sActorBuilder = sActorBuilderFactory.create(actor.getName(), sDefinition.getId(), false);
            sActorBuilder.addDescription(actor.getDescription());
            sActors.add(sActorBuilder.getActor());
        }
        try {
            actorMappingService.addActors(sActors);
            byte[] actorMappingXML = businessArchive.getResource("actorMapping.xml");
            if (actorMappingXML != null) {
                String actorMapping = new String(actorMappingXML);
                ImportActorMapping importActorMapping = new ImportActorMapping(actorMappingService, identityService, parser, sDefinition.getId(), actorMapping);
                try {
                    importActorMapping.execute();
                }
                catch (SBonitaException e) {}
            }
        }
        catch (SBonitaException e) {
            // empty catch block
        }
        return this.checkResolution(actorMappingService, (long)sDefinition.getId()).isEmpty();
    }

    @Override
    public List<Problem> checkResolution(TenantServiceAccessor tenantAccessor, SProcessDefinition processDefinition) {
        ActorMappingService actorMappingService = tenantAccessor.getActorMappingService();
        long processDefinitionId = processDefinition.getId();
        return this.checkResolution(actorMappingService, processDefinitionId);
    }

    public List<Problem> checkResolution(ActorMappingService actorMappingService, long processDefinitionId) {
        try {
            List<SActor> actors = actorMappingService.getActors(processDefinitionId);
            ArrayList<Problem> problems = new ArrayList<Problem>();
            for (SActor sActor : actors) {
                List<SActorMember> actorMembers = actorMappingService.getActorMembers(sActor.getId(), 0, 1);
                if (!actorMembers.isEmpty()) continue;
                ProblemImpl problem = new ProblemImpl(Problem.Level.ERROR, sActor.getId(), "actor", "Actor '" + sActor.getName() + "' does not contain any members");
                problems.add((Problem)problem);
            }
            return problems;
        }
        catch (SBonitaReadException e) {
            return Collections.singletonList(new ProblemImpl(Problem.Level.ERROR, processDefinitionId, "process", "Unable to read actors"));
        }
    }
}

