/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.data;

import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.data.DataService;
import org.bonitasoft.engine.data.model.SDataSource;
import org.bonitasoft.engine.data.model.SDataSourceState;
import org.bonitasoft.engine.data.model.builder.SDataSourceBuilderFactory;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;

public class CreateDefaultDataSource
implements TransactionContent {
    private final DataService dataService;
    private final SessionService sessionService;
    private final long tenantId;
    private final String username;

    public CreateDefaultDataSource(DataService dataService, SessionService sessionService, long tenantId, String username) {
        this.dataService = dataService;
        this.sessionService = sessionService;
        this.username = username;
        this.tenantId = tenantId;
    }

    @Override
    public void execute() throws SBonitaException {
        SSession session = this.sessionService.createSession(this.tenantId, this.username);
        SDataSource bonitaDataSource = BuilderFactory.get(SDataSourceBuilderFactory.class).createNewInstance("bonita_data_source", "6.0", SDataSourceState.ACTIVE, "org.bonitasoft.engine.data.instance.DataInstanceDataSourceImpl").done();
        this.dataService.createDataSource(bonitaDataSource);
        SDataSource transientDataSource = BuilderFactory.get(SDataSourceBuilderFactory.class).createNewInstance("bonita_transient_data_source", "6.0", SDataSourceState.ACTIVE, "org.bonitasoft.engine.core.data.instance.impl.TransientDataInstanceDataSource").done();
        this.dataService.createDataSource(transientDataSource);
        this.sessionService.deleteSession(session.getId());
    }
}

