/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.exceptions.SObjectAlreadyExistsException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.model.SGroup;

public class CreateGroup
implements TransactionContent {
    private final SGroup sGroup;
    private final IdentityService identityService;

    public CreateGroup(SGroup sGroup, IdentityService identityService) {
        this.sGroup = sGroup;
        this.identityService = identityService;
    }

    @Override
    public void execute() throws SBonitaException {
        try {
            this.identityService.getGroupByPath(this.sGroup.getPath());
            String message = "Group named \"" + this.sGroup.getName() + "\" already exists";
            throw new SObjectAlreadyExistsException(message);
        }
        catch (SGroupNotFoundException e) {
            this.identityService.createGroup(this.sGroup);
            return;
        }
    }
}

