/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorMemberDeletionException;
import org.bonitasoft.engine.actor.mapping.SActorMemberNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.api.impl.transaction.identity.DeleteWithActorMembers;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileMemberBuilderFactory;
import org.bonitasoft.engine.profile.model.SProfileMember;

public class DeleteGroups
extends DeleteWithActorMembers
implements TransactionContent {
    private final IdentityService identityService;
    private final ActorMappingService actorMappingService;
    private final ProfileService profileService;
    private final List<Long> groupIds;

    public DeleteGroups(IdentityService identityService, ActorMappingService actorMappingService, ProfileService profileService, List<Long> groupIds) {
        this.identityService = identityService;
        this.actorMappingService = actorMappingService;
        this.groupIds = groupIds;
        this.profileService = profileService;
    }

    @Override
    public void execute() throws SBonitaException {
        ArrayList<Long> list = new ArrayList<Long>(this.groupIds);
        while (!list.isEmpty()) {
            Long groupId = list.get(0);
            this.deleteMembershipsByGroup(groupId);
            this.deleteActorMembers(groupId);
            this.deleteProfileMembers(groupId);
            List<Long> deleteChildrenGroup = this.identityService.deleteChildrenGroup(groupId);
            list.removeAll(deleteChildrenGroup);
            this.identityService.deleteGroup(groupId);
            list.remove(0);
        }
    }

    private void deleteActorMembers(Long groupId) throws SActorMemberNotFoundException, SActorMemberDeletionException, SBonitaReadException {
        List<SActorMember> actorMembers = this.actorMappingService.getActorMembersOfGroup(groupId);
        for (SActorMember sActorMember : actorMembers) {
            this.setActorIdsOfRemovedElements(this.actorMappingService.removeActorMember(sActorMember.getId()));
        }
    }

    private void deleteProfileMembers(Long groupId) throws SBonitaException {
        int numberOfElements = 1000;
        String field = BuilderFactory.get(SProfileMemberBuilderFactory.class).getIdKey();
        List<SProfileMember> profileMembers = this.profileService.getProfileMembersOfGroup(groupId, 0, 1000, field, OrderByType.ASC);
        while (profileMembers != null && !profileMembers.isEmpty()) {
            for (SProfileMember sProfileMember : profileMembers) {
                this.profileService.deleteProfileMember(sProfileMember);
            }
            profileMembers = this.profileService.getProfileMembersOfGroup(groupId, 0, 1000, field, OrderByType.ASC);
        }
    }

    private void deleteMembershipsByGroup(long groupId) throws SBonitaException {
        List<SUserMembership> memberships;
        int i = 0;
        do {
            memberships = this.identityService.getUserMembershipsOfGroup(groupId, i, i + 20);
            i += 20;
            for (SUserMembership sUserMembership : memberships) {
                this.identityService.deleteUserMembership(sUserMembership.getId());
            }
        } while (memberships.size() == 20);
    }
}

