/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.builder.SGroupBuilderFactory;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class UpdateGroup
implements TransactionContent {
    private static final int BATCH_SIZE = 100;
    private final long groupId;
    private final EntityUpdateDescriptor changeDescriptor;
    private final IdentityService identityService;
    private SGroup sGroup;

    public UpdateGroup(long groupId, EntityUpdateDescriptor changeDescriptor, IdentityService identityService) {
        this.groupId = groupId;
        this.changeDescriptor = changeDescriptor;
        this.identityService = identityService;
    }

    @Override
    public void execute() throws SBonitaException {
        this.sGroup = this.identityService.getGroup(this.groupId);
        this.updateGroup(this.sGroup, this.changeDescriptor);
    }

    private void updateGroup(SGroup group, EntityUpdateDescriptor changeDescriptor) throws SIdentityException {
        SGroupBuilderFactory sGroupFactiry = BuilderFactory.get(SGroupBuilderFactory.class);
        String parentPathKey = sGroupFactiry.getParentPathKey();
        String nameKey = sGroupFactiry.getNameKey();
        Map<String, Object> fields = changeDescriptor.getFields();
        if (fields.containsKey(parentPathKey) || fields.containsKey(nameKey)) {
            String parentPath = fields.containsKey(parentPathKey) ? (String)fields.get(parentPathKey) : group.getParentPath();
            String groupName = fields.containsKey(nameKey) ? (String)fields.get(nameKey) : group.getName();
            this.updateChildren(group, parentPath, sGroupFactiry.getIdKey(), parentPathKey, groupName);
        }
        this.identityService.updateGroup(group, changeDescriptor);
    }

    private void updateChildren(SGroup group, String parentPath, String idKey, String parentPathKey, String groupName) throws SIdentityException {
        List<SGroup> groupChildren = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(parentPath);
        stringBuilder.append('/');
        stringBuilder.append(groupName);
        String parentPath2 = stringBuilder.toString();
        int i = 0;
        do {
            groupChildren = this.identityService.getGroupChildren(group.getId(), i * 100, 100, idKey, OrderByType.ASC);
            ++i;
            for (SGroup child : groupChildren) {
                this.updateChildren(child, parentPath2, idKey, parentPathKey, child.getName());
            }
        } while (!groupChildren.isEmpty());
        EntityUpdateDescriptor updateDescriptor = new EntityUpdateDescriptor();
        updateDescriptor.addField(parentPathKey, parentPath);
        this.identityService.updateGroup(group, updateDescriptor);
    }
}

