/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.persistence.OrderByType;

public class GetChildInstanceIdsOfProcessInstance
implements TransactionContentWithResult<List<Long>> {
    private final ProcessInstanceService processInstanceService;
    private final long processInstanceId;
    private final int pageIndex;
    private final int numberPerPage;
    private final String sortingField;
    private final OrderByType sortingOrder;
    private List<Long> childInstanceIds;

    public GetChildInstanceIdsOfProcessInstance(ProcessInstanceService processInstanceService, long processInstanceId, int pageIndex, int numberPerPage, String field, OrderByType order) {
        this.processInstanceService = processInstanceService;
        this.processInstanceId = processInstanceId;
        this.pageIndex = pageIndex;
        this.numberPerPage = numberPerPage;
        this.sortingField = field;
        this.sortingOrder = order;
    }

    @Override
    public void execute() throws SBonitaException {
        this.childInstanceIds = this.processInstanceService.getChildInstanceIdsOfProcessInstance(this.processInstanceId, this.pageIndex * this.numberPerPage, this.numberPerPage, this.sortingField, this.sortingOrder);
    }

    @Override
    public List<Long> getResult() {
        return this.childInstanceIds;
    }
}

