/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.internal.servlet;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadException;
import org.bonitasoft.engine.api.impl.ServerAPIImpl;
import org.bonitasoft.engine.api.internal.ServerWrappedException;
import org.bonitasoft.engine.api.internal.servlet.ServletCall;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.exception.StackTraceTransformer;

public class HttpAPIServletCall
extends ServletCall {
    private static final String SLASH = "/";
    private static final String ARRAY = "[]";
    private static final String NULL = "null";
    private static final String BYTE_ARRAY = "==ByteArray==";
    private static final String CLASS_NAME_PARAMETERS = "classNameParameters";
    private static final String PARAMETERS_VALUES = "parametersValues";
    private static final String OPTIONS = "options";
    private static final XStream xstream = new XStream();

    public HttpAPIServletCall(HttpServletRequest request, HttpServletResponse response) throws FileUploadException, IOException {
        super(request, response);
    }

    @Override
    public void doGet() {
        this.error("GET method forbidden", 403);
    }

    @Override
    public void doPost() {
        try {
            Object invokeMethod;
            String apiInterfaceName = null;
            String methodName = null;
            String[] pathParams = this.getRequestURL().split(SLASH);
            if (pathParams != null && pathParams.length >= 2) {
                apiInterfaceName = pathParams[pathParams.length - 2];
                methodName = pathParams[pathParams.length - 1];
            }
            String options = this.getParameter(OPTIONS);
            String parametersValues = this.getParameter(PARAMETERS_VALUES);
            String parametersClasses = this.getParameter(CLASS_NAME_PARAMETERS);
            HashMap<String, Serializable> myOptions = new HashMap();
            if (options != null && !options.isEmpty()) {
                myOptions = (Map)this.fromXML(options, xstream);
            }
            ArrayList<String> myClassNameParameters = new ArrayList();
            if (parametersClasses != null && !parametersClasses.isEmpty() && !parametersClasses.equals(ARRAY)) {
                myClassNameParameters = (List)this.fromXML(parametersClasses, xstream);
            }
            Object[] myParametersValues = new Object[]{};
            if (parametersValues != null && !parametersValues.isEmpty() && !parametersValues.equals(NULL) && (myParametersValues = (Object[])this.fromXML(parametersValues, xstream)) != null && myParametersValues.length != 0) {
                Iterator<byte[]> binaryParameters = this.getBinaryParameters().iterator();
                for (int i = 0; i < myParametersValues.length; ++i) {
                    Object parameter = myParametersValues[i];
                    if (!BYTE_ARRAY.equals(parameter)) continue;
                    myParametersValues[i] = this.deserialize(binaryParameters.next());
                }
            }
            ServerAPIImpl serverAPI = new ServerAPIImpl();
            try {
                invokeMethod = serverAPI.invokeMethod(myOptions, apiInterfaceName, methodName, myClassNameParameters, myParametersValues);
            }
            catch (ServerWrappedException e) {
                throw StackTraceTransformer.mergeStackTraces((ServerWrappedException)e);
            }
            String invokeMethodSerialized = null;
            if (invokeMethod != null) {
                invokeMethodSerialized = this.toXML(invokeMethod, xstream);
            }
            this.output(invokeMethodSerialized);
        }
        catch (Exception e) {
            this.error(this.toResponse(e), 500);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T fromXML(String object, XStream xstream) {
        StringReader xmlReader = new StringReader(object);
        ObjectInputStream in = null;
        try {
            in = xstream.createObjectInputStream((Reader)xmlReader);
            try {
                Object object2 = in.readObject();
                return (T)object2;
            }
            catch (IOException e) {
                throw new BonitaRuntimeException("unable to deserialize object " + object, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BonitaRuntimeException("unable to deserialize object " + object, (Throwable)e);
            }
            finally {
                in.close();
                xmlReader.close();
            }
        }
        catch (IOException e) {
            throw new BonitaRuntimeException("unable to deserialize object " + object, (Throwable)e);
        }
    }

    @Override
    public void doPut() {
        this.error("PUT method forbidden", 403);
    }

    @Override
    public void doDelete() {
        this.error("DELETE method forbidden", 403);
    }

    private String toResponse(Exception exception) {
        Throwable result = null;
        result = exception instanceof ServerWrappedException ? exception.getCause() : exception;
        xstream.omitField(Throwable.class, "suppressedExceptions");
        return this.toXML(result, xstream);
    }

    private String toXML(Object object, XStream xstream) {
        StringWriter stringWriter = new StringWriter();
        try {
            ObjectOutputStream out = xstream.createObjectOutputStream((Writer)stringWriter);
            try {
                out.writeObject(object);
            }
            catch (IOException e) {
                throw new BonitaRuntimeException("unable to serialize object " + object.toString(), (Throwable)e);
            }
            finally {
                stringWriter.close();
                out.close();
            }
        }
        catch (IOException e1) {
            throw new BonitaRuntimeException("unable to serialize object " + object.toString(), (Throwable)e1);
        }
        return stringWriter.toString();
    }
}

