/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.classloader;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bonitasoft.engine.classloader.BonitaClassLoader;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.ParentClassLoaderResolver;
import org.bonitasoft.engine.classloader.ParentRedirectClassLoader;
import org.bonitasoft.engine.classloader.VirtualClassLoader;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class ClassLoaderServiceImpl
implements ClassLoaderService {
    private final ParentClassLoaderResolver parentClassLoaderResolver;
    private final TechnicalLoggerService logger;
    private final String temporaryFolder;
    private VirtualClassLoader virtualGlobalClassLoader;
    private final Map<String, VirtualClassLoader> localClassLoaders = new HashMap<String, VirtualClassLoader>();
    private static final String separator = ":";
    private static final String GLOBAL_FOLDER = "global";
    public static final String GLOBAL_TYPE = "___global___";
    public static final long GLOBAL_ID = -1L;
    private static final String LOCAL_FOLDER = "local";

    public ClassLoaderServiceImpl(ParentClassLoaderResolver parentClassLoaderResolver, String temporaryFolder, TechnicalLoggerService logger) {
        this.parentClassLoaderResolver = parentClassLoaderResolver;
        this.logger = logger;
        if (temporaryFolder.startsWith("${") && temporaryFolder.contains("}")) {
            Pattern pattern = Pattern.compile("^(.*)\\$\\{(.*)\\}(.*)$");
            Matcher matcher = pattern.matcher(temporaryFolder);
            matcher.find();
            StringBuilder sb = new StringBuilder();
            sb.append(matcher.group(1));
            sb.append(System.getProperty(matcher.group(2)));
            sb.append(matcher.group(3));
            this.temporaryFolder = sb.toString();
        } else {
            this.temporaryFolder = temporaryFolder;
        }
    }

    private String getKey(String type, long id) {
        StringBuffer stb = new StringBuffer();
        stb.append(type);
        stb.append(separator);
        stb.append(id);
        return stb.toString();
    }

    @Override
    public long getGlobalClassLoaderId() {
        return -1L;
    }

    @Override
    public String getGlobalClassLoaderType() {
        return GLOBAL_TYPE;
    }

    private synchronized VirtualClassLoader getVirtualGlobalClassLoader() {
        if (this.virtualGlobalClassLoader == null) {
            this.virtualGlobalClassLoader = new VirtualClassLoader(GLOBAL_TYPE, -1L, VirtualClassLoader.class.getClassLoader());
        }
        return this.virtualGlobalClassLoader;
    }

    @Override
    public synchronized ClassLoader getGlobalClassLoader() {
        return this.getVirtualGlobalClassLoader();
    }

    @Override
    public synchronized ClassLoader getLocalClassLoader(String type, long id) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getLocalClassLoader"));
        }
        NullCheckingUtil.checkArgsNotNull(id, type);
        String key = this.getKey(type, id);
        VirtualClassLoader classLoader = this.localClassLoaders.get(key);
        if (classLoader == null) {
            VirtualClassLoader virtualClassLoader = new VirtualClassLoader(type, id, new ParentRedirectClassLoader(this.getGlobalClassLoader(), this.parentClassLoaderResolver, this, type, id));
            this.localClassLoaders.put(key, virtualClassLoader);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getLocalClassLoader"));
        }
        return this.localClassLoaders.get(key);
    }

    @Override
    public void removeLocalClassLoader(String type, long id) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "removeLocalClassLoader"));
        }
        NullCheckingUtil.checkArgsNotNull(id, type);
        String key = this.getKey(type, id);
        VirtualClassLoader localClassLoader = this.localClassLoaders.get(key);
        if (localClassLoader != null) {
            localClassLoader.release();
            this.localClassLoaders.remove(key);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "removeLocalClassLoader"));
        }
    }

    private String getGlobalTemporaryFolder() {
        StringBuffer stb = new StringBuffer(this.temporaryFolder);
        stb.append(File.separator);
        stb.append(GLOBAL_FOLDER);
        return stb.toString();
    }

    private String getLocalTemporaryFolder(String artifactType, long artifactId) {
        StringBuffer stb = new StringBuffer(this.temporaryFolder);
        stb.append(File.separator);
        stb.append(LOCAL_FOLDER);
        stb.append(File.separator);
        stb.append(artifactType);
        stb.append(File.separator);
        stb.append(artifactId);
        return stb.toString();
    }

    @Override
    public synchronized void removeAllLocalClassLoaders(String application) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "removeAllLocalClassLoaders"));
        }
        NullCheckingUtil.checkArgsNotNull(application);
        HashSet<String> keySet = new HashSet<String>(this.localClassLoaders.keySet());
        for (String key : keySet) {
            if (!key.startsWith(application + separator)) continue;
            VirtualClassLoader localClassLoader = this.localClassLoaders.get(key);
            if (localClassLoader != null) {
                localClassLoader.release();
            }
            this.localClassLoaders.remove(key);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "removeAllLocalClassLoaders"));
        }
    }

    public String getTemporaryFolder() {
        return this.temporaryFolder;
    }

    @Override
    public synchronized void refreshGlobalClassLoader(Map<String, byte[]> resources) {
        VirtualClassLoader virtualClassloader = (VirtualClassLoader)this.getGlobalClassLoader();
        virtualClassloader.release();
        virtualClassloader.setClassLoader(new BonitaClassLoader(resources, this.getGlobalClassLoaderType(), this.getGlobalClassLoaderId(), this.getGlobalTemporaryFolder(), ClassLoaderServiceImpl.class.getClassLoader()));
    }

    @Override
    public synchronized void refreshLocalClassLoader(String type, long id, Map<String, byte[]> resources) {
        VirtualClassLoader virtualClassloader = (VirtualClassLoader)this.getLocalClassLoader(type, id);
        virtualClassloader.release();
        virtualClassloader.setClassLoader(new BonitaClassLoader(resources, type, id, this.getLocalTemporaryFolder(type, id), new ParentRedirectClassLoader(this.getGlobalClassLoader(), this.parentClassLoaderResolver, this, type, id)));
    }
}

