/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.category.persistence;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.core.category.model.SCategory;
import org.bonitasoft.engine.core.category.model.SProcessCategoryMapping;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;

public class SelectDescriptorBuilder {
    private static final String PROCESS_ID = "processId";

    public static SelectByIdDescriptor<SCategory> getCategory(long categoryId) {
        return new SelectByIdDescriptor<SCategory>("getCategoryById", SCategory.class, categoryId);
    }

    public static SelectOneDescriptor<SCategory> getCategory(String categoryName) {
        Map<String, Object> parameters = Collections.singletonMap("name", categoryName);
        return new SelectOneDescriptor<SCategory>("getCategoryByName", parameters, SCategory.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfElement(String elementName, Class<? extends PersistentObject> clazz) {
        Map<String, Object> parameters = Collections.emptyMap();
        return new SelectOneDescriptor<Long>("getNumberOf" + elementName, parameters, clazz, Long.class);
    }

    public static SelectListDescriptor<SCategory> getCategories(String field, OrderByType order, int fromIndex, int numberOfProcesses) {
        Map<String, Object> parameters = Collections.emptyMap();
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfProcesses, SCategory.class, field, order);
        return new SelectListDescriptor<SCategory>("getCategories", parameters, SCategory.class, queryOptions);
    }

    public static SelectListDescriptor<Long> getProcessIdsOfCategory(long categoryId) {
        Map<String, Object> parameters = Collections.singletonMap("categoryId", categoryId);
        return new SelectListDescriptor<Long>("getProcessIdsOfCategory", parameters, SProcessCategoryMapping.class, Long.class);
    }

    public static SelectListDescriptor<SCategory> getCategoriesOfProcess(long processId, int fromIndex, int numberOfCategories, OrderByType order) {
        Map<String, Object> parameters = Collections.singletonMap(PROCESS_ID, processId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfCategories, SCategory.class, "name", order);
        return new SelectListDescriptor<SCategory>("getCategoriesOfProcess", parameters, SCategory.class, queryOptions);
    }

    public static SelectListDescriptor<SCategory> getCategoriesUnrelatedToProcess(long processId, int fromIndex, int numberOfCategories, OrderByType order) {
        Map<String, Object> parameters = Collections.singletonMap(PROCESS_ID, processId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfCategories, SCategory.class, "name", order);
        return new SelectListDescriptor<SCategory>("getCategoriesUnrelatedToProcess", parameters, SCategory.class, queryOptions);
    }

    public static SelectOneDescriptor<Long> getNumberOfCategoriesOfProcess(long processId) {
        Map<String, Object> parameters = Collections.singletonMap(PROCESS_ID, processId);
        return new SelectOneDescriptor<Long>("getNumberOfCategoriesOfProcess", parameters, SProcessCategoryMapping.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfCategoriesUnrelatedToProcess(long processId) {
        Map<String, Object> parameters = Collections.singletonMap(PROCESS_ID, processId);
        return new SelectOneDescriptor<Long>("getNumberOfCategoriesUnrelatedToProcess", parameters, SProcessCategoryMapping.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfCategorizedProcessIds(List<Long> processIds) {
        Map<String, Object> parameters = Collections.singletonMap("processIds", processIds);
        return new SelectOneDescriptor<Long>("getNumberOfCategorizedProcessIds", parameters, SProcessCategoryMapping.class, Long.class);
    }

    public static SelectListDescriptor<Long> getCategorizedProcessIds(List<Long> processIds) {
        Map<String, Object> parameters = Collections.singletonMap("processIds", processIds);
        return new SelectListDescriptor<Long>("getCategorizedProcessIds", parameters, SProcessCategoryMapping.class);
    }

    public static SelectOneDescriptor<Long> isCategoryExistsInProcess(long categoryId, long processDefinitionId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("categoryId", categoryId);
        parameters.put("processDefinitionId", processDefinitionId);
        return new SelectOneDescriptor<Long>("isCategoryExistsInProcess", parameters, SProcessCategoryMapping.class);
    }

    public static SelectListDescriptor<SProcessCategoryMapping> getCategoryMappingOfProcessAndCategories(long processDefinitionId, List<Long> categoryIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("categoryIds", categoryIds);
        parameters.put("processDefinitionId", processDefinitionId);
        return new SelectListDescriptor<SProcessCategoryMapping>("getCategoryMappingOfProcessAndCategories", parameters, SProcessCategoryMapping.class);
    }
}

