/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.connector.parser;

import java.util.List;
import org.bonitasoft.engine.core.connector.parser.JarDependencies;
import org.bonitasoft.engine.core.connector.parser.SConnectorImplementationDescriptor;
import org.bonitasoft.engine.xml.XMLNode;

public class DescriptorNodeBuilder {
    public static XMLNode getDocument(SConnectorImplementationDescriptor descriptor) {
        XMLNode connector = new XMLNode("connectorImplementation");
        connector.addAttribute("implementationId", descriptor.getId());
        connector.addAttribute("implementationVersion", descriptor.getVersion());
        connector.addAttribute("definitionId", descriptor.getDefinitionId());
        connector.addAttribute("definitionVersion", descriptor.getDefinitionVersion());
        connector.addAttribute("implementationClassname", descriptor.getImplementationClassName());
        JarDependencies jarDependencies = descriptor.getJarDependencies();
        if (jarDependencies != null) {
            XMLNode jarDependenciesNodes = DescriptorNodeBuilder.getJarDependencies(jarDependencies);
            connector.addChild(jarDependenciesNodes);
        }
        return connector;
    }

    private static XMLNode getJarDependencies(JarDependencies jarDependencies) {
        XMLNode jarDependenciesNode = new XMLNode("jarDependencies");
        List<String> dependencies = jarDependencies.getDependencies();
        for (int i = 0; i < dependencies.size(); ++i) {
            String dependency = dependencies.get(i);
            XMLNode dependencyNode = new XMLNode("jarDependency");
            dependencyNode.setContent(dependency);
            jarDependenciesNode.addChild(dependencyNode);
        }
        return jarDependenciesNode;
    }
}

