/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategyProvider;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class OperationServiceImpl
implements OperationService {
    private final Map<String, OperationExecutorStrategy> operationExecutorsMap;
    private final ExpressionResolverService expressionResolverService;
    private final DataInstanceService dataInstanceService;
    private final TechnicalLoggerService logger;

    public OperationServiceImpl(OperationExecutorStrategyProvider operationExecutorStrategyProvider, ExpressionResolverService expressionResolverService, TechnicalLoggerService logger, DataInstanceService dataInstanceService) {
        this.expressionResolverService = expressionResolverService;
        this.dataInstanceService = dataInstanceService;
        this.logger = logger;
        List<OperationExecutorStrategy> expressionExecutors = operationExecutorStrategyProvider.getOperationExecutors();
        this.operationExecutorsMap = new HashMap<String, OperationExecutorStrategy>(expressionExecutors.size());
        for (OperationExecutorStrategy operationExecutorStrategy : expressionExecutors) {
            this.operationExecutorsMap.put(operationExecutorStrategy.getOperationType(), operationExecutorStrategy);
        }
    }

    private OperationExecutorStrategy getOperationExecutorStrategy(SOperation operation) throws SOperationExecutionException {
        String operatorTypeName = operation.getType().name();
        OperationExecutorStrategy operationExecutorStrategy = this.operationExecutorsMap.get(operatorTypeName);
        if (operationExecutorStrategy == null) {
            throw new SOperationExecutionException("Unable to find an executor for operation type " + operatorTypeName);
        }
        return operationExecutorStrategy;
    }

    @Override
    public void execute(SOperation operation, long dataContainerId, String dataContainerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.executeOperation(operation, dataContainerId, dataContainerType, expressionContext);
    }

    @Override
    public void execute(SOperation operation, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.execute(operation, (long)expressionContext.getContainerId(), expressionContext.getContainerType(), expressionContext);
    }

    private void executeOperation(SOperation operation, long dataContainerId, String dataContainerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.execute(Arrays.asList(operation), dataContainerId, dataContainerType, expressionContext);
    }

    protected Object getOperationValue(SOperation operation, SExpressionContext expressionContext, SExpression sExpression) throws SOperationExecutionException {
        try {
            return this.expressionResolverService.evaluate(sExpression, expressionContext);
        }
        catch (ClassCastException e) {
            throw new SOperationExecutionException("Trying to set variable " + operation.getLeftOperand().getName() + " a value which is not Serializable", e);
        }
        catch (SBonitaException e) {
            throw new SOperationExecutionException(e);
        }
    }

    @Override
    public void execute(List<SOperation> operations, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.execute(operations, (long)expressionContext.getContainerId(), expressionContext.getContainerType(), expressionContext);
    }

    @Override
    public void execute(List<SOperation> operations, long dataContainerId, String dataContainerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.retrieveDataInstancesToSetAndPutItInExpressionContextIfNotIn(operations, expressionContext);
        HashMap<SLeftOperand, OperationExecutorStrategy> updates = new HashMap<SLeftOperand, OperationExecutorStrategy>();
        for (SOperation sOperation : operations) {
            Object operationValue = this.getOperationValue(sOperation, expressionContext, sOperation.getRightOperand());
            OperationExecutorStrategy operationExecutorStrategy = this.getOperationExecutorStrategy(sOperation);
            Object value = operationExecutorStrategy.getValue(sOperation, operationValue, dataContainerId, dataContainerType, expressionContext);
            if (!operationExecutorStrategy.doUpdateData()) {
                operationExecutorStrategy.update(sOperation.getLeftOperand(), value, dataContainerId, dataContainerType);
            } else {
                expressionContext.getInputValues().put(sOperation.getLeftOperand().getName(), value);
                updates.put(sOperation.getLeftOperand(), operationExecutorStrategy);
            }
            if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) continue;
            StringBuilder stb = new StringBuilder();
            stb.append("Executed operation on container [id: '");
            stb.append(dataContainerId);
            stb.append("', type: '");
            stb.append(dataContainerType);
            stb.append("']. Operation: [left operand: '");
            stb.append(sOperation.getLeftOperand().getName());
            stb.append("', operator: '");
            stb.append(sOperation.getOperator());
            stb.append("', operation value: '");
            stb.append(operationValue);
            stb.append("']");
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, stb.toString());
        }
        for (Map.Entry entry : updates.entrySet()) {
            ((OperationExecutorStrategy)entry.getValue()).update((SLeftOperand)entry.getKey(), expressionContext.getInputValues().get(((SLeftOperand)entry.getKey()).getName()), dataContainerId, dataContainerType);
        }
    }

    private void retrieveDataInstancesToSetAndPutItInExpressionContextIfNotIn(List<SOperation> operations, SExpressionContext expressionContext) throws SOperationExecutionException {
        if (expressionContext.getContainerId() != null) {
            List<SDataInstance> dataInstances;
            HashSet<String> names = new HashSet<String>(operations.size());
            for (SOperation operation : operations) {
                if (!this.getOperationExecutorStrategy(operation).doUpdateData()) continue;
                names.add(operation.getLeftOperand().getName());
            }
            try {
                dataInstances = this.dataInstanceService.getDataInstances(new ArrayList<String>(names), expressionContext.getContainerId(), expressionContext.getContainerType());
            }
            catch (SDataInstanceException e) {
                throw new SOperationExecutionException(e);
            }
            Map<String, Object> inputValues = expressionContext.getInputValues();
            for (SDataInstance dataInstance : dataInstances) {
                if (inputValues.containsKey(dataInstance.getName())) continue;
                inputValues.put(dataInstance.getName(), dataInstance.getValue());
            }
        }
    }
}

