/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.bindings;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bonitasoft.engine.bpm.connector.FailAction;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SActorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SAutomaticTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SCallActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SDocumentDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SGatewayDefinition;
import org.bonitasoft.engine.core.process.definition.model.SHumanTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SManualTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SMultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SParameterDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SReceiveTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSendTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSubProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.SUserFilterDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SBoundaryEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SCatchEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SIntermediateCatchEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SIntermediateThrowEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SThrowEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCatchSignalEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SCorrelationDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.STerminateEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowMessageEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowSignalEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.STimerEventTriggerDefinition;
import org.bonitasoft.engine.core.process.definition.model.impl.SStandardLoopCharacteristicsImpl;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.definition.model.STextDataDefinition;
import org.bonitasoft.engine.data.definition.model.SXMLDataDefinition;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.xml.XMLNode;

public class XMLSProcessDefinition {
    public static final String CORRELATION_VALUE = "value";
    public static final String CORRELATION_KEY = "key";
    public static final String NAMESPACE = "http://www.bonitasoft.org/ns/process/server/6.0";
    public static final String PROCESS_NODE = "processDefinition";
    public static final String TRANSITIONS_NODE = "transitions";
    public static final String FLOW_ELEMENTS_NODE = "flowElements";
    public static final String FLOW_NODES_NODE = "flowNodes";
    public static final String CONNECTORS_NODE = "connectors";
    public static final String DATA_DEFINITIONS_NODE = "dataDefinitions";
    public static final String DOCUMENT_DEFINITIONS_NODE = "documentDefinitions";
    public static final String DOCUMENT_DEFINITION_NODE = "documentDefinition";
    public static final String DOCUMENT_DEFINITION_URL = "url";
    public static final String DOCUMENT_DEFINITION_FILE = "file";
    public static final String DOCUMENT_DEFINITION_FILE_NAME = "fileName";
    public static final String DOCUMENT_DEFINITION_MIME_TYPE = "mimeType";
    public static final String OPERATIONS_NODE = "operations";
    public static final String DEPENDENCIES_NODE = "dependencies";
    public static final String ACTORS_NODE = "actors";
    public static final String PARAMETERS_NODE = "parameters";
    public static final String ACTOR_NODE = "actor";
    public static final String INITIATOR_NODE = "actorInitiator";
    public static final String CONNECTOR_NODE = "connector";
    public static final String USER_FILTER_NODE = "userFilter";
    public static final String DATA_DEFINITION_NODE = "dataDefinition";
    public static final String USER_TASK_NODE = "userTask";
    public static final String MANUAL_TASK_NODE = "manualTask";
    public static final String AUTOMATIC_TASK_NODE = "automaticTask";
    public static final String RECEIVE_TASK_NODE = "receiveTask";
    public static final String SEND_TASK_NODE = "sendTask";
    public static final String CALL_ACTIVITY_NODE = "callActivity";
    public static final String DATA_INPUT_OPERATION_NODE = "dataInputOperation";
    public static final String DATA_OUTPUT_OPERATION_NODE = "dataOutputOperation";
    public static final String CALLABLE_ELEMENT_NODE = "callableElement";
    public static final String CALLABLE_ELEMENT_VERSION_NODE = "callableElementVersion";
    public static final String CALLABLE_ELEMENT_TYPE = "callableElementType";
    public static final String GATEWAY_NODE = "gateway";
    public static final String PARAMETER_NODE = "parameter";
    public static final String START_EVENT_NODE = "startEvent";
    public static final String INTERMEDIATE_CATCH_EVENT_NODE = "intermediateCatchEvent";
    public static final String INTERMEDIATE_THROW_EVENT_NODE = "intermediateThrowEvent";
    public static final String END_EVENT_NODE = "endEvent";
    public static final String BOUNDARY_EVENTS_NODE = "boundaryEvents";
    public static final String BOUNDARY_EVENT_NODE = "boundaryEvent";
    public static final String INTERRUPTING = "interrupting";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String IDREF = "idref";
    public static final String VERSION = "version";
    public static final String DESCRIPTION = "description";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DISPLAY_DESCRIPTION = "displayDescription";
    public static final String STRING_INDEXES = "stringIndexes";
    public static final String STRING_INDEX = "stringIndex";
    public static final String INDEX = "index";
    public static final String LABEL = "label";
    public static final String DISPLAY_DESCRIPTION_AFTER_COMPLETION = "displayDescriptionAfterCompletion";
    public static final String INCOMING_TRANSITION = "incomingTransition";
    public static final String OUTGOING_TRANSITION = "outgoingTransition";
    public static final String TRANSITION_NODE = "transition";
    public static final String TRANSITION_SOURCE = "source";
    public static final String TRANSITION_TARGET = "target";
    public static final String TRANSITION_CONDITION = "condition";
    public static final String ACTOR_NAME = "actorName";
    public static final String CONNECTOR_ID = "connectorId";
    public static final String CONNECTOR_ACTIVATION_EVENT = "activationEvent";
    public static final String CONNECTOR_FAIL_ACTION = "failAction";
    public static final String CONNECTOR_ERROR_CODE = "errorCode";
    public static final String CONNECTOR_INPUT = "input";
    public static final String CONNECTOR_INPUT_NAME = "inputName";
    public static final String USER_FILTER_ID = "userFilterId";
    public static final String DATA_DEFINITION_CLASS = "className";
    public static final String DATA_DEFINITION_TRANSIENT = "transient";
    public static final String EXPRESSION_NODE = "expression";
    public static final String EXPRESSION_TYPE = "expressionType";
    public static final String EXPRESSION_RETURN_TYPE = "returnType";
    public static final String EXPRESSION_INTERPRETER = "interpreter";
    public static final String EXPRESSION_CONTENT = "content";
    public static final String GATEWAY_TYPE = "gatewayType";
    public static final String DEFAULT_TRANSITION = "defaultTransition";
    public static final String PARAMETER_TYPE = "type";
    public static final String BOS_VERSION = "bos_version";
    private static final String BOS_CURRENT_VERSION = "6.0-SNAPSHOT";
    public static final String DEFAULT_VALUE_NODE = "defaultValue";
    public static final String TIMER_EVENT_TRIGGER_NODE = "timerEventTrigger";
    public static final String CATCH_MESSAGE_EVENT_TRIGGER_NODE = "catchMessageEventTrigger";
    public static final String THROW_MESSAGE_EVENT_TRIGGER_NODE = "throwMessageEventTrigger";
    public static final String CATCH_SIGNAL_EVENT_TRIGGER_NODE = "catchSignalEventTrigger";
    public static final String CATCH_ERROR_EVENT_TRIGGER_NODE = "catchErrorEventTrigger";
    public static final String THROW_SIGNAL_EVENT_TRIGGER_NODE = "throwSignalEventTrigger";
    public static final String THROW_ERROR_EVENT_TRIGGER_NODE = "throwErrorEventTrigger";
    public static final String TERMINATE_EVENT_TRIGGER_NODE = "terminateEventTrigger";
    public static final String TIMER_EVENT_TRIGGER_TIMER_TYPE = "type";
    public static final String ERROR_CODE = "errorCode";
    public static final String CORRELATION_NODE = "correlation";
    public static final String TARGET_PROCESS = "targetProcess";
    public static final String TARGET_FLOW_NODE = "targetFlowNode";
    public static final String OPERATION_NODE = "operation";
    public static final String OPERATION_RIGHT_OPERAND = "rightOperand";
    public static final String OPERATION_LEFT_OPERAND = "leftOperand";
    public static final String OPERATION_OPERATOR_TYPE = "operatorType";
    public static final String OPERATION_OPERATOR = "operator";
    public static final String LEFT_OPERAND_NAME = "name";
    public static final String CONNECTOR_INPUTS_NODE = "inputs";
    public static final String CONNECTOR_OUTPUTS_NODE = "outputs";
    public static final String CONNECTOR_VERSION = "version";
    public static final String STANDARD_LOOP_CHARACTERISTICS_NODE = "standardLoopCharacteristics";
    public static final String LOOP_CONDITION = "loopCondition";
    public static final String TEST_BEFORE = "testBefore";
    public static final String LOOP_MAX = "loopMax";
    public static final String MULTI_INSTANCE_LOOP_CHARACTERISTICS_NODE = "multiInstanceLoopCharacteristics";
    public static final String MULTI_INSTANCE_IS_SEQUENTIAL = "isSequential";
    public static final String MULTI_INSTANCE_DATA_INPUT_ITEM_REF = "dataInputItemRef";
    public static final String MULTI_INSTANCE_DATA_OUTPUT_ITEM_REF = "dataOutputItemRef";
    public static final String MULTI_INSTANCE_LOOP_DATA_INPUT = "loopDataInputRef";
    public static final String MULTI_INSTANCE_LOOP_DATA_OUTPUT = "loopDataOutputRef";
    public static final String MULTI_INSTANCE_LOOP_CARDINALITY = "loopCardinality";
    public static final String MULTI_INSTANCE_COMPLETION_CONDITION = "completionCondition";
    public static final String PRIORITY = "priority";
    public static final String EXPECTED_DURATION = "expectedDuration";
    public static final String XML_DATA_DEFINITION_NAMESPACE = "namespace";
    public static final String XML_DATA_DEFINITION_ELEMENT = "element";
    public static final String XML_DATA_DEFINITION_NODE = "xmlDataDefinition";
    public static final String TEXT_DATA_DEFINITION_NODE = "textDataDefinition";
    public static final String TEXT_DATA_DEFINITION_LONG = "longText";
    public static final String SUB_PROCESS = "subProcess";
    public static final String TRIGGERED_BY_EVENT = "triggeredByEvent";
    private final Map<Object, String> objectToId = new HashMap<Object, String>();

    public XMLNode getXMLProcessDefinition(SProcessDefinition definition) {
        XMLNode rootNode = new XMLNode(PROCESS_NODE);
        rootNode.addAttribute(ID, String.valueOf(definition.getId()));
        rootNode.addAttribute("name", definition.getName());
        rootNode.addAttribute("version", definition.getVersion());
        rootNode.addAttribute(BOS_VERSION, BOS_CURRENT_VERSION);
        rootNode.addAttribute(DESCRIPTION, definition.getDescription());
        XMLNode stringIndexes = new XMLNode(STRING_INDEXES);
        for (int i = 1; i <= 5; ++i) {
            XMLNode xmlNode = new XMLNode(STRING_INDEX);
            xmlNode.addAttribute(INDEX, String.valueOf(i));
            xmlNode.addAttribute(LABEL, definition.getStringIndexLabel(i));
            SExpression stringIndexValue = definition.getStringIndexValue(i);
            if (stringIndexValue != null) {
                XMLNode value = new XMLNode(EXPRESSION_NODE);
                this.fillExpressionNode(value, stringIndexValue);
                xmlNode.addChild(value);
            }
            stringIndexes.addChild(xmlNode);
        }
        rootNode.addChild(stringIndexes);
        rootNode.addAttribute("xmlns", NAMESPACE);
        this.createAndFillFlowElements(rootNode, definition.getProcessContainer());
        XMLNode dependencies = new XMLNode(DEPENDENCIES_NODE);
        rootNode.addChild(dependencies);
        XMLNode parameters = new XMLNode(PARAMETERS_NODE);
        dependencies.addChild(parameters);
        for (SParameterDefinition parameter : definition.getParameters()) {
            XMLNode parameterNode = new XMLNode(PARAMETER_NODE);
            this.fillParameterNode(parameterNode, parameter);
            parameters.addChild(parameterNode);
        }
        XMLNode actors = new XMLNode(ACTORS_NODE);
        dependencies.addChild(actors);
        for (SActorDefinition actor : definition.getActors()) {
            XMLNode actorNode = new XMLNode(ACTOR_NODE);
            this.fillActorNode(actorNode, actor);
            actors.addChild(actorNode);
        }
        SActorDefinition actorInitiator = definition.getActorInitiator();
        if (actorInitiator != null) {
            XMLNode initiatorNode = new XMLNode(INITIATOR_NODE);
            rootNode.addChild(initiatorNode);
            this.fillActorNode(initiatorNode, actorInitiator);
        }
        return rootNode;
    }

    private void createAndFillFlowElements(XMLNode containerNode, SFlowElementContainerDefinition container) {
        XMLNode flowElements = new XMLNode(FLOW_ELEMENTS_NODE);
        containerNode.addChild(flowElements);
        XMLNode transitionsNode = new XMLNode(TRANSITIONS_NODE);
        flowElements.addChild(transitionsNode);
        for (STransitionDefinition transition : container.getTransitions()) {
            XMLNode transitionNode = new XMLNode(TRANSITION_NODE);
            String id = String.valueOf(Math.abs(UUID.randomUUID().getMostSignificantBits()));
            this.objectToId.put(transition, id);
            transitionNode.addAttribute(ID, id);
            this.fillTransitionNode(transitionNode, transition);
            transitionsNode.addChild(transitionNode);
        }
        XMLNode connectorsNode = new XMLNode(CONNECTORS_NODE);
        flowElements.addChild(connectorsNode);
        for (SConnectorDefinition connector : container.getConnectors()) {
            XMLNode connectorNode = new XMLNode(CONNECTOR_NODE);
            this.fillConnectorNode(connectorNode, connector);
            connectorsNode.addChild(connectorNode);
        }
        XMLNode dataDefinitionsNode = new XMLNode(DATA_DEFINITIONS_NODE);
        flowElements.addChild(dataDefinitionsNode);
        for (SDataDefinition dataDefinition : container.getDataDefinitions()) {
            XMLNode dataDefinitionNode = this.getDataDefinitionNode(dataDefinition);
            dataDefinitionsNode.addChild(dataDefinitionNode);
        }
        XMLNode documentDefinitionsNode = new XMLNode(DOCUMENT_DEFINITIONS_NODE);
        flowElements.addChild(documentDefinitionsNode);
        for (SDocumentDefinition document : container.getDocumentDefinitions()) {
            XMLNode documentDefinitionNode = new XMLNode(DOCUMENT_DEFINITION_NODE);
            this.fillDocumentDefinitionNode(documentDefinitionNode, document);
            documentDefinitionsNode.addChild(documentDefinitionNode);
        }
        this.createAndFillFlowNodes(container, flowElements);
    }

    private void createAndFillFlowNodes(SFlowElementContainerDefinition container, XMLNode flowElements) {
        XMLNode flowNodes = new XMLNode(FLOW_NODES_NODE);
        flowElements.addChild(flowNodes);
        for (SActivityDefinition activity : container.getActivities()) {
            XMLNode activityNode;
            if (activity instanceof SCallActivityDefinition) {
                activityNode = new XMLNode(CALL_ACTIVITY_NODE);
            } else if (activity instanceof SAutomaticTaskDefinition) {
                activityNode = new XMLNode(AUTOMATIC_TASK_NODE);
            } else if (activity instanceof SReceiveTaskDefinition) {
                activityNode = new XMLNode(RECEIVE_TASK_NODE);
            } else if (activity instanceof SSendTaskDefinition) {
                activityNode = new XMLNode(SEND_TASK_NODE);
            } else if (activity instanceof SSubProcessDefinition) {
                activityNode = new XMLNode(SUB_PROCESS);
            } else {
                activityNode = activity instanceof SManualTaskDefinition ? new XMLNode(MANUAL_TASK_NODE) : new XMLNode(USER_TASK_NODE);
                this.fillHumanTask(activity, activityNode);
            }
            this.fillFlowNode(activityNode, activity);
            this.addDataDefinitionNodes(activity, activityNode);
            this.addOperationNodes(activity, activityNode);
            this.addLoopCharacteristics(activity, activityNode);
            this.addBoundaryEventDefinitionsNode(activity, activityNode);
            if (activity instanceof SHumanTaskDefinition) {
                SHumanTaskDefinition humanTaskDefinition = (SHumanTaskDefinition)activity;
                if (humanTaskDefinition.getSUserFilterDefinition() != null) {
                    XMLNode userFilterNode = new XMLNode(USER_FILTER_NODE);
                    this.fillUserFilterNode(userFilterNode, humanTaskDefinition.getSUserFilterDefinition());
                    activityNode.addChild(userFilterNode);
                }
            } else if (activity instanceof SCallActivityDefinition) {
                this.fillCallActivity((SCallActivityDefinition)activity, activityNode);
            } else if (activity instanceof SSubProcessDefinition) {
                this.fillSubProcess((SSubProcessDefinition)activity, activityNode);
            } else if (activity instanceof SReceiveTaskDefinition) {
                this.fillReceiveTask((SReceiveTaskDefinition)activity, activityNode);
            } else if (activity instanceof SSendTaskDefinition) {
                this.fillSendTask((SSendTaskDefinition)activity, activityNode);
            }
            flowNodes.addChild(activityNode);
        }
        for (SGatewayDefinition gateway : container.getGateways()) {
            XMLNode gatewayNode = new XMLNode(GATEWAY_NODE);
            this.fillGatewayNode(gatewayNode, gateway);
            flowNodes.addChild(gatewayNode);
        }
        this.createAndfillStartEvents(container.getStartEvents(), flowNodes);
        this.createAndfillIntermediateCatchEvents(container.getIntermediateCatchEvents(), flowNodes);
        this.createAndfillIntermediatThrowEvents(container.getIntermdiateThrowEvents(), flowNodes);
        this.createAndfillEndEvents(container.getEndEvents(), flowNodes);
    }

    private void addBoundaryEventDefinitionsNode(SActivityDefinition activity, XMLNode activityNode) {
        XMLNode boundaryEventsNode = new XMLNode(BOUNDARY_EVENTS_NODE);
        activityNode.addChild(boundaryEventsNode);
        this.addBoundaryEventDefinitionNodes(activity, boundaryEventsNode);
    }

    private void addBoundaryEventDefinitionNodes(SActivityDefinition activity, XMLNode boundaryEventsNode) {
        for (SBoundaryEventDefinition boundaryEvent : activity.getBoundaryEventDefinitions()) {
            XMLNode boundaryEventNode = new XMLNode(BOUNDARY_EVENT_NODE);
            this.fillFlowNode(boundaryEventNode, boundaryEvent);
            this.fillCatchEventDefinition(boundaryEventNode, boundaryEvent);
            boundaryEventsNode.addChild(boundaryEventNode);
        }
    }

    private void fillSubProcess(SSubProcessDefinition activity, XMLNode activityNode) {
        activityNode.addAttribute(TRIGGERED_BY_EVENT, String.valueOf(activity.isTriggeredByEvent()));
        this.createAndFillFlowElements(activityNode, activity.getSubProcessContainer());
    }

    private void fillCallActivity(SCallActivityDefinition activity, XMLNode activityNode) {
        this.addExpressionNode(activityNode, CALLABLE_ELEMENT_NODE, activity.getCallableElement());
        this.addExpressionNode(activityNode, CALLABLE_ELEMENT_VERSION_NODE, activity.getCallableElementVersion());
        this.createAndfillOperations(activityNode, activity.getDataInputOperations(), DATA_INPUT_OPERATION_NODE);
        this.createAndfillOperations(activityNode, activity.getDataOutputOperations(), DATA_OUTPUT_OPERATION_NODE);
        activityNode.addAttribute(CALLABLE_ELEMENT_TYPE, activity.getCallableElementType().name());
    }

    private void fillReceiveTask(SReceiveTaskDefinition receiveTask, XMLNode activityNode) {
        this.createAndfillMessageEventTriggers(activityNode, receiveTask.getTrigger());
    }

    private void fillSendTask(SSendTaskDefinition sendTask, XMLNode activityNode) {
        this.createAndfillMessageEventTrigger(activityNode, sendTask.getMessageTrigger());
    }

    private void fillHumanTask(SActivityDefinition activity, XMLNode activityNode) {
        SHumanTaskDefinition humanTaskDefinition = (SHumanTaskDefinition)activity;
        String actorName = humanTaskDefinition.getActorName();
        activityNode.addAttribute(ACTOR_NAME, actorName);
        String priority = humanTaskDefinition.getPriority();
        activityNode.addAttribute(PRIORITY, priority);
        Long expectedDuration = humanTaskDefinition.getExpectedDuration();
        if (expectedDuration != null) {
            activityNode.addAttribute(EXPECTED_DURATION, String.valueOf(expectedDuration));
        }
    }

    private void createAndfillStartEvents(List<SStartEventDefinition> startEvents, XMLNode flowNodes) {
        for (SStartEventDefinition startEvent : startEvents) {
            XMLNode startEventNode = new XMLNode(START_EVENT_NODE);
            this.fillFlowNode(startEventNode, startEvent);
            this.fillCatchEventDefinition(startEventNode, startEvent);
            flowNodes.addChild(startEventNode);
        }
    }

    private void createAndfillEndEvents(List<SEndEventDefinition> endEvents, XMLNode flowNodes) {
        for (SEndEventDefinition endEvent : endEvents) {
            XMLNode endEventNode = new XMLNode(END_EVENT_NODE);
            this.fillFlowNode(endEventNode, endEvent);
            this.fillThrowEventDefinition(endEventNode, endEvent);
            this.createAndFillTerminateEventTrigger(endEventNode, endEvent);
            this.createAndfillErrorEventTriggers(endEventNode, endEvent);
            flowNodes.addChild(endEventNode);
        }
    }

    private void createAndFillTerminateEventTrigger(XMLNode eventNode, SEndEventDefinition event) {
        STerminateEventTriggerDefinition terminateEventTriggerDefinition = event.getTerminateEventTriggerDefinition();
        if (terminateEventTriggerDefinition != null) {
            XMLNode terminateEventTriggerNode = new XMLNode(TERMINATE_EVENT_TRIGGER_NODE);
            eventNode.addChild(terminateEventTriggerNode);
        }
    }

    private void createAndfillIntermediatThrowEvents(List<SIntermediateThrowEventDefinition> throwEvents, XMLNode flowNodes) {
        for (SIntermediateThrowEventDefinition event : throwEvents) {
            XMLNode eventNode = new XMLNode(INTERMEDIATE_THROW_EVENT_NODE);
            this.fillFlowNode(eventNode, event);
            this.fillThrowEventDefinition(eventNode, event);
            flowNodes.addChild(eventNode);
        }
    }

    private void fillThrowEventDefinition(XMLNode eventNode, SThrowEventDefinition event) {
        this.createAndfillMessageEventTriggers(eventNode, event);
        this.createAndfillSignalEventTriggers(eventNode, event);
    }

    private void createAndfillSignalEventTriggers(XMLNode eventNode, SThrowEventDefinition event) {
        for (SThrowSignalEventTriggerDefinition signalEventTrigger : event.getSignalEventTriggerDefinitions()) {
            XMLNode signalEventTriggerNode = new XMLNode(THROW_SIGNAL_EVENT_TRIGGER_NODE);
            signalEventTriggerNode.addAttribute("name", signalEventTrigger.getSignalName());
            eventNode.addChild(signalEventTriggerNode);
        }
    }

    private void createAndfillErrorEventTriggers(XMLNode eventNode, SEndEventDefinition event) {
        for (SThrowErrorEventTriggerDefinition errorEventTrigger : event.getErrorEventTriggerDefinitions()) {
            XMLNode errorEventTriggerNode = new XMLNode(THROW_ERROR_EVENT_TRIGGER_NODE);
            errorEventTriggerNode.addAttribute("errorCode", errorEventTrigger.getErrorCode());
            eventNode.addChild(errorEventTriggerNode);
        }
    }

    private void createAndfillMessageEventTriggers(XMLNode eventNode, SThrowEventDefinition event) {
        for (SThrowMessageEventTriggerDefinition messageEventTrigger : event.getMessageEventTriggerDefinitions()) {
            this.createAndfillMessageEventTrigger(eventNode, messageEventTrigger);
        }
    }

    private void createAndfillMessageEventTrigger(XMLNode eventNode, SThrowMessageEventTriggerDefinition messageEventTrigger) {
        XMLNode messageEventTriggerNode = new XMLNode(THROW_MESSAGE_EVENT_TRIGGER_NODE);
        messageEventTriggerNode.addAttribute("name", messageEventTrigger.getMessageName());
        this.addExpressionNode(messageEventTriggerNode, TARGET_PROCESS, messageEventTrigger.getTargetProcess());
        SExpression targetFlowNode = messageEventTrigger.getTargetFlowNode();
        if (targetFlowNode != null) {
            this.addExpressionNode(messageEventTriggerNode, TARGET_FLOW_NODE, targetFlowNode);
        }
        this.createAndFillDataDefinitions(messageEventTriggerNode, messageEventTrigger);
        this.createAndfillCorrelations(messageEventTriggerNode, messageEventTrigger.getCorrelations());
        eventNode.addChild(messageEventTriggerNode);
    }

    private void createAndFillDataDefinitions(XMLNode messageEventTriggerNode, SThrowMessageEventTriggerDefinition messageEventTrigger) {
        for (SDataDefinition dataDefinition : messageEventTrigger.getDataDefinitions()) {
            XMLNode dataDefinitionNode = this.getDataDefinitionNode(dataDefinition);
            messageEventTriggerNode.addChild(dataDefinitionNode);
        }
    }

    private void addDataDefinitionNodes(SActivityDefinition activity, XMLNode activityNode) {
        XMLNode dataDefinitionsNodeFromActivity = new XMLNode(DATA_DEFINITIONS_NODE);
        activityNode.addChild(dataDefinitionsNodeFromActivity);
        for (SDataDefinition dataDefinition : activity.getSDataDefinitions()) {
            XMLNode dataDefinitionNode = this.getDataDefinitionNode(dataDefinition);
            dataDefinitionsNodeFromActivity.addChild(dataDefinitionNode);
        }
    }

    private void addOperationNodes(SActivityDefinition activity, XMLNode activityNode) {
        XMLNode operationsNode = new XMLNode(OPERATIONS_NODE);
        activityNode.addChild(operationsNode);
        this.createAndfillOperations(operationsNode, activity.getSOperations(), OPERATION_NODE);
    }

    private void addLoopCharacteristics(SActivityDefinition activity, XMLNode activityNode) {
        SLoopCharacteristics loopCharacteristics = activity.getLoopCharacteristics();
        if (loopCharacteristics != null) {
            XMLNode loopNode;
            if (loopCharacteristics instanceof SStandardLoopCharacteristicsImpl) {
                loopNode = new XMLNode(STANDARD_LOOP_CHARACTERISTICS_NODE);
                SStandardLoopCharacteristicsImpl loop = (SStandardLoopCharacteristicsImpl)loopCharacteristics;
                loopNode.addAttribute(TEST_BEFORE, String.valueOf(loop.isTestBefore()));
                XMLNode expressionNode = new XMLNode(LOOP_CONDITION);
                this.fillExpressionNode(expressionNode, loop.getLoopCondition());
                loopNode.addChild(expressionNode);
                SExpression loopMax = loop.getLoopMax();
                if (loopMax != null) {
                    XMLNode loopMaxNode = new XMLNode(LOOP_MAX);
                    this.fillExpressionNode(loopMaxNode, loopMax);
                    loopNode.addChild(loopMaxNode);
                }
            } else {
                SExpression completionCondition;
                loopNode = new XMLNode(MULTI_INSTANCE_LOOP_CHARACTERISTICS_NODE);
                SMultiInstanceLoopCharacteristics loop = (SMultiInstanceLoopCharacteristics)loopCharacteristics;
                loopNode.addAttribute(MULTI_INSTANCE_IS_SEQUENTIAL, String.valueOf(loop.isSequential()));
                loopNode.addAttribute(MULTI_INSTANCE_DATA_INPUT_ITEM_REF, loop.getDataInputItemRef());
                loopNode.addAttribute(MULTI_INSTANCE_DATA_OUTPUT_ITEM_REF, loop.getDataOutputItemRef());
                loopNode.addAttribute(MULTI_INSTANCE_LOOP_DATA_INPUT, loop.getLoopDataInputRef());
                loopNode.addAttribute(MULTI_INSTANCE_LOOP_DATA_OUTPUT, loop.getLoopDataOutputRef());
                SExpression loopCardinality = loop.getLoopCardinality();
                if (loopCardinality != null) {
                    XMLNode expressionNode = new XMLNode(MULTI_INSTANCE_LOOP_CARDINALITY);
                    this.fillExpressionNode(expressionNode, loopCardinality);
                    loopNode.addChild(expressionNode);
                }
                if ((completionCondition = loop.getCompletionCondition()) != null) {
                    XMLNode expressionNode = new XMLNode(MULTI_INSTANCE_COMPLETION_CONDITION);
                    this.fillExpressionNode(expressionNode, completionCondition);
                    loopNode.addChild(expressionNode);
                }
            }
            activityNode.addChild(loopNode);
        }
    }

    private void createAndfillIntermediateCatchEvents(List<SIntermediateCatchEventDefinition> catchEvents, XMLNode flowNodes) {
        for (SIntermediateCatchEventDefinition intermediateCatchEvent : catchEvents) {
            XMLNode intermediateCatchEventNode = new XMLNode(INTERMEDIATE_CATCH_EVENT_NODE);
            this.fillFlowNode(intermediateCatchEventNode, intermediateCatchEvent);
            this.fillCatchEventDefinition(intermediateCatchEventNode, intermediateCatchEvent);
            flowNodes.addChild(intermediateCatchEventNode);
        }
    }

    private void fillCatchEventDefinition(XMLNode catchEventNode, SCatchEventDefinition catchEvent) {
        this.createAndfillTimerEventTriggers(catchEventNode, catchEvent);
        this.createAndfillMessageEventTriggers(catchEventNode, catchEvent);
        this.createAndfillSignalEventTriggers(catchEventNode, catchEvent);
        this.createAndfillErrorEventTriggers(catchEventNode, catchEvent);
        catchEventNode.addAttribute(INTERRUPTING, String.valueOf(catchEvent.isInterrupting()));
    }

    private void createAndfillSignalEventTriggers(XMLNode catchEventNode, SCatchEventDefinition catchEvent) {
        for (SCatchSignalEventTriggerDefinition signalEventTrigger : catchEvent.getSignalEventTriggerDefinitions()) {
            XMLNode signalEventTriggerNode = new XMLNode(CATCH_SIGNAL_EVENT_TRIGGER_NODE);
            signalEventTriggerNode.addAttribute("name", signalEventTrigger.getSignalName());
            catchEventNode.addChild(signalEventTriggerNode);
        }
    }

    private void createAndfillErrorEventTriggers(XMLNode catchEventNode, SCatchEventDefinition catchEvent) {
        for (SCatchErrorEventTriggerDefinition errorEventTrigger : catchEvent.getErrorEventTriggerDefinitions()) {
            XMLNode errorEventTriggerNode = new XMLNode(CATCH_ERROR_EVENT_TRIGGER_NODE);
            errorEventTriggerNode.addAttribute("errorCode", errorEventTrigger.getErrorCode());
            catchEventNode.addChild(errorEventTriggerNode);
        }
    }

    private void createAndfillMessageEventTriggers(XMLNode catchEventNode, SCatchEventDefinition catchEvent) {
        for (SCatchMessageEventTriggerDefinition messageEventTrigger : catchEvent.getMessageEventTriggerDefinitions()) {
            this.createAndfillMessageEventTriggers(catchEventNode, messageEventTrigger);
        }
    }

    private void createAndfillMessageEventTriggers(XMLNode activityNode, SCatchMessageEventTriggerDefinition trigger) {
        XMLNode messageEventTriggerNode = new XMLNode(CATCH_MESSAGE_EVENT_TRIGGER_NODE);
        messageEventTriggerNode.addAttribute("name", trigger.getMessageName());
        this.createAndfillCorrelations(messageEventTriggerNode, trigger.getCorrelations());
        this.createAndfillOperations(messageEventTriggerNode, trigger.getOperations(), OPERATION_NODE);
        activityNode.addChild(messageEventTriggerNode);
    }

    private void createAndfillOperations(XMLNode parentNode, List<SOperation> list, String operationNodeName) {
        for (SOperation operation : list) {
            this.createAndFillOperation(parentNode, operation, operationNodeName);
        }
    }

    private void createAndFillOperation(XMLNode parentNode, SOperation operation, String operationNodeName) {
        XMLNode operationNode = new XMLNode(operationNodeName);
        operationNode.addAttribute(OPERATION_OPERATOR_TYPE, operation.getType().name());
        operationNode.addAttribute(OPERATION_OPERATOR, operation.getOperator());
        XMLNode leftOperand = new XMLNode(OPERATION_LEFT_OPERAND);
        this.fillLeftOperandNode(leftOperand, operation.getLeftOperand());
        operationNode.addChild(leftOperand);
        SExpression rightOperandExpression = operation.getRightOperand();
        if (rightOperandExpression != null) {
            XMLNode expressionNode = new XMLNode(OPERATION_RIGHT_OPERAND);
            this.fillExpressionNode(expressionNode, rightOperandExpression);
            operationNode.addChild(expressionNode);
        }
        parentNode.addChild(operationNode);
    }

    private void fillConnectorNode(XMLNode connectorNode, SConnectorDefinition connector) {
        connectorNode.addAttribute("name", connector.getName());
        connectorNode.addAttribute(CONNECTOR_ID, connector.getConnectorId());
        connectorNode.addAttribute("version", connector.getVersion());
        connectorNode.addAttribute(CONNECTOR_ACTIVATION_EVENT, connector.getActivationEvent().toString());
        connectorNode.addAttribute(CONNECTOR_FAIL_ACTION, connector.getFailAction().toString());
        if (connector.getFailAction() == FailAction.ERROR_EVENT) {
            connectorNode.addAttribute("errorCode", connector.getErrorCode());
        }
        Map<String, SExpression> inputs = connector.getInputs();
        this.createAndFillInputsNode(connectorNode, inputs);
        XMLNode outputsNode = new XMLNode(CONNECTOR_OUTPUTS_NODE);
        this.createAndfillOperations(outputsNode, connector.getOutputs(), OPERATION_NODE);
        connectorNode.addChild(outputsNode);
    }

    private void fillUserFilterNode(XMLNode userFilterNode, SUserFilterDefinition userFilter) {
        userFilterNode.addAttribute("name", userFilter.getName());
        userFilterNode.addAttribute(USER_FILTER_ID, userFilter.getUserFilterId());
        userFilterNode.addAttribute("version", userFilter.getVersion());
        Map<String, SExpression> inputs = userFilter.getInputs();
        this.createAndFillInputsNode(userFilterNode, inputs);
    }

    private void createAndFillInputsNode(XMLNode connectorNode, Map<String, SExpression> inputs) {
        XMLNode inputsNode = new XMLNode(CONNECTOR_INPUTS_NODE);
        for (Map.Entry<String, SExpression> input : inputs.entrySet()) {
            if (input.getValue() == null) continue;
            XMLNode inputNode = new XMLNode(CONNECTOR_INPUT);
            inputNode.addAttribute("name", input.getKey());
            XMLNode expressionNode = new XMLNode(EXPRESSION_NODE);
            this.fillExpressionNode(expressionNode, input.getValue());
            inputNode.addChild(expressionNode);
            inputsNode.addChild(inputNode);
        }
        connectorNode.addChild(inputsNode);
    }

    private void fillLeftOperandNode(XMLNode rightOperandNode, SLeftOperand sLeftOperand) {
        rightOperandNode.addAttribute("name", sLeftOperand.getName());
    }

    private void createAndfillCorrelations(XMLNode messageEventTriggerNode, List<SCorrelationDefinition> correlations) {
        for (SCorrelationDefinition correlation : correlations) {
            XMLNode correlationNode = new XMLNode(CORRELATION_NODE);
            XMLNode keyNode = new XMLNode(CORRELATION_KEY);
            this.fillExpressionNode(keyNode, correlation.getKey());
            correlationNode.addChild(keyNode);
            XMLNode valueNode = new XMLNode(CORRELATION_VALUE);
            this.fillExpressionNode(valueNode, correlation.getValue());
            correlationNode.addChild(valueNode);
            messageEventTriggerNode.addChild(correlationNode);
        }
    }

    private void createAndfillTimerEventTriggers(XMLNode catchEventNode, SCatchEventDefinition catchEvent) {
        for (STimerEventTriggerDefinition timerEventTrigger : catchEvent.getTimerEventTriggerDefinitions()) {
            XMLNode timerEventTriggerNode = new XMLNode(TIMER_EVENT_TRIGGER_NODE);
            timerEventTriggerNode.addAttribute("type", timerEventTrigger.getTimerType().toString());
            XMLNode expression = new XMLNode(EXPRESSION_NODE);
            this.fillExpressionNode(expression, timerEventTrigger.getTimerExpression());
            timerEventTriggerNode.addChild(expression);
            catchEventNode.addChild(timerEventTriggerNode);
        }
    }

    private XMLNode getDataDefinitionNode(SDataDefinition dataDefinition) {
        XMLNode dataDefinitionNode = null;
        if (dataDefinition instanceof SXMLDataDefinition) {
            String element;
            dataDefinitionNode = new XMLNode(XML_DATA_DEFINITION_NODE);
            this.fillDataDefinitionNode(dataDefinitionNode, dataDefinition);
            SXMLDataDefinition xmlData = (SXMLDataDefinition)dataDefinition;
            String namespace = xmlData.getNamespace();
            if (namespace != null) {
                dataDefinitionNode.addChild(XML_DATA_DEFINITION_NAMESPACE, namespace);
            }
            if ((element = xmlData.getElement()) != null) {
                dataDefinitionNode.addChild(XML_DATA_DEFINITION_ELEMENT, element);
            }
        } else if (dataDefinition instanceof STextDataDefinition) {
            dataDefinitionNode = new XMLNode(TEXT_DATA_DEFINITION_NODE);
            dataDefinitionNode.addAttribute(TEXT_DATA_DEFINITION_LONG, String.valueOf(((STextDataDefinition)dataDefinition).isLongText()));
            this.fillDataDefinitionNode(dataDefinitionNode, dataDefinition);
        } else {
            dataDefinitionNode = new XMLNode(DATA_DEFINITION_NODE);
            this.fillDataDefinitionNode(dataDefinitionNode, dataDefinition);
        }
        return dataDefinitionNode;
    }

    private void fillDataDefinitionNode(XMLNode dataDefinitionNode, SDataDefinition dataDefinition) {
        SExpression defaultValueExpression;
        dataDefinitionNode.addAttribute("name", dataDefinition.getName());
        dataDefinitionNode.addAttribute(DATA_DEFINITION_CLASS, dataDefinition.getClassName());
        dataDefinitionNode.addAttribute(DATA_DEFINITION_TRANSIENT, String.valueOf(dataDefinition.isTransientData()));
        if (dataDefinition.getDescription() != null) {
            dataDefinitionNode.addChild(DESCRIPTION, dataDefinition.getDescription());
        }
        if ((defaultValueExpression = dataDefinition.getDefaultValueExpression()) != null) {
            XMLNode defaultValueNode = new XMLNode(DEFAULT_VALUE_NODE);
            this.fillExpressionNode(defaultValueNode, defaultValueExpression);
            dataDefinitionNode.addChild(defaultValueNode);
        }
    }

    private void fillDocumentDefinitionNode(XMLNode documentDefinitionNode, SDocumentDefinition documentDefinition) {
        documentDefinitionNode.addAttribute("name", documentDefinition.getName());
        documentDefinitionNode.addAttribute(DOCUMENT_DEFINITION_MIME_TYPE, documentDefinition.getContentMimeType());
        if (documentDefinition.getFileName() != null) {
            documentDefinitionNode.addChild(DOCUMENT_DEFINITION_FILE_NAME, documentDefinition.getFileName());
        }
        if (documentDefinition.getDescription() != null) {
            documentDefinitionNode.addChild(DESCRIPTION, documentDefinition.getDescription());
        }
        if (documentDefinition.getUrl() != null) {
            documentDefinitionNode.addChild(DOCUMENT_DEFINITION_URL, documentDefinition.getUrl());
        }
        if (documentDefinition.getFile() != null) {
            documentDefinitionNode.addChild(DOCUMENT_DEFINITION_FILE, documentDefinition.getFile());
        }
    }

    private void fillActorNode(XMLNode actorNode, SActorDefinition actor) {
        actorNode.addAttribute("name", actor.getName());
        actorNode.addChild(DESCRIPTION, actor.getDescription());
    }

    private void fillParameterNode(XMLNode parameterNode, SParameterDefinition parameter) {
        parameterNode.addAttribute("name", parameter.getName());
        parameterNode.addAttribute("type", parameter.getType());
        if (parameter.getDescription() != null) {
            parameterNode.addChild(DESCRIPTION, parameter.getDescription());
        }
    }

    private void fillGatewayNode(XMLNode gatewayNode, SGatewayDefinition gateway) {
        this.fillFlowNode(gatewayNode, gateway);
        gatewayNode.addAttribute(GATEWAY_TYPE, gateway.getGatewayType().toString());
    }

    private void fillFlowNode(XMLNode node, SFlowNodeDefinition flowNode) {
        XMLNode transitionNode;
        node.addAttribute(ID, String.valueOf(flowNode.getId()));
        node.addAttribute("name", flowNode.getName());
        node.addAttribute(DESCRIPTION, flowNode.getDescription());
        this.addExpressionNode(node, DISPLAY_NAME, flowNode.getDisplayName());
        this.addExpressionNode(node, DISPLAY_DESCRIPTION, flowNode.getDisplayDescription());
        this.addExpressionNode(node, DISPLAY_DESCRIPTION_AFTER_COMPLETION, flowNode.getDisplayDescriptionAfterCompletion());
        for (STransitionDefinition transition : flowNode.getIncomingTransitions()) {
            transitionNode = new XMLNode(INCOMING_TRANSITION);
            this.fillTransitionRefNode(transitionNode, transition);
            node.addChild(transitionNode);
        }
        for (STransitionDefinition transition : flowNode.getOutgoingTransitions()) {
            transitionNode = new XMLNode(OUTGOING_TRANSITION);
            this.fillTransitionRefNode(transitionNode, transition);
            node.addChild(transitionNode);
        }
        if (flowNode.getDefaultTransition() != null) {
            XMLNode defaultTransition = new XMLNode(DEFAULT_TRANSITION);
            this.fillTransitionRefNode(defaultTransition, flowNode.getDefaultTransition());
            node.addChild(defaultTransition);
        }
        for (SConnectorDefinition connector : flowNode.getConnectors()) {
            XMLNode connectorNode = new XMLNode(CONNECTOR_NODE);
            this.fillConnectorNode(connectorNode, connector);
            node.addChild(connectorNode);
        }
    }

    private void addExpressionNode(XMLNode node, String expressionNodeName, SExpression expression) {
        if (expression != null) {
            XMLNode xmlNode = new XMLNode(expressionNodeName);
            this.fillExpressionNode(xmlNode, expression);
            node.addChild(xmlNode);
        }
    }

    private void fillTransitionRefNode(XMLNode transitionNode, STransitionDefinition transition) {
        transitionNode.addAttribute(IDREF, this.objectToId.get(transition));
    }

    private void fillExpressionNode(XMLNode expressionNode, SExpression sExpression) {
        expressionNode.addAttribute("name", sExpression.getName());
        expressionNode.addAttribute(EXPRESSION_TYPE, sExpression.getExpressionType());
        expressionNode.addAttribute(EXPRESSION_RETURN_TYPE, sExpression.getReturnType());
        expressionNode.addAttribute(EXPRESSION_INTERPRETER, sExpression.getInterpreter());
        expressionNode.addChild(EXPRESSION_CONTENT, sExpression.getContent());
        for (SExpression dependency : sExpression.getDependencies()) {
            XMLNode dependencyExpression = new XMLNode(EXPRESSION_NODE);
            this.fillExpressionNode(dependencyExpression, dependency);
            expressionNode.addChild(dependencyExpression);
        }
    }

    private void fillTransitionNode(XMLNode transitionNode, STransitionDefinition transition) {
        transitionNode.addAttribute("name", transition.getName());
        transitionNode.addAttribute(TRANSITION_SOURCE, String.valueOf(transition.getSource()));
        transitionNode.addAttribute(TRANSITION_TARGET, String.valueOf(transition.getTarget()));
        if (transition.getCondition() != null) {
            XMLNode condition = new XMLNode(TRANSITION_CONDITION);
            this.fillExpressionNode(condition, transition.getCondition());
            transitionNode.addChild(condition);
        }
    }

    static final class BEntry<K, V>
    implements Map.Entry<K, V> {
        private final K k;
        private V v;

        public BEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V value) {
            this.v = value;
            return this.v;
        }
    }
}

