/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.incident;

import java.util.List;
import org.bonitasoft.engine.incident.Incident;
import org.bonitasoft.engine.incident.IncidentHandler;
import org.bonitasoft.engine.incident.IncidentService;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class IncidentServiceImpl
implements IncidentService {
    private final List<IncidentHandler> handlers;
    private final TechnicalLoggerService logger;

    public IncidentServiceImpl(TechnicalLoggerService logger, List<IncidentHandler> handlers) {
        this.logger = logger;
        this.handlers = handlers;
    }

    @Override
    public void report(long tenantId, Incident incident) {
        for (IncidentHandler handler : this.handlers) {
            try {
                handler.handle(tenantId, incident);
            }
            catch (Throwable t) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unable to report an incident using the handler " + handler + " incident was " + incident);
            }
        }
    }
}

