/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SHandler;
import org.bonitasoft.engine.events.model.SHandlerExecutionException;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.synchro.WaitForEventSynchronization;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.TransactionService;

public abstract class AbstractUpdateHandler
implements SHandler<SEvent> {
    private static final long serialVersionUID = 1L;
    private final long tenantId;
    private final Map<Class<?>, Method> getIdMethods = Collections.synchronizedMap(new HashMap());

    public AbstractUpdateHandler(long tenantId) {
        this.tenantId = tenantId;
    }

    protected abstract Map<String, Serializable> getEvent(SEvent var1);

    @Override
    public void execute(SEvent sEvent) throws SHandlerExecutionException {
        try {
            Map<String, Serializable> event = this.getEvent(sEvent);
            Long id = this.getObjectId(sEvent);
            TenantServiceAccessor tenantServiceAccessor = this.getTenantServiceAccessor();
            WaitForEventSynchronization synchronization = new WaitForEventSynchronization(event, id, tenantServiceAccessor.getSynchroService());
            TransactionService transactionService = tenantServiceAccessor.getTransactionService();
            transactionService.registerBonitaSynchronization(synchronization);
        }
        catch (STransactionNotFoundException e) {
            e.printStackTrace();
            throw new SHandlerExecutionException(e);
        }
    }

    private Long getObjectId(SEvent sEvent) {
        Long id = null;
        Object object = null;
        try {
            object = sEvent.getObject();
            Class<?> clazz = object.getClass();
            Method method = null;
            method = this.getIdMethods.containsKey(clazz) ? this.getIdMethods.get(clazz) : clazz.getMethod("getId", new Class[0]);
            Object invoke = method.invoke(object, new Object[0]);
            id = (Long)invoke;
        }
        catch (Throwable e) {
            System.err.println("AbstractUpdateHandler: No id on object " + object);
        }
        return id;
    }

    private TenantServiceAccessor getTenantServiceAccessor() throws SHandlerExecutionException {
        try {
            return ServiceAccessorFactory.getInstance().createTenantServiceAccessor(this.tenantId);
        }
        catch (Exception e) {
            throw new SHandlerExecutionException(e.getMessage(), null);
        }
    }
}

